function openLoginPanel() {
  /* if already open, just bring it to front */
  if (document.getElementById('loginPanelMicro')) {
    bringToFront('loginPanelMicro');
    return;
  }

  /* build the panel */
  createPanel(
    'loginPanelMicro',        // id
    'CC',                     // center-center
    'ctc',                    // scale-in animation
    380, 480,                // w, h
    {
      title: 'Login',
      bodyContent: '',        // we’ll inject the original HTML
      noFooter: true,
      radius: '8px'
    }
  );

  /* inject the exact original markup */
  const body = document.querySelector('#loginPanelMicro .panel-body');
  body.innerHTML = `
    <div class="login-container" style="position:static;margin:0 auto;background:none;box-shadow:none;">
      <h4>Login</h4>
      <form id="loginFormMicro">
        <div class="form-group">
          <label for="usernameMicro">Username:</label>
          <input type="text" id="usernameMicro" required>
          <div id="usernameMessageMicro" class="message"></div>
        </div>

        <div class="form-group">
          <label for="passwordMicro">Password:</label>
          <div class="password-container">
            <input type="password" id="passwordMicro" required>
            <span class="password-toggle" id="togglePasswordMicro">👁</span>
          </div>
        </div>

        <button type="submit" id="loginBtnMicro">Login</button>
        <button type="button" id="logoffBtnMicro" style="display:none;">Log Off</button>

        <div id="loginMessageMicro" class="message"></div>
        <span class="header-progress">
          <progress id="myProgressBarMicro" value="10" max="100"></progress>
        </span>
        <div id="attemptWarningMicro" class="message warning"></div>
      </form>
    </div>
  `;

  /* copy-paste the original JS but scoped to the new ids */
  (() => {
    /* tiny helpers ------------------------------------------------ */
    const $ = id => document.getElementById(id);
    function displayMessage(elId, msg, type = 'error') {
      const d = $(elId);
      if (!d) return;
      d.textContent = msg;
      d.className = 'message ' + type;
    }

    /* -- background loop & logo (keep global, no change) ---------- */
    /* -- bottom-bar IP fetch (keep global, no change) ------------- */

    /* -- scoped login logic -------------------------------------- */
    const usernameInput  = $('usernameMicro');
    const passwordInput  = $('passwordMicro');
    const loginBtn       = $('loginBtnMicro');
    const logoffBtn      = $('logoffBtnMicro');
    const progressBar    = $('myProgressBarMicro');

    /* restore state ------------------------------------------------ */
    (() => {
      const logged = localStorage.getItem('logged');
      let attempts = parseInt(localStorage.getItem('loginAttempts') || '0');
      if (attempts > 5) loginBtn.disabled = true;
      if (logged === 'true') {
        usernameInput.value = localStorage.getItem('user') || '';
        passwordInput.value = localStorage.getItem('password') || '';
        logoffBtn.style.display = 'block';
      }
    })();

    /* password toggle --------------------------------------------- */
    $('togglePasswordMicro').onclick = () => {
      const p = passwordInput;
      const icon = $('togglePasswordMicro');
      const isPwd = p.type === 'password';
      p.type = isPwd ? 'text' : 'password';
      icon.textContent = isPwd ? '🔒' : '👁';
    };

    /* username blur check ----------------------------------------- */
    usernameInput.addEventListener('blur', () => {
      const u = usernameInput.value.trim();
      if (!u) return;
      displayMessage('usernameMessageMicro', 'Checking…', 'warning');
      fetch('https://j.kunok.com/aui.php?action=check_username', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({data:{username:u}})
      })
      .then(r => r.json())
      .then(r => displayMessage('usernameMessageMicro', r.exists ? '✓ Username found' : '❌ Doesn’t exist', r.exists ? 'success' : 'error'))
      .catch(() => displayMessage('usernameMessageMicro', 'Network error', 'error'));
    });

    /* submit ------------------------------------------------------ */
    $('loginFormMicro').addEventListener('submit', e => {
      e.preventDefault();
      const u = usernameInput.value.trim();
      const p = passwordInput.value;
      let attempts = parseInt(localStorage.getItem('loginAttempts') || '0');
      if (attempts > 5) { loginBtn.disabled = true; return; }

      displayMessage('loginMessageMicro', 'Checking credentials…', 'warning');
      progressBar.value = 50;

      fetch('https://j.kunok.com/aui.php?action=login', {
        method: 'POST',
        headers: {'Content-Type': 'application/json'},
        body: JSON.stringify({data:{username:u, password:p}})
      })
      .then(r => r.json())
      .then(r => {
        if (r.message === 'Login successful' && r.id) {
          progressBar.value = 100;
          displayMessage('loginMessageMicro', r.message, 'success');
          /* store everything exactly as your original code */
          ['userid','user','user_name','flag','level','timestamp','img','logged']
            .forEach(k => localStorage.setItem(k, r[k] || ''));
          localStorage.setItem('password', p);
          localStorage.setItem('loginAttempts', '0');

          /* redirect */
          let url = 'router.html';
          if (r.level === '1') url = 'user.html';
          else if (r.level === '2') url = 'admin.html';
          else if (r.level === '3') url = 'superadmin.html';
          location.href = url;
        } else {
          attempts++; localStorage.setItem('loginAttempts', attempts);
          //loginBtn.disabled = attempts > 5;
          displayMessage('attemptWarningMicro', `${5-attempts} attempts left`, 'warning');
          displayMessage('loginMessageMicro', r.error || 'Invalid credentials', 'error');
        }
      })
      .catch(() => {
        attempts++; localStorage.setItem('loginAttempts', attempts);
        displayMessage('loginMessageMicro', 'Network error', 'error');
      });
    });

    /* logoff inside panel ---------------------------------------- */
    logoffBtn.onclick = () => {
      localStorage.clear();
      displayMessage('loginMessageMicro', 'Logged off', 'success');
      setTimeout(() => location.reload(), 1000);
    };

  })(); /* end scoped login */
}

window.addEventListener('load', () => {
  if (localStorage.getItem('logged') !== 'true') openLoginPanel();
});
