function getFieldStats(data) {
  const fields = Object.values(data).filter(f => typeof f === 'object');
  
  return {
    // Required fields
    totalRequired: fields.filter(f => f.required).length,
    answeredRequired: fields.filter(f => f.required && isFieldAnswered(f)).length,
    
    // All fields (including optional)
    totalFields: fields.length,
    answeredFields: fields.filter(f => isFieldAnswered(f)).length,
    
    // Files
    totalFiles: fields.reduce((sum, f) => sum + countFiles(f), 0)
  };
}
function countFiles(field) {
  if (!field?.value || field.data_type !== 'attachment') return 0;
  try {
    const files = JSON.parse(field.value);
    return Array.isArray(files) ? files.length : 0;
  } catch {
    return 0;
  }
}
function isFieldAnswered(field) {
  if (!field) return false;
  
  switch(field.data_type) {
    case 'text':
    case 'textarea':
      return !!field.value?.trim();
    case 'radio':
    case 'select':
      return field.value !== undefined;
    case 'attachment':
      return countFiles(field) > 0;
    case 'radiotextatt':
      return !!field.value?.text?.trim() || countFiles(field) > 0;
    default:
      return false;
  }
}
function setupLiveUpdates() {
  // Example: Monitor all inputs in your form
  document.addEventListener('input', (e) => {
    const bucketStats = getFieldStats(bucket);
    const cupStats = getFieldStats(cup);
    
    updateUI(bucketStats, cupStats); // Your rendering function
  });
}
function saveScrollPosition(panelId = "gen") {
  const panel = document.getElementById(panelId);
  if (!panel) return;
  const body = panel.querySelector(".panel-body");
  if (!body) return;
  const scrollTop = body.scrollTop;
  const scrollLeft = body.scrollLeft;
  localStorage.setItem(`scroll_${panelId}`, JSON.stringify({ top: scrollTop, left: scrollLeft }));
  console.log(`✅ Saved scroll for ${panelId}`, scrollTop, scrollLeft);
}

function restoreScrollPosition(panelId = "gen") {
  const panel = document.getElementById(panelId);
  if (!panel) return;
  const body = panel.querySelector(".panel-body");
  if (!body) return;
  const pos = JSON.parse(localStorage.getItem(`scroll_${panelId}`) || "{}");
  
  if (pos && typeof pos.top === "number") {
    // Smooth scroll implementation
    body.scrollTo({
      top: pos.top,
      left: pos.left || 0,
      behavior: 'smooth'
    });
    console.log(`✅ Restored scroll for ${panelId} with smooth animation`, pos.top, pos.left);
  }
}

// Save the current scroll position
function saveScroll() {
  saveScrollPosition("gen");
}

function restoreScroll() {
  restoreScrollPosition("gen");
}

// Optional: Add smooth scroll to any element
function smoothScrollTo(elementId, offset = 0) {
  const element = document.getElementById(elementId);
  if (element) {
    element.scrollTo({
      top: offset,
      behavior: 'smooth'
    });
  }
}
// Save the current scroll position
      let savedScrollPosition = 0;
        const scrollableDiv = document.getElementById('gform');

        // Save the current scroll position of the div
      function saveScroll() {
  saveScrollPosition("gen");
}
function restoreScroll() {
  restoreScrollPosition("gen");
}
function Sum1(summary, data) {
  const lang = window.lang || "en";
  const targetDivId = "rsSum1";
  const targetDiv = document.getElementById(targetDivId);

  if (!targetDiv) {
    console.error(`Target div ${targetDivId} not found`);
    return;
  }

  if (!summary || !summary.segments || !summary.totals) {
    targetDiv.innerHTML = "<div>No summary data available</div>";
    return;
  }

  // Enhanced file counting function
  function countAllFiles(field) {
    if (!field || !field.value) return 0;

    let count = 0;

    if (field.data_type === "attachment" && typeof field.value === "string") {
      count += field.value.split(",").filter((f) => f.trim()).length;
    }

    if (
      (field.data_type === "radioatt" || field.data_type === "radiotextatt") &&
      field.value?.att &&
      typeof field.value.att === "string"
    ) {
      count += field.value.att.split(",").filter((f) => f.trim()).length;
    }

    if (
      field.data_type === "checktextatt" &&
      field.value?.att &&
      typeof field.value.att === "string"
    ) {
      count += field.value.att.split(",").filter((f) => f.trim()).length;
    }

    return count;
  }

  // Enhanced calculation functions
  function calculateCurrentScore(field) {
    if (!isFieldAnswered(field)) return 0;

    if (field.weights) {
      if (field.data_type === "radio" || field.data_type === "radioatt") {
        const radioValue =
          field.data_type === "radioatt" ? field.value?.radio : field.value;
        return field.weights[radioValue] || 0;
      }
      if (field.data_type === "checkbox") {
        return field.value.reduce(
          (sum, idx) => sum + (field.weights[idx] || 0),
          0,
        );
      }
      if (
        field.data_type === "radiotext" ||
        field.data_type === "radiotextatt"
      ) {
        return field.weights[field.value.radio] || 0;
      }
      if (
        field.data_type === "checktext" ||
        field.data_type === "checktextatt"
      ) {
        return field.value.check.reduce(
          (sum, idx) => sum + (field.weights[idx] || 0),
          0,
        );
      }
    }
    return field.score || (isFieldAnswered(field) ? 1 : 0);
  }

  function calculateMaxScore(field) {
    if (field.weights) {
      if (
        ["radio", "radioatt", "radiotext", "radiotextatt"].includes(
          field.data_type,
        )
      ) {
        return Math.max(...field.weights);
      }
      if (["checkbox", "checktext", "checktextatt"].includes(field.data_type)) {
        return field.weights
          .filter((w) => w > 0)
          .reduce((sum, w) => sum + w, 0);
      }
    }
    return field.score || 1;
  }

  function calculateScoreAchieved(field) {
    const currentScore = calculateCurrentScore(field);
    return (field.score || 1) * currentScore;
  }

  function countFiles(field) {
    if (!field || !field.value) return 0;

    // Handle regular attachment fields
    if (field.data_type === "attachment" && typeof field.value === "string") {
      return field.value.split(",").filter((f) => f.trim()).length;
    }

    // Handle radioatt fields - check for value.att string
    if (
      field.data_type === "radioatt" &&
      field.value?.att &&
      typeof field.value.att === "string"
    ) {
      return field.value.att.split(",").filter((f) => f.trim()).length;
    }

    // Handle radiotextatt fields - check for value.att string
    if (
      field.data_type === "radiotextatt" &&
      field.value?.att &&
      typeof field.value.att === "string"
    ) {
      return field.value.att.split(",").filter((f) => f.trim()).length;
    }

    return 0;
  }

  function getFileValue(field) {
    if (!field || !field.value) return "";

    if (field.data_type === "attachment") {
      return typeof field.value === "string" ? field.value : "";
    }

    if (
      (field.data_type === "radioatt" ||
        field.data_type === "radiotextatt" ||
        field.data_type === "checktextatt") &&
      field.value?.att
    ) {
      return field.value.att;
    }

    return "";
  }
  function getFieldValueDisplay(field) {
    if (!field.value) return "";

    if (typeof field.value === "object") {
      try {
        return JSON.stringify(field.value);
      } catch (e) {
        return "[object]";
      }
    }
    return String(field.value);
  }
  let html = `
    <style>
      .sum1-table {
        width: 100%;
        border-collapse: collapse;
        font-family: Arial, sans-serif;
        font-size: 0.9em;
      }
      .sum1-table th, .sum1-table td {
        padding: 6px 8px;
        border: 1px solid #ddd;
        text-align: left;
      }
      .sum1-table th {
        background-color: #f2f2f2;
        font-weight: bold;
      }
      .sum1-segment {
        background-color: #e6f7ff;
      }
      .sum1-section {
        background-color: #f0f0f0;
      }
      .sum1-field {
        background-color: #f9f9f9;
      }
      .sum1-answered {
        color: #4CAF50;
      }
      .sum1-unanswered {
        color: #f44336;
      }
      .sum1-status {
        display: inline-block;
        width: 12px;
        height: 12px;
        border-radius: 50%;
        margin-right: 5px;
      }
      .sum1-status-answered {
        background-color: #4CAF50;
      }
      .sum1-status-unanswered {
        background-color: #f44336;
      }
      .sum1-file-value {
        max-width: 200px;
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        display: inline-block;
      }
    </style>
    <table class="sum1-table">
      <thead>
        <tr>
          <th>Name</th>
          <th>Type</th>
          <th>Status</th>
          <th>Score</th>
          <th>Achieved</th>
          <th>Score Achieved</th>
          <th>Max</th>
          <th>Files</th>
          <th>File Value</th>
          <th>Value</th>
        </tr>
      </thead>
      <tbody>
  `;
  const global = summary.totals;
  // Calculate global totals
  let globalFileCount = 0;
  let globalScoreAchieved = 0;
  for (const key in data) {
    if (key === "grouping" || data[key].type === "section") continue;
    globalFileCount += countAllFiles(data[key]);
    globalScoreAchieved += calculateScoreAchieved(data[key]);
  }

  // Global totals row

  html += `
    <tr class="sum1-global">
      <td colspan="3"><strong>GRAND  TOTAL</strong></td>
      <td>${global.answeredFields}/${global.allFields}</td>

      <td>${global.totalScore}</td>
      <td>${global.totalScoreWeighted}</td>
      <td>${globalScoreAchieved.toFixed(1)}</td>
      <td>${global.maxPossibleScoreWeighted}</td>
      <td>${globalFileCount}</td>
      <td colspan="2"></td>
    </tr>
  `;

  // Process all segments and sections
  Object.entries(summary.segments).forEach(([segmentKey, segment]) => {
    // Calculate segment totals
    let segmentFileCount = 0;
    let segmentScoreAchieved = 0;
    let segmentAnsweredFields = 0;
    let segmentAllFields = 0;
    // Segment header
    html += `
      <tr class="sum1-segment">
        <td colspan="2"><strong>${segment.label || segmentKey}</strong></td>
        <td>${segment.totals.answeredFields}/${segment.totals.allFields}</td>
        <td>${segment.totals.totalScore}</td>
        <td>${segment.totals.totalScoreWeighted}</td>
        <td>${segment.totals.totalScoreWeighted}</td>
        <td>${segment.totals.maxPossibleScoreWeighted}</td>
        <td>${segment.totals.totalFiles}</td>
        <td colspan="2"></td>
      </tr>
    `;

    Object.entries(segment.sections).forEach(([sectionKey, section]) => {
      // Calculate section totals
      let sectionFileCount = 0;
      let sectionScoreAchieved = 0;
      for (const key in data) {
        if (
          data[key].section === sectionKey &&
          data[key].segment?.includes(segmentKey)
        ) {
          sectionFileCount += countAllFiles(data[key]);
          sectionScoreAchieved += calculateScoreAchieved(data[key]);
        }
      }

      // Section header
      html += `
        <tr class="sum1-section">
          <td colspan="2">${section.label || sectionKey}</td>
          <td>${section.totals.answeredFields}/${section.totals.allFields}</td>
          <td>${section.totals.totalScore}</td>
          <td>${section.totals.totalScoreWeighted}</td>
          <td>${sectionScoreAchieved.toFixed(1)}</td>
          <td>${section.totals.maxPossibleScoreWeighted}</td>
          <td>${sectionFileCount}</td>
          <td colspan="2"></td>
        </tr>
      `;

      // Show ALL fields in this section
      for (const key in data) {
        if (
          data[key].section === sectionKey &&
          data[key].segment?.includes(segmentKey)
        ) {
          const field = data[key];
          if (field.type === "section") continue;

          const isAnswered = isFieldAnswered(field);
          const currentScore = calculateCurrentScore(field);
          const maxScore = calculateMaxScore(field);
          const scoreAchieved = calculateScoreAchieved(field);
          const fileCount = countAllFiles(field);
          const fileValue = getFileValue(field);
          const fieldValue = getFieldValueDisplay(field);

          html += `
            <tr class="sum1-field">
              <td>
                <span class="sum1-status ${isAnswered ? "sum1-status-answered" : "sum1-status-unanswered"}"></span>
                ${field.label?.[lang] || key}
              </td>
              <td>${field.data_type || field.type || "field"}</td>
              <td class="${isAnswered ? "sum1-answered" : "sum1-unanswered"}">
                ${isAnswered ? "Answered" : "Unanswered"}
              </td>
              <td>${field.score || 1}</td>
              <td>${currentScore}</td>
              <td>${scoreAchieved.toFixed(1)}</td>
              <td>${maxScore}</td>
              <td>${fileCount}</td>
              <td class="sum1-file-value" title="${fileValue}">${fileValue}</td>
              <td class="sum1-file-value" title="${fieldValue}">${fieldValue}</td>
            </tr>
          `;
        }
      }
    });
  });

  html += `
      </tbody>
    </table>
    <div style="margin-top: 10px; font-size: 0.8em;">
      <span class="sum1-status sum1-status-answered"></span> Answered field |
      <span class="sum1-status sum1-status-unanswered"></span> Unanswered field
    </div>
  `;

  targetDiv.innerHTML = html;

  // Helper function to get file values
  function getFileValue(field) {
    if (!field || !field.value) return "";

    if (field.data_type === "attachment") {
      return typeof field.value === "string" ? field.value : "";
    }

    if (
      (field.data_type === "radioatt" || field.data_type === "radiotextatt") &&
      field.value?.att
    ) {
      return field.value.att;
    }

    if (field.data_type === "checktextatt" && field.value?.att) {
      return field.value.att;
    }

    return "";
  }
}