(function () {
  // CSS injection (unchanged)
  const style = document.createElement("style");
  style.textContent = `
#avt_myDiv {
  position: absolute;
  height: 60px;
  display: flex;
  align-items: center;
  border-radius: 8px;
  padding: 5px;
  cursor: grab;
  user-select: none;
  z-index: 1000;
  transition: flex-direction 0.2s ease;
}
#avt_avatar {
  width: 50px;
  height: 50px;
  border-radius: 50%;
  background-color: #ccc;
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  box-shadow: 0 2px 5px rgba(0,0,0,0.2);
  cursor: pointer;
  flex-shrink: 0;
}
#avt_rightContent {
  width: 200px;
  height: 100%;
  background: white;
  margin-left: 8px;
  margin-right: 8px;
  padding: 8px;
  border-radius: 8px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
  display: flex;
  flex-direction: column;
  justify-content: center;
  opacity: 1;
  visibility: visible;
  transition: opacity 0.2s ease, visibility 0.2s ease;
}
#avt_rightContent.hidden {
  opacity: 0;
  visibility: hidden;
}
#avt_info {
  font-size: 12px;
}
.btns {
  margin-top: 6px;
  display: flex;
  gap: 4px;
  flex-wrap: wrap;
  align-items: center;
}
button {
  font-size: 11px;
  padding: 3px 6px;
  border: none;
  border-radius: 4px;
  background: #2196F3;
  color: white;
  cursor: pointer;
}
.btnReset {
  background: #9e9e9e;
}
.btnHide ,#avt_closePanelBtn{
  background: #f44336;
  border-radius: 50%;
  width: 18px;
  height: 18px;
  line-height: 20px;
  padding: 0;
  margin-left: auto;
}
#avt_panel {
  position: absolute;
  width: 200px;
  height: 200px;
  background: #3f51b5;
  color: white;
  border-radius: 8px;
  padding: 10px;
  display: none;
  opacity: 0;
  transition: transform 0.3s ease, opacity 0.3s ease;
}
#avt_panel.slide-up { transform: translateY(10px); }
#avt_panel.slide-down { transform: translateY(-10px); }
#avt_panel.show {
  display: block;
  opacity: 1;
  transform: translateY(0);
}
#avt_closePanelBtn {
  position: absolute;
  top: 8px;
  right: 5px;
  background: rgba(0,0,0,0.2);
  color: white;
  border: none;
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
  padding: 2px 6px;
  border-radius: 50%;
  line-height: 1;
}
#avt_closePanelBtn:hover {
  background-color: rgba(255,25,25,0.);
}
#avt_myDiv.shrinked {
  width: auto;
}
#avt_rightContent.hidden {
  display: none; /* Ensures layout shrinks */
}
`;
  document.head.appendChild(style);

  // Create UI (unchanged)
  const div = document.createElement("div");
  div.id = "avt_myDiv";
  div.innerHTML = `
  <div id="avt_avatar" title="Double-click to toggle info"></div>
  <div id="avt_rightContent">
    <div id="avt_info">
      <div id="avt_userName"><strong>User</strong></div>
      <div id="avt_userInfo">Info here</div>
    </div>
    <div class="btns">
      <button id="avt_togglePanelBtn">Panel</button>
      <button class="btnReset" id="avt_resetBtn">R</button>
      <button class="btnLANG" id="avt_btnLANG">L</button>
      <button class="btnHide" id="avt_hideBtn"></button>
    </div>
  </div>
  `;
  const panel = document.createElement("div");
  panel.id = "avt_panel";
  panel.innerHTML = `
    <button id="avt_closePanelBtn" title="Close Panel"></button>
    <div id="avt_panel_body">I'm the toggle panel</div>
  `;
  document.body.appendChild(div);
  document.body.appendChild(panel);

  // Setup (unchanged)
  const myDiv = div;
  const avatar = document.getElementById("avt_avatar");
  const rightContent = document.getElementById("avt_rightContent");
  const panelEl = document.getElementById("avt_panel");
  const toggleBtn = document.getElementById("avt_togglePanelBtn");
  const hideBtn = document.getElementById("avt_hideBtn");
  const resetBtn = document.getElementById("avt_resetBtn");
  const langBtn = document.getElementById("avt_btnLANG");
  const closeBtn = document.getElementById("avt_closePanelBtn");

  // Avatar (unchanged)
  const user_imgr =
    localStorage.getItem("img") || "https://via.placeholder.com/80";
  let user_img;
  try {
    user_img = atob(user_imgr);
  } catch {
    user_img = "https://i.pravatar.cc/40?u=yanyong";
  }
  avatar.style.backgroundImage = `url(${user_img})`;

  // Initialize position and visibility
  window.avatarOnRight = false;
  let isHidden = false;

  // Simplified position loading
  function loadPosition() {
    const savedX = localStorage.getItem("myDivX");
    const savedY = localStorage.getItem("myDivY");
    
    if (savedX !== null && savedY !== null) {
      myDiv.style.left = savedX + "px";
      myDiv.style.top = savedY + "px";
    } else {
      // Default position
      myDiv.style.left = "20px";
      myDiv.style.top = window.innerHeight - 80 + "px";
    }
    
    updateDirection();
  }

  // Load visibility state
  function loadVisibility() {
    const hiddenState = localStorage.getItem("avt_rightContent_hidden");
    if (hiddenState === "1") {
      rightContent.classList.add("hidden");
      myDiv.classList.add("shrinked");
      isHidden = true;
    } else {
      rightContent.classList.remove("hidden");
      myDiv.classList.remove("shrinked");
      isHidden = false;
    }
  }

  // Initial load
  loadPosition();
  loadVisibility();

  // Drag functionality (simplified)
  let offsetX = 0, offsetY = 0, dragging = false;

  myDiv.addEventListener("mousedown", (e) => {
    if (e.target.tagName === "BUTTON") return;
    dragging = true;
    offsetX = e.clientX - myDiv.offsetLeft;
    offsetY = e.clientY - myDiv.offsetTop;
    myDiv.style.cursor = "grabbing";
  });

  document.addEventListener("mouseup", () => {
    if (dragging) {
      // Save position exactly as is
      localStorage.setItem("myDivX", myDiv.offsetLeft);
      localStorage.setItem("myDivY", myDiv.offsetTop);
      
      // Save visibility state separately
      localStorage.setItem(
        "avt_rightContent_hidden", 
        rightContent.classList.contains("hidden") ? "1" : "0"
      );
    }
    dragging = false;
    myDiv.style.cursor = "grab";
  });

  document.addEventListener("mousemove", (e) => {
    if (!dragging) return;
    const x = e.clientX - offsetX;
    const y = e.clientY - offsetY;
    const clamped = clampToViewport(x, y, myDiv);
    myDiv.style.left = clamped.x + "px";
    myDiv.style.top = clamped.y + "px";
    updateDirection();
    if (panel.classList.contains("show")) positionPanel();
  });

  // Toggle info (simplified)
  function toggleInfo() {
        const mouseX = event ? event.clientX : 0;
        if(mouseX + 240 > window.innerWidth) return; // Prevent toggling if near right edge
 
    
    if (window.avatarOnRight && !isHidden) {     
    
     // alert("DANGER ON RIGHT - NOT ALLOWED TO HIDE");
      if (rightContent.style.visibility === "hidden") {
        rightContent.style.visibility = "visible";
        //isHidden = false;
      } else {
        rightContent.style.visibility = "visible";
        //  rightContent.style.visibility = "hidden";
        //isHidden = true;
      }
       // If this was triggered by hide button, prevent default behavior
        
      return; // Block hiding attempt
    }

    rightContent.classList.toggle("hidden");
    myDiv.classList.toggle("shrinked", rightContent.classList.contains("hidden"));
    isHidden = rightContent.classList.contains("hidden");
    
    // Save visibility state
    localStorage.setItem("avt_rightContent_hidden", isHidden ? "1" : "0");
  }

  avatar.addEventListener("dblclick", toggleInfo);
  hideBtn.addEventListener("click", toggleInfo);

  // Reset position (unchanged)
  resetBtn.addEventListener("click", () => {
    localStorage.removeItem("myDivX");
    localStorage.removeItem("myDivY");
    myDiv.style.left = "20px";
    myDiv.style.top = window.innerHeight - 80 + "px";
    updateDirection();
  });

  // Panel toggle (unchanged)
  toggleBtn.addEventListener("click", () => {
    if (panelEl.classList.contains("show")) {
      panelEl.classList.remove("show", "slide-up", "slide-down");
      setTimeout(() => (panelEl.style.display = "none"), 50);
    } else {
      positionPanel();
      panelEl.classList.add("show");
    }
  });

  // Close panel (unchanged)
  closeBtn.addEventListener("click", () => {
    panelEl.classList.remove("show", "slide-up", "slide-down");
    setTimeout(() => (panelEl.style.display = "none"), 200);
  });

  // Language toggle (unchanged)
  window.lang = localStorage.getItem("lang") || "en";
  updateLangButton();
  langBtn.addEventListener("click", () => {
    window.lang = window.lang === "en" ? "th" : "en";
    localStorage.setItem("lang", window.lang);
    updateLangButton();
  });
  function updateLangButton() {
    langBtn.textContent = window.lang === "en" ? "E" : "T";
    if (window.lang === "en") {
      langBtn.textContent = "E";
      langBtn.style.backgroundColor = "#4CAF50"; // green
    } else {
      langBtn.textContent = "T";
      langBtn.style.backgroundColor = "#2196F3"; // blue
    }
  }

  // Helper functions (unchanged)
  function updateDirection() {
    const rect = myDiv.getBoundingClientRect();
    if (rect.left + 400 > window.innerWidth && rect.left - 400 > 0) {
      myDiv.style.flexDirection = "row-reverse";
      rightContent.style.marginLeft = "0";
      rightContent.style.marginRight = "8px";
      window.avatarOnRight = true;
    } else {
      myDiv.style.flexDirection = "row";
      rightContent.style.marginRight = "0";
      rightContent.style.marginLeft = "8px";
      window.avatarOnRight = false;
    }
  }

  function clampToViewport(x, y, div) {
    const w = div.offsetWidth;
    const h = div.offsetHeight;
    const maxX = window.innerWidth - (w + 5);
    const maxY = window.innerHeight - (h + 5);
    return {
      x: Math.max(0, Math.min(x, maxX)),
      y: Math.max(0, Math.min(y, maxY)),
    };
  }

  function positionPanel() {
    const rect = myDiv.getBoundingClientRect();
    const panelWidth = 200;
    const panelHeight = 200;
    const margin = 10;
    let top =
      rect.bottom + panelHeight + margin > window.innerHeight
        ? rect.top - panelHeight - margin - 20
        : rect.bottom + margin;
    panelEl.classList.toggle("slide-down", top > rect.top);
    panelEl.classList.toggle("slide-up", top <= rect.top);

    const left =
      rect.left > window.innerWidth / 2
        ? rect.left + 60
        : rect.right - (margin + panelWidth) - 60;

    panelEl.style.left = `${left}px`;
    panelEl.style.top = `${top}px`;
    panelEl.style.display = "block";
    requestAnimationFrame(() => panelEl.classList.add("show"));
  }
  function checkAvatarPosition(x, y) {
    const avatarWidth = 50;  // Avatar width only
    const avatarHeight = 60; // Container height
    const buffer = 5;        // Small margin
    
    return (
        x >= -buffer && 
        y >= -buffer &&
        x <= window.innerWidth - avatarWidth + buffer &&
        y <= window.innerHeight - avatarHeight + buffer
    );
}
function loadPosition() {
    const savedX = localStorage.getItem("myDivX");
    const savedY = localStorage.getItem("myDivY");
    const defaultX = 20;
    const defaultY = window.innerHeight - 80;

    if (savedX !== null && savedY !== null) {
        const parsedX = parseInt(savedX);
        const parsedY = parseInt(savedY);
        
        if (!checkAvatarPosition(parsedX, parsedY)) {
            console.log("Avatar would be off-screen, resetting position");
            localStorage.removeItem("myDivX");
            localStorage.removeItem("myDivY");
            myDiv.style.left = defaultX + "px";
            myDiv.style.top = defaultY + "px";
        } else {
            myDiv.style.left = savedX + "px";
            myDiv.style.top = savedY + "px";
        }
    } else {
        myDiv.style.left = defaultX + "px";
        myDiv.style.top = defaultY + "px";
    }
    
    updateDirection();
}
})();