<?php
// CORS headers
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");

// Handle OPTIONS preflight request
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

header('Content-Type: application/json');

// SQLite setup
$db = new SQLite3('data.db');
$db->exec('CREATE TABLE IF NOT EXISTS users (
    ida INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
    id TEXT,
    name TEXT,
    username TEXT,
    password TEXT,
    flag INTEGER DEFAULT 1,
    level INTEGER DEFAULT 1,
    img TEXT, -- New field for user avatar
    timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
)');
// Create logs table if not exists
$db->exec('CREATE TABLE IF NOT EXISTS logs (
    id INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
    username TEXT,
    timestamp DATETIME,
    datatime TEXT,
    act TEXT,
    status TEXT
)');
function generateUID() {
    list($usec, $sec) = explode(' ', microtime());
    $msec = sprintf('%03d', round($usec * 1000));
    return date('YmdHis') . $msec . uniqid('', true);
}
function addLog($db, $id,$username, $act, $status) {
    $timestamp = date('Y-m-d H:i:s');
    $datatime = date('c'); // ISO 8601 Format
    $stmt = $db->prepare('INSERT INTO logs (id,username, timestamp, datatime, act, status) VALUES (:id, :username, :timestamp, :datatime, :act, :status)');
    $stmt->bindValue(':id', $id, SQLITE3_TEXT);
    $stmt->bindValue(':username', $username, SQLITE3_TEXT);
    $stmt->bindValue(':timestamp', $timestamp, SQLITE3_TEXT);
    $stmt->bindValue(':datatime', $datatime, SQLITE3_TEXT);
    $stmt->bindValue(':act', $act, SQLITE3_TEXT);
    $stmt->bindValue(':status', $status, SQLITE3_TEXT);
    $stmt->execute();
}
$method = $_SERVER['REQUEST_METHOD'];
$action = $_GET['action'] ?? '';
$raw_input = file_get_contents('php://input');
$data = json_decode($raw_input, true);
$requestData = $data['data'] ?? null;

try {
    if ($action === 'add') {
        if ($method === 'POST' && $requestData) {
            //$id = !empty($requestData['id']) ? $requestData['id'] : generateUID();
            $id = generateUID();
            $name = $requestData['name'] ?? '';
            $username = $requestData['username'] ?? '';
            $password = $requestData['password'] ?? ''; // plain text
            $flag = $requestData['flag'] ?? 1;
            $level = $requestData['level'] ?? 1;
            $img = $requestData['img'] ?? ''; // New
            $timestamp = date('Y-m-d H:i:s');
            $stmt = $db->prepare('INSERT INTO users (id, name, username, password, flag, level, img, timestamp) 
                      VALUES (:id, :name, :username, :password, :flag, :level, :img, :timestamp)');
            $stmt->bindValue(':id', $id, SQLITE3_TEXT);
            $stmt->bindValue(':name', $name, SQLITE3_TEXT);
            $stmt->bindValue(':username', $username, SQLITE3_TEXT);
            $stmt->bindValue(':password', $password, SQLITE3_TEXT);
            $stmt->bindValue(':flag', $flag, SQLITE3_INTEGER);
            $stmt->bindValue(':level', $level, SQLITE3_INTEGER);
            $stmt->bindValue(':img', $img, SQLITE3_TEXT);
            $stmt->bindValue(':timestamp', $timestamp, SQLITE3_TEXT);

            if ($stmt->execute()) {
                echo json_encode([
                    'message' => 'User created',
                    'data' => $requestData + ['id' => $id, 'timestamp' => $timestamp]
                ]);
            } else {
                throw new Exception('Add failed');
            }
        } else {
            throw new Exception('Invalid add request');
        }
    } 
   elseif ($action === 'login') {
    if ($method === 'POST' && $requestData) {
        $username = $requestData['username'] ?? null;
        $password = $requestData['password'] ?? null;

        if ($username && $password) {
            $stmt = $db->prepare('SELECT * FROM users WHERE username = :username');
            $stmt->bindValue(':username', $username, SQLITE3_TEXT);
            $result = $stmt->execute();
            $user = $result->fetchArray(SQLITE3_ASSOC);

            if ($user) {
                if ($user['flag'] == 0) {
                    addLog($db, $id,$username, 'login', 'suspended');
                    http_response_code(403);
                    echo json_encode(['error' => 'Account suspended']);
                } elseif ($user['flag'] == 3) {
                    addLog($db, $id,$username, 'login', 'wait');
                    http_response_code(403);
                    echo json_encode(['error' => 'Account is on wait']);
                } elseif ($user['password'] === $password) {
                    addLog($db, $id,$username, 'login', 'success');
                    echo json_encode([
                        'message' => 'Login successful',
                        'id' => $user['id'],
                        'user' => $user['username'],
                        'name' => $user['name'],
                        'flag' => $user['flag'],
                        'level' => $user['level'],
                        'timestamp' => $user['timestamp'],
                        'img' => $user['img']
                    ]);
                } else {
                    addLog($db,$id, $username, 'login', 'wrong password');
                    http_response_code(401);
                    echo json_encode(['error' => 'Invalid password']);
                }
            } else {
                addLog($db,$id, $username, 'login', 'wrong user');
                http_response_code(401);
                echo json_encode(['error' => 'Invalid username or password']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Username and password are required']);
        }
    } else {
        http_response_code(400);
        echo json_encode(['error' => 'Invalid login request']);
    }
}



    elseif ($action === 'check_username') {
        if ($method === 'POST' && $requestData) {
            $username = $requestData['username'] ?? null;
            if ($username) {
                $stmt = $db->prepare('SELECT * FROM users WHERE username = :username');
                $stmt->bindValue(':username', $username, SQLITE3_TEXT);
                $result = $stmt->execute();
                $user = $result->fetchArray(SQLITE3_ASSOC);
                if ($user) {
                    echo json_encode(['exists' => true]);
                } else {
                    echo json_encode(['exists' => false]);
                }
            } else {
                http_response_code(400);
                echo json_encode(['error' => 'Username is required']);
            }
        } else {
            http_response_code(400);
            echo json_encode(['error' => 'Invalid request']);
        }
    }
    elseif ($action === 'list') {
        if ($method === 'GET') {
            $userId = $_GET['id'] ?? null;

            if ($userId) {
                $stmt = $db->prepare('SELECT * FROM users WHERE id = :id');
                $stmt->bindValue(':id', $userId, SQLITE3_TEXT);
                $results = $stmt->execute();
                $user = $results->fetchArray(SQLITE3_ASSOC);
                if ($user) {
                    echo json_encode(['data' => [$user]]);
                } else {
                    echo json_encode(['data' => []]);
                }
            } else {
                $results = $db->query('SELECT * FROM users');
                $users = [];
                while ($row = $results->fetchArray(SQLITE3_ASSOC)) {
                    $users[] = $row;
                }
                echo json_encode(['data' => $users]);
            }
        } else {
            http_response_code(405);
            echo json_encode(['error' => 'Invalid HTTP method for list action']);
        }
    }
    elseif ($action === 'del') {
        if (($method === 'DELETE' || $method === 'POST') && $requestData) {
            $id = $requestData['id'] ?? null;
            if ($id) {
                $stmt = $db->prepare('DELETE FROM users WHERE id = :id');
                $stmt->bindValue(':id', $id, SQLITE3_TEXT);
                if ($stmt->execute()) {
                    echo json_encode(['message' => 'User deleted']);
                } else {
                    throw new Exception('Delete failed');
                }
            } else {
                throw new Exception('Missing ID');
            }
        }
    }
    elseif ($action === 'update') {
        if (($method === 'PUT' || $method === 'POST') && $requestData) {
            $id = $requestData['id'] ?? null;
            if ($id) {
                $updates = [];
                $params = [':id' => $id];
                $types = [':id' => SQLITE3_TEXT];

                if (isset($requestData['name'])) {
                    $updates[] = 'name = :name';
                    $params[':name'] = $requestData['name'];
                    $types[':name'] = SQLITE3_TEXT;
                }
                if (isset($requestData['username'])) {
                    $updates[] = 'username = :username';
                    $params[':username'] = $requestData['username'];
                    $types[':username'] = SQLITE3_TEXT;
                }
                if (isset($requestData['password'])) {
                    $updates[] = 'password = :password';
                    $params[':password'] = $requestData['password']; // plain text
                    $types[':password'] = SQLITE3_TEXT;
                }
                if (isset($requestData['flag'])) {
                    $updates[] = 'flag = :flag';
                    $params[':flag'] = $requestData['flag'];
                    $types[':flag'] = SQLITE3_INTEGER;
                }
                if (isset($requestData['level'])) {
                    $updates[] = 'level = :level';
                    $params[':level'] = $requestData['level'];
                    $types[':level'] = SQLITE3_INTEGER;
                }
                if (isset($requestData['img'])) {
                    $updates[] = 'img = :img';
                    $params[':img'] = $requestData['img'];
                    $types[':img'] = SQLITE3_TEXT;
                }

                if (!empty($updates)) {
                    $sql = 'UPDATE users SET ' . implode(', ', $updates) . ' WHERE id = :id';
                    $stmt = $db->prepare($sql);
                    foreach ($params as $key => $value) {
                        $stmt->bindValue($key, $value, $types[$key]);
                    }
                    if ($stmt->execute()) {
                        echo json_encode(['message' => 'User updated']);
                    } else {
                        throw new Exception('Update failed');
                    }
                } else {
                    throw new Exception('No fields to update');
                }
            } else {
                throw new Exception('Missing ID');
            }
        }
    } else {
        throw new Exception('Invalid action');
    }
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode(['error' => $e->getMessage()]);
}

$db->close();
?>
