<?php
header('Access-Control-Allow-Origin: *');
// Strict sanitization for directory names only (keep existing)
$folder = preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folder'] ?? 'default');
$foldergroup = preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['foldergroup'] ?? '');
$folderuser = preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folderuser'] ?? 'unknown');
$isLogo = ($_POST['subfolder'] ?? '') === 'logo';

// Build upload directory
$uploadDir = "./s/$folder/";
if ($foldergroup) $uploadDir .= "$foldergroup/";
$uploadDir .= "$folderuser/";

// Ensure directory existsif ($isLogo &&
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0777, true) or die("ERROR: Failed to create directory");
}

if (empty($_FILES['fileUpload'])) {
    die("ERROR: No file uploaded");
}

$originalName = $_FILES['fileUpload']['name'];

// Preserve ALL characters (spaces, Unicode, symbols) except:
$filename = preg_replace([
    '/[\x00-\x1F\x7F]/u', // Control characters
    '/\.\.\//',           // Path traversal
    '/\.\//',             // Path traversal
    '/\s+/u',             // Replace spaces with underscores
], ['', '', '', '_'], $originalName);

// For logo files, just add prefix without changing filename
if ($isLogo && !str_starts_with($filename, 'logo_')) {
    $filename = 'logo_' . $filename;
}
$location = $uploadDir . $filename;

// Avoid overwrite
if (file_exists($location)) {
    $counter = 1;
    $pathInfo = pathinfo($filename);
    while (file_exists($location)) {
        $filename = $pathInfo['filename'] . " ($counter)." . $pathInfo['extension'];
        $location = $uploadDir . $filename;
        $counter++;
    }
}

if (move_uploaded_file($_FILES['fileUpload']['tmp_name'], $location)) {
    echo "s/$folder/" . ($foldergroup ? "$foldergroup/" : "") . "$folderuser/$filename";
} else {
    echo "ERROR: File move failed";
}
?>