function calculateCurrentScore(field) {
  if (!isFieldAnswered(field)) return 0;
  if (field.weights) {
    if (["radio", "radioatt", "radiotext", "radiotextatt"].includes(field.data_type)) {
      const radioValue = field.data_type.includes("radio") && field.value?.radio !== undefined ? field.value.radio : field.value;
      return field.weights[radioValue] || 0;
    }
    if (["checkbox", "checktext", "checktextatt"].includes(field.data_type)) {
      return field.value?.check?.reduce((sum, idx) => sum + (field.weights[idx] || 0), 0) || 0;
    }
  }
  return field.score || (isFieldAnswered(field) ? 1 : 0);
}
function isFieldAnswered(field) {
  if (!field) return false;
  const inputType = field.data_type || field.type;
  if (!inputType) return false;

  const isValidText = text => text && text.trim() !== "" && text !== "Others (please specify)/อื่น ๆ (โปรดระบุ)";
  const isValidAttachment = field => field.value?.att && countFiles({ value: field.value.att, data_type: "attachment" }) > 0;

  switch (inputType) {
    case "checkbox":
      return Array.isArray(field.value) && field.value.length > 0;
    case "radio":
    case "select":
      return field.value !== null && field.value !== "";
    case "attachment":
    case "file":
      return field.value && countFiles(field) > 0;
    case "radiotext":
      return field.value?.radio !== null || isValidText(field.value?.text);
    case "radioatt":
      return field.value?.radio !== null || isValidAttachment(field);
    case "radiotextatt":
      return field.value?.radio !== null || isValidText(field.value?.text) || isValidAttachment(field);
    case "checktext":
      return Array.isArray(field.value?.check) && (field.value.check.length > 0 || isValidText(field.value?.text));
    case "checktextatt":
      return Array.isArray(field.value?.check) && (field.value.check.length > 0 || isValidText(field.value?.text) || isValidAttachment(field));
    default:
      return field.value !== null && field.value !== "" && field.value !== undefined;
  }
}
function calculateMaxScore(field) {
  if (field.weights) {
    if (["radio", "radioatt", "radiotext", "radiotextatt"].includes(field.data_type)) {
      return Math.max(...field.weights);
    }
    if (["checkbox", "checktext", "checktextatt"].includes(field.data_type)) {
      return field.weights.filter(w => w > 0).reduce((sum, w) => sum + w, 0);
    }
  }
  return field.score || 1;
}
function countFiles(field) {
  if (!field || !field.value) return 0;
  if (field.data_type === "attachment" && typeof field.value === "string") {
    return field.value.split(",").filter(f => f.trim()).length;
  }
  if (["radiotextatt", "radioatt", "checktextatt"].includes(field.data_type) && field.value?.att && typeof field.value.att === "string") {
    return field.value.att.split(",").filter(f => f.trim()).length;
  }
  return 0;
}
function calculateScoreAchieved(field) {
  const currentScore = calculateCurrentScore(field);
  return (field.score || 1) * currentScore;
}