function makeCircleProgress(targetId) {
  // Remove existing instance if it exists
  const existingContainer = document.getElementById(targetId);
  if (existingContainer) {
    existingContainer.innerHTML = '';
  } else {
    console.error("Target container not found:", targetId);
    return;
  }

  // Create new content
  existingContainer.innerHTML = `
    <div id="circleprogress" style="display: flex; flex-direction: column; align-items: center;">
      <svg width="120" height="120">
        <circle cx="60" cy="60" r="50" stroke="#eee" stroke-width="12" fill="none" />
        <circle id="reqProgressCircle" cx="60" cy="60" r="50" stroke="#39923cff"
                stroke-width="12" fill="none" stroke-linecap="round"
                transform="rotate(-90 60 60)"
                stroke-dasharray="314" stroke-dashoffset="314" />
        <text id="reqPercentage" x="60" y="70" text-anchor="middle" font-size="30" font-weight="bold" fill="currentColor" >0%</text>
      </svg>
      <div id="reqProgressLabel" style="width: 160px; text-align: center; margin-top: 0px; font-size: 1em; ">
        <span>Progress: <span id="answeredCount">0</span>/<span id="totalCount">0</span></span>
      </div>
      <button id="testProgressButton" style="display:none; margin-top: 15px; padding: 8px 16px; background: #4caf50; color: white; border: none; border-radius: 4px; cursor: pointer;">
        Test Random Progress
      </button>
    </div>
  `;

  const radius = 50;
  const circumference = 2 * Math.PI * radius;
  const circle = existingContainer.querySelector("#reqProgressCircle");
  const label = existingContainer.querySelector("#reqPercentage");
  const answeredEl = existingContainer.querySelector("#answeredCount");
  const totalEl = existingContainer.querySelector("#totalCount");

  function updateRequirementProgress(answered, total) {
    answered = answered || 0;
    total = total || 0;
    const percent = total > 0 ? Math.round((answered / total) * 100) : 0;

    // Update counts
    if (answeredEl) answeredEl.textContent = answered;
    if (totalEl) totalEl.textContent = total;

    // Set color
    const color = percent === 100
      ? "#267829ff"
      : percent >= 50
      ? "#ffa600ff"
      : "#fc3526ff";
    if (circle) circle.style.stroke = color;

    // Animate progress
    const duration = 1500;
    const start = performance.now();

    function animate(time) {
      const elapsed = time - start;
      const progress = Math.min(elapsed / duration, 1);
      const value = percent * progress;
      const offset = circumference - (value / 100) * circumference;
      if (circle) circle.style.strokeDashoffset = offset;
      if (label) label.textContent = `${Math.round(value)}%`;
      if (progress < 1) requestAnimationFrame(animate);
    }

    requestAnimationFrame(animate);
  }

  // Attach test button
  existingContainer.querySelector("#testProgressButton").addEventListener("click", function() {
    const total = Math.floor(Math.random() * 20) + 5;
    const answered = Math.floor(Math.random() * (total + 1));
    updateRequirementProgress(answered, total);
  });

  // Optionally return update function if needed
  return updateRequirementProgress;
}