function showUserLangPanel(divId = "langswitcher", scale = 1) {
  const container = document.getElementById(divId);
  if (!container) {
    console.warn(`Div with id="${divId}" not found.`);
    return;
  }

  container.innerHTML = `
    <div style="line-height:1.5; text-align: center; transform: scale(${scale}); transform-origin: top left; display: inline-block;">
      <div id="langsw">
        <div id="userLanguageHTML">
          <div class="lang-switcher-slide" id="slideSwitch" onclick="toggleLang()" title="Click to toggle language">
            <div class="lang-slide-option">EN</div>
            <div class="lang-slide-option">TH</div>
            <div class="lang-slide-indicator"></div>
          </div>
        </div>
      </div>
    </div>
  `;

  // Initialize language switch state
  const savedLang = localStorage.getItem('language') || 'en';
  window.lang = savedLang;
  updateSwitch(savedLang);
}
function toggleLang() {
  const currentLang = localStorage.getItem('language') || 'en';
  const newLang = currentLang === 'en' ? 'th' : 'en';
  setLanguage(newLang);
  switchLang(newLang);
  window.lang = newLang;
}

function setLanguage(lang) {
  localStorage.setItem('language', lang);
  updateSwitch(lang);
  console.log('Language set to:', lang);
}

function updateSwitch(lang) {
  const switchEl = document.getElementById('slideSwitch');
  if (switchEl) {
    switchEl.classList.toggle('active', lang === 'th');
  }
}

function switchLang(lang) {
  window.lang = lang;
  document.querySelectorAll(".lang-btn").forEach((btn) => {
    btn.classList.toggle("active", btn.dataset.lang === lang);
  });

  (window.formStack || []).forEach((panelId) => {
    if (panelId === "gen" && typeof genpaN === "function") genpaN(window.userid);
    else if (panelId === "profile" && typeof profilepaN === "function") profilepaN(window.userid);
  });

  if (document.getElementById("summan") && typeof renderSchemaStructureToSumman === "function") {
    renderSchemaStructureToSumman(window.bucket, "gform", lang);
  }

  if (document.getElementById("jumperhelper") && typeof updateJumperHelperWithUnanswered === "function") {
    updateJumperHelperWithUnanswered(QSummary(window.bucket).summary, window.bucket);
  }
}

function addLangSwitcherStyles() {
  const styleId = "langSwitcherStyles";
  if (document.getElementById(styleId)) return; // Avoid duplicate

  const style = document.createElement("style");
  style.id = styleId;
  style.textContent = `
    .lang-switcher-slide {
      font-family: Arial, sans-serif;
      position: relative;
      display: inline-block;
      width: 120px;
      height: 40px;
      background: #f0f0f0;
      border-radius: 20px;
      overflow: visible;
      cursor: pointer;
    }
    .lang-slide-option {
      position: absolute;
      width: 50%;
      height: 100%;
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 2;
      color: #666;      
      font-size:28px;
    margin:0px;

      transition: color 0.3s;
    }
    .lang-slide-option:nth-child(1) { left: 0; }
    .lang-slide-option:nth-child(2) { left: 50%; }

    .lang-switcher-slide:not(.active) .lang-slide-option:nth-child(1),
    .lang-switcher-slide.active .lang-slide-option:nth-child(2) {
      color: white;
    }

    .lang-slide-indicator {
      position: absolute;
      width: 50%;
      height: 100%;
      background: #007bff;
      border-radius: 20px;
      transition: all 0.3s ease;
      left: 0;
      z-index: 1;
    }
    .lang-switcher-slide.active .lang-slide-indicator {
      left: 50%;
      background: #28a745;
    }
  `;
  document.head.appendChild(style);
}

