function saveScrollPosition(id = "gen", className = "panel-body") {
  const el = document.querySelector(`#${id} .${className}`);
  if (!el) return;
  localStorage.setItem(`scroll_${id}`, JSON.stringify({ top: el.scrollTop, left: el.scrollLeft }));
}

function restoreScrollPosition(id = "gen", className = "panel-body") {
  const el = document.querySelector(`#${id} .${className}`);
  if (!el) return;
  const pos = JSON.parse(localStorage.getItem(`scroll_${id}`) || "{}");
  if (typeof pos.top === "number") {
    el.scrollTo({ top: pos.top, left: pos.left || 0, behavior: "smooth" });

    // Blink border for 2 seconds
    el.style.transition = "border 0.3s";
    el.style.border = "2px solid red";
    setTimeout(() => {
      el.style.border = "";
    }, 2000);
  }
}

function saveScroll(id = "gen", className = "panel-body") {
  saveScrollPosition(id, className);
}

function restoreScroll(id = "gen", className = "panel-body") {
  restoreScrollPosition(id, className);
}

function smoothScrollTo(id, top = 0) {
  const el = document.getElementById(id);
  if (el) el.scrollTo({ top, behavior: "smooth" });
}
