function userStatus(action) {
  if (action === "off") {
    const statusEl = document.getElementById("userStatus");
    if (statusEl) statusEl.remove();
    return;
  }
  const userid = localStorage.getItem("userid");
  const user = localStorage.getItem("user");
  const user_name = window.username || localStorage.getItem("user_name");
  const flag = localStorage.getItem("flag");
  const level = localStorage.getItem("level");
  const img = localStorage.getItem("img");
  const logged = localStorage.getItem("logged");

  window.userid = userid;
  if (!logged || logged !== "true") {
    alert("Not allowed to access. Please login first.");
    window.location.href = "login.html";
    return;
  }

  // Create status bar if not present
  let statusEl = document.getElementById("userStatus");
  if (!statusEl) {
    statusEl = document.createElement("div");
    statusEl.id = "userStatus";
    statusEl.style.position = "fixed";
    statusEl.style.bottom = "0";
    //statusEl.style.left = '0';
    statusEl.style.right = "0";
    statusEl.style.background = "rgba(10,10,11,0.25)";
    statusEl.style.color = "#fff";
    statusEl.style.padding = "2px 10px";
    statusEl.style.textAlign = "right";
    statusEl.style.zIndex = "1";
    //statusEl.style.width = '50%';

    document.body.appendChild(statusEl);
  }

  statusEl.innerHTML = `
        Logged in as: ${user}
        <a href="#" id="userInfoLink" style="color:#0066ff; margin-left:5px; text-decoration:none">Info</a>
        <a href="#" id="userLogoutLink" style="color:#ff1155; margin-left:5px; text-decoration:none">Logout</a>
    `;
  addStyle(`
        #userStatus {
        font-size: 14px;
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.5);
        border-radius: 8px;
        }
        `);
  // Info click
  statusEl.querySelector("#userInfoLink")?.addEventListener("click", (e) => {
    e.preventDefault();
    showUserInfoPanel();
  });

  // Logout click
  statusEl.querySelector("#userLogoutLink")?.addEventListener("click", (e) => {
    e.preventDefault();
    logout();
  });
  statusEl.addEventListener("mousedown", (e) => startDrag(e, "userStatus"));
}

// The logout function
function logout() {
  localStorage.removeItem("userid");
  localStorage.removeItem("user");
  localStorage.removeItem("user_name");
  
  localStorage.removeItem("flag");
  localStorage.removeItem("level");
  localStorage.removeItem("img");
  localStorage.removeItem("user_startTimestamp");
  localStorage.removeItem("user_startDateTime");
  localStorage.removeItem("logged");
  alert("You have been logged out.");
  window.location.href = "login.html";
}

// The Info Panel
function showUserInfoPanel() {
  const user = localStorage.getItem("user");
  const userid = localStorage.getItem("userid");
  const user_name = localStorage.getItem("user_name");
  
  const flag = localStorage.getItem("flag");
  const level = localStorage.getItem("level");
  const img = localStorage.getItem("img");
  const user_startDateTime = localStorage.getItem("user_startDateTime");
  const user_startTimestamp = localStorage.getItem("user_startTimestamp");
  const user_imgr =
    localStorage.getItem("img") || "https://via.placeholder.com/80";
  user_img = atob(user_imgr);

  const userInfoHTML = `
        <div style="line-height:1.5; text-align: center;">
            <img src="${user_img}" alt="${user}"
                 style="border-radius: 50%; width: 80px; height: 80px; object-fit: cover; border: 2px solid #555;" />
            <h3 style="margin: 10px 0 5px 0">${user} (${user_name})</h3>
            <p style="margin: 0;"><strong>Flag:</strong> ${flag}</p>
            <p style="margin: 0;"><strong>Level:</strong> ${level}</p>
            </div>
            <p style="margin: 0; "><strong>ID:</strong><div style="overflow:hidden;text-overflow:ellipsis"> ${userid}</div></p>
            <hr style="margin: 10px 0;">
            <p><strong>Login Time:</strong><span style="font-size:13px"> ${user_startDateTime}</span></p>
            <p><strong>Timestamp:</strong> ${user_startTimestamp}</p>

    `;

  createPanel("userInfo", "CC", "btt", 300, 450, {
    noHeader: true,
    headerTitle: "User Info",
    bodyContent: userInfoHTML,
    bodyCloseButton: true,
    footerCloseBtn: true,
    footerTitle: "",
    noDrag: false,
    overflow: true,
    radius: "8px",
  });
}
