/* checklistv.js – vertical checklist only
   Assumes page already has:
        <div id="rail"></div>
        <div id="counter">0 of 5</div>
   Labels are read from <div id="labels" style="display:none">…</div>
*/
(function () {
  /* ---------- helpers ---------- */
  function $(sel) { return document.querySelector(sel); }

  function toggle(node) {
    node.classList.toggle('checked');
    updateCounter();
  }

  function updateCounter() {
    var checked = rail.querySelectorAll('.node.checked').length;
    counter.textContent = checked + ' of ' + rail.querySelectorAll('.node').length;
  }

  /* ---------- inject CSS once ---------- */
  if (!document.querySelector('#checklistv-css')) {
    var css = document.createElement('style');
    css.id  = 'checklistv-css';
    css.textContent =
      '#rail{position:relative;width:140px;margin:20px auto}' +
      '#line{position:absolute;left:14px;top:0;bottom:0;width:4px;background:#bbb;z-index:1}' +
      '.nodeWrap{position:relative;height:50px}' +
      '.node{position:absolute;left:0;top:50%;width:28px;height:28px;border-radius:50%;border:3px solid #555;background:#fff;cursor:pointer;transform:translateY(-50%);z-index:2;transition:background .2s;text-align:center;line-height:28px}' +
      '.node.checked{background:#4caf50}' +
      '.node .tick{display:none;color:#fff;font-size:18px}' +
      '.node.checked .tick{display:inline}' +
      '.label{position:absolute;left:40px;top:50%;transform:translateY(-50%);font-size:14px;white-space:nowrap}' +
      '#counter{text-align:center;margin-top:20px;font-size:18px}';
    document.head.appendChild(css);
  }

  /* ---------- build nodes ---------- */
  var rail   = $('#rail');
  var counter= $('#counter');
  var labelsRaw = ($('#labels') ? $('#labels').textContent.trim().split(/\s*\n\s*/) : []);
  var NODE_COUNT = labelsRaw.length || 5;

  /* vertical line */
  var line = document.createElement('div');
  line.id = 'line';
  rail.appendChild(line);

  for (var i = 0; i < NODE_COUNT; i++) {
    var wrap = document.createElement('div');
    wrap.className = 'nodeWrap';

    var node = document.createElement('div');
    node.className = 'node';
    node.innerHTML = '<span class="tick">&#10003;</span>';
    node.onclick = function () { toggle(this); };

    var lbl = document.createElement('div');
    lbl.className = 'label';
    lbl.textContent = labelsRaw[i] || ('Item ' + (i + 1));

    wrap.appendChild(node);
    wrap.appendChild(lbl);
    rail.appendChild(wrap);
  }

  updateCounter();

  /* ---------- API helpers (console) ---------- */
  window.checklistv = {
    check  : function (idx) { rail.querySelectorAll('.node')[idx].classList.add('checked');    updateCounter(); },
    uncheck: function (idx) { rail.querySelectorAll('.node')[idx].classList.remove('checked'); updateCounter(); },
    setLabel: function (idx, txt) {
      var lbl = rail.querySelectorAll('.node')[idx].parentNode.querySelector('.label');
      if (lbl) lbl.textContent = txt;
    }
  };
})();