addStyle(`      
     /* Toggle slide switch */
        .lang-switcher-slide {
        font-family: Arial, sans-serif;
            position: relative;
            display: inline-block;
            width: 120px;
            height: 40px;
            background: #f0f0f0;
            border-radius: 20px;
            overflow: hidden;
            cursor: pointer; /* Makes whole switch clickable */
        }
        .lang-slide-option {
            position: absolute;
            width: 50%;
            height: 100%;
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 2; /* Above the indicator */
            color: #666; /* Default text color */
            font-weight: bold;
            transition: color 0.3s;
        }
        .lang-slide-option:nth-child(1) { left: 0; }
        .lang-slide-option:nth-child(2) { left: 50%; }
        
        /* Active text color */
        .lang-switcher-slide:not(.active) .lang-slide-option:nth-child(1),
        .lang-switcher-slide.active .lang-slide-option:nth-child(2) {
            color: white; /* White text for active option */
        }
        
        /* Sliding indicator */
        .lang-slide-indicator {
            position: absolute;
            width: 50%;
            height: 100%;
            background: #007bff;
            border-radius: 20px;
            transition: all 0.3s ease;
            left: 0;
            z-index: 1;
        }
        .lang-switcher-slide.active .lang-slide-indicator {
            left: 50%;
            background: #28a745; /* Different color for TH */
        }
            
    `);
    createDiv("a",`
    <div class="lang-switcher-slide" id="slideSwitch" onclick="toggleLang()">
        <div class="lang-slide-option">EN</div>
        <div class="lang-slide-option">TH</div>
        <div class="lang-slide-indicator"></div>
    </div>
`);

       document.addEventListener('DOMContentLoaded', function() {
            const savedLang = localStorage.getItem('language') || 'en';
            updateSwitch(savedLang);
        });
        
        // Toggle between EN/TH
        function toggleLang() {
            const currentLang = localStorage.getItem('language') || 'en';
            const newLang = currentLang === 'en' ? 'th' : 'en';
            setLanguage(newLang);
        }
        
        // Update UI and storage
        function setLanguage(lang) {
            localStorage.setItem('language', lang);
            updateSwitch(lang);
            console.log('Language set to:', lang);
            // Add your actual language switching logic here
        }
        
        // Visual update
        function updateSwitch(lang) {
            const switchEl = document.getElementById('slideSwitch');
            switchEl.classList.toggle('active', lang === 'th');
        }
    