function stoast(htmlmsg, {pos = 'CC', backgroundcolor = '#333', color = '#fff', timeclose = 3000} = {}) {
    // Create toast element
    const toast = document.createElement('div');
    toast.innerHTML = htmlmsg;
    toast.style.cssText = `
        position: fixed;
        background: ${backgroundcolor};
        color: ${color};
        padding: 12px 20px;
        border-radius: 8px;
        box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        opacity: 0;
        transition: opacity 0.3s ease-in-out, transform 0.3s ease-in-out;
        z-index: 1000;
        max-width: 80%;
        word-wrap: break-word;
    `;

    // Append to body to measure dimensions
    document.body.appendChild(toast);
    
    // Get dimensions
    const w = toast.offsetWidth;
    const h = toast.offsetHeight;
    let l = 0;
    let t = 0;

    // Calculate position
    switch (pos) {
        case "TL": 
            l = 20;
            t = 20;
            break;
        case "TC": 
        case "T1": 
            l = (window.innerWidth - w) / 2;
            t = pos === 'T1' ? 20 : 50;
            break;
        case "TR": 
            l = window.innerWidth - w - 20;
            t = 20;
            break;
        case "TR1": 
            l = window.innerWidth - w - 10;
            t = 10;
            break;
        case "CL": 
            l = 20;
            t = (window.innerHeight - h) / 2;
            break;
        case "CC": 
            l = (window.innerWidth - w) / 2;
            t = (window.innerHeight - h) / 2;
            break;
        case "CR": 
            l = window.innerWidth - w - 20;
            t = (window.innerHeight - h) / 2;
            break;
        case "BL": 
            l = 20;
            t = window.innerHeight - h - 20;
            break;
        case "BC": 
            l = (window.innerWidth - w) / 2;
            t = window.innerHeight - h - 20;
            break;
        case "BR": 
            l = window.innerWidth - w - 20;
            t = window.innerHeight - h - 20;
            break;
    }

    // Apply position and initial transform
    toast.style.left = `${l}px`;
    toast.style.top = `${t}px`;
    toast.style.transform = 'translateY(20px)';

    // Animate in
    setTimeout(() => {
        toast.style.opacity = '1';
        toast.style.transform = 'translateY(0)';
    }, 10);

    // Animate out and remove
    setTimeout(() => {
        toast.style.opacity = '0';
        toast.style.transform = 'translateY(20px)';
        setTimeout(() => {
            toast.remove();
        }, 300);
    }, timeclose);

    return toast;
}