<script>
(function () {
  function createProgressBar(div, showLabel = true) {
    if (div._initialized) return;

    div.style.position = "relative";
    div.style.background = "#ddd";
    div.style.borderRadius = "4px";
    div.style.overflow = "hidden";

    if (!div.style.height) {
      div.style.height = showLabel ? "20px" : "2px";
    }

    const fill = document.createElement("div");
    fill.style.background = "#4caf50";
    fill.style.height = "100%";
    fill.style.width = "0%";
    fill.style.transition = "width 0.3s";
    div.appendChild(fill);

    let label = null;
    if (showLabel) {
      label = document.createElement("div");
      label.style.position = "absolute";
      label.style.top = "0";
      label.style.left = "0";
      label.style.width = "100%";
      label.style.height = "100%";
      label.style.display = "flex";
      label.style.alignItems = "center";
      label.style.justifyContent = "center";
      label.style.fontSize = "12px";
      label.style.fontFamily = "sans-serif";
      label.style.color = "#000";
      div.appendChild(label);
    }

    div._fill = fill;
    div._label = label;
    div._initialized = true;
  }

  function setProgress(divId, percent, showLabel) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    createProgressBar(div, showLabel);

    const clamped = Math.min(Math.max(percent, 0), 100);

    if (!div._hasSet) {
      div._fill.style.width = "0%";
      setTimeout(() => {
        div._fill.style.width = clamped + "%";
        if (showLabel && div._label) div._label.textContent = clamped + "%";
        div.title = `${clamped}%`;
      }, 50);
      div._hasSet = true;
    } else {
      div._fill.style.width = clamped + "%";
      if (showLabel && div._label) div._label.textContent = clamped + "%";
      div.title = `${clamped}%`;
    }
  }

  window.ProgressBar = function (divId, percent) {
    setProgress(divId, percent, true);
  };

  window.ProgressLine = function (divId, percent) {
    setProgress(divId, percent, false);
  };
})();
</script>
