(function () {
  // Ensure tooltip element exists
function createTooltipDiv() {
    if (!document.getElementById("tooltip")) {
      const tooltip = document.createElement("div");
      tooltip.id = "tooltip";
      tooltip.role = "tooltip";
      document.body.appendChild(tooltip);
    }
  }
function showPercent(percent, x, y) {
    clearInterval(countIntervalId);
    percent = Math.min(Math.max(percent, 0), 100); // clamp to 0–100

    let current = 0;
    const duration = 1000; // ms
    const steps = 30;
    const stepTime = duration / steps;
    const increment = percent / steps;

    const tooltip = document.getElementById("tooltip");
    tooltip.style.left = x + "px";
    tooltip.style.top = y + "px";
    tooltip.style.visibility = "visible";
    tooltip.style.opacity = "1";

    countIntervalId = setInterval(() => {
      current += increment;
      if (current >= percent) {
        current = percent;
        clearInterval(countIntervalId);
        countIntervalId = null;
        hideTimeoutId = setTimeout(() => hideTooltip(), 1000);
      }
      tooltip.innerHTML = Math.round(current) + "%";
    }, stepTime);
  }
  function addStyle() {
    const style = document.createElement("style");
    style.textContent = `
      #tooltip {
        position: fixed;
        background: #222;
        color: #fff;
        padding: 6px 10px;
        border-radius: 4px;
        font-size: 13px;
        white-space: nowrap;
        pointer-events: none;
        z-index: 9999;
        visibility: hidden;
        opacity: 0;
        transition: opacity 0.2s ease;
      }
    `;
    document.head.appendChild(style);
  }

  function showTooltip(text, x, y) {
    const tooltip = document.getElementById("tooltip");
    if (!tooltip) return;
    tooltip.innerHTML = text;
    tooltip.style.left = x + "px";
    tooltip.style.top = y + "px";
    tooltip.style.visibility = "visible";
    tooltip.style.opacity = "1";
  }

  function hideTooltip() {
    const tooltip = document.getElementById("tooltip");
    if (!tooltip) return;
    tooltip.style.visibility = "hidden";
    tooltip.style.opacity = "0";
  }

  // Setup
  createTooltipDiv();
  addStyle();

  // Expose globally
  window.showTooltip = showTooltip;
  window.hideTooltip = hideTooltip;
  
})();