function loadScript(url, callback) {
    // Remove old script with same URL (ignore timestamp)
    const old = document.querySelector(`script[data-url="${url}"]`);
    if (old) old.remove();

    // Create new script with cache-busting timestamp
    const script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = url + (url.includes('?') ? '&' : '?') + 't=' + Date.now();
    script.setAttribute('data-url', url);

    script.onload = () => {
        if (typeof callback === "function") callback();
    };
    script.onerror = () => {
        console.error(`Failed to load script: ${url}`);
    };

    document.head.appendChild(script);
}

// Example usage:
// loadScript("ul.js", () => {    console.log("ul.js loaded fresh every time!");});
function loadStyle(cssString, id = "dynamic-style") {
    // Remove old style if exists
    const oldStyle = document.getElementById(id);
    if (oldStyle) oldStyle.remove();

    // Create new style element
    const style = document.createElement("style");
    style.id = id;
    style.type = "text/css";
    style.textContent = cssString;

    document.head.appendChild(style);
}
