async function updateItemPanelEX(itemId = "", onUpdateDone = null) {
    const API = "https://j.kunok.com/api62.php";

    function renderForm(item) {
    return `
    <style>
        .form-row { display: flex; gap: 10px; }
        .form-row > div { flex: 1; }
        textarea {
            width: 100%;
            min-height: 100px;
            font-family: monospace;
            font-size: 13px;
            padding: 6px;
            resize: vertical;
        }
        .actions {
            margin-top: 10px;
            display: flex;
            gap: 10px;
            flex-wrap: wrap;
        }
    </style>
    <form id="updateItemFormEX">
        <div>
    <label for="itemId">ID:</label>
    <input type="text" id="itemId" value="${item.id}"  style="width: 100%;">
</div>

        <div><label for="itemName">Name:</label> <input type="text" id="itemName" value="${item.name || ''}" required></div>
        <div class="form-row">
            <div>
                <label for="itemFlag">Flag:</label>
                <select id="itemFlag">
                    <option value="1" ${item.flag == 1 ? "selected" : ""}>1 (Active)</option>
                    <option value="0" ${item.flag == 0 ? "selected" : ""}>0 (Hidden)</option>
                    <option value="3" ${item.flag == 3 ? "selected" : ""}>3 (Deleted)</option>
                </select>
            </div>
            <div>
                <label for="itemKeeper">Keeper:</label>
                <input type="text" id="itemKeeper" value="${item.keeper || ''}">
            </div>
        </div>
        <div>
            <label for="itemBoard">Board (JSON):</label>
            <textarea id="itemBoard">${item.board || ''}</textarea>
        </div>
        <div class="actions">
            <button type="submit">Update Item</button>
            <button type="button" id="assignToPlateBtn">Assign to Plate</button>
            <button type="button" id="assignFromPlateBtn">Assign from Plate</button>
            <button type="button" id="openUserListBtn">Open User List</button>
        </div>
    </form>
    <div id="lengthSummary" style="margin-top:10px; font-size:13px; color:#333;">
        <strong>Length Info:</strong><br>
        bucket: ${(item.bucket || "").length} | 
        cup: ${(item.cup || "").length} | 
        board: ${(item.board || "").length}
    </div>
    <div id="itemMessageEX" class="message"></div>
    `;
}


    function displayMessage(msg, isError = false) {
        const box = document.getElementById("itemMessageEX");
        if (box) {
            box.textContent = msg;
            box.style.color = isError ? "red" : "green";
        }
    }
function updateLengthSummary() {
//    const bucket = document.getElementById("itemBucket")?.value || "";
//    const cup = document.getElementById("itemCup")?.value || "";
//    const board = document.getElementById("itemBoard")?.value || "";

    const summaryBox = document.getElementById("lengthSummary");
    if (summaryBox) {
        summaryBox.innerHTML = `
            <strong>Length Info:</strong><br>
            bucket: ${window.bucket_plate.length} | 
            cup: ${window.bucket_plate.length} 
        `;
    }
}

    async function fetchItemData(id) {
        const res = await fetch(`${API}?id=${encodeURIComponent(id)}`);
        const json = await res.json();
        if (!json.data) throw new Error("Item not found");
        return json.data;
    }

    if (!itemId) {
        const urlParams = new URLSearchParams(window.location.search);
        itemId = urlParams.get("id");
    }

    if (!itemId) {
        createPanel("updateItemPanelEX", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">No item ID provided</div>`,
            noFooter: true,
            title: "Update Item"
        });
        return;
    }

    try {
        const original = await fetchItemData(itemId);

        createPanel("updateItemPanelEX", "CC", "ctc", 500, 640, {
            bodyContent: renderForm(original),
            noFooter: true,
            title: "Update Item"
        });

        setTimeout(() => {
            const form = document.getElementById("updateItemFormEX");
            if (form) {
                form.addEventListener("submit", async (e) => {
                    e.preventDefault();

                    const newId = document.getElementById("itemId").value.trim();
                    const payload = {
                        id: newId,
                        name: document.getElementById("itemName").value.trim(),
                        flag: parseInt(document.getElementById("itemFlag").value),
                        keeper: document.getElementById("itemKeeper").value.trim(),
                        board: document.getElementById("itemBoard").value.trim(),
                        bucket: original.bucket || "", // preserve original
                        cup: original.cup || ""
                    };

                    try {
                        const res = await fetch(API, {
                            method: "POST",
                            headers: { "Content-Type": "application/json" },
                            body: JSON.stringify({ data: payload })
                        });

                        const result = await res.json();
                        if (!res.ok || result.error) throw new Error(result.error || "Unknown error");

                        displayMessage(result.message || "Item updated");

                        if (typeof onUpdateDone === "function") {
                            onUpdateDone();
                        }

                    } catch (err) {
                        displayMessage("Error: " + err.message, true);
                    }
                });
            }

            // Handle "Assign to Plate"
            const toBtn = document.getElementById("assignToPlateBtn");
            if (toBtn) {
                toBtn.addEventListener("click", () => {
                    window.bucket_plate = original.bucket || "";
                    window.cup_plate = original.cup || "";
                    alert("Assigned to plate:\n\nbucket_plate = " + window.bucket_plate + "\ncup_plate = " + window.cup_plate);
                });
            }

            // Handle "Assign from Plate"
            const fromBtn = document.getElementById("assignFromPlateBtn");
            if (fromBtn) {
                fromBtn.addEventListener("click", () => {
                    original.bucket = window.bucket_plate || "";
                    original.cup = window.cup_plate || "";
                        updateLengthSummary();

                    alert("Assigned from plate:\n\nbucket = " + original.bucket + "\ncup = " + original.cup);
                });
            }

            // Handle Open User List
            const openListBtn = document.getElementById("openUserListBtn");
            if (openListBtn) {
                openListBtn.addEventListener("click", () => {
                    if (typeof userListPanel === "function") {
                        userListPanel();
                    } else {
                        alert("userListPanel() not available");
                    }
                });
            }
        }, 100);
    } catch (err) {
        console.error("Failed to load item:", err);
        createPanel("updateItemPanelEX", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">${err.message}</div>`,
            noFooter: true,
            title: "Update Item"
        });
    }
}
