async function userListPanel() {
    const defaultAvatar = 'https://placehold.co/40x40/ccc/fff.png?text=?';
    let allUsers = [];

    function renderFilterControls() {
        return `
            <div style="display:flex; gap:10px; margin-bottom:10px; align-items: center;">
                <input type="text" id="userSearchInput" placeholder="Search name/username..." style="flex:1; padding:4px;">
                <select id="levelFilter">
                    <option value="">All Levels</option>
                    <option value="1">Level 1</option>
                    <option value="2">Level 2</option>
                    <option value="3">Level 3</option>
                </select>
                <select id="flagFilter">
                    <option value="">All Flags</option>
                    <option value="0">0 (Suspended)</option>
                    <option value="1">1 (Active)</option>
                    <option value="3">3 (Wait)</option>
                </select>
            </div>
        `;
    }

    function renderTable(users = []) {
    if (!Array.isArray(users)) return `<div>No user data</div>`;
    return `
        <div>
            ${users.map(user => {
                if (user.img && !user.img.startsWith('http')) {
                    console.warn(`Invalid image URL for user ${user.id}: ${user.img}`);
                }
                return `
                    <div class="userlist-entry" data-user-id="${user.id}">
                        <img src="${user.img ? user.img : defaultAvatar}" onerror="this.src='${defaultAvatar}'" />
                        <div>
                            <div><strong>${user.name}</strong> (${user.username})</div>
                            <div class="meta">Level: ${user.level}, Flag: ${user.flag}</div>
                        </div>
                    </div>
                `;
            }).join("")}
        </div>
    `;
}

    function filterAndRender() {
        const search = document.getElementById("userSearchInput")?.value?.toLowerCase() || "";
        const level = document.getElementById("levelFilter")?.value;
        const flag = document.getElementById("flagFilter")?.value;

        const filtered = allUsers.filter(user => {
            const matchesSearch =
                user.name?.toLowerCase().includes(search) ||
                user.username?.toLowerCase().includes(search);
            const matchesLevel = level ? user.level == level : true;
            const matchesFlag = flag ? user.flag == flag : true;
            return matchesSearch && matchesLevel && matchesFlag;
        });

        const contentDiv = document.getElementById("userListContent");
        if (contentDiv) {
            contentDiv.innerHTML = renderTable(filtered);
            attachClickEvents();
        }
    }

    function attachClickEvents() {
        const entries = document.querySelectorAll(".userlist-entry");
        entries.forEach(entry => {
            entry.addEventListener("click", () => {
                const userId = entry.getAttribute("data-user-id");
                if (userId && typeof updateUserPanel === "function") {
                    //closePanel("userListPanel");
                    updateUserPanel(userId);
                } else {
                    alert("updateUserPanel function not found.");
                }
            });
        });
    }

    try {
        const res = await fetch("https://i.kunok.com/aui.php?action=list");
        const json = await res.json();
        allUsers = json.data || [];

        const html = `
            <style>
                .userlist-entry {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    margin-bottom: 10px;
                    padding: 6px;
                    border-bottom: 1px solid #eee;
                    cursor: pointer;
                    transition: background 0.2s;
                }
                .userlist-entry:hover {
                    background: #f9f9f9;
                }
                .userlist-entry img {
                    width: 40px;
                    height: 40px;
                    border-radius: 4px;
                    object-fit: cover;
                }
                .meta {
                    font-size: 12px;
                    color: #666;
                }
            </style>
            ${renderFilterControls()}
            <div id="userListContent">${renderTable(allUsers)}</div>
        `;

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include panel system.");
            return;
        }

        createPanel("userListPanel", "CC", "ctc", 500, 600, {
            bodyContent: html,
            noFooter: true,
            title: "User List"
        });

        // Attach events after panel render
        setTimeout(() => {
            ["userSearchInput", "levelFilter", "flagFilter"].forEach(id => {
                document.getElementById(id)?.addEventListener("input", filterAndRender);
            });
            attachClickEvents();
        }, 100);

    } catch (err) {
        console.error("Error loading user list:", err);
        createPanel("userListPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">${err.message}</div>`,
            noFooter: true,
            title: "User List"
        });
    }
}
