window.normaluser = true;

function switchto(id, name, username) {
    window.userid = id;
    console.log(`Switch to ${name} (${username}), ID: ${id} completed`);
    alert(`Switch to ${name} (${username}), ID: ${id} completed`);
    window.normaluser = true;
}

async function userListPanel() { 
    const host = 'https://i.kunok.com/';
    const defaultAvatar = 'https://placehold.co/40x40/ccc/fff.png?text=?';

    function render(users = []) {
        if (!Array.isArray(users)) return `<div>No data</div>`;
        return `
            <style>
                .userlist-entry {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    margin-bottom: 10px;
                    padding: 6px;
                    border-bottom: 1px solid #ddd;
                }
                .userlist-entry img {
                    width: 40px;
                    height: 40px;
                    border-radius: 4px;
                    object-fit: cover;
                }
                .switch-btn {
                    margin-left: auto;
                    padding: 5px 10px;
                    background-color: #007bff;
                    color: white;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                }
                .switch-btn:hover {
                    background-color: #0056b3;
                }
            </style>
            <div>
                ${users.map(user => {
                    const imgSrc = user.img && user.img.trim() !== "" ? user.img : defaultAvatar;
                    return `
                        <div class="userlist-entry">
                            <img src="${imgSrc}" onerror="this.src='${defaultAvatar}'" />
                            <div>
                                <div><strong>${user.name}</strong> (${user.username})</div>
                                <div style="font-size: 12px; color: #666;">
                                    IDA: ${user.ida}, ID: ${user.id}, Password: ${user.password}
                                </div>
                            </div>
                            <button class="switch-btn" onclick="switchto('${user.id}', '${user.name}', '${user.username}')">Switch</button>
                        </div>
                    `;
                }).join("")}
            </div>
        `;
    }

    try {
        //const res = await fetch("https://i.kunok.com/aui.php?action=list");
         const res = await fetch(`${host}aui.php?action=list`);
        const json = await res.json();

        let users = json.data || [];

        // ✅ apply condition if window.normaluser is true
        if (window.normaluser) {
            users = users.filter(u => Number(u.ida) > 43 && Number(u.flag) === 1);
            let totalCount = users.length;
            UfooterContent = `Total:${totalCount}`;

        }

        const html = render(users);

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include panel system.");
            return;
        }

        createPanel("userListPanel", "CC", "ctc", 500, 600, {
            bodyContent: html,
            noFooter: false,
            title: window.normaluser ? "User List (Normal Users)" : "User List",
                        footerTitle:UfooterContent,
                        resizeAble: true,

        });

    } catch (err) {
        console.error("Error loading user list:", err);
        createPanel("userListPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">${err.message}</div>`,
            noFooter: true,
            title: "User List"
        });
    }
}