<?php
// apix.php
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type");
header("Content-Type: application/json");

$dbfile = __DIR__ . "/dbx.db";

// --- initdatabase ---
if (isset($_GET['initdatabase'])) {
    if (file_exists($dbfile)) unlink($dbfile);
    $db = new SQLite3($dbfile);

    $db->exec("CREATE TABLE users (
        ida INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
        id TEXT,
        name TEXT,
        username TEXT,
        password TEXT,
        flag INTEGER DEFAULT 1,
        level INTEGER DEFAULT 1,
        timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
        img TEXT
    )");

    $db->exec("CREATE TABLE items (
        ida INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL,
        id TEXT,
        name TEXT,
        flag INTEGER DEFAULT 1,
        timestamp DATETIME DEFAULT CURRENT_TIMESTAMP,
        bucket TEXT,
        cup TEXT,
        board TEXT,
        keeper TEXT
    )");

    echo json_encode(["ok"=>true,"msg"=>"Database initialized"]);
    exit;
}

if (!file_exists($dbfile)) {
    echo json_encode(["error"=>"Database not found. Call ?initdatabase=1 first."]);
    exit;
}
$db = new SQLite3($dbfile);

// helper: get body JSON
$method = $_SERVER['REQUEST_METHOD'];
$body = json_decode(file_get_contents("php://input"), true);
if (!$body) $body = [];

// path
$path = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);

// --- USERS ---
if (strpos($path, "/users") !== false) {
    if ($method=="GET" && preg_match("#/users/([^/]+)$#", $path, $m)) {
        $id = $m[1];
        $stmt = $db->prepare("SELECT * FROM users WHERE id=?");
        $stmt->bindValue(1, $id, SQLITE3_TEXT);
        $res = $stmt->execute()->fetchArray(SQLITE3_ASSOC);
        echo json_encode(["data"=>$res]); exit;
    }
    if ($path=="/users" && $method=="GET") {
        $res = $db->query("SELECT * FROM users");
        $out=[];
        while($row=$res->fetchArray(SQLITE3_ASSOC)) $out[]=$row;
        echo json_encode(["data"=>$out]); exit;
    }
    if ($path=="/users/add" && $method=="POST") {
        $id = $body['id'] ?? uniqid();
        $stmt = $db->prepare("INSERT INTO users (id,name,username,password,flag,level,img) VALUES (?,?,?,?,?,?,?)");
        $stmt->bindValue(1,$id);
        $stmt->bindValue(2,$body['name'] ?? "");
        $stmt->bindValue(3,$body['username'] ?? "");
        $stmt->bindValue(4,$body['password'] ?? "");
        $stmt->bindValue(5,$body['flag'] ?? 1);
        $stmt->bindValue(6,$body['level'] ?? 1);
        $stmt->bindValue(7,$body['img'] ?? "");
        $stmt->execute();
        echo json_encode(["ok"=>true,"id"=>$id]); exit;
    }
    if ($path=="/users/update" && ($method=="POST"||$method=="PUT")) {
        if (empty($body['id'])) { echo json_encode(["error"=>"Missing id"]); exit; }
        $fields=["name","username","password","flag","level","img"];
        $updates=[];$values=[];
        foreach($fields as $f){ if(isset($body[$f])){ $updates[]="$f=?"; $values[]=$body[$f]; } }
        if(!$updates){ echo json_encode(["error"=>"No fields to update"]); exit; }
        $values[]=$body['id'];
        $stmt=$db->prepare("UPDATE users SET ".implode(",",$updates)." WHERE id=?");
        foreach($values as $i=>$v) $stmt->bindValue($i+1,$v);
        $stmt->execute();
        echo json_encode(["ok"=>true]); exit;
    }
    if ($path=="/users/delete" && ($method=="POST"||$method=="DELETE")) {
        if (empty($body['id'])) { echo json_encode(["error"=>"Missing id"]); exit; }
        $stmt=$db->prepare("DELETE FROM users WHERE id=?");
        $stmt->bindValue(1,$body['id']);
        $stmt->execute();
        echo json_encode(["ok"=>true]); exit;
    }
}

// --- ITEMS ---
if (strpos($path, "/items") !== false) {
    if ($method=="GET" && preg_match("#/items/([^/]+)$#", $path, $m)) {
        $id = $m[1];
        $stmt = $db->prepare("SELECT * FROM items WHERE id=? AND flag!=3");
        $stmt->bindValue(1, $id, SQLITE3_TEXT);
        $res = $stmt->execute()->fetchArray(SQLITE3_ASSOC);
        if($res && $res['board']){ $res['board']=json_decode($res['board'],true); }
        echo json_encode(["data"=>$res]); exit;
    }
    if ($path=="/items" && $method=="GET") {
        $res = $db->query("SELECT * FROM items WHERE flag!=3");
        $out=[];
        while($row=$res->fetchArray(SQLITE3_ASSOC)){
            if($row['board']) $row['board']=json_decode($row['board'],true);
            $out[]=$row;
        }
        echo json_encode(["data"=>$out]); exit;
    }
    if ($path=="/items/add" && $method=="POST") {
        $id = $body['id'] ?? uniqid();
        $stmt=$db->prepare("INSERT INTO items (id,name,flag,bucket,cup,board,keeper) VALUES (?,?,?,?,?,?,?)");
        $stmt->bindValue(1,$id);
        $stmt->bindValue(2,$body['name'] ?? "");
        $stmt->bindValue(3,$body['flag'] ?? 1);
        $stmt->bindValue(4,$body['bucket'] ?? "");
        $stmt->bindValue(5,$body['cup'] ?? "");
        $stmt->bindValue(6,is_array($body['board'])?json_encode($body['board']):($body['board'] ?? ""));
        $stmt->bindValue(7,$body['keeper'] ?? "");
        $stmt->execute();
        echo json_encode(["ok"=>true,"id"=>$id]); exit;
    }
    if ($path=="/items/update" && ($method=="POST"||$method=="PUT")) {
        if (empty($body['id'])) { echo json_encode(["error"=>"Missing id"]); exit; }
        $fields=["name","flag","bucket","cup","board","keeper"];
        $updates=[];$values=[];
        foreach($fields as $f){
            if(isset($body[$f])){
                $updates[]="$f=?";
                $values[]=($f=="board" && is_array($body[$f]))?json_encode($body[$f]):$body[$f];
            }
        }
        if(!$updates){ echo json_encode(["error"=>"No fields to update"]); exit; }
        $values[]=$body['id'];
        $stmt=$db->prepare("UPDATE items SET ".implode(",",$updates)." WHERE id=?");
        foreach($values as $i=>$v) $stmt->bindValue($i+1,$v);
        $stmt->execute();
        echo json_encode(["ok"=>true]); exit;
    }
    if ($path=="/items/delete" && ($method=="POST"||$method=="DELETE")) {
        if (empty($body['id'])) { echo json_encode(["error"=>"Missing id"]); exit; }
        $stmt=$db->prepare("UPDATE items SET flag=3 WHERE id=?");
        $stmt->bindValue(1,$body['id']);
        $stmt->execute();
        echo json_encode(["ok"=>true]); exit;
    }
}

// --- console test for structure ---
if (isset($_GET['console'])) {
    $res1 = $db->query("PRAGMA table_info(users)");
    $users=[]; while($r=$res1->fetchArray(SQLITE3_ASSOC)) $users[]=$r;
    $res2 = $db->query("PRAGMA table_info(items)");
    $items=[]; while($r=$res2->fetchArray(SQLITE3_ASSOC)) $items[]=$r;
    echo json_encode(["users"=>$users,"items"=>$items]); exit;
}

echo json_encode(["error"=>"Not found"]);
