function genform(divId, data) {
  
  console.log("🧪 genform data keys:", Object.keys(data));
  console.log("🧪 schema.grouping:", data.grouping);
  const container = document.getElementById(divId);
  if (!container) {
    console.error(`Div with ID ${divId} not found`);
    return;
  }

  // Store reference to original data (no deep copy)
  //container._formData = data;
  // 2. Validate and store data FIRST
  container._formData = {
    ...data,
    grouping: data.grouping || {
      // Ensure grouping exists
      name: ["default"],
      type: ["segment"],
      label: { en: ["Default"], th: ["ค่าเริ่มต้น"] },
    },
  };
  const lang = window.lang || "en";

  // Normalize values on load
  for (const key in data) {
    if (key === "grouping" || data[key].type === "section") continue;
    const field = data[key];
    if (
      field.data_type === "radiotext" ||
      field.data_type === "radiotextatt" ||
      field.data_type === "radioatt"
    ) {
      if (
        !field.value ||
        field.value.radio === "" ||
        field.value.text === "Others (please specify)/อื่น ๆ (โปรดระบุ)"
      ) {
        field.value = { radio: null, text: "", att: "" };
      }
    } else if (
      field.data_type === "checktext" ||
      field.data_type === "checktextatt"
    ) {
      if (!field.value || !Array.isArray(field.value.check)) {
        field.value = { check: [], text: "", att: "" };
      }
    }
  }

  // Initialize container HTML
  container.innerHTML = `
    <div style="font-family: Arial, sans-serif;">
      <div style="display: none; justify-content: space-between; align-items: center;">
        <h3 style="font-size: 0.8em;">${getLabel({ label: { en: "Form in", th: "FORM" } }, lang)} ${divId}</h3>
      </div>
      <div id="${divId}-fields"></div>
      <div style="display:none;">
        <textarea id="${divId}-input" placeholder="Enter JSON schema"></textarea>
        <button id="${divId}-copy-btn">Copy to Schema</button>
        <textarea id="${divId}-output" readonly></textarea>
      </div>
    </div>
  `;

  const fieldsDiv = document.getElementById(`${divId}-fields`);
  const schema = container._formData;
  //  const grouping = getGroupingData(schema);
  // 27725
  const grouping = getGroupingData(schema) || {};
  const groupNames = Array.isArray(grouping.name) ? grouping.name : [];
  const groupLabels = {
    en: Array.isArray(grouping.label?.en) ? grouping.label.en : [],
    th: Array.isArray(grouping.label?.th) ? grouping.label.th : [],
  };
  // 27725

  // Organize segments and sections
  const segments = new Map();

  if (grouping) {
    const names = Array.isArray(grouping.name) ? grouping.name : [];
    const types = Array.isArray(grouping.type) ? grouping.type : [];
    const labels = {
      en: Array.isArray(grouping.label?.en) ? grouping.label.en : [],
      th: Array.isArray(grouping.label?.th) ? grouping.label.th : [],
    };
    console.log("Grouping:", grouping);
    console.log("Names:", names, "Types:", types, "Labels:", labels);

    names.forEach((name, i) => {
      if (types[i] === "segment") {
        const segmentLabel = {
          en: labels.en[i] || name,
          th: labels.th[i] || name,
        };
        console.log(`Creating segment: ${name}, Label:`, segmentLabel);
        segments.set(name, {
          label: segmentLabel,
          sections: new Map(),
        });
      }
    });
  } else {
    console.warn("No valid grouping found in schema. Using default segment.");
    segments.set("default", {
      label: {
        en: "Default",
        th: "ค่าเริ่มต้น",
      },
      sections: new Map(),
    });
  }

  // Map fields to segments and sections
  for (const key in schema) {
    if (key === "grouping" || schema[key].type !== "field") continue;
    const field = schema[key];
    const segment =
      field.segment?.[0] ||
      (grouping?.name && Array.isArray(grouping.name)
        ? grouping.name[0]
        : grouping?.name) ||
      "default";

    if (!segments.has(segment)) {
      segments.set(segment, {
        label: { en: segment, th: segment },
        sections: new Map(),
      });
    }

    if (field.section) {
      if (!segments.get(segment).sections.has(field.section)) {
        if (schema[field.section]) {
          segments
            .get(segment)
            .sections.set(
              field.section,
              getLabel(schema[field.section], lang) || field.section,
            );
        } else {
          console.warn(
            `Section ${field.section} for field ${key} not found in schema`,
          );
        }
      }
    } else {
      console.warn(`Field ${key} has no section assigned`);
    }
  }

  // Generate form structure
  segments.forEach((segmentData, segmentId) => {
    const segDetails = document.createElement("details");
    segDetails.className = "segment";
    segDetails.style.cssText =
      "border-radius: 5px; background-color: rgba(255,255,255,.3); backdrop-filter: blur(15px); border: 1px solid #4a90e2; margin-bottom: 10px; padding: 10px;";
    segDetails.id = `${divId}-segment-${encodeFieldKey(segmentId)}`;
    segDetails.open = true;
    ////segDetails.innerHTML = `<summary style="font-weight: bold; cursor: pointer;">${getLabel({ label: { en: "Segment", th: "Segment" } }, lang)}: ${getLabel(segmentData.label, lang) || segmentId}</summary>`;
    // 2407 const segmentLabel = getLabel(segmentData.label, lang) ||  (typeof segmentData.label === 'string' ? segmentData.label : segmentId);
    // Safely get the segment label
    const segmentIndex = groupNames.indexOf(segmentId);
    const segmentLabel =
      (groupLabels[lang] && groupLabels[lang][segmentIndex]) ||
      (groupLabels.en && groupLabels.en[segmentIndex]) ||
      segmentId;

    segDetails.innerHTML = `<summary style="font-weight: bold; cursor: pointer;">${getLabel({ label: { en: "Segment", th: "Segment" } }, lang)}: ${segmentLabel}</summary>`;

    const segDiv = document.createElement("div");
    segDiv.style.padding = "10px";

    segmentData.sections.forEach((sectionLabel, sectionId) => {
      const secDetails = document.createElement("details");
      secDetails.className = "section";
      secDetails.id = `${divId}-section-${encodeFieldKey(sectionId)}`;
      secDetails.style.cssText =
        "box-shadow: 0 14px 12px rgba(100, 100, 100, 0.1); border-radius: 8px; background-color: rgba(255,255,255,.1); backdrop-filter: blur(20px); border: 1px solid rgba(150,200,200,.5); margin: 8px 0; padding: 4px 8px;";
      secDetails.open = true;

      let sectionTotals = {
        allFields: 0,
        requiredFields: 0,
        answeredFields: 0,
        answeredRequiredFields: 0,
        totalScore: 0,
        totalScoreWeighted: 0,
        maxPossibleScore: 0,
        maxPossibleScoreWeighted: 0,
        totalFiles: 0,
        unansweredFields: [],
      };

      for (const key in schema) {
        if (key === "grouping" || schema[key].type === "section") continue;
        const field = schema[key];
        if (field.section !== sectionId || !field.segment?.includes(segmentId))
          continue;

        const currentScore = calculateCurrentScore(field);
        const maxScore = calculateMaxScore(field);
        const isAnswered = isFieldAnswered(field);
        const fileCount = countFiles(field);

        sectionTotals.allFields++;
        if (field.required) sectionTotals.requiredFields++;
        if (isAnswered) sectionTotals.answeredFields++;
        if (field.required && isAnswered)
          sectionTotals.answeredRequiredFields++;
        sectionTotals.totalScore += isAnswered ? field.score || 1 : 0;
        sectionTotals.totalScoreWeighted += currentScore;
        sectionTotals.maxPossibleScore += field.score || 1;
        sectionTotals.maxPossibleScoreWeighted += maxScore;
        sectionTotals.totalFiles += fileCount;
        if (field.required && !isFieldAnswered(field)) {
          if (
            document.getElementById(`${divId}-field-${encodeFieldKey(key)}`)
          ) {
            sectionTotals.unansweredFields.push({
              key,
              label: getLabel(field, lang) || key,
            });
          } else {
            console.warn(
              `Field ${key} not rendered in DOM, skipping from unanswered list`,
            );
          }
        }
      }

      const progressPercent =
        sectionTotals.requiredFields > 0
          ? Math.round(
              (sectionTotals.answeredRequiredFields /
                sectionTotals.requiredFields) *
                100,
            )
          : 100;
      secDetails.innerHTML = `
        <summary style="cursor: pointer; margin-top: 10px; padding: 8px; background-color: rgba(200,190,200,.1); border-radius: 4px; font-size: 0.9em;">
          <span style="font-weight: bold;">${sectionLabel}</span>
        </summary>
        <div id="${divId}-section-header-${encodeFieldKey(sectionId)}" style="margin-bottom: 8px; padding: 8px; background-color: rgba(200,200,200,.1); ">

            [Progress: ${progressPercent}% (${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields})]
            <div style="width: 100%; height: 10px; border-radius: 5px; overflow: hidden;">
              <div style="width: ${progressPercent}%; background-color: #4caf50; height: 100%;"></div>

          </div>
        </div>
      `;

      const secDiv = document.createElement("div");
      secDiv.style.padding = "18px 0px";

      let hasField = false;
      for (const key in schema) {
        if (key === "grouping" || schema[key].type === "section") continue;
        const field = schema[key];
        if (field.section !== sectionId || !field.segment?.includes(segmentId))
          continue;

        hasField = true;
        const fieldDiv = document.createElement("div");
        fieldDiv.className = "form-field";
        fieldDiv.id = `${divId}-field-${encodeFieldKey(key)}`;
        fieldDiv.style.cssText =
          "font-weight: 350; border-radius: 5px; border: 1px solid rgba(120,120,120,.05);box-shadow: 0px 0px 0px 1px rgba(100,100, 100, 0.1);background-color: rgba(215,215,215,.1); backdrop-filter: blur(10px); padding: 10px; margin-bottom: 10px; border-radius: 4px;";
        if (field.required && !isFieldAnswered(field)) {
          fieldDiv.style.outline = "2px solid red";
        }

        const label = document.createElement("label");
        label.style.cssText =
          "margin: 10px 0px;  box-shadow: 1px 1px rgba(100, 100, 100, 0.1);padding: 10px 5px; border-radius: 5px; background-color: rgba(255,255,255,.5); backdrop-filter: blur(5px); font-weight: 500; margin-right: 6px; display: block; padding-bottom: 5px;";
        if (field.required) label.classList.add("required-field");
        label.innerHTML =
          (getLabel(field, lang) || key) + (field.required ? "" : "");
        label.htmlFor = `${divId}-${encodeFieldKey(key)}`;
        if (field.score !== undefined || field.weights) {
          const scoreDisplay = document.createElement("span");
          scoreDisplay.className = "score-display";
          const maxScore = calculateMaxScore(field);
          const currentScore = calculateCurrentScore(field);
          if (typeof window.score !== "undefined" && window.score) {
            scoreDisplay.textContent = `(Score: ${currentScore}/${maxScore})`;
          }
          label.appendChild(scoreDisplay);
        }
        fieldDiv.appendChild(label);

        const input = createInputElement(divId, key, field, lang, schema);
        fieldDiv.appendChild(input);
        fieldDiv.appendChild(
          createResetButton(divId, key, field, input, lang, schema, fieldDiv),
        );

        const scoreBar = document.createElement("div");
        scoreBar.className = "score-bar";
        scoreBar.style.cssText =
          "margin-top: 5px; font-size: 0.9em; color: #555;overflow:auto;";
        const currentScore = calculateCurrentScore(field);
        const maxScore = calculateMaxScore(field);
        const scoreAchieved = calculateScoreAchieved(field);
        const weight = field.weights ? field.weights.join(", ") : "1";
        const fileCount = countFiles(field);
        let valueText = "";
        if (typeof field.value === "object" && field.value !== null) {
          try {
            valueText = JSON.stringify(field.value);
          } catch (e) {
            valueText = "[object]";
          }
        } else {
          valueText = field.value || "";
        }
        //scoreshow
        if(window.scoreshow) {
            if(window.super) {
            scoreBar.textContent = `[score: ${currentScore}, weight: ${weight}, maxscore: ${maxScore}, score achieved: ${scoreAchieved.toFixed(1)}, required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`
            } else {
                scoreBar.textContent =`[Required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`;
            }
        }
        
        fieldDiv.appendChild(scoreBar);

        secDiv.appendChild(fieldDiv);
      }

      if (hasField) {
        const sectionSummary = document.createElement("details");
        sectionSummary.className = "section-summary";
        sectionSummary.id = `${divId}-summary-${encodeFieldKey(segmentId)}-${encodeFieldKey(sectionId)}`;
        sectionSummary.style.cssText =
          "margin-top: 10px; padding: 8px; background-color: rgba(200,200,200,.6); border-radius: 4px; font-size: 0.9em;";
        sectionSummary.open = true;
        const unansweredCount =
          sectionTotals.requiredFields - sectionTotals.answeredRequiredFields;
        //[field total: ${sectionTotals.allFields}, score: ${sectionTotals.totalScore}, achieved score: ${sectionTotals.totalScoreWeighted}, maxscore: ${sectionTotals.maxPossibleScoreWeighted}, total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]
        scs="";
        if (window.scoreshow) {scs=`score: ${sectionTotals.totalScore}, achieved score: ${sectionTotals.totalScoreWeighted}, maxscore: ${sectionTotals.maxPossibleScoreWeighted}, `;} else {scs=``;}
        sectionSummary.innerHTML = `
          <summary style="cursor: pointer;">UnAnswered/Total/TotalRequired (${unansweredCount}/${sectionTotals.allFields}/${sectionTotals.requiredFields})</summary>
          <div style="padding: 8px;">
            [field total: ${sectionTotals.allFields}, ${scs} total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]
            ${
              sectionTotals.unansweredFields.length > 0
                ? `
              <div style="margin-top: 10px; color: red;">
                <strong>Unanswered Required Fields:</strong>
                <ul style="margin: 5px 0; padding-left: 20px;">
                  ${sectionTotals.unansweredFields
                    .map(
                      (field) => `
                    <li style="max-width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                      <a href="javascript:scrollToField('${encodeFieldKey(field.key)}', '${divId}')"
                         style="text-decoration: none; color: red;"
                         title="${field.label}">
                        ${field.label}
                      </a>
                    </li>
                  `,
                    )
                    .join("")}
                </ul>
              </div>
            `
                : ""
            }
          </div>
        `;
        secDiv.appendChild(sectionSummary);
        segDiv.appendChild(secDetails);
        secDetails.appendChild(secDiv);
      }
    });

    segDetails.appendChild(segDiv);
    fieldsDiv.appendChild(segDetails);
  });

  // Handle schema copy button
  const copyBtn = document.getElementById(`${divId}-copy-btn`);
  copyBtn.addEventListener("click", () => {
    const inputEl = document.getElementById(`${divId}-input`);
    try {
      const newSchema = JSON.parse(inputEl.value);
      genform(divId, newSchema);
    } catch (e) {
      console.error(`Invalid JSON in ${divId}-input: ${e.message}`);
      alert(
        getLabel(
          {
            label: {
              en: `Invalid JSON: ${e.message}`,
              th: `JSON ไม่ถูกต้อง: ${e.message}`,
            },
          },
          lang,
        ),
      );
    }
  });
  // NEW DEBUGGING SECTION - RIGHT BEFORE listenform
  console.groupCollapsed("🛠️ Pre-listenform Debug");
  console.log("1. Schema data exists?", !!container._formData);
  console.log("2. Schema keys:", Object.keys(container._formData));
  console.log("3. Bucket data:", container._formData.bucket);
  console.log("4. Summan element exists?", !!document.getElementById("summan"));

  // DIRECT SUMMARY RENDER ATTEMPT
  // 5. NEW CRITICAL FIX: Immediate summary render
  const renderSummaryNow = () => {
    if (container._formData && document.getElementById("summan")) {
      renderSchemaStructureToSumman(
        container._formData,
        divId,
        window.lang || "en",
      );
    }
  };

  // 6. Call it both immediately AND after slight delay
  renderSummaryNow();
  setTimeout(renderSummaryNow, 50); // Double safety
  listenform(divId);
  
}
// Helper functions
function getOptions(field, lang) {
  if (Array.isArray(field.options)) {
    return field.options;
  }
  return field.options?.[lang] || field.options?.en || [];
}
function getLabel(field, lang) {
  return field.label?.[lang] || field.label?.en || "";
}
function encodeFieldKey(key) {
  return encodeURIComponent(key).replace(/'/g, "'");
}
function getGroupingData(schema) {
  // Default structure
  const defaultResult = {
    name: ["default"],
    type: ["segment"],
    label: {
      en: ["Default"],
      th: ["ค่าเริ่มต้น"],
    },
    // Include all necessary default values
    segments: [],
    summary: {
      segments: {},
      totals: {
        allFields: 0,
        requiredFields: 0,
        answeredFields: 0,
        answeredRequiredFields: 0,
        totalScore: 0,
        totalScoreWeighted: 0,
        maxPossibleScore: 0,
        maxPossibleScoreWeighted: 0,
        totalFiles: 0,
        unansweredRequiredFields: [],
      },
    },
  };
  if (schema.grouping && typeof schema.grouping === "object") {
    return schema.grouping;
  }
  console.warn("Invalid data format: grouping is missing");
  return null;
}
function listenform(divId) {
  const schema = document.getElementById(divId)._formData;
  const lang = window.lang || "en";

  const updateAllPanels = () => {
    // Update both summary panels
    if (document.getElementById("summan")) {
      renderSchemaStructureToSumman(schema, divId, lang);
    }
    if (document.getElementById("jumperhelper")) {
      updateJumperHelperWithUnanswered(QSummary(schema).summary, schema);
    }
     autoSaveToLocal(divId, schema);   // <-- NEW
  };

  for (const key in schema) {
    if (key === "grouping" || schema[key].type === "section") continue;
    const field = schema[key];
    const inputType = field.data_type || field.type;
    const inputId = `${divId}-${encodeFieldKey(key)}`;
    const fieldDiv = document.getElementById(
      `${divId}-field-${encodeFieldKey(key)}`,
    );

    if (["string", "textarea", "text", "number"].includes(inputType)) {
      const inputEl = document.getElementById(inputId);
      if (inputEl) {
        inputEl.addEventListener("input", () => {
          schema[key].value =
            inputType === "number"
              ? parseFloat(inputEl.value) || 0
              : inputEl.value.trim();
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
          updateAllPanels();
        });
      }
    } else if (inputType === "radio") {
      document
        .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}"]`)
        .forEach((el) => {
          el.addEventListener("change", () => {
            schema[key].value = parseInt(el.value);
            updateFieldDisplay(fieldDiv, field);
            updateSectionSummaries(divId, schema, lang);
            updateAllPanels();
          });
        });
    } else if (inputType === "checkbox") {
      document
        .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}[]"]`)
        .forEach((el) => {
          el.addEventListener("change", () => {
            schema[key].value = Array.from(
              document.querySelectorAll(
                `input[name="${divId}-${encodeFieldKey(key)}[]"]:checked`,
              ),
            ).map((e) => parseInt(e.value));
            updateFieldDisplay(fieldDiv, field);
            updateSectionSummaries(divId, schema, lang);
            updateAllPanels();
          });
        });
    } else if (inputType === "select") {
      const inputEl = document.getElementById(inputId);
      if (inputEl) {
        inputEl.addEventListener("change", () => {
          schema[key].value = inputEl.value;
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
        });
      }
    } else if (inputType === "attachment") {
      const inputEl = document.getElementById(inputId);
      if (inputEl) {
        inputEl.addEventListener("input", () => {
          schema[key].value = inputEl.value.trim();
          //document.getElementById(`${divId}-filecount-${encodeFieldKey(key)}`).textContent = `Files: ${countFiles(field)}`;
          // Update file count display immediately
          const fileCount = countFiles(schema[key]);
          document.getElementById(
            `${divId}-filecount-${encodeFieldKey(key)}`,
          ).textContent = `Files: ${fileCount}`;
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
          updateAllPanels();
        });
      }
    } else if (
      inputType === "radiotext" ||
      inputType === "radiotextatt" ||
      inputType === "radioatt"
    ) {
      document
        .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}-radio"]`)
        .forEach((el) => {
          el.addEventListener("change", () => {
            schema[key].value.radio = parseInt(el.value);
            // REMOVED ALL VISIBILITY TOGGLING
            updateFieldDisplay(fieldDiv, field);
            updateSectionSummaries(divId, schema, lang);
            updateAllPanels();
          });
        });
      const textInput = document.getElementById(
        `${divId}-${encodeFieldKey(key)}-text`,
      );
      if (textInput) {
        textInput.addEventListener("input", () => {
          schema[key].value.text = textInput.value.trim();
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
        });
      }

      const attInput = document.getElementById(
        `${divId}-${encodeFieldKey(key)}-att`,
      );
      if (attInput) {
        // ENSURE ATTACHMENT INPUT IS ALWAYS VISIBLE
        attInput.style.display = "block";
        attInput.addEventListener("input", () => {
          schema[key].value.att = attInput.value.trim();
          document.getElementById(
            `${divId}-filecount-${encodeFieldKey(key)}`,
          ).textContent = `Files: ${countFiles(field)}`;
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
        });
      }
    } else if (inputType === "checktext" || inputType === "checktextatt") {
      document
        .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}[]"]`)
        .forEach((el) => {
          el.addEventListener("change", () => {
            schema[key].value.check = Array.from(
              document.querySelectorAll(
                `input[name="${divId}-${encodeFieldKey(key)}[]"]:checked`,
              ),
            ).map((e) => parseInt(e.value));
            // REMOVED ALL VISIBILITY TOGGLING
            updateFieldDisplay(fieldDiv, field);
            updateSectionSummaries(divId, schema, lang);
            updateAllPanels();
          });
        });

      const textInput = document.getElementById(
        `${divId}-${encodeFieldKey(key)}-text`,
      );
      if (textInput) {
        textInput.addEventListener("input", () => {
          schema[key].value.text = textInput.value.trim();
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
        });
      }

      const attInput = document.getElementById(
        `${divId}-${encodeFieldKey(key)}-att`,
      );
      if (attInput) {
        // ENSURE ATTACHMENT INPUT IS ALWAYS VISIBLE
        attInput.style.display = "block";
        attInput.addEventListener("input", () => {
          schema[key].value.att = attInput.value.trim();
          document.getElementById(
            `${divId}-filecount-${encodeFieldKey(key)}`,
          ).textContent = `Files: ${countFiles(field)}`;
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);
        });
      }
    }
  }

  if (document.getElementById("jumperhelper")) {
    const summary = QSummary(schema).summary;
    updateJumperHelperWithUnanswered(summary, schema);
  }
}
function stripHTML(str) {
  if (!str) return "";
  const tmp = document.createElement("div");
  tmp.innerHTML = str;
  return tmp.textContent || tmp.innerText || "";
}

function limitText(str, max = 40) {
  str = stripHTML(str);
  return str.length > max ? str.substring(0, max) + "…" : str;
}
function updateJumperHelperWithUnanswered(
  summary,
  data,
  targetDivId = "jumperhelper",
) {
    //window.scoreshow=true;
  // Ensure we have score data
  if (!summary.totals.maxPossibleScoreWeighted) {
    summary = QSummary(data).summary;
  }    
  const lang = window.lang || "en";
    const scorePercentage = summary.totals.maxPossibleScoreWeighted > 0 
    ? (summary.totals.totalScoreWeighted / summary.totals.maxPossibleScoreWeighted * 100).toFixed(1)
    : 0;
  if (!summary || !summary.segments || !summary.totals) {
    console.error("Invalid summary object:", summary);
    return "";
  }

  const panelStack = window.panelStack || [];
  const formId =
    panelStack.length > 0 ? panelStack[panelStack.length - 1] : "gform";
  //const activeFormId =    formId === "gen" ? "gform" : formId === "profile" ? "pro" : formId;

  if (formId === "gen") window.activeFormId = "gform";
  else if (formId === "profile") window.activeFormId = "pro";

  // Enhanced getLabel function with better fallbacks
  const getLabel = (item) => {
    if (!item) return "";
    if (typeof item.label === "string") return item.label;
    if (item.label && (item.label[lang] || item.label.en)) {
      return item.label[lang] || item.label.en;
    }
    if (item.labels && (item.labels[lang] || item.labels.en)) {
      return item.labels[lang] || item.labels.en;
    }
    return item.key || "";
  };

  // Helper functions
  const generateId = (prefix) =>
    `${prefix}-${Math.random().toString(36).substr(2, 9)}`;
  const generateScrollLink = (key) =>
    `javascript:scrollToField('${key}', '${activeFormId}')`;

  // Generate all toggle IDs in advance
  const globalUnansweredToggleId = generateId("global-unanswered-toggle");
  const collapseAllId = generateId("collapse-all");
  const sectionToggleIds = {};
  const segmentToggleIds = {};
  const progressCircleId = generateId("progress-circle");

  // Pre-process to collect all toggle IDs
  Object.entries(summary.segments).forEach(([segmentKey, segment]) => {
    segmentToggleIds[segmentKey] = generateId(`segment-${segmentKey}-toggle`);
    Object.entries(segment.sections || {}).forEach(([sectionKey]) => {
      sectionToggleIds[sectionKey] = generateId(`section-${sectionKey}-toggle`);
    });
  });

  let html = `<div style='font-family: Arial, sans-serif;'>`;

  // Enhanced Collapse/Expand All controls
  html += `
    <div style='margin-bottom: 1px; display: flex; gap: 5px;'>
      <button id="${collapseAllId}"
              onclick="
                const isCollapsed = this.textContent.includes('${lang === "th" ? "Expand" : "Expand"}');
                document.querySelectorAll('[id^=segment-][id$=-toggle], [id^=section-][id$=-toggle]').forEach(el => {
                  el.style.display = isCollapsed ? 'block' : 'none';
                });
                document.querySelectorAll('[id^=segment-][id$=-toggle] + div, [id^=section-][id$=-toggle] + div').forEach(el => {
                  el.style.display = isCollapsed ? 'block' : 'none';
                });
                this.textContent = isCollapsed ?
                  '▼ ${lang === "th" ? "Collapse" : "Collapse All"}' :
                  '▶ ${lang === "th" ? "Expand" : "Expand All"}';
                document.getElementById('${globalUnansweredToggleId}').style.display = isCollapsed ? 'block' : 'none';
              "
              style="
                padding: 5px 10px;
                background: #4a90e2;
                color: white;
                border: none;
                border-radius: 8px;
                cursor: pointer;
                flex: 1;
                font-size:13px;
              ">
        ▼ ${lang === "th" ? "Collapse All" : "Collapse All"}
      </button>


    </div>
  `;

  // Grand Summary - unchanged from previous version
  const globalTotals = summary.totals;
  const fieldsPercent =
    globalTotals.allFields > 0
      ? Math.round((globalTotals.answeredFields / globalTotals.allFields) * 100)
      : 100;
  const requiredPercent =
    globalTotals.requiredFields > 0
      ? Math.round(
          (globalTotals.answeredRequiredFields / globalTotals.requiredFields) *
            100,
        )
      : 100;
  // Calculate progress values
  //globalTotals = summary.totals;
  
  const answeredRequired = globalTotals.answeredRequiredFields || 0;
  const totalRequired = globalTotals.requiredFields || 1; // Avoid division by zero
  const progressPercent = Math.round((answeredRequired / totalRequired) * 100);
  const progressColor =
    progressPercent === 100
      ? "#4CAF50"
      : progressPercent >= 50
        ? "#ff9d00ff"
        : "#F44336";
  html += `
   <div style="display: flex; flex-direction: column; align-items: center; margin-bottom: 20px;">
     <svg width="120" height="120" id="${progressCircleId}-svg">
       <circle cx="60" cy="60" r="50" stroke="#eee" stroke-width="12" fill="none" />
       <circle id="${progressCircleId}" cx="60" cy="60" r="50"
               stroke="${progressColor}" stroke-width="12" fill="none" stroke-linecap="round"
               transform="rotate(-90 60 60)"
               stroke-dasharray="314" stroke-dashoffset="${314 - (314 * progressPercent) / 100}" />
       <text x="60" y="60" text-anchor="middle" dy=".3em" font-size="32" font-weight="bold" font-family="Arial, sans-serif" fill="currentColor"id="${progressCircleId}-percent">${progressPercent}%</text>
     </svg>
     <div id="${progressCircleId}-label" style="width: 160px; text-align: center; margin-top: 5px; font-size: 1em; font-weight: bold;">
       <div>${getLabel({ label: { en: "Progress", th: "Progress" } })}: <span id="${progressCircleId}-answered">${answeredRequired}</span>/<span id="${progressCircleId}-total">${totalRequired}</span></div>
     </div>
        ${window.scoreshow ? `
      <div style='margin-bottom: 5px; margin-top: 10px; width: 100%;'>
        ${getLabel({ label: { en: "Score", th: "score" } })}: 
        <b>${summary.totals.totalScoreWeighted.toFixed(1)}/${summary.totals.maxPossibleScoreWeighted.toFixed(1)}</b>
        (${scorePercentage}%)
        <div style='width: 100%; background-color: #e0e0e0; height: 7px; border-radius: 5px; overflow: hidden;'>
          <div style='width: ${scorePercentage}%; background-color: #2196F3; height: 100%;'></div>
        </div>
      </div>
    ` : ''}
   </div>
 `;
  html += `
    <div style='border: 2px solid #4a90e2; padding: 10px; margin-bottom: 20px; border-radius: 5px;font-size:14px;'>
      <h4 style='margin: 0 0 5px 0;'>${getLabel({ label: { en: "Grand Summary", th: "Summary" } })}</h4>
      <div style='margin-bottom: 5px;'>
        ${getLabel({ label: { en: "Total Fields", th: "Total Fields" } })}: ${globalTotals.answeredFields}/${totalRequired}
        <div style='width: 100%; background-color: #e0e0e0; height: 7px; border-radius: 5px; overflow: hidden;'>
          <div style='width: ${fieldsPercent}%; background-color: #4caf50; height: 100%;'></div>
        </div>
      </div>
      <div style='margin-bottom: 5px;'>
        ${getLabel({ label: { en: "Required", th: "Required" } })}: ${globalTotals.answeredRequiredFields}/${globalTotals.requiredFields}
        <div style='width: 100%; background-color: #e0e0e0; height: 7px; border-radius: 5px; overflow: hidden;'>
          <div style='width: ${requiredPercent}%; background-color: #4caf50; height: 100%;'></div>
        </div>
      </div>
      <div style='margin-bottom: 5px;'>
        ${getLabel({ label: { en: "Total Files", th: "Total Files" } })}: <b>${globalTotals.totalFiles}</b>
      </div>
      
  `;

  // Global unanswered fields with toggle
  if (globalTotals.unansweredRequiredFields?.length > 0) {
    html += `
      <div style='margin-top: 10px; color: rgba(231, 104, 26, 1);font-size:13px;font-weight: bold;'>
        <a href="javascript:void(0)"
           onclick="document.getElementById('${globalUnansweredToggleId}').style.display =
                   document.getElementById('${globalUnansweredToggleId}').style.display === 'none' ? 'block' : 'none';
                   this.innerHTML = document.getElementById('${globalUnansweredToggleId}').style.display === 'none' ?
                   '${getLabel({ label: { en: "Unanswered Required Fields: ▼", th: "ฟิลด์ที่จำเป็นยังไม่ได้ตอบ: ▼" } })}' :
                   '${getLabel({ label: { en: "Unanswered Required Fields: ▶", th: "ฟิลด์ที่จำเป็นยังไม่ได้ตอบ: ▶" } })}';"
           style="text-decoration: none; color: rgba(230, 54, 0, 1);">
          ${getLabel({ label: { en: "Unanswered Required Fields: ▼", th: "ฟิลด์ที่จำเป็นยังไม่ได้ตอบ: ▼" } })}
        </a>
        <div id="${globalUnansweredToggleId}">
          <ul style='margin: 5px 0; padding-left: 10px;font-size:13px;font-weight: bold;'>
            ${globalTotals.unansweredRequiredFields
              .map((field) => {
                const fieldData = data[field.key] || {};
                return `
              <li style='max-width: 200px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;font-size:13px;font-weight: normal;'>
              <a href="javascript:scrollToField('${encodeFieldKey(field.key)}', '${activeFormId}')"
                       style='text-decoration: none; color: red;'
                       title="${stripHTML(getLabel(fieldData))}">
${limitText(getLabel(fieldData), 40)} (${field.section})
                    </a>
              </li>
            `;
              })
              .join("")}
          </ul>
        </div>
      </div>
    `;
  }

  html += `</div>`;

  // Segments with their sections - now with toggle support for segments
  html += "<div style='display: flex; flex-wrap: wrap; gap: 10px;'>";

  Object.entries(summary.segments).forEach(([segmentKey, segment]) => {
    const segmentTotals = segment.totals || {};
    const segmentData = data[segmentKey] || {};
    const segmentToggleId = segmentToggleIds[segmentKey];
    const fieldsPercent =
      segmentTotals.allFields > 0
        ? Math.round(
            (segmentTotals.answeredFields / segmentTotals.allFields) * 100,
          )
        : 100;
    const requiredPercent =
      segmentTotals.requiredFields > 0
        ? Math.round(
            (segmentTotals.answeredRequiredFields /
              segmentTotals.requiredFields) *
              100,
          )
        : 100;

    const segmentLabel = getLabel(segmentData) || segmentKey;

    html += `
      <div style='border: 1px solid #ccc; padding: 10px; border-radius: 5px; min-width: 200px;background:rgba(120,120,120,.1)'>
        <p style='margin: 0 0 5px 0; cursor: pointer;font-size:14px;'
            onclick="
              const segToggle = document.getElementById('${segmentToggleId}');
              segToggle.style.display = segToggle.style.display === 'none' ? 'block' : 'none';
              this.querySelector('span').textContent = segToggle.style.display === 'none' ? '▶' : '▼';
            ">
          <span>▼</span> ${segmentLabel}
        </p>
        <div id="${segmentToggleId}">
          <div style='margin-bottom: 5px;font-size:13px;font-weight: bold;'>
            ${getLabel({ label: { en: "Fields", th: "คำถาม" } })}: ${segmentTotals.answeredFields}/${segmentTotals.allFields}
            <div style='width: 100%; background-color: #e0e0e0; height: 5px; border-radius: 5px; overflow: hidden;'>
              <div style='width: ${fieldsPercent}%; background-color: #4caf50; height: 100%;'></div>
            </div>
          </div>
          <div style='margin-bottom: 5px;font-size:13px;font-weight: bold;;'>
            ${getLabel({ label: { en: "Required", th: "จำเป็นต้องตอบ" } })}: ${segmentTotals.answeredRequiredFields}/${segmentTotals.requiredFields}
            <div style='width: 100%; background-color: #e0e0e0; height: 5px; border-radius: 5px; overflow: hidden;'>
              <div style='width: ${requiredPercent}%; background-color: #4caf50; height: 100%;'></div>
            </div>
          </div>
    `;

    // Group unanswered fields by section
    const unansweredBySection = {};
    if (segmentTotals.unansweredRequiredFields?.length > 0) {
      segmentTotals.unansweredRequiredFields.forEach((field) => {
        if (!unansweredBySection[field.section]) {
          unansweredBySection[field.section] = [];
        }
        unansweredBySection[field.section].push(field);
      });
    }

    // Sections within this segment
    html += `<div style='margin-top: 10px;'>`;

    Object.entries(segment.sections || {}).forEach(([sectionKey, section]) => {
      const sectionData = data[sectionKey] || {};
      const sectionTotals = section.totals || {};
      const sectionToggleId = sectionToggleIds[sectionKey];
      const hasUnanswered = unansweredBySection[sectionKey]?.length > 0;

      const sectionLabel = getLabel(sectionData) || sectionKey;

      html += `
        <div style='margin-bottom: 8px;'>
          <div style='display: flex; justify-content: space-between; align-items: center; cursor: pointer;font-size:13px;'
               onclick="
                 const secToggle = document.getElementById('${sectionToggleId}');
                 if (secToggle) {
                   secToggle.style.display = secToggle.style.display === 'none' ? 'block' : 'none';
                   this.querySelector('span').textContent = secToggle.style.display === 'none' ? '▶' : '▼';
                 }
               ">
            <div style='flex-grow: 1;'>
              ${sectionLabel} (${sectionTotals.answeredFields}/${sectionTotals.allFields})
            </div>
            ${hasUnanswered ? `<span>▼</span>` : ""}
          </div>
          ${
            hasUnanswered
              ? `
            <div id="${sectionToggleId}" style="display: block; margin-top: 4px;">
              <ul style='margin: 3px 0; padding-left: 15px; font-size: 0.5em;font-size:13px;'>
                ${unansweredBySection[sectionKey]
                  .map((field) => {
                    const fieldData = data[field.key] || {};
                    return `
                  <li style='max-width: 180px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;font-size:14px;'>
                    <a href="${generateScrollLink(field.key)}"
                       style='text-decoration: none; color: red;'
                       title="${stripHTML(getLabel(fieldData))}">
${limitText(getLabel(fieldData), 40)}
                    </a>
                  </li>
                `;
                  })
                  .join("")}
              </ul>
            </div>
          `
              : ""
          }
        </div>
      `;
    });

    html += `</div></div></div>`;
  });

  html += `</div></div>`;

  // Add CSS styles
  html += `
    <style>
      [id$="-toggle"] {
        transition: all 0.3s ease;
      }
      a[onclick], [onclick] {
        cursor: pointer;
        user-select: none;
      }
      a[onclick]:hover {
        text-decoration: underline !important;
      }
      .section-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
      }
      #${collapseAllId}:hover {
        background: #3a80d2;
      }
      h4[onclick]:hover, [onclick]:hover {
        background-color: #f5f5f5;
      }
    </style>
  `;

  const jumperDiv = document.getElementById(targetDivId);
  if (jumperDiv) {
    jumperDiv.innerHTML = html;
  } else {
    console.error(`Target div ${targetDivId} not found`);
  }

  return html;
}
function restoreScrollPosition(panelId = "gen") {
  const panel = document.getElementById(panelId);
  if (!panel) return;
  const body = panel.querySelector(".panel-body");
  if (!body) return;
  const pos = JSON.parse(localStorage.getItem(`scroll_${panelId}`) || "{}");

  if (pos && typeof pos.top === "number") {
    // Smooth scroll implementation
    body.scrollTo({
      top: pos.top,
      left: pos.left || 0,
      behavior: "smooth",
    });
    console.log(
      `✅ Restored scroll for ${panelId} with smooth animation`,
      pos.top,
      pos.left,
    );
  }
}
function createInputElement(divId, key, field, lang, schema) {
  const inputType = field.data_type || field.type;
  let input;
boxwidth="85%";
  if (inputType === "textarea") {
    input = document.createElement("textarea");
    input.id = `${divId}-${encodeFieldKey(key)}`;
    input.value = field.value || "";
    input.style.width = boxwidth;
    input.style.borderRadius  = "6px";
    input.style.outline="2 px solid (rgba(100,100,100,.9)";
    input.style.border = '0px solid transparent';
    input.style.padding = '5px 10px';
  } else if (inputType === "radioatt") {
    input = document.createElement("div");
    input.style.cssText = "display: flex; flex-direction: column; gap: 5px;";
    input.style.borderRadius  = "6px";
    //input.style.outline="2 px solid (rgba(100,100,100,.1)";
    input.style.border = '0px solid transparent';
    input.style.padding = '5px 10px';
    const radioContainer = document.createElement("div");
    radioContainer.style.cssText =
      "display: flex; flex-direction: column; gap: 5px;";
    getOptions(field, lang).forEach((opt, idx) => {
      const radioLabel = document.createElement("label");
      radioLabel.style.cssText =
        "margin-right: 8px; display: flex; align-items: center;";
      const val = idx;
      radioLabel.innerHTML = `<input type="radio" name="${divId}-${encodeFieldKey(key)}-radio" value="${val}" ${field.value && field.value.radio === val ? "checked" : ""}> ${opt}`;
      radioContainer.appendChild(radioLabel);
    });
    input.appendChild(radioContainer);
    const attDiv = document.createElement("div");
    attDiv.style.marginTop = "5px";
    const attInput = document.createElement("input");
    attInput.type = "text";
    attInput.style.borderRadius  = "6px";
    attInput.style.outline="1 px solid (rgba(100,100,100,.5)";
    attInput.style.border = '0px solid transparent';
    attInput.style.padding = '5px 10px';
    attInput.id = `${divId}-${encodeFieldKey(key)}-att`;
    attInput.value = (field.value && field.value.att) || "";
    attInput.placeholder = getLabel(
      { label: { en: "Click on Add File", th: "Click on Add File" } },
      lang,
    );
    //attInput.style.width = "260px";
    attInput.style.cssText = "width: 85%; display: block;"; // Force display: block

    //attInput.style.display = field.value?.radio === 0 ? "block" : "none";
    attDiv.appendChild(attInput);
    const fileCount = document.createElement("div");
    fileCount.id = `${divId}-filecount-${encodeFieldKey(key)}`;
    fileCount.style.marginTop = "5px";
    fileCount.textContent = `Files: ${countFiles(field)}`;
    input.appendChild(fileCount);
    attDiv.appendChild(createAddFileButton(divId, key, field, schema, lang));
    attDiv.appendChild(
      createSaveAttachmentButton(divId, key, field, schema, lang),
    );
    input.appendChild(attDiv);
  } else if (inputType === "radio") {
    input = document.createElement("div");
    input.style.cssText = "display: flex; flex-direction: column; gap: 5px;";
    getOptions(field, lang).forEach((opt, idx) => {
      const radioLabel = document.createElement("label");
      radioLabel.style.cssText =
        "margin-right: 8px; display: flex; align-items: center;";
      const val = idx;
      radioLabel.innerHTML = `<input type="radio" name="${divId}-${encodeFieldKey(key)}" value="${val}" ${field.value === val ? "checked" : ""}> ${opt}`;
      input.appendChild(radioLabel);
    });
  } else if (inputType === "checkbox") {
    input = document.createElement("div");
    input.style.cssText = "display: flex; flex-direction: column; gap: 5px;";
    getOptions(field, lang).forEach((opt, idx) => {
      const checkLabel = document.createElement("label");
      checkLabel.style.cssText =
        "margin-right: 8px; display: flex; align-items: center;";
      const val = idx;
      checkLabel.innerHTML = `<input type="checkbox" name="${divId}-${encodeFieldKey(key)}[]" value="${val}" ${field.value && field.value.includes(val) ? "checked" : ""}> ${opt}`;
      input.appendChild(checkLabel);
    });
  } else if (inputType === "select") {
    input = document.createElement("select");
    input.id = `${divId}-${encodeFieldKey(key)}`;
    input.style.width = boxwidth;
    getOptions(field, lang).forEach((opt, idx) => {
      const option = document.createElement("option");
      const value = idx === 0 ? "" : opt;
      option.value = value;
      option.textContent = opt;
      option.selected = field.value === value;
      input.appendChild(option);
    });
  } else if (inputType === "attachment") {
    input = document.createElement("div");
    const textInput = document.createElement("input");
    textInput.type = "text";
    textInput.style.borderRadius  = "6px";
    textInput.style.outline="2 px solid (rgba(100,100,100,.9)";
    textInput.style.border = '0px solid transparent';
    textInput.style.padding = '5px 10px';
    textInput.id = `${divId}-${encodeFieldKey(key)}`; // Consistent ID without -att suffix
    textInput.value = field.value || "";
    textInput.placeholder = getLabel(
      {
        label: {
          en: "Enter file names (comma-separated)",
          th: "Enter file names (comma-separated,คั่นด้วยเครื่องหมายจุลภาค)",
        },
      },
      lang,
    );
    textInput.style.width = "90%";
    input.appendChild(textInput);

    const fileCount = document.createElement("div");
    fileCount.id = `${divId}-filecount-${encodeFieldKey(key)}`;
    fileCount.style.marginTop = "5px";
    fileCount.textContent = `Files: ${countFiles(field)}`;
    input.appendChild(fileCount);

    const buttonDiv = document.createElement("div");
    buttonDiv.style.marginTop = "5px";
    buttonDiv.appendChild(createAddFileButton(divId, key, field, schema, lang));
    buttonDiv.appendChild(
      createSaveAttachmentButton(divId, key, field, schema, lang),
    );
    input.appendChild(buttonDiv);
  } else if (inputType === "radiotext" || inputType === "radiotextatt") {
    input = document.createElement("div");
    input.style.cssText = "display: flex; flex-direction: column; gap: 5px;";
    input.style.borderRadius  = "6px";
    input.style.outline="1 px solid (rgba(100,100,100,.9)";
    input.style.border = '0px solid transparent';
    input.style.padding = '5px 10px';
    const radioContainer = document.createElement("div");
    radioContainer.style.cssText =
      "display: flex; flex-direction: column; gap: 5px;";
    getOptions(field, lang).forEach((opt, idx) => {
      const radioLabel = document.createElement("label");
      radioLabel.style.cssText =
        "margin-right: 8px; display: flex; align-items: center;";
      const val = idx;
      radioLabel.innerHTML = `<input type="radio" name="${divId}-${encodeFieldKey(key)}-radio" value="${val}" ${field.value && field.value.radio === val ? "checked" : ""}> ${opt}`;
      radioContainer.appendChild(radioLabel);
    });
    input.appendChild(radioContainer);
    const textInput = document.createElement("input");
    textInput.type = "text";
    textInput.style.borderRadius  = "6px";
    textInput.style.outline="1 px solid (rgba(100,100,100,.5)";
    textInput.style.border = '0px solid transparent';
    textInput.style.padding = '5px 10px';
    textInput.id = `${divId}-${encodeFieldKey(key)}-text`;
    textInput.value = (field.value && field.value.text) || "";
    textInput.placeholder = getLabel(
      {
        label: {
          en: "Enter details (e.g., Others)",
          th: "Enter details (e.g., Others) (เช่น อื่น ๆ)",
        },
      },
      lang,
    );
    //textInput.style.width = "260px";
    //textInput.style.marginTop = "5px";
    //textInput.style.display = field.value?.radio === getOptions(field, lang).length - 1 ? "block" : "none";
    textInput.style.cssText = "width: 85%; margin-top: 5px; display: block ;"; // Force display: block
    input.appendChild(textInput);
    if (inputType === "radiotextatt") {
      const attDiv = document.createElement("div");
      attDiv.style.marginTop = "5px";
      const attInput = document.createElement("input");
      attInput.type = "text";
      attInput.style.borderRadius  = "6px";
    attInput.style.outline="1 px solid (rgba(100,100,100,.5)";
    attInput.style.border = '0px solid transparent';
    attInput.style.padding = '5px 10px';
      attInput.id = `${divId}-${encodeFieldKey(key)}-att`;
      attInput.value = (field.value && field.value.att) || "";
      attInput.placeholder = getLabel(
        { label: { en: "Click on Add file", th: "Click on Add file" } },
        lang,
      );
      attInput.style.width = "85%";
      attInput.style.borderRadius  = "6px";
    attInput.style.outline="2 px solid (rgba(200,200,200,.5)";
    attInput.style.border = '0px solid transparent';
    attInput.style.padding = '5px 10px';
      attDiv.appendChild(attInput);
      const fileCount = document.createElement("div");
      fileCount.id = `${divId}-filecount-${encodeFieldKey(key)}`;
      fileCount.style.marginTop = "5px";
      fileCount.textContent = `Files: ${countFiles(field)}`;
      input.appendChild(fileCount);
      attDiv.appendChild(createAddFileButton(divId, key, field, schema, lang));
      attDiv.appendChild(
        createSaveAttachmentButton(divId, key, field, schema, lang),
      );
      input.appendChild(attDiv);
    }
  } else if (inputType === "checktext" || inputType === "checktextatt") {
    input = document.createElement("div");
    input.style.cssText = "display: flex; flex-direction: column; gap: 5px;";
    input.style.borderRadius  = "6px";
    input.style.outline="1 px solid (rgba(100,100,100,.1)";
    input.style.border = '0px solid transparent';
    input.style.padding = '5px 10px';
    const checkContainer = document.createElement("div");
    checkContainer.style.cssText =
      "display: flex; flex-direction: column; gap: 5px;";
    getOptions(field, lang).forEach((opt, idx) => {
      const checkLabel = document.createElement("label");
      checkLabel.style.cssText =
        "margin-right: 8px; display: flex; align-items: center;";
      const val = idx;
      checkLabel.innerHTML = `<input type="checkbox" name="${divId}-${encodeFieldKey(key)}[]" value="${val}" ${field.value && field.value.check.includes(val) ? "checked" : ""}> ${opt}`;
      checkContainer.appendChild(checkLabel);
    });
    input.appendChild(checkContainer);
    const textInput = document.createElement("input");
    textInput.type = "text";
     textInput.style.borderRadius  = "6px";
    textInput.style.outline="2 px solid (rgba(100,100,100,.1)";
    textInput.style.border = '0px solid transparent';
    textInput.style.padding = '5px 10px';
    textInput.id = `${divId}-${encodeFieldKey(key)}-text`;
    textInput.value = (field.value && field.value.text) || "";
    textInput.placeholder = getLabel(
      {
        label: {
          en: "Enter details (e.g., Others)",
          th: "Enter details (e.g., Others) (เช่น อื่น ๆ)",
        },
      },
      lang,
    );
    //textInput.style.width = "260px";
    //textInput.style.marginTop = "5px";
    //textInput.style.display = field.value?.check.includes(getOptions(field, lang).length - 1) ? "block" : "none";
    textInput.style.cssText = "width: 85%; margin-top: 5px; display: block ;";

    input.appendChild(textInput);
    if (inputType === "checktextatt") {
      const attDiv = document.createElement("div");
      attDiv.style.marginTop = "5px";
      const attInput = document.createElement("input");
      attInput.type = "text";
      attInput.style.borderRadius  = "6px";
    attInput.style.outline="1 px solid (rgba(100,100,100,.1)";
    attInput.style.border = '0px solid transparent';
    attInput.style.padding = '5px 10px';
      attInput.id = `${divId}-${encodeFieldKey(key)}-att`;
      attInput.value = (field.value && field.value.att) || "";
      attInput.placeholder = getLabel(
        { label: { en: "Click on Add file", th: "Click on Add file" } },
        lang,
      );
      attInput.style.width = "85%";
      attInput.style.borderRadius  = "6px";
    attInput.style.outline="2 px solid (rgba(200,200,200,.5)";
    attInput.style.border = '0px solid transparent';
    attInput.style.padding = '5px 10px';
      attDiv.appendChild(attInput);
      const fileCount = document.createElement("div");
      fileCount.id = `${divId}-filecount-${encodeFieldKey(key)}`;
      fileCount.style.marginTop = "5px";
      fileCount.textContent = `Files: ${countFiles(field)}`;
      input.appendChild(fileCount);
      attDiv.appendChild(createAddFileButton(divId, key, field, schema, lang));
      attDiv.appendChild(
        createSaveAttachmentButton(divId, key, field, schema, lang),
      );
      input.appendChild(attDiv);
    }
  } else {
    input = document.createElement("input");
    input.id = `${divId}-${encodeFieldKey(key)}`;
    input.type = inputType === "string" ? "text" : inputType || "text";
    input.value = field.value || (inputType === "number" ? 0 : "");
    input.style.width = "85%";
    input.style.borderRadius  = "6px";
    input.style.outline="2 px solid (rgba(200,200,200,.1)";
    input.style.border = '0px solid transparent';
    input.style.padding = '5px 10px';
  }

  return input;
}
function createResetButton(divId, key, field, input, lang, schema, fieldDiv) {
  const inputType = field.data_type || field.type;
  const resetBtn = document.createElement("button");
  resetBtn.textContent = getLabel(
    { label: { en: "reset", th: "reset" } },
    lang,
  );
  resetBtn.style.cssText = `margin-left: 10px; padding: 4px 8px; cursor: pointer;
    background: #ff6459ff;
    color: #fff;
    border: none;
    border-radius: 10px;
    width: 38px;
    height: 15px;
    font-size: 12px;
    line-height: 1;
    cursor: pointer;
    margin-left: 5px;
    padding: 0px 15px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    float: right;
    transition: all 0.2s ease;`;

  // Button hover effects
  resetBtn.onmouseover = function () {
    this.style.background = "#d32f2f";
    this.style.transform = "scale(1.1)";
  };
  resetBtn.onmouseout = function () {
    this.style.background = "#f44336";
    this.style.transform = "scale(1)";
  };

  resetBtn.onclick = () => {
    // Common reset actions
    const resetCommon = () => {
      fieldDiv.style.outline = field.required ? "2px solid red" : "";
      updateFieldDisplay(fieldDiv, field);
      updateSectionSummaries(divId, schema, lang);

      // Force update jumper helper if present
      if (document.getElementById("jumperhelper")) {
        const summary = QSummary(schema).summary;
        updateJumperHelperWithUnanswered(summary, schema);
      }

      // Force update summan if present
      if (document.getElementById("summan")) {
        renderSchemaStructureToSumman(schema, divId, lang);
      }
    };

    // Handle different field types
    switch (inputType) {
      case "radio":
        schema[key].value = null;
        document
          .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}"]`)
          .forEach((el) => {
            el.checked = false;
          });
        break;

      case "radioatt":
        schema[key].value = { radio: null, att: "" };
        document
          .querySelectorAll(
            `input[name="${divId}-${encodeFieldKey(key)}-radio"]`,
          )
          .forEach((el) => {
            el.checked = false;
          });
        document.getElementById(`${divId}-${encodeFieldKey(key)}-att`).value =
          "";
        document.getElementById(
          `${divId}-filecount-${encodeFieldKey(key)}`,
        ).textContent = "Files: 0";
        break;

      case "checkbox":
        schema[key].value = [];
        document
          .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}[]"]`)
          .forEach((el) => {
            el.checked = false;
          });
        break;

      case "select":
        schema[key].value = "";
        document.getElementById(`${divId}-${encodeFieldKey(key)}`).value = "";
        break;

      case "attachment":
        schema[key].value = "";
        document.getElementById(`${divId}-${encodeFieldKey(key)}`).value = "";
        document.getElementById(
          `${divId}-filecount-${encodeFieldKey(key)}`,
        ).textContent = "Files: 0";
        break;

      case "radiotext":
        schema[key].value = { radio: null, text: "" };
        document
          .querySelectorAll(
            `input[name="${divId}-${encodeFieldKey(key)}-radio"]`,
          )
          .forEach((el) => {
            el.checked = false;
          });
        document.getElementById(`${divId}-${encodeFieldKey(key)}-text`).value =
          "";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-text`,
        ).style.display = "block";
        break;

      case "radiotextatt":
        schema[key].value = { radio: null, text: "", att: "" };
        document
          .querySelectorAll(
            `input[name="${divId}-${encodeFieldKey(key)}-radio"]`,
          )
          .forEach((el) => {
            el.checked = false;
          });
        document.getElementById(`${divId}-${encodeFieldKey(key)}-text`).value =
          "";
        document.getElementById(`${divId}-${encodeFieldKey(key)}-att`).value =
          "";
        document.getElementById(
          `${divId}-filecount-${encodeFieldKey(key)}`,
        ).textContent = "Files: 0";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-text`,
        ).style.display = "block";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-att`,
        ).style.display = "block";
        break;

      case "checktext":
        schema[key].value = { check: [], text: "" };
        document
          .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}[]"]`)
          .forEach((el) => {
            el.checked = false;
          });
        document.getElementById(`${divId}-${encodeFieldKey(key)}-text`).value =
          "";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-text`,
        ).style.display = "block";
        break;

      case "checktextatt":
        schema[key].value = { check: [], text: "", att: "" };
        document
          .querySelectorAll(`input[name="${divId}-${encodeFieldKey(key)}[]"]`)
          .forEach((el) => {
            el.checked = false;
          });
        document.getElementById(`${divId}-${encodeFieldKey(key)}-text`).value =
          "";
        document.getElementById(`${divId}-${encodeFieldKey(key)}-att`).value =
          "";
        document.getElementById(
          `${divId}-filecount-${encodeFieldKey(key)}`,
        ).textContent = "Files: 0";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-text`,
        ).style.display = "block";
        document.getElementById(
          `${divId}-${encodeFieldKey(key)}-att`,
        ).style.display = "block";
        break;

      default: // string, number, textarea
        schema[key].value = inputType === "number" ? 0 : "";
        document.getElementById(`${divId}-${encodeFieldKey(key)}`).value =
          inputType === "number" ? "0" : "";
    }

    // Update score bar with current file count
    const scoreBar = fieldDiv.querySelector(".score-bar");
    if (scoreBar) {
      const currentScore = calculateCurrentScore(field);
      const maxScore = calculateMaxScore(field);
      const weight = field.weights ? field.weights.join(", ") : "1";
      const fileCount = countFiles(field);

      let valueText = "";
      if (typeof field.value === "object" && field.value !== null) {
        try {
          valueText = JSON.stringify(field.value);
        } catch (e) {
          valueText = "[object]";
        }
      } else {
        valueText = field.value || "";
      }
      //scoreshow
      /*
      scoreBar.textContent = window.debug
        ? `[score: ${currentScore}, weight: ${weight}, maxscore: ${maxScore}, required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`
        : `[Required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`;
    */
    }

    // Update UI and summaries
    resetCommon();
  };

  return resetBtn;
}
function createAddFileButton(divId, key, field, schema, lang) {
  const addFileBtn = document.createElement("button");
  addFileBtn.textContent = getLabel(
    { label: { en: "Add file", th: "Add file" } },
    lang,
  );
  addFileBtn.style.cssText =
    "margin-left: 10px; padding: 4px 8px; cursor: pointer;";

  addFileBtn.onclick = () => {
    window.logomode = false;
    toggleUploadPanel();

    // Determine the correct input ID based on field type
    const inputId =
      field.data_type === "attachment"
        ? `${divId}-${encodeFieldKey(key)}` // For simple attachment fields
        : `${divId}-${encodeFieldKey(key)}-att`; // For radioatt/checktextatt

    updateFileListFromInput(inputId);

    // Set up a completion callback
    window.uploadCompleteCallback = () => {
      const attInput = document.getElementById(inputId);
      if (attInput) {
        // Trigger full update sequence
        const inputEvent = new Event("input", { bubbles: true });
        attInput.dispatchEvent(inputEvent);

        // Update the correct field value structure
        if (field.data_type === "attachment") {
          field.value = attInput.value.trim();
        } else if (field.data_type.includes("att")) {
          field.value.att = attInput.value.trim();
        }

        // Update displays
        const fieldDiv = document.getElementById(
          `${divId}-field-${encodeFieldKey(key)}`,
        );
        if (fieldDiv) {
          updateFieldDisplay(fieldDiv, field);
          updateSectionSummaries(divId, schema, lang);

          // Update file count display
          const fileCountDisplay = fieldDiv.querySelector(
            `#${divId}-filecount-${encodeFieldKey(key)}`,
          );
          if (fileCountDisplay) {
            fileCountDisplay.textContent = `Files: ${countFiles(field)}`;
          }
        }
      }
    };
  };

  return addFileBtn;
}
function createSaveAttachmentButton(divId, key, field, schema, lang) {
  const saveAttBtn = document.createElement("button");
  saveAttBtn.textContent = getLabel(
    { label: { en: "Save Attachment", th: "Save Attachment" } },
    lang,
  );
  saveAttBtn.style.cssText =
    "margin-left: 10px; padding: 4px 8px; cursor: pointer;";
  saveAttBtn.onclick = () => {
    schema[key].value.att = document.getElementById(
      `${divId}-${encodeFieldKey(key)}-att`,
    ).value;
    document.getElementById(
      `${divId}-filecount-${encodeFieldKey(key)}`,
    ).textContent = `Files: ${countFiles(schema[key])}`;
    const fieldDiv = document.getElementById(
      `${divId}-field-${encodeFieldKey(key)}`,
    );
    if (fieldDiv) {
      updateFieldDisplay(fieldDiv, field);
      updateSectionSummaries(divId, schema, lang);
    } else {
      console.warn("fieldDiv not found for field:", key);
    }
  };
  return saveAttBtn;
}
function updateFieldDisplay(fieldDiv, field) {
  // Update border based on required status and whether the field is answered
  let hasValue = false;
  let valueText = "";
  fieldDiv.style.outline =
    field.required && !isFieldAnswered(field) ? "2px solid red" : "";

  // Update score bar
  const scoreBar = fieldDiv.querySelector(".score-bar");
  if (scoreBar) {
    const currentScore = calculateCurrentScore(field);
    const maxScore = calculateMaxScore(field);
    const scoreAchieved = calculateScoreAchieved(field);

    const weight = field.weights ? field.weights.join(", ") : "1";

    // Get file count based on type
    //let fileCount = 0;
    fileCount = countFiles(field);
    let valueDisplay = "";

    if (field.data_type === "attachment") {
      fileCount = countFiles(field);
    } else if (field.data_type === "radiotextatt" && field.value?.att) {
      fileCount = countFiles(field);
    }

    let valueText = "";
    if (typeof field.value === "object" && field.value !== null) {
      try {
        valueText = JSON.stringify(field.value);
      } catch (e) {
        valueText = "[object]";
      }
    } else {
      valueText = field.value || "";
    }
    if (valueText !== null && valueText !== undefined && valueText !== "")
      hasValue = true;
    const valueIndicator = hasValue ? "✓" : "";
    if (field.data_type === "radioatt") {
      valueDisplay = `Selected: ${field.value?.radio ?? "none"}`;
      if (fileCount > 0) {
        valueDisplay += `, Files: ${fileCount}`;
      }
    }
    //scoreshow
    if (window.super) {
    if (window.debug || window.scoreshow) {
      scoreBar.textContent = `[score: ${currentScore}, weight: ${weight}, maxscore: ${maxScore}, score achieved: ${scoreAchieved.toFixed(1)}, required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`;
    } else {
      scoreBar.textContent = `[Required: ${field.required ? "yes" : "no"}, Files: ${fileCount}, value: ${valueText}]`;
    }
    }
    
  }
}

function updateSectionSummaries(divId, schema, lang) {
  // Accumulate global totals from all segments and sections
  let globalTotalFields = 0;
  let globalAnsweredFields = 0;
  globalRequiredFields = 0;
  let globalAnsweredRequiredFields = 0;
  const segments = new Map();
  if (schema.grouping) {
    schema.grouping.name.forEach((name, i) => {
      if (schema.grouping.type[i] === "segment") {
        segments.set(name, {
          label: getLabel({ label: schema.grouping.label }, lang)[i] || name,
          sections: new Map(),
        });
      }
    });
  } else {
    console.warn("No grouping defined in schema, using default segment");
    segments.set("default", { label: "Default", sections: new Map() });
  }

  // Map fields to segments and sections
  for (const key in schema) {
    if (key === "grouping") continue;
    const field = schema[key];
    const segment = field.segment?.[0] || schema.grouping?.name[0] || "default";
    if (!segments.has(segment)) {
      console.log(`Creating default segment for ${segment}`);
      segments.set(segment, { label: segment, sections: new Map() });
    }
    if (field.type === "section") {
      segments.get(segment).sections.set(key, getLabel(field, lang) || key);
    } else if (field.section) {
      if (!segments.get(segment).sections.has(field.section)) {
        if (schema[field.section]) {
          segments
            .get(segment)
            .sections.set(
              field.section,
              getLabel({ label: schema[field.section]?.label }, lang) ||
                field.section,
            );
        } else {
          console.warn(
            `Section ${field.section} for field ${key} not found in schema`,
          );
        }
      }
    } else {
      console.warn(`Field ${key} has no section assigned`);
    }
  }

  segments.forEach((segmentData, segmentId) => {
    console.log(`Processing segment: ${segmentId}`);
    segmentData.sections.forEach((sectionLabel, sectionId) => {
      console.log(`Processing section: ${sectionId} in segment: ${segmentId}`);
      let sectionTotals = {
        allFields: 0,
        requiredFields: 0,
        answeredFields: 0,
        answeredRequiredFields: 0,
        totalScore: 0,
        totalScoreWeighted: 0,
        maxPossibleScore: 0,
        maxPossibleScoreWeighted: 0,
        totalFiles: 0,
        unansweredFields: [],
      };

      for (const key in schema) {
        if (key === "grouping" || schema[key].type === "section") continue;
        const field = schema[key];
        if (
          field.section !== sectionId ||
          !field.segment?.includes(segmentId)
        ) {
          console.log(
            `Skipping field ${key} in render: section=${field.section}, segment=${field.segment}, expected section=${sectionId}, segment=${segmentId}`,
          );
          continue;
        }

        console.log(
          `Rendering field: ${key}, type: ${field.data_type || field.type}`,
        );
        hasField = true;
        const fieldDiv = document.createElement("div");
        fieldDiv.className = "form-field";
        const encodedKey = encodeFieldKey(key);
        fieldDiv.id = `${divId}-field-${encodedKey}`;
        fieldDiv.style.cssText =
          "background-color: #f9f9f9; padding: 10px; margin-bottom: 10px; border-radius: 4px;";
        if (field.required && !isFieldAnswered(field)) {
          fieldDiv.style.outline = "2px solid red";
        }
        if (!field.data_type && !field.type) {
          console.warn(`Field ${key} has no data_type or type defined`);
          continue;
        }
        globalTotalFields += sectionTotals.allFields;

        console.log(
          `Processing field: ${key}, type: ${field.data_type || field.type}`,
        );
        let fileCount = 0;

        const currentScore = calculateCurrentScore(field);
        const maxScore = calculateMaxScore(field);
        const scoreAchieved = calculateScoreAchieved(field);

        const isAnswered = isFieldAnswered(field);
        const isFile =
          field.data_type === "attachment" || field.type === "attachment";
        fileCount = isFile ? countFiles(field) : 0;
        if (field.data_type === "attachment") {
          fileCount = countFiles(field);
        } else if (field.data_type === "radiotextatt" && field.value?.att) {
          fileCount = countFiles({
            value: field.value.att,
            data_type: "attachment", // Treat it as attachment for counting
          });
        } else if (field.data_type === "radioatt" && field.value?.att) {
          // ADDED THIS CASE
          fileCount = countFiles({
            value: field.value.att,
            data_type: "attachment",
          });
        }
        sectionTotals.allFields++;
        if (field.required) sectionTotals.requiredFields++;
        if (isAnswered) sectionTotals.answeredFields++;
        if (field.required && isAnswered)
          sectionTotals.answeredRequiredFields++;
        sectionTotals.totalScore += isAnswered ? field.score || 1 : 0;
        sectionTotals.totalScoreWeighted += currentScore;
        sectionTotals.maxPossibleScore += field.score || 1;
        sectionTotals.maxPossibleScoreWeighted += maxScore;
        sectionTotals.totalFiles += fileCount;

        if (isFile) {
          console.log(
            `Attachment field ${key}: value="${field.value}", files=${fileCount}`,
          );
        }

        if (field.required && !isFieldAnswered(field)) {
          const encodedKey = encodeFieldKey(key);
          const fieldElement = document.getElementById(
            `${divId}-field-${encodedKey}`,
          );
          if (fieldElement) {
            sectionTotals.unansweredFields.push({
              key,
              label: getLabel(field, lang) || key,
              elementId: `${divId}-field-${encodedKey}`,
            });
          } else {
            console.warn(
              `Field ${key} not rendered in DOM (ID: ${divId}-field-${encodedKey}), skipping from unanswered list`,
            );
          }
        }
      }

      console.log(
        `Section ${sectionId} totals: ${JSON.stringify(sectionTotals, null, 2)}`,
      );

      const sectionSummary = document.getElementById(
        `${divId}-summary-${encodeFieldKey(segmentId)}-${encodeFieldKey(sectionId)}`,
      );
      if (sectionSummary) {
        //window.debug=true;
        const unansweredCount =
          sectionTotals.requiredFields - sectionTotals.answeredRequiredFields;
        // In the section summary HTML generation
        // In the section summary HTML generation

        a = window.debug
          ? `[field total: ${sectionTotals.allFields}, score: ${sectionTotals.totalScore}, achieved score: ${sectionTotals.totalScoreWeighted}, maxscore: ${sectionTotals.maxPossibleScoreWeighted}, total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]`
          : `[field total: ${sectionTotals.allFields}, total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]`;
          if (window.scoreshow) {
              a=`[field total: ${sectionTotals.allFields}, score: ${sectionTotals.totalScore}, achieved score: ${sectionTotals.totalScoreWeighted}, maxscore: ${sectionTotals.maxPossibleScoreWeighted}, total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]`;
          }
          else {
              a =`[field total: ${sectionTotals.allFields}, total required: ${sectionTotals.requiredFields}, answered required/total: ${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields}, unanswered required/total: ${unansweredCount}/${sectionTotals.requiredFields}, Files: ${sectionTotals.totalFiles}]`;
          }
        sectionSummary.innerHTML =
          `
          <summary style="cursor: pointer;">UnAnswered/Total/Required (${unansweredCount}/${sectionTotals.allFields}/${sectionTotals.requiredFields})</summary>
          <div style="padding: 8px;">
            ` +
          a +
          `${
            sectionTotals.unansweredFields.length > 0
              ? `
              <div style="margin-top: 10px; color: red;">
                <strong>Unanswered Required Fields:</strong>
                <ul style="margin: 5px 0; padding-left: 20px;">
                  ${sectionTotals.unansweredFields
                    .map(
                      (field) => `
                    <li style=" white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                      <a href="javascript:scrollToField('${encodeFieldKey(
                        field.key,
                      )}', '${divId}')"
                         style="text-decoration: none; color: red;"
                         title="${field.label}">
                        ${field.label}
                      </a>
                    </li>
                  `,
                    )
                    .join("")}
                </ul>
              </div>
            `
              : ""
          }
          </div>
        `;
        if (unansweredCount > 0) {
          sectionSummary.classList.add("unanswered");
        } else {
          sectionSummary.classList.remove("unanswered");
        }
      }

      const sectionHeader = document.getElementById(
        `${divId}-section-header-${encodeFieldKey(sectionId)}`,
      );
      if (sectionHeader) {
        const progressPercent =
          sectionTotals.requiredFields > 0
            ? Math.round(
                (sectionTotals.answeredRequiredFields /
                  sectionTotals.requiredFields) *
                  100,
              )
            : 100;
        globalAnsweredFields += sectionTotals.answeredRequiredFields;
        globalAnsweredRequiredFields += sectionTotals.answeredRequiredFields;
        globalRequiredFields += sectionTotals.requiredFields;
        sectionHeader.innerHTML = `


            [Progress: ${progressPercent}% (${sectionTotals.answeredRequiredFields}/${sectionTotals.requiredFields})]
            <div style="width: 100%; background-color: #e0e0e0; height: 10px; border-radius: 5px; overflow: hidden;">
              <div style="width: ${progressPercent}%; background-color: #4caf50; height: 100%;"></div>
            </div>

        `;
      }
    });
  });
  // Update your summary div by id 'summan'
  const summanDiv = document.getElementById("summan");
  if (summanDiv) {
    summanDiv.textContent = `Total fields: ${globalTotalFields} | ${globalRequiredFields} Answered required fields: ${globalAnsweredFields}`;
    renderSchemaStructureToSumman(schema, divId, lang);
  }

}
// Helper: remove HTML tags
function stripHtmlTags(str) {
  if (!str) return '';
  return str.replace(/<\/?[^>]+(>|$)/g, ""); 
}

// Helper: shorten text safely
function shortLabel(str, max = 27) {
  const clean = stripHtmlTags(str);
  return clean.length > max ? clean.substring(0, max) + "..." : clean;
}

function renderSchemaStructureToSumman(schema, divId, lang = "en") {
    /* 0️⃣  keep every key already in window.board and add the three score objects */
  const bucketStat = QSummary(bucket)?.summary?.totals ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };
  const cupStat    = QSummary(cup)?.summary?.totals    ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };

  const overallAchieved = bucketStat.totalScoreWeighted + cupStat.totalScoreWeighted;
  const overallMax      = bucketStat.maxPossibleScoreWeighted + cupStat.maxPossibleScoreWeighted;

  Object.assign(window.board, {
    overallScore: {
      achieved : overallAchieved,
      max      : overallMax,
      percent  : overallMax ? (overallAchieved / overallMax * 100).toFixed(1) : 0
    },
    assessment: {
      achieved : bucketStat.totalScoreWeighted,
      max      : bucketStat.maxPossibleScoreWeighted,
      percent  : bucketStat.maxPossibleScoreWeighted ? (bucketStat.totalScoreWeighted / bucketStat.maxPossibleScoreWeighted * 100).toFixed(1) : 0
    },
    profile: {
      achieved : cupStat.totalScoreWeighted,
      max      : cupStat.maxPossibleScoreWeighted,
      percent  : cupStat.maxPossibleScoreWeighted ? (cupStat.totalScoreWeighted / cupStat.maxPossibleScoreWeighted * 100).toFixed(1) : 0
    }
  });
  bucketStats = getFieldStats(bucket);
  cupStats = getFieldStats(cup);
 // weighted scores from QSummary
 const bSum = QSummary(bucket)?.summary?.totals ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };
 const cSum = QSummary(cup)?.summary?.totals    ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };

 const totalScoreWeighted       = bSum.totalScoreWeighted + cSum.totalScoreWeighted;
 const maxPossibleScoreWeighted = bSum.maxPossibleScoreWeighted + cSum.maxPossibleScoreWeighted;
 const scorePct = maxPossibleScoreWeighted
   ? (totalScoreWeighted / maxPossibleScoreWeighted * 100).toFixed(1)
   : 0;


  window.bucket_answeredRequired = bucketStats.answeredRequired;
  window.bucket_totalRequired = bucketStats.totalRequired;
  window.cup_answeredRequired = cupStats.answeredRequired;
  window.cup_totalRequired = cupStats.totalRequired;
  if (window.bucket_totalRequired - window.bucket_answeredRequired > 0) {
    let cp = Math.round(
      (window.bucket_answeredRequired / window.bucket_totalRequired) * 100,
    );
    updateBadge(
      "assessment",
      window.bucket_totalRequired - window.bucket_answeredRequired,
      "red",
    );
    updateStatus(
      "assessment",
      `${cp}% (${window.bucket_answeredRequired}/${window.bucket_totalRequired}) `,
    );
  } else {
    updateStatus(
      "assessment",
      `100% (${window.bucket_answeredRequired}/${window.bucket_totalRequired}) `,
    );
    updateBadge("assessment", 0, "red");
  }
  if (window.cup_totalRequired - window.cup_answeredRequired > 0) {
    let cp = Math.round(
      (window.cup_answeredRequired / window.cup_totalRequired) * 100,
    );
    updateBadge(
      "Profile",
      window.cup_totalRequired - window.cup_answeredRequired,
      "red",
    );
    updateStatus(
      "Profile",
      `${cp}% (${window.cup_answeredRequired}/${window.cup_totalRequired}) `,
    );
  } else {
    updateBadge("Profile", 0, "red");
    updateStatus(
      "Profile",
      `100% (${window.cup_answeredRequired}/${window.cup_totalRequired}) `,
    );
  }
  let aap = window.bucket_totalRequired + window.cup_totalRequired;
  let asp = window.bucket_answeredRequired + window.cup_answeredRequired;
  window.totalRequired = aap;
  window.answeredRequired = asp;
  let overallPercent =
    aap > 0 ? Math.min(100, Math.round((asp / aap) * 100)) : 0;
  stillneed = aap - asp;
  prog = `Progress (${asp}/${aap}) ` + overallPercent + "%";
  updateStatus("A1", prog);
  if (overallPercent > 0) updateBadge("A1", stillneed, "red");
  if (overallPercent === 100) updateBadge("A1", "Ready", "green");

  const segments = new Map();
  let globalTotalFields = 0;
  let globalRequiredFields = 0;
  let globalAnsweredFields = 0;
  let globalAnsweredRequiredFields = 0;
  let globalunAnsweredRequiredFields = 0;
  let globalTotalFiles = 0; // Add global file counter

  // 1. Prepare segment structure
  if (schema.grouping) {
    schema.grouping.name.forEach((name, i) => {
      if (schema.grouping.type[i] === "segment") {
        segments.set(name, {
          label: getLabel({ label: schema.grouping.label }, lang)[i] || name,
          sections: new Map(),
        });
      }
    });
  } else {
    segments.set("default", { label: "Default", sections: new Map() });
  }

  // 2. Organize fields into segments/sections and count
  for (const key in schema) {
    if (key === "grouping") continue;
    const field = schema[key];

    const segment =
      field.segment?.[0] || schema.grouping?.name?.[0] || "default";
    if (!segments.has(segment)) {
      segments.set(segment, { label: segment, sections: new Map() });
    }

    if (field.type === "section") {
      segments.get(segment).sections.set(key, {
        label: getLabel(field, lang) || key,
        fields: [],
      });
    } else if (field.section) {
      const section = field.section;
      if (!segments.get(segment).sections.has(section)) {
        if (schema[section]) {
          segments.get(segment).sections.set(section, {
            label: getLabel({ label: schema[section].label }, lang) || section,
            fields: [],
          });
        }
      }

      const sectionObj = segments.get(segment).sections.get(section);
      if (sectionObj) {
        sectionObj.fields.push({
          key,
          label: getLabel(field, lang) || key,
        });
      }

      // Count for global progress
      globalTotalFields++;
      const answered = isFieldAnswered(field);
      if (answered) globalAnsweredFields++;
      if (field.required) {
        globalRequiredFields++;
        if (answered) globalAnsweredRequiredFields++;
        else globalunAnsweredRequiredFields++;
      }
      // Count files for all field types that can have them
      // Add this file counting block:
      if (field.data_type === "attachment") {
        globalTotalFiles += countFiles(field);
      } else if (field.data_type === "radiotextatt" && field.value?.att) {
        globalTotalFiles += countFiles({
          value: field.value.att,
          data_type: "attachment",
        });
      } else if (field.data_type === "radioatt" && field.value?.att) {
        // Add this case
        globalTotalFiles += countFiles({
          value: field.value.att,
          data_type: "attachment",
        });
      }
    }
  }

  // 3. Calculate percentages and set window.allowsubmit
  const percentAnsweredAll =
    globalTotalFields > 0
      ? Math.round((globalAnsweredFields / globalTotalFields) * 100)
      : 100;

  const percentAnsweredRequired =
    globalRequiredFields > 0
      ? Math.round((globalAnsweredRequiredFields / globalRequiredFields) * 100)
      : 100;

  let status = "Not Active";
  window.allowsubmit = false;

  if (globalAnsweredRequiredFields === 0) {
    status = "⛔ Not Active";
  } else if (globalAnsweredRequiredFields < globalRequiredFields) {
    status = "🔄 In Progress";
  } else {
    status = "✅ READY";
    window.allowsubmit = true;
  }
ovs="";
if (window.scoreshow) ovs=`<div style="margin-bottom:12px;padding:12px;border-radius:8px;font-size:14px;background:#f5f5f5;">
      <strong>Overall (Assessment + Profile)</strong><br>
      Score: <b>${totalScoreWeighted}</b> / ${maxPossibleScoreWeighted}  (${scorePct}%)
    </div>`;
  // 4. Build HTML 📊
  let html = `<div style="font-size: 0.95em; font-family: sans-serif;">
      ${ovs}
    <div style="margin-bottom: 15px; padding:12px 12px;border-radius:8px;font-size:13px;background:rgba(160,160,160,.1);">
      <strong>Summary ${status}</strong><br><hr>
    <!--  Total fields: <b>${globalTotalFields}</b><br> -->
      Total required: <b>${globalRequiredFields}</b><br>
<!--      Answered fields: <b>${globalAnsweredFields}</b><br> -->
      Answered : <b>${globalAnsweredRequiredFields}</b><br>
        UnAnswered : <b style="color: red">${globalunAnsweredRequiredFields}</b>
      Total files: <b>${globalTotalFiles}</b><br>  <!-- Add files count -->
<hr>
      <div style="margin-bottom: 10px;">
        <div>[Answered: ${percentAnsweredAll}%]</div>
        <div style="background: #eee; height: 6px; border-radius: 5px;">
          <div style="width: ${percentAnsweredAll}%; background: #2196f3; height: 6px; border-radius: 5px;"></div>
        </div>
      </div>
      <div>
        <div>[Answered Required: ${percentAnsweredRequired}%]</div>
        <div style="background: #eee; height: 6px; border-radius: 5px;">
          <div style="width: ${percentAnsweredRequired}%; background: #4caf50; height: 6px; border-radius: 5px;"></div>
        </div>
      </div>
      
    </div><hr>`;

  // 5. Segment → Section → Fields  📁 color: #2a5; 📂 color: #06c; 🔑 color: #c00;  ${field.key}:
  // Helper function to count required and answered fields in a section
  const countSectionStats = (fields) => {
    let required = 0;
    let answeredRequired = 0;
    let unAnsweredRequired = 0;

    fields.forEach((field) => {
      const fieldObj = schema[field.key];
      if (fieldObj?.required) {
        required++;
        if (isFieldAnswered(fieldObj)) {
          answeredRequired++;
        } else unAnsweredRequired++;
      }
    });

    return { required, answeredRequired, unAnsweredRequired };
  };

  // 5. Segment → Section → Fields with expand/collapse
  segments.forEach((seg, segId) => {
    // Count segment stats
    let segRequired = 0;
    let segAnsweredRequired = 0;
    let segTotalFields = 0;
    let segAnsweredFields = 0;
    let segUnanswered = 0;

    seg.sections.forEach((section) => {
      section.fields.forEach((field) => {
        const fieldObj = schema[field.key];
        segTotalFields++;
        if (isFieldAnswered(fieldObj)) segAnsweredFields++;
        if (fieldObj?.required) {
          segRequired++;
          if (isFieldAnswered(fieldObj)) segAnsweredRequired++;
          else segUnanswered++;
        }
      });
    });

    const segPercent =
      segRequired > 0
        ? Math.round((segAnsweredRequired / segRequired) * 100)
        : 100;
    const jumpsg = `${divId}-segment-${encodeFieldKey(segId)}`;
    html += `<div style="margin-bottom: 10px;">
    <div style="display: flex; align-items: center; gap: 4px;">
      <div style="text-decoration: none; flex-grow: 1;font-size: 13px; cursor: pointer;" onclick="toggleSection(this, 'seg_${segId}')"><b>${seg.label}</b> (${segAnsweredRequired}/${segRequired}, ${segPercent}%,Unanswered: <b style="color: red">${segUnanswered}</b>)
     </div> <a href="javascript:scrollTo('${jumpsg}', '${divId}')"
       style="margin-left: 10px; font-size: 0.8em; text-decoration: none;">
       ❮
    </a>
    </div>
      <div id="seg_${segId}" style=" margin-left: 1px;">`;

    seg.sections.forEach((section, secId) => {
      // Count section stats
      const stats = countSectionStats(section.fields);
      const secPercent =
        stats.required > 0
          ? Math.round((stats.answeredRequired / stats.required) * 100)
          : 100;
      const jumpsc = `${divId}-section-${encodeFieldKey(secId)}`;

      html += `<div style="margin-left: 0px;">
      <div style="display: flex; align-items: center; gap: 1px;">
        <div style="font-size: 13px; flex-grow: 0;white-space: wrap;cursor: pointer;" onclick="toggleSection(this, 'sec_${segId}_${secId}')">
          <b>${section.label}</b> (${stats.answeredRequired}/${stats.required}, ${secPercent}%,: UnAnswered:<b style="color: red">${stats.unAnsweredRequired}</b>)
         </div><a href="javascript:scrollTo('${jumpsc}', '${divId}')"
       style="margin-left: 10px; font-size: 0.6em; text-decoration: none;">
       ❮
    </a>
    </div>
        <div id="sec_${segId}_${secId}" style=" margin-left: 0px;">`;

      section.fields.forEach((field) => {
        const fieldObj = schema[field.key];
        const isAnswered = fieldObj ? isFieldAnswered(fieldObj) : false;
        const dotColor = isAnswered ? "green" : "red";
        const isRequired = fieldObj?.required ? " (Required)" : "";

        html += `<div style="margin-left: 0px; display: flex; align-items: center; min-height: 20px;">
        <span style="
            display: inline-block;
            min-width: 8px;
            min-height: 8px;
            width: 8px;
            height: 8px;
            border-radius: 50%;
            background: ${dotColor};
            margin-right: 4px;
            flex-shrink: 0;
        "></span>
          <a href="javascript:scrollToField('${encodeFieldKey(field.key)}', '${divId}')"
             style="
             font-size: 13px;
               text-decoration: none;
               color: inherit;
               white-space: nowrap;
               overflow: hidden;
               text-overflow: ellipsis;
               max-width: 90%;
           "
             title="${stripHtmlTags(field.label)}">
   ${shortLabel(field.label)}🔗
              
          </a>
        </div>`;
      });

      html += `</div></div>`;
    });

    html += `</div></div>`;
  });

  html += `</div>`;

  // Add the toggle function to the window object
  window.toggleSection = function (element, id) {
    const content = document.getElementById(id);
    if (content.style.display === "none") {
      content.style.display = "block";
      element.innerHTML = element.innerHTML.replace("▶", "▼");
    } else {
      content.style.display = "none";
      element.innerHTML = element.innerHTML.replace("▼", "▶");
    }
  };

  // 6. Output to #summan
  const summaryDiv = document.getElementById("summan");
  if (summaryDiv) {
    summaryDiv.innerHTML = html;
  } else {
    console.warn("Div with id 'summan' not found");
  }

}
function scrollToField(key, formId = "gform") {
  const id = `${formId}-field-${encodeURIComponent(key)}`;
  const el = document.getElementById(id);
  if (el) {
    el.scrollIntoView({ behavior: "smooth", block: "center" });
    el.style.background = "rgba(255, 165, 0, 0.3)";
    setTimeout(() => (el.style.background = ""), 2000);
  } else {
    console.warn("Scroll target not found:", id);
  }
}
function scrollTo(key, formId = "gform") {
  const id = `${encodeURIComponent(key)}`;
  const el = document.getElementById(id);
  if (el) {
    el.scrollIntoView({ behavior: "smooth", block: "start" });
    el.style.outline = "3px solid #ffa500";
    setTimeout(() => (el.style.border = ""), 2000);
  } else {
    console.warn("Scroll target not found:", id);
  }
}
/**
 * Comprehensive form scoring calculator
 * @param {object} schema - Your form schema
 * @returns {object} Complete scoring summary
 */
// Add this function to your code if not already present
function QSummaryXX(schema) {
  const summary = {
    totals: {
      allFields: 0,
      requiredFields: 0,
      answeredFields: 0,
      answeredRequiredFields: 0,
      totalScore: 0,
      totalScoreWeighted: 0,       // Current weighted score
      maxPossibleScore: 0,
      maxPossibleScoreWeighted: 0, // Maximum possible weighted score
      totalFiles: 0,
      unansweredRequiredFields: []
    },
    segments: {}
  };

  // Process all fields in the schema
  for (const key in schema) {
    if (key === 'grouping' || schema[key].type === 'section') continue;
    
    const field = schema[key];
    const isAnswered = isFieldAnswered(field);
    const fieldScore = field.score || 1;
    const fieldWeight = field.weights ? field.weights[0] || 1 : 1;
    const fileCount = countFiles(field);

    // Update totals
    summary.totals.allFields++;
    if (field.required) summary.totals.requiredFields++;
    if (isAnswered) summary.totals.answeredFields++;
    if (field.required && isAnswered) summary.totals.answeredRequiredFields++;
    
    // Score calculations
    summary.totals.totalScore += isAnswered ? fieldScore : 0;
    summary.totals.totalScoreWeighted += isAnswered ? fieldScore * fieldWeight : 0;
    summary.totals.maxPossibleScore += fieldScore;
    summary.totals.maxPossibleScoreWeighted += fieldScore * fieldWeight;
    summary.totals.totalFiles += fileCount;

    // [Add segment/section processing here if needed...]
  }

  return { summary };
}
function scrollToTop(formId) {
  const container = document.getElementById(formId);
  if (!container) return;
  container.scrollIntoView({ behavior: "smooth", block: "start" });
}

function scrollToBottom(formId) {
  const container = document.getElementById(formId);
  if (!container) return;
  container.scrollIntoView({ behavior: "smooth", block: "end" });
}
function toggleAll(formId, expand = true) {
  document.querySelectorAll(`#${formId}-fields details`).forEach(det => {
    det.open = expand;
  });
}
function toggleSections(formId) {
  // look at the first section/segment to decide current state
  const firstDetails = document.querySelector(`#${formId}-fields details`);
  if (!firstDetails) return;

  const expand = !firstDetails.open; // if first is closed → expand all, else collapse all
  document.querySelectorAll(`#${formId}-fields details`).forEach(det => {
    det.open = expand;
  });
}
function collapseSectionsOnly(formId, expand = false) {
  // loop all sections inside this form
  document.querySelectorAll(`#${formId}-fields details.section`).forEach(sec => {
    sec.open = expand;
  });
}
function toggleSectionsOnly(formId) {
  const firstSection = document.querySelector(`#${formId}-fields details.section`);
  if (!firstSection) return;
  const expand = !firstSection.open;
  collapseSectionsOnly(formId, expand);
}

function autoSaveToLocal(divId, schema) {
  const key = `local-${divId}`;          // isolated key
  localStorage.setItem(key, JSON.stringify(schema));
}
