(function () {
  // CSS injection
  const style = document.createElement("style");
  style.textContent = `
#avt_myDiv {
  position: absolute;
  height: 60px;
  display: flex;
  align-items: center;
  border-radius: 8px;
  padding: 5px;
  cursor: grab;
  user-select: none;
  z-index: 1000;
  transition: flex-direction 0.2s ease;
}
#avt_avatar {
  width: 50px;
  height: 50px;
  border-radius: 50%;
  background-color: #ccc;
  background-size: cover;
  background-position: center;
  background-repeat: no-repeat;
  box-shadow: 0 2px 5px rgba(0,0,0,0.2);
  cursor: pointer;
  flex-shrink: 0;
}
#avt_rightContent {
  width: 200px;
  height: 100%;
  background: white;
  margin-left: 8px;
  margin-right: 8px;
  padding: 8px;
  border-radius: 8px;
  box-shadow: 0 4px 10px rgba(0,0,0,0.2);
  display: flex;
  flex-direction: column;
  justify-content: center;
  opacity: 1;
  visibility: visible;
  transition: opacity 0.2s ease, visibility 0.2s ease;
}
#avt_rightContent.hidden {
  opacity: 0;
  visibility: hidden;
}
#avt_info {
  font-size: 12px;
}
.btns {
  margin-top: 6px;
  display: flex;
  gap: 4px;
  flex-wrap: wrap;
  align-items: center;
}
button {
  font-size: 11px;
  padding: 3px 6px;
  border: none;
  border-radius: 4px;
  background: #2196F3;
  color: white;
  cursor: pointer;
}
.btnReset {
  background: #9e9e9e;
}
.btnHide ,#avt_closePanelBtn{
  background: #f44336;
  border-radius: 50%;
  width: 18px;
  height: 18px;
  line-height: 20px;
  padding: 0;
  margin-left: auto;
}
#avt_panel {
  position: absolute;
  width: 200px;
  height: 200px;
  background: #3f51b5;
  color: white;
  border-radius: 8px;
  padding: 10px;
  display: none;
  opacity: 0;
  transition: transform 0.3s ease, opacity 0.3s ease;
}
#avt_panel.slide-up { transform: translateY(10px); }
#avt_panel.slide-down { transform: translateY(-10px); }
#avt_panel.show {
  display: block;
  opacity: 1;
  transform: translateY(0);
}
#avt_closePanelBtn {
  position: absolute;
  top: 8px;
  right: 5px;
  background: rgba(0,0,0,0.2);
  color: white;
  border: none;
  font-size: 16px;
  font-weight: bold;
  cursor: pointer;
  padding: 2px 6px;
  border-radius: 50%;
  line-height: 1;
}
#avt_closePanelBtn:hover {
  background-color: rgba(255,25,25,0.);
}
#avt_myDiv.shrinked {
  width: auto;
}
#avt_rightContent.hidden {
  display: none; /* Ensures layout shrinks */
}

`;
  document.head.appendChild(style);

  // Create UI
  const div = document.createElement("div");
  div.id = "avt_myDiv";
  div.innerHTML = `
  <div id="avt_avatar" title="Double-click to toggle info"></div>
  <div id="avt_rightContent">
    <div id="avt_info">
      <div id="avt_userName"><strong>User</strong></div>
      <div id="avt_userInfo">Info here</div>
    </div>
    <div class="btns">
      <button id="avt_togglePanelBtn">Panel</button>
      <button class="btnReset" id="avt_resetBtn">R</button>
      <button class="btnLANG" id="avt_btnLANG">L</button>
      <button class="btnHide" id="avt_hideBtn"></button>
    </div>
  </div>
  `;
  const panel = document.createElement("div");
  panel.id = "avt_panel";
  panel.innerHTML = `
    <button id="avt_closePanelBtn" title="Close Panel"></button>
    <div id="avt_panel_body">I'm the toggle panel</div>
  `;
  document.body.appendChild(div);
  document.body.appendChild(panel);

  // Setup
  const myDiv = div;
  const avatar = document.getElementById("avt_avatar");
  const rightContent = document.getElementById("avt_rightContent");
  const panelEl = document.getElementById("avt_panel");
  const toggleBtn = document.getElementById("avt_togglePanelBtn");
  const hideBtn = document.getElementById("avt_hideBtn");
  const resetBtn = document.getElementById("avt_resetBtn");
  const langBtn = document.getElementById("avt_btnLANG");
  const closeBtn = document.getElementById("avt_closePanelBtn");

  // Avatar
  const user_imgr =
    localStorage.getItem("img") || "https://via.placeholder.com/80";
  let user_img;
  try {
    user_img = atob(user_imgr);
  } catch {
    user_img = "https://i.pravatar.cc/40?u=yanyong";
  }
  avatar.style.backgroundImage = `url(${user_img})`;

  // Position
  const savedX = localStorage.getItem("myDivX");
  const savedY = localStorage.getItem("myDivY");
  myDiv.style.left = savedX ? savedX + "px" : "20px";
  myDiv.style.top = savedY ? savedY + "px" : window.innerHeight - 80 + "px";

  let offsetX = 0,
    offsetY = 0,
    dragging = false;

  myDiv.addEventListener("mousedown", (e) => {
    if (e.target.tagName === "BUTTON") return;
    dragging = true;
    offsetX = e.clientX - myDiv.offsetLeft;
    offsetY = e.clientY - myDiv.offsetTop;
    myDiv.style.cursor = "grabbing";
  });

  document.addEventListener("mouseup", () => {
    if (dragging) {
      const isHidden = rightContent.classList.contains("hidden");
      localStorage.setItem("avt_rightContent_hidden", isHidden ? "1" : "0");

      let saveX = myDiv.offsetLeft;
      let saveY = myDiv.offsetTop;
      const rightContentWidth = 200;

      // If content is hidden, adjust position to account for hidden panel
      if (isHidden) {
        if (window.avatarOnRight) {
          saveX -= rightContentWidth;
        } else {
          saveX += rightContentWidth;
        }
      }

      localStorage.setItem("myDivX", saveX);
      localStorage.setItem("myDivY", saveY);
    }
    dragging = false;
    myDiv.style.cursor = "grab";
  });

  document.addEventListener("mousemove", (e) => {
    if (!dragging) return;
    dragMoved = true;
    const x = e.clientX - offsetX;
    const y = e.clientY - offsetY;
    const clamped = clampToViewport(x, y, myDiv);
    myDiv.style.left = clamped.x + "px";
    myDiv.style.top = clamped.y + "px";
    updateDirection();
    if (panel.classList.contains("show")) positionPanel();
  });

  function updateDirectiosssn() {
    const rect = myDiv.getBoundingClientRect();
    const avatarWidth = 50; // Width of the avatar element
    const threshold = 300; // Distance from right edge to trigger alert

    // Check if avatar is near right edge and currently on right side
    const isNearRightEdge = rect.right > window.innerWidth - threshold;
    const isCurrentlyOnRight = myDiv.style.flexDirection !== "row-reverse";

    if (isNearRightEdge && isCurrentlyOnRight) {
      // Show alert before changing direction
      if (
        confirm(
          "The avatar is near the right edge. Would you like to move it to the left side?",
        )
      ) {
        myDiv.style.flexDirection = "row-reverse";
        rightContent.style.marginLeft = "0";
        rightContent.style.marginRight = "8px";
      }
    } else if (rect.left + 400 > window.innerWidth && rect.left - 400 > 0) {
      // Normal automatic positioning when not near edge
      myDiv.style.flexDirection = "row-reverse";
      rightContent.style.marginLeft = "0";
      rightContent.style.marginRight = "8px";
      window.avatarOnRight = true;
    } else {
      // Default positioning
      myDiv.style.flexDirection = "row";
      rightContent.style.marginRight = "0";
      rightContent.style.marginLeft = "8px";
      window.avatarOnRight = false;
    }
    console.log("Avatar position:", window.avatarOnRight ? "RIGHT" : "LEFT");

    //console.log(`Direction updated: ${myDiv.style.flexDirection}`);
    //console.log(`Avatar position: left=${rect.left}px, right=${rect.right}px`);
    //console.log(`Window width: ${window.innerWidth}px`);
  }
  // Toggle info
  // Toggle info
  //let originalPosition = { left: 0, top: 0 };

  function toggleInfo() {
    // If avatar is on right AND we're trying to hide
    if (window.avatarOnRight && !isHidden) {
      alert("DANGER ON RIGHT - NOT ALLOWED TO HIDE");
      if (rightContent.style.visibility === "hidden") {
        rightContent.style.visibility = "visible";
        //isHidden = false;
      } else {
        rightContent.style.visibility = "visible";
        //  rightContent.style.visibility = "hidden";
        //isHidden = true;
      }
      return; // Block hiding attempt
    }
    rightContent.style.visibility = "visible";
    // Otherwise proceed with toggle (either showing or allowed hide)
    rightContent.classList.toggle("hidden");
    // isHidden = true;
    //window.avataronright = true;
    myDiv.classList.toggle(
      "shrinked",
      rightContent.classList.contains("hidden"),
    );
    const nowHidden = rightContent.classList.contains("hidden");
    localStorage.setItem("avt_rightContent_hidden", nowHidden ? "1" : "0");

    console.log(
      "Toggled. Now:",
      rightContent.classList.contains("hidden") ? "Hidden" : "Visible",
      "| Avatar on:",
      window.avatarOnRight ? "Right" : "Left",
    );
  }

  avatar.addEventListener("dblclick", toggleInfo);
  hideBtn.addEventListener("click", toggleInfo);

  // Reset position
  resetBtn.addEventListener("click", () => {
    localStorage.removeItem("myDivX");
    localStorage.removeItem("myDivY");
    myDiv.style.left = "20px";
    myDiv.style.top = window.innerHeight - 80 + "px";
    updateDirection();
  });

  // Panel toggle
  toggleBtn.addEventListener("click", () => {
    if (panelEl.classList.contains("show")) {
      panelEl.classList.remove("show", "slide-up", "slide-down");
      setTimeout(() => (panelEl.style.display = "none"), 50);
    } else {
      positionPanel();
      panelEl.classList.add("show");
    }
  });

  // Close panel
  closeBtn.addEventListener("click", () => {
    panelEl.classList.remove("show", "slide-up", "slide-down");
    setTimeout(() => (panelEl.style.display = "none"), 200);
  });

  // Language toggle
  window.lang = localStorage.getItem("lang") || "en";
  updateLangButton();
  langBtn.addEventListener("click", () => {
    window.lang = window.lang === "en" ? "th" : "en";
    localStorage.setItem("lang", window.lang);
    updateLangButton();
  });
  function updateLangButton() {
    langBtn.textContent = window.lang === "en" ? "E" : "T";
    if (window.lang === "en") {
      langBtn.textContent = "E";
      langBtn.style.backgroundColor = "#4CAF50"; // green
    } else {
      langBtn.textContent = "T";
      langBtn.style.backgroundColor = "#2196F3"; // blue
    }
  }

  function updateDirection() {
    const rect = myDiv.getBoundingClientRect();
    if (rect.left + 400 > window.innerWidth && rect.left - 400 > 0) {
      myDiv.style.flexDirection = "row-reverse";
      rightContent.style.marginLeft = "0";
      rightContent.style.marginRight = "8px";
    } else {
      myDiv.style.flexDirection = "row";
      rightContent.style.marginRight = "0";
      rightContent.style.marginLeft = "8px";
    }
  }
  function clampToViewport(x, y, div) {
    const w = div.offsetWidth;
    const h = div.offsetHeight;
    const maxX = window.innerWidth - (w + 5);
    const maxY = window.innerHeight - (h + 5);
    return {
      x: Math.max(0, Math.min(x, maxX)),
      y: Math.max(0, Math.min(y, maxY)),
    };
  }
  function positionPanel() {
    const rect = myDiv.getBoundingClientRect();
    const panelWidth = 200;
    const panelHeight = 200;
    const margin = 10;
    let top =
      rect.bottom + panelHeight + margin > window.innerHeight
        ? rect.top - panelHeight - margin - 20
        : rect.bottom + margin;
    panelEl.classList.toggle("slide-down", top > rect.top);
    panelEl.classList.toggle("slide-up", top <= rect.top);

    const left =
      rect.left > window.innerWidth / 2
        ? rect.left + 60
        : rect.right - (margin + panelWidth) - 60;

    panelEl.style.left = `${left}px`;
    panelEl.style.top = `${top}px`;
    panelEl.style.display = "block";
    requestAnimationFrame(() => panelEl.classList.add("show"));
  }
  function updateDirection() {
    const rect = myDiv.getBoundingClientRect();
    const isCurrentlyOnRight = myDiv.style.flexDirection !== "row-reverse";

    console.group("Avatar Position Check");
    console.log(
      "Current layout:",
      isCurrentlyOnRight
        ? "Avatar on LEFT of content"
        : "Avatar on RIGHT of content",
    );
    console.log("Avatar position - Left:", rect.left, "Right:", rect.right);
    console.log("Window width:", window.innerWidth);

    if (rect.left + 400 > window.innerWidth && rect.left - 400 > 0) {
      console.log("Condition: Switching to avatar on RIGHT (row-reverse)");
      myDiv.style.flexDirection = "row-reverse";
      rightContent.style.marginLeft = "0";
      rightContent.style.marginRight = "8px";
      window.avatarOnRight = true;
    } else {
      console.log("Condition: Default layout - avatar on LEFT");
      myDiv.style.flexDirection = "row";
      rightContent.style.marginRight = "0";
      rightContent.style.marginLeft = "8px";
      window.avatarOnRight = false;
    }

    console.log(
      "New layout:",
      myDiv.style.flexDirection === "row-reverse"
        ? window.avataronright
        : "Avatar on LEFT of content",
    );
    console.groupEnd();
  }
  // Load position and visibility state
  // Load initial state
  function loadInitialState() {
    const savedHiddenState =
      localStorage.getItem("avt_rightContent_hidden") === "1";
    const savedX = localStorage.getItem("myDivX");
    const savedY = localStorage.getItem("myDivY");
    const rightContentWidth = 200; // Should match your CSS width

    // Apply hidden state first
    if (savedHiddenState) {
      rightContent.classList.add("hidden");
      myDiv.classList.add("shrinked");
    }

    // Then set position with adjustment if hidden
    if (savedX !== null && savedY !== null) {
      let adjustedX = parseInt(savedX);

      // If content was hidden when saved, adjust position
      if (savedHiddenState) {
        if (window.avatarOnRight) {
          adjustedX += rightContentWidth;
        } else {
          adjustedX -= rightContentWidth;
        }
      }

      myDiv.style.left = adjustedX + "px";
      myDiv.style.top = savedY + "px";
    } else {
      // Default position
      myDiv.style.left = "20px";
      myDiv.style.top = window.innerHeight - 80 + "px";
    }

    updateDirection();
  }
  //updateDirection();
  function loadPosition() {
    const savedX = localStorage.getItem("myDivX");
    const savedY = localStorage.getItem("myDivY");
    const avatarWidth = isHidden ? 60 : 260; // 60 for avatar only, 260 including rightContent

    const defaultX = 20;
    const defaultY = window.innerHeight - 80;

    // Check if saved position would be off-screen
    if (savedX !== null && savedY !== null) {
      const parsedX = parseInt(savedX);
      const parsedY = parseInt(savedY);
      const avatarWidth = myDiv.offsetWidth;
      const avatarHeight = myDiv.offsetHeight;

      // Check if position is outside visible area
      const isOffScreen =
        parsedX + avatarWidth < 0 || // Left edge
        parsedX > window.innerWidth || // Right edge
        parsedY + avatarHeight < 0 || // Top edge
        parsedY > window.innerHeight; // Bottom edge

      if (isOffScreen) {
        console.log("Saved position is off-screen, resetting to default");
        localStorage.removeItem("myDivX");
        localStorage.removeItem("myDivY");
        myDiv.style.left = `${defaultX}px`;
        myDiv.style.top = `${defaultY}px`;
      } else {
        myDiv.style.left = `${parsedX}px`;
        myDiv.style.top = `${parsedY}px`;
      }
    } else {
      myDiv.style.left = `${defaultX}px`;
      myDiv.style.top = `${defaultY}px`;
    }

    // Update direction after positioning
    updateDirection();
  }

  // Replace the original position loading code with:
  window.avatarOnRight = false;
  isHidden = false;
  // Load hidden state
  const hiddenState = localStorage.getItem("avt_rightContent_hidden");
  if (hiddenState === "1") {
    //loadPosition();
    //rightContent.style.visibility = "visible";
    //myDiv.classList.add("shrinked");
    isHidden = true;
  } else {
    //loadPosition();
    //rightContent.style.visibility = "hidden";
    // myDiv.classList.remove("shrinked");
    isHidden = false;
  }
  // loadInitialState();

  // loadPosition();
})();