function PanelTR() {
  const id = "myPanelTR";
  const existing = document.getElementById(id);
  
    createPanel(id, "TR", "rtl", 520, window.innerHeight-50, {
      title: "JumperHelperSumman",
      noFooter: true,
      noDrag :false,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
      <p><div id="jumperhelper"></div></p>
      
    </div>
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
     <div id="summan"></div>
    </div>
  </div>
  
  </div>`,
    });
    // Refresh all forms in the stack
// Optional: Refresh summary panels if they exist   

  
}
function profilepaN(id) {
        loadPanelDataNoCOmpress(id, "profile", "pro", "cup");
        setContent("profile", "header", "Profile"); // Add this line
    }
    //form gen
function genpaN(id) {
        loadPanelDataNoCOmpress(id, "gen", "gform", "bucket");
        setContent("gen", "header", "Assessment"); // Add this line

}
     // Unified panel creator
function createPanelWrapper(panelId, formId) {
        // Track the current form globally

        // Add to stack if not already present
        if (!formStack.includes(panelId)) {
            formStack.push(panelId);
        }

        const content = `<div id="${formId}">Wait...</div>`;
        if (formId === "gform") {
            fsize = 630;
            rdir = "ttb";
        } else {
            fsize = 540;
            rdir = "btt";
        }
        const commonFooterButtons = [
            {
                label: "☁️ Save Online💥",
                align: "center",

                onclick: (id) => saveToServerM(userid),
            },
            {
                label: "🌐 Load 💥",
                align: "center",

                onclick: (id) => genpaN(userid),
            },
            {
                label: "Close 💥",
                className: "task-btn",
                align: "center",
                onclick: (id, label) => {
                    closePanel(id);
                },
            },
        ];
        createPanel(panelId, "TC", rdir, fsize, window.innerHeight - 20, {
            noHeader: false,
            headerTitle: "form",
            bodyContent: content,
            bodyCloseButton: false,
            footerButtons: commonFooterButtons,
            footerTitle: "",
            noDrag: false,
            resizeAble: true,
            overflow: true,     
            radius: "8px",       
            footerCloseBtn: false,
        });

        setTimeout(() => {            moveXY(panelId, 160, 5);        }, 10);
       
        addFooterButton(panelId, "△", {
            className: "task-btn",
            align: "left",
            title: "△ Scroll to Top",   // 👈 tooltip
            onclick: (id, label) => {
           scrollToTop(formId);
            },
        });
        addFooterButton(panelId, "▽", {
            className: "task-btn",
            align: "left",
            title: "▽ Scroll to Bottom",   // 👈 tooltip
            onclick: (id, label) => {
                
                  scrollToBottom(formId);
            },
        });        
        
        addFooterButton(panelId, "↕", {
  className: "task-btn",
  align: "left",
  title: "「」 Toggle Sections",   // 👈 tooltip
  onclick: () => {
    toggleSections(formId);
  },
});
addFooterButton(panelId, "⛶", {
  className: "task-btn",
  align: "left",
  title: "⛶ Toggle Sections Only",   // 👈 tooltip
  onclick: () => toggleSectionsOnly(formId),
});

         addFooterButton(panelId, "📌", {
            className: "task-btn",
            align: "left",
              title: "📌 Pin or BookMark possition",   // 👈 tooltip
            onclick: (id, label) => {
                
                saveScrollPosition(panelId);
            },
        });
        addFooterButton(panelId, "☆", {
            className: "task-btn",
            align: "left",
             title: "☆ Jumpto last 📌 Pin or BookMark possition",   // 👈 tooltip
            onclick: (id, label) => {
                
                restoreScrollPosition(panelId);
            },
        });
        addFooterButton(panelId, "💾 Local", {
            className: "task-btn",
            align: "left",
            title: "💾 Save to Local Storage -Offline",   // 👈 tooltip
            onclick: (id, label) => {
                saveToLocalStorage(userid);
            },
        });
        addFooterButton(panelId, "📁 Local", {
            className: "task-btn",
            align: "left",
            title: "📁 Load from Local Storage -Offline",   // 👈 tooltip
            onclick: (id, label) => {
                if (loadFromLocalStorage(userid)) {
                    // Refresh forms if they exist
                    if (document.getElementById("gform"))
                        genform("gform", bucket);
                    if (document.getElementById("pro")) genform("pro", cup);
                    //updateGrandSummary("summan", true, true);
                }
            },
        });
        addFooterButton(panelId, "🔒", {
  className: "task-btn",
  align: "left",
  title: "Lock or unlock dragging",
  onclick: () => {
    togglePanelDrag(panelId);
  },
});
         addFooterButton(panelId, "❌", {
            className: "task-btn",
            align: "left",
            onclick: (id, label) => {
                
                  closePanel(panelId);
            },
        });
        //if (formId === "gform") genform(formId, bucket);        else if (formId === "pro") genform(formId, cup);
         // Add scroll position restoration after generating the form
    if (formId === "gform") {
        genform(formId, bucket);
        restoreScrollPosition(formId);
    } 
    else if (formId === "pro") {
        genform(formId, cup);
        restoreScrollPosition(formId);
    }
    }
  
function QSummary(data) {
    // Add score initialization
  Object.values(data).forEach(item => {
    if (item.type === "field") {
      item.score = item.score || 1; // Same default as genform
    }
  });
  // Create a default empty result structure
  const defaultResult = { 
    segments: [], 
    summary: { 
      segments: {}, 
      totals: {
        allFields: 0,
        requiredFields: 0,
        answeredFields: 0,
        answeredRequiredFields: 0,
        totalScore: 0,
        totalScoreWeighted: 0,
        maxPossibleScore: 0,
        maxPossibleScoreWeighted: 0,
        totalFiles: 0,
        unansweredRequiredFields: []
      }
    } 
  };
if (!data || typeof data !== 'object') {
    console.warn("Invalid data format: data is missing or not an object");
    return { segments: [], summary: { segments: {}, totals: {} } };
  }
// Handle profile-style grouping (where grouping is an object with arrays)
  if (data.grouping && typeof data.grouping === 'object' && !Array.isArray(data.grouping)) {
    // Normalize profile grouping structure to match gen structure
    const grouping = {
      name: Array.isArray(data.grouping.name) ? data.grouping.name : [data.grouping.name || "default"],
      type: Array.isArray(data.grouping.type) ? data.grouping.type : [data.grouping.type || "segment"],
      label: {
        en: Array.isArray(data.grouping.label?.en) ? data.grouping.label.en : [data.grouping.label?.en || "Default"],
        th: Array.isArray(data.grouping.label?.th) ? data.grouping.label.th : [data.grouping.label?.th || "ค่าเริ่มต้น"]
      }
    };
    data.grouping = grouping;
  }
  // If no grouping exists at all, create a default one
  else if (!data.grouping) {
    data.grouping = {
      name: ["default"],
      type: ["segment"],
      label: { 
        en: ["Default"], 
        th: ["ค่าเริ่มต้น"] 
      }
    };
  }
  // Initialize with default grouping if missing
  if (!data.grouping) {
    data.grouping = {
      name: ["default"],
      type: ["segment"],
      label: { en: ["Default"], th: ["ค่าเริ่มต้น"] }
    };
  }

  const result = { segments: [] };
  const summary = {
    segments: {},
    totals: {
      allFields: 0,
      requiredFields: 0,
      answeredFields: 0,
      answeredRequiredFields: 0,
      totalScore: 0,
      totalScoreWeighted: 0,
      maxPossibleScore: 0,
      maxPossibleScoreWeighted: 0,
      totalFiles: 0,
      unansweredRequiredFields: [],
    },
  };

  const segmentMap = {};

  Object.entries(data).forEach(([key, item]) => {
    if (key === "grouping" || item.type === "section") return;

    const segment = item.segment?.[0] || data.grouping?.name[0] || "default";
    const section = item.section;
    if (!segment || !section || !data[section]) {
      console.warn(
        `Invalid field ${key}: missing segment or section, or section not found in schema`,
      );
      return;
    }

    // Initialize segment/section if not exists
    if (!summary.segments[segment]) {
      const segmentIndex = data.grouping.name.indexOf(segment);
      summary.segments[segment] = {
        label: data.grouping.label?.en[segmentIndex] || segment,
        sections: {},
        totals: {
          allFields: 0,
          requiredFields: 0,
          answeredFields: 0,
          answeredRequiredFields: 0,
          totalScore: 0,
          totalScoreWeighted: 0,
          maxPossibleScore: 0,
          maxPossibleScoreWeighted: 0,
          totalFiles: 0,
          unansweredRequiredFields: [],
        },
      };
    }
    if (!summary.segments[segment].sections[section]) {
      summary.segments[segment].sections[section] = {
        label: data[section]?.label?.en || section,
        totals: {
          allFields: 0,
          requiredFields: 0,
          answeredFields: 0,
          answeredRequiredFields: 0,
          totalScore: 0,
          totalScoreWeighted: 0,
          maxPossibleScore: 0,
          maxPossibleScoreWeighted: 0,
          totalFiles: 0,
          unansweredRequiredFields: [],
        },
      };
    }

    const currentScore = calculateCurrentScore(item);
    const maxScore = calculateMaxScore(item);
    const isAnswered = isFieldAnswered(item);

    // Handle file counting for all field types
    let fileCount = 0;
    if (item.data_type === "attachment") {
      fileCount = countFiles(item);
    } else if (item.data_type === "radiotextatt") {
      // Create a temporary field object just for counting
      fileCount = countFiles({
        value: item.value?.att || "",
        data_type: "attachment",
      });
    } else if (item.data_type === "radiotextatt" && item.value?.att) {
      fileCount = countFiles({
        value: item.value.att,
        data_type: "attachment",
      });
    } else if (item.data_type === "radioatt" && item.value?.att) {
      // Added for radioatt
      fileCount = countFiles({
        value: item.value.att,
        data_type: "attachment",
      });
    }

    // Update totals at all levels
    const sectionTotals = summary.segments[segment].sections[section].totals;
    const segmentTotals = summary.segments[segment].totals;
    const globalTotals = summary.totals;

    // Section level
    sectionTotals.allFields++;
    if (item.required) sectionTotals.requiredFields++;
    if (isAnswered) sectionTotals.answeredFields++;
    if (item.required && isAnswered) sectionTotals.answeredRequiredFields++;
    sectionTotals.totalScore += isAnswered ? item.score || 1 : 0;
    sectionTotals.totalScoreWeighted += currentScore;
    sectionTotals.maxPossibleScore += item.score || 1;
    sectionTotals.maxPossibleScoreWeighted += maxScore;
    sectionTotals.totalFiles += fileCount;

    // Segment level (aggregate from sections)
    segmentTotals.allFields++;
    if (item.required) segmentTotals.requiredFields++;
    if (isAnswered) segmentTotals.answeredFields++;
    if (item.required && isAnswered) segmentTotals.answeredRequiredFields++;
    segmentTotals.totalScore += isAnswered ? item.score || 1 : 0;
    segmentTotals.totalScoreWeighted += currentScore;
    segmentTotals.maxPossibleScore += item.score || 1;
    segmentTotals.maxPossibleScoreWeighted += maxScore;
    segmentTotals.totalFiles += fileCount;

    // Global level (aggregate from segments)
    globalTotals.allFields++;
    if (item.required) globalTotals.requiredFields++;
    if (isAnswered) globalTotals.answeredFields++;
    if (item.required && isAnswered) globalTotals.answeredRequiredFields++;
    globalTotals.totalScore += isAnswered ? item.score || 1 : 0;
    globalTotals.totalScoreWeighted += currentScore;
    globalTotals.maxPossibleScore += item.score || 1;
    globalTotals.maxPossibleScoreWeighted += maxScore;
    globalTotals.totalFiles += fileCount;

    // Track unanswered required fields at all levels
    if (item.required && !isAnswered) {
      const fieldInfo = {
        key,
        label: getLabel(item, window.lang || "en") || key,
        segment,
        section,
      };

      sectionTotals.unansweredRequiredFields.push(fieldInfo);
      segmentTotals.unansweredRequiredFields.push(fieldInfo);
      globalTotals.unansweredRequiredFields.push(fieldInfo);
    }
  });

  // Build the result.segments structure (if needed for other purposes)
  Object.entries(summary.segments).forEach(([segmentKey, segment]) => {
    const segmentEntry = {
      name: segmentKey,
      label: segment.label,
      sections: [],
    };

    Object.entries(segment.sections).forEach(([sectionKey, section]) => {
      segmentEntry.sections.push({
        name: sectionKey,
        label: section.label,
        totals: section.totals,
      });
    });

    result.segments.push(segmentEntry);
  });

  return { result, summary };
}
function normalizeGroupingData(data) {
        if (!data) return null;

        // Case 1: New structure (data_type: "grouping" at root)
        if (data.data_type === "grouping") {
            return {
                name: data.name || [],
                label: data.label || { en: [], th: [] },
                type: data.type || [],
            };
        }
        // Case 2: Old structure (nested under "grouping" key)
        else if (data.grouping) {
            return {
                name: data.grouping.name || [],
                label: data.grouping.label || { en: [], th: [] },
                type: data.grouping.type || [],
            };
        }
        // Case 3: No recognized grouping structure
        return null;
    }
function safeParseJSON(str) {
        try {
            return JSON.parse(str || "{}");
        } catch (e) {
            console.error("JSON parse error:", e);
            return {};
        }
    }
async function loadDataOnly(id) {
        // Show loading started toast
        toast(
            "⏳ Loading data...",
            { pos: "BR", slide: "btt" },
            { background: "#2196F3" },
            1500,
        );

        if (!navigator.onLine) {
            const message = "⚠️ Offline — using cached data if available";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data`);
                toast(
                    "✅ Using cached data",
                    { pos: "TR", slide: "btt" },
                    { background: "#4CAF50" },
                    500,
                );
                return cached.data;
            }
            return null;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return null;
        }

        const url = `https://v.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading data`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                "🔍 Fetching data...",
                { pos: "BR", slide: "btt" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ Not modified, using cached data`);
                if (cached && cached.data) {
                    const loadTime = Date.now() - startTime;
                    console.log(`✅ Load completed in ${loadTime}ms`);
                    toast(
                        `✅ Loaded from cache (${loadTime}ms)`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return cached.data;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                "📦 Processing data...",
                { pos: "BR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = "⚠️ No 'data' field in response";
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return null;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }

            const loadTime = Date.now() - startTime;
            console.log(`✅ Load completed in ${loadTime}ms`);
            toast(
                `✅ Load successful (${loadTime}ms)`,
                { pos: "BR", slide: "btt" },
                { background: "#4CAF50" },
                1500,
            );
            return data;
        } catch (e) {
            console.error("❌ Load failed:", e.message);
            toast(
                `❌ Load failed: ${e.message}`,
                { pos: "BC", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
            return null;
        }
    }
async function loadAndUpdateSummaries(id) {
        try {
            // Show loading indicator
            toast(
                "⏳ Loading summaries...",
                { pos: "BR", slide: "btt" },
                { background: "blue" },
            );

            const data = await loadDataOnly(id);
            if (!data) {
                toast(
                    "⚠️ No data received",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Parse and store into memory
            bucket = safeParseJSON(data.bucket) || {};
            cup = safeParseJSON(data.cup) || {};
            board = safeParseJSON(data.board) || {};
            // Normalize grouping data (works with both structures)
            const normalizedGrouping = normalizeGroupingData(bucket);
            if (normalizedGrouping) {
                // For backward compatibility, ensure bucket has grouping in expected format
                if (!bucket.grouping && !bucket.data_type) {
                    bucket.grouping = normalizedGrouping;
                }
            }
            // Verify data was loaded
            if (
                Object.keys(bucket).length === 0 &&
                Object.keys(cup).length === 0 &&
                Object.keys(board).length === 0
            ) {
                toast(
                    "⚠️ Empty data loaded",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Check for cup data and warn if missing
            if (!cup || Object.keys(cup).length === 0) {
                toast(
                    "⚠️ No Cup data found",
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                );
            }

 bucketStats = getFieldStats(bucket);
    cupStats = getFieldStats(cup);
    
    /* inside loadAndUpdateSummaries, after bucketStats / cupStats are set */
const b = (QSummary(bucket)?.summary?.totals) ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };
const c = (QSummary(cup)?.summary?.totals)    ?? { totalScoreWeighted:0, maxPossibleScoreWeighted:0 };

Object.assign(window.board, {
  overallScore: {
    achieved : b.totalScoreWeighted + c.totalScoreWeighted,
    max      : b.maxPossibleScoreWeighted + c.maxPossibleScoreWeighted,
    percent  : (b.maxPossibleScoreWeighted + c.maxPossibleScoreWeighted)
                 ? ((b.totalScoreWeighted + c.totalScoreWeighted) / (b.maxPossibleScoreWeighted + c.maxPossibleScoreWeighted) * 100).toFixed(1)
                 : 0
  },
  assessment: {
    achieved : b.totalScoreWeighted,
    max      : b.maxPossibleScoreWeighted,
    percent  : b.maxPossibleScoreWeighted ? (b.totalScoreWeighted / b.maxPossibleScoreWeighted * 100).toFixed(1) : 0
  },
  profile: {
    achieved : c.totalScoreWeighted,
    max      : c.maxPossibleScoreWeighted,
    percent  : c.maxPossibleScoreWeighted ? (c.totalScoreWeighted / c.maxPossibleScoreWeighted * 100).toFixed(1) : 0
  }
});

    cp="";

    window.bucket_answeredRequired=bucketStats.answeredRequired;
    window.bucket_totalRequired=bucketStats.totalRequired;
    window.cup_answeredRequired=cupStats.answeredRequired;
    window.cup_totalRequired=cupStats.totalRequired;
if (window.bucket_totalRequired-window.bucket_answeredRequired>0) {
    let cp=Math.round((window.bucket_answeredRequired/ window.bucket_totalRequired) * 100);
    updateBadge("assessment",window.bucket_totalRequired-window.bucket_answeredRequired,"red");
    updateStatus("assessment",`${cp}% (${window.bucket_answeredRequired}/${window.bucket_totalRequired})`);
let aap=window.bucket_answeredRequired+window.bucket_totalRequired;
let asp=window.bucket_answeredRequired+window.cup_answeredRequired;
let paap=Math.round(asp/aap)*100;
//updateBadge("A1",`Progress (${asp}/${aap}) ${paap}%`,"red");
//updateStatus("A1",`(${asp}/${aap}) ${paap}%`);
} else   {
        updateBadge("assessment",0,"red");
        updateStatus("assessment",`${cp}% (${window.bucket_answeredRequired}/${window.bucket_totalRequired}) `);
}
if (window.cup_totalRequired-window.cup_answeredRequired>0) {
   let cp=Math.round((window.cup_answeredRequired/ window.cup_totalRequired) * 100);
     updateBadge("Profile",window.cup_totalRequired-window.cup_answeredRequired,"red");
     updateStatus("Profile",`${cp}% (${window.cup_answeredRequired}/${window.cup_totalRequired}) `);
    } else  { 
      updateBadge("Profile",0,"red");
      updateStatus("Profile",`100% (${window.cup_totalRequired}) `);
    }

            // Update summary UIs
            updateGrandSummary("summan", true, true);
//console.log("totals.answeredRequiredFields,totals.requiredFields"+totals.answeredRequiredFields+":"+totals.requiredFields);
            // Also update other summary panels if they exist
            if (document.getElementById("requirementProgress")) {
                const totals = QSummary(bucket).summary.totals;
                updateRequirementProgress(
                    totals.answeredRequiredFields,
                    totals.requiredFields,
                );
            }

            if (document.getElementById("requirementChecklist")) {
                updateRequirementChecklist([
                    { data: bucket, name: "Bucket" },
                    { data: cup, name: "Cup" },
                ]);
            }

            toast(
                "✅ Summaries updated",
                { pos: "BR", slide: "btt" },
                { background: "green" },
            );
        } catch (e) {
            console.error("❌ Failed to load summaries:", e);
            toast(
                "❌ Failed to load summaries",
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
        }
    }
function updateGrandSummary(targetDivPrefix,hoverMode = false,showOnlyBucketCup = false) {
        // Initialize containers array
          


        let containers = [
            { data: bucket, name: "Bucket" },
            { data: cup, name: "Cup" },
            { data: board, name: "Board" },
        ].filter((container) => container.data); // Only include if data exists
        BucketName = "Assessment";
        CupName = "Profile";
        // Show warning if specifically requesting Bucket & Cup but cup is missing
        if (showOnlyBucketCup && (!cup || !Object.keys(cup).length)) {
            toast(
                "⚠️ Cup data not available",
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
            );
        }

        // Filter to only show Bucket and Cup if requested
        if (showOnlyBucketCup) {
            containers = containers.filter(
                (container) =>
                    container.name === "Bucket" || container.name === "Cup",
            );
        }

        const grandDivId = `${targetDivPrefix}-grand`;
        const panelExists = document.getElementById(grandDivId);

        // Calculate grand totals and container statuses
        let grandTotals = {
            allFields: 0,
            requiredFields: 0,
            answeredFields: 0,
            answeredRequiredFields: 0,
            totalFiles: 0, // Initialize file count          
        };

        let allReady = true;
        let allInactive = true;
        const containerStatuses = [];
            assessment_prog="";
            profile_prog="";
            all_prog="";
            status_prog="";
            assessment_dot="";
            profile_dor="";
            all_dot="";
            status_dot="";

        containers.forEach((container, index) => {
            const summary = QSummary(container.data).summary.totals;
            let requiredPercent =
                summary.requiredFields > 0
                    ? Math.round(
                          (summary.answeredRequiredFields /
                              summary.requiredFields) *
                              100,
                      )
                    : 0;

            // Aggregate all counts including files
            grandTotals.allFields += summary.allFields || 0;
            grandTotals.requiredFields += summary.requiredFields || 0;
            grandTotals.answeredFields += summary.answeredFields || 0;
            grandTotals.answeredRequiredFields +=
                summary.answeredRequiredFields || 0;
            grandTotals.totalFiles += summary.totalFiles || 0; // Add file count

            // Determine container status
            let status, statusClass;
            if (summary.requiredFields === 0) {
                status = "No Required Fields";
                statusClass = "status-neutral";
            } else if (
                summary.answeredRequiredFields >= summary.requiredFields
            ) {
                status = "READY ✓";
                statusClass = "status-ready";
                allInactive = false;
                window.allReady= true;
                status_dot="greenDot";
            } else if (summary.answeredRequiredFields > 0) {
                status = "IN PROGRESS 🟡";
                statusClass = "status-progress";
                allReady = false;
                window.allReady= false;
                allInactive = false;
                status_dot="yellowDot";                
            } else {
                status = "INACTIVE ⛔";
                statusClass = "status-inactive";
                allReady = false;
                window.allReady= false;
                status_dot="redDot";
            }

            containerStatuses.push({
                name: container.name,
                status: status,
                statusClass: statusClass,
                requiredPercent: requiredPercent,
                stats: summary,
                totalFiles: summary.totalFiles || 0, // Add file count per container
            });
        });

        // Determine submit status status-ready
        let submitStatus, submitStatusClass;
        let isReadyToSubmit = false; // Add this flag

        if (containers.length === 0) {
            submitStatus = "NO DATA";
            submitStatusClass = "status-neutral";
        } else if (allReady) {
            submitStatus = " ✅ READY FOR SUBMIT";
            submitStatusClass = "status-ready-submit";
            isReadyToSubmit = true; // Set flag when ready
            window.allReady= true;
            status_dot="greenDot";
            progress_prog=submitStatus;
        } else if (allInactive) {
            submitStatus = "INACTIVE ⛔";
            submitStatusClass = "status-inactive";
            status_dot="redDot";
            window.allReady= false;
            progress_prog=submitStatus;
        } else {
            submitStatus = "IN PROGRESS 🟡";
            submitStatusClass = "status-progress";
            status_dot="yellowDot";
            window.allReady= false;
            progress_prog=submitStatus;
        }

        // Show alert if ready to submit
        if (isReadyToSubmit) {
            // Only alert if this is a new ready state (not already ready)
            if (!window.wasReadyToSubmit) {
             now = new Date();
             expiredDate = new Date(window.dateExpired);
             timeLeft = expiredDate - now;
             isExpired = timeLeft <= 0;
             if (isExpired) {
                if (allReady) {
                  submitStatus = " ⛔ TIME EXPIRED";                    
                }
                 alert("⛔ Not Allowed to SUBMIT ,All requirements are completed but TIME EXPIRED");
              } else 
              {
              //cfb=document.querySelector(".confirm_btn");
              //cfb.style.display="block";
                alert("✓ Ready for SUBMIT! All requirements are completed.");
                // Optional: Play a sound
              }
            }
        }
        window.wasReadyToSubmit = isReadyToSubmit; // Remember state

        // Calculate grand percentages
        const grandRequiredPercent =
            grandTotals.requiredFields > 0
                ? Math.round(
                      (grandTotals.answeredRequiredFields /
                          grandTotals.requiredFields) *
                          100,
                  )
                : 0;

        // Build HTML content
        let html = `
    <style>
    .status-ready-submit     { color: #079a11ff; font-weight: bold; }
    .status-ready { color: #3b5a3dff; font-weight: bold; }
        .status-progress { color: #e7ae03ff; font-weight: bold; }
        .status-inactive { color: #F44336; font-weight: bold; }
        .status-neutral { color: #9E9E9E; }
        
        .container-card {
            margin: 1px 0;
            padding: 2px 10px;
            background:rgba(250,250,250,.2);
            backdrop-filter: blur(15px);
            box-shadow: 2px 2px 12px rgba(0, 0, 0, 0.1);
            border-radius: 6px;
            border-left: 4px solid #ddd;
            font-size:12px;
            width:85%;
        }
            .container-card strong{
            color:rgba(30, 24, 102, 0.8);
            font-size:13px;
            }
        .toggle-btn {
            padding: 5px 10px;
            background: #f0f0f0;
            border: 1px solid #ddd;
            border-radius: 4px;
            cursor: pointer;
            margin: 5px 0;
            font-size: 12px;
        }
        .toggle-btn:hover {
            background: #e0e0e0;
        }
        .file-count {
            margin-top: 1px;
            font-size: 0.9em;
            color: #666;
        }
        


#checklist {
  --item-bg: rgba(250,250,250,.7);


  --item-text-color: rgba(47, 47, 47, 1);
  --item-padding: 1px 16px;
  --item-gap: 2px;
  --item-radius: 8px;
  --item-border: 0px solid rgba(200,200,200,.01);
      border-radius: 12px; 
      background:rgba(200,200,200,.5);
      width:85%;
}

/* Individual item styling */
.itemsDisplay {
  display: flex;
  align-items: center;
  gap: var(--item-gap);
  background: var(--item-bg);
  color: var(--item-text-color);
  padding: var(--item-padding);
  border-radius: var(--item-radius);
  border: var(--item-border);
  margin-bottom: 6px;
  
}

/* Status dot styling */
.itemsStatusDot {
  width: 16px;
  height: 16px;
  border-radius: 50%;
  flex-shrink: 0;
  margin-right:10px;
}

/* Text area styling */
.itemsText {
  flex-grow: 1;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  font-size:13px;
}

/* Color variants */
.greyDot { background: #95a5a6; }
.greenDot { background: #03ce58ff; }
.redDot { background: #e74c3c; }
.yellowDot { background: #facc00ff; }
.blueDot { background: #3498db; }
.purpleDot { background: #9b59b6; }


.progress-container {
  font-family: Arial, sans-serif;
  font-size:12px;
  border: 0px solid #e0e0e0;
  border-radius: 8px;
  //background-color: #f9f9f9;
  //box-shadow: 1 2px 4px rgba(0,0,0,0.1);
}

.progress-container {
  font-family: sans-serif;
  width: 85%;
  margin-top:10px;
  padding: 2px 10px;
  border: 0px solid rgba(0,0,0,0.7);
  border-radius: 8px;
  background-color: rgba(255,255,255,.5);
  display: grid;
  grid-template-rows: auto auto;
  gap: 2px;
   box-shadow: 0 2px 4px rgba(0,0,0,0.1);
   
  backdrop-filter: blur(45px);
}

/* First row - status and stats */
.status-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.status-progress {
  font-size: bold;
  background-color: rgba(1,1,1,.4);
   padding: 2px 10px;
  
  border-radius: 8px;
  backdrop-filter: blur(15px);
}
.progress-container   .status-progress { 
color:rgba(222, 95, 4, 1);
font-size:15px;
  background-color: rgba(1,1,1,.1);
}
/* Second row - progress bar and completion */
.progress-row {
  display: flex;
  flex-direction: column;
  gap: 6px;
}

.progress-barI {
  height: 10px;
  background-color: #e0e0e0;
  border-radius: 10px;
  overflow: hidden;
  margin: 4px 0;
}

.progress-fill {
  height: 100%;
  background-color: #006eaaff;
  transition: width 0.3s ease;

}

.completion-stats {
  display: flex;
  justify-content: space-between;
  font-size: 0.9em;
  color: #666;
}
  #center{
   display: flex; flex-direction: column; align-items: center;
  }
   .confirm_btn {
        padding: 2px 16px !important;  /* Reduced padding */
        margin-left: 4px !important;  /* Reduced gap */
        font-size: 14px !important;
        border-radius: 8px;
        color:white;
    }
    .confirm_btn_red {
    border:1px solid white;
    background:red;
    border-radius: 8px;
    color:white;
    }
   /* Timing section styling */
#timing_sec {
        gap: 6px !important;  /* Reduced from 10px */
        padding: 4px 8px !important;
         background-color: rgba(10,10,10,.1);
         
    }
    
    #timing_left {
        padding-right: 4px !important;
        background-color: rgba(10,10,10,.7);
        border-radius: 12px;
        padding:2px 22px;
        width:200px;
         backdrop-filter: blur(25px);
    }

#timing_right {
  margin-left: 1px;
}

.confirm_btn {
  padding: 1px 8px;
  border: none;
  border-radius: 10px;
  background-color: rgba(30, 136, 229, 0.9);
  
  font-weight: bold;
  cursor: pointer;
  transition: background-color 0.2s;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.confirm_btn:hover {
  background-color: rgba(0, 119, 255, 0.9);
}
  .progress-checklist-wrapper {
  background: rgba(100,200,200,0.01);
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    width: 100%;
    padding:20px 0px;
    border-radius:  16px;
    backdrop-filter: blur(15px);
}
     #cclock {
        display: flex;
        justify-content: space-between;
        font-family: sans-serif;
        font-size: 13px;
        padding: 5px 1px;
        background: rgba(200,200,200,0.1);
        border-radius: 6px;
        margin-bottom: -5px;
    }
    
    .clock-section {
        display: flex;
        align-items: center;
        gap: 6px;
    }
    
    .expired-date {
    font-size:13px;
        color: ${window.dateExpired && new Date() > new Date(window.dateExpired) ? '#d5271bff' : '#000e2dff'};
        font-weight: ${window.dateExpired && new Date() > new Date(window.dateExpired) ? 'bold' : 'normal'};
    }
    .right-align {
        justify-content: flex-end;
    }
    #timing_left {
        padding-right: 4px !important;
    }
    .countdown {
        color: #4CAF50;
    }
    </style>

    <div style="text-align: right;display:none">
        <button class="toggle-btn" onclick="updateGrandSummary('${targetDivPrefix}', ${hoverMode}, ${!showOnlyBucketCup})">
            ${showOnlyBucketCup ? "Show All" : "Show Only ${BucketName} & {CupName}"}
        </button>
    </div>
<div class="progress-checklist-wrapper">    
<div id="checklist" style="padding: 10px; ">
  <div class="itemsDisplay" id="item-start">
    <div class="itemsStatusDot greyDot"></div>
    <div class="itemsText">Start</div>
  </div>
  
  <div class="itemsDisplay" id="item-profile">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Profile</div>
  </div>
  
  <div class="itemsDisplay" id="item-assessment">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Assessment</div>
  </div>
  
  <div class="itemsDisplay" id="item-end">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Progress: 0%</div>
  </div>
  
</div>
 <div class="progress-container">
 <div id="cclock"></div>
 </div> 
    <div class="progress-container">
         <div class="${submitStatusClass}">${submitStatus}</div>
        <div>Required: ${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields} (${grandRequiredPercent}%) ,
        Files: ${grandTotals.totalFiles}</div>
        <div class="progress-barI">
            <div class="progress-fill" style="width: ${grandRequiredPercent}%; background: ${grandRequiredPercent === 100 ? "#4CAF50" : grandRequiredPercent > 0 ? "#d35b06ff" : "#F44336"};"></div>
        </div>
        <div></div>
    </div>   

    
    `;
//updateProgress("A1",grandRequiredPercent);
prog=grandRequiredPercent+"% "+`(${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields}) `;
if (grandTotals.answeredRequiredFields<1) INACTIVE=true; else INACTIVE=false;
all_prog=prog;
updateBadge("A1",0);
updateStatus("A1",prog);
    bucketStats = getFieldStats(bucket);
    cupStats = getFieldStats(cup);
    
    cp="";

    window.bucket_answeredRequired=bucketStats.answeredRequired;
    window.bucket_totalRequired=bucketStats.totalRequired;
    window.cup_answeredRequired=cupStats.answeredRequired;
    window.cup_totalRequired=cupStats.totalRequired;
if (window.bucket_totalRequired-window.bucket_answeredRequired>0) {
    let cp=Math.round((window.bucket_answeredRequired/ window.bucket_totalRequired) * 100);
    window.assessmentPercent=cp;
    updateBadge("assessment",window.bucket_totalRequired-window.bucket_answeredRequired,"red");
    updateStatus("assessment",`${cp}% (${window.bucket_answeredRequired}/${window.bucket_totalRequired})`);
let aap=window.bucket_totalRequired+window.cup_totalRequired;
window.totalRequired=aap;
let asp=window.bucket_answeredRequired+window.cup_answeredRequired;
window.answeredRequired=asp;
let paap=Math.round((asp/aap)*100);
updateBadge("A1",`${aap-asp}`,"red");
updateStatus("A1",`Progress (${asp}/${aap}) ${paap}%`);
updateProgress("A1",paap);
console.log("window.totalRequired"+window.totalRequired);

} else   {
  window.assessmentPercent=100;
        updateBadge("assessment",0,"red");
        updateStatus("assessment",`${cp}% (${window.bucket_answeredRequired}/${window.bucket_totalRequired}) `);
}
if (window.cup_totalRequired-window.cup_answeredRequired>0) {
   let cp=Math.round((window.cup_answeredRequired/ window.cup_totalRequired) * 100);
   window.profilePercent=cp;
     updateBadge("Profile",window.cup_totalRequired-window.cup_answeredRequired,"red");
     updateStatus("Profile",`${cp}% (${window.cup_answeredRequired}/${window.cup_totalRequired}) `);
    } else  { 
      window.profilePercent=100;
      updateBadge("Profile",0,"red");
      updateStatus("Profile",`100% (${window.cup_totalRequired}) `);
    }
        // Add container status cards with file counts
        containerStatuses.forEach((container) => {
            if (container.name==="Bucket") {
                updateProgress("assessment",container.requiredPercent);
                prog=container.requiredPercent +"% "+`(${container.stats.answeredRequiredFields}/${container.stats.requiredFields})`;
                updateStatus("assessment",prog);
                assessment_prog=prog;
                
            }
             if (container.name==="Cup") {
                updateProgress("Profile",container.requiredPercent);
                prog=container.requiredPercent +"% "+`(${container.stats.answeredRequiredFields}/${container.stats.requiredFields})`;
                updateStatus("Profile",prog);
                profile_prog=prog;
            }
            // Map internal names to display names
            const displayName =
                container.name === "Bucket"
                    ? BucketName
                    : container.name === "Cup"
                      ? CupName
                      : container.name; // Keep "Board" as is or map it if needed
            html += `
        <div class="container-card" style="border-left-color: ${container.requiredPercent === 100 ? "#4CAF50" : container.requiredPercent > 0 ? "#0059cdff" : "#F44336"}">
            <div style="display: flex; justify-content: space-between;">
                <strong>${displayName}</strong>
                <span class="${container.statusClass}">${container.status}</span>
            </div>
            <div style="margin-top: 5px;">
                <div>Required: ${container.stats.answeredRequiredFields}/${container.stats.requiredFields} ,Progress: ${container.requiredPercent}%,Files: ${container.totalFiles}</div>
                <div class="progress-barI">
                    <div class="progress-fill" style="width: ${container.requiredPercent}%; background: ${container.requiredPercent === 100 ? "#38783aff" : container.requiredPercent > 0 ? "#3362b8ff" : "#F44336"};"></div>
                </div>
                <div></div>
                <div class="file-counts"></div>
            </div>
        </div>
       
        `;
        });
//bb = `Total Fields: ${aa}/${bb}`;
bb=grandRequiredPercent;
        html += `</div>`;
layoutqold=`<div style="display: flex; height: 100%; overflow: hidden;">
    <div style="flex: 1; overflow: auto; padding: 1px; ">
      <div id="left1">${submitStatus}</div>
      
    </div>
    <div style="flex: 1; box-sizing: border-box; overflow: hidden; padding: 1px; ">
     <div id="right1">`+html+`</div>
     
    </div>
  </div>
   </div>
  </div>`;
  //board assign
/* replace board  
board={
    userid: userid,
    user: user,
    user_name: window.user_name,
    totalRequired:window.totalRequired,
    answeredRequired:window.answeredRequired,
    save:"saved",
    time: new Date().toISOString()    
}
*/
Object.assign(window.board, {
    userid: userid,
    user: user,
    user_name: window.user_name,
    totalRequired: window.totalRequired,
    answeredRequired: window.answeredRequired,
    save: "saved",
    time: new Date().toISOString()
});
butt = "";
bbb=''; 
 now = new Date();
     expiredDate = new Date(window.dateExpired);
     timeLeft = expiredDate - now;
  isExpired = timeLeft <= 0;

//if (butt="") butt="";
butt='<button id="confirm_n_btn" class="confirm_btn_red" >✕ Not Allowed , Need Full Answered </button>';
if (isReadyToSubmit) { 
   // Set default expiration date if not defined
   
  butt = checksubmitbtn(); 
} else {
  


}
if (isExpired) {
  butt='<button id="confirm_btn" class="confirm_btn_red" >✕ Not Allowed </button>';
} else butt='<button id="confirm_btn" class="confirm_btn" onclick=checksubmit(); > '+bbb+' </button>';
    
    // Format dates and times
   

layoutq = `
<div style="display: flex; flex-direction: column; height: 100%; overflow: hidden;">
  <div id="timing_sec" style="display: flex; justify-content: space-between; align-items: center; padding: 8px;  border-radius: 14px; margin-bottom: 8px;">
    <div id="timing_left" style="font-weight: bold; font-size: 14px;" class="${submitStatusClass}">
      ${submitStatus}
    </div>
    <div id="timing_right">
      ${butt}
    </div>
  </div>
  ${html}
</div>`;

// Then continue with your createPanel code...
        // Create or update panel
        if (!panelExists) {
            createPanel(
                grandDivId,
                "CC",
                "ctc",
                420,                
                window.innerHeight - 80,
                {
                    title:
                        "GRAND SUMMARY" +
                        (showOnlyBucketCup
                            ? `(${BucketName} & ${CupName})`
                            : ""),
                    bodyContent: layoutq,
                    bodyCloseButton: false,
                    noFooter: true,
                    noDrag: false,
                    overflow: true,
                    radius: "8px",                    
                },
                
            );
           thedot0= 'redDot';
           thedot1= 'redDot';
           thedot2= 'redDot'; 
           if (window.assessmentPercent<1) thedot0= 'redDot';
           if (window.assessmentPercent>1) thedot0= 'blueDot';
           if (window.assessmentPercent>99) thedot0= 'greenDot';
           // updateStatus('item-profile', 'Profile 50%', 'blueDot');
           updateItemStatus('item-assessment', ' Assessment '+assessment_prog, thedot0);
           
           if (window.profilePercent<1) thedot1= 'redDot';
           if (window.profilePercent>1) thedot1= 'blueDot';
           if (window.profilePercent>99) thedot1= 'greenDot';
           updateItemStatus('item-profile', ' Profile '+profile_prog, thedot1);

 updateItemStatus('item-end', ' Progress '+all_prog, 'blueDot')
 if (INACTIVE) updateItemStatus('item-end', ' Progress '+all_prog, 'redDot')
 if ((window.profilePercent>99) && (window.assessmentPercent>99)) updateItemStatus('item-end', ' Progress '+all_prog, 'greenDot')
 
 now = new Date();
        startTimeText = now.toLocaleTimeString();
          if (window.profilePercent>1) thedot2= 'blueDot';
          if (window.assessmentPercent>99) thedot2= 'blueDot';
          if ((window.assessmentPercent>99) && (window.profilePercent>99) )  thedot2= 'greenDot';
          updateItemStatus('item-start', ' last :'+ startTimeText, thedot2);
 //updateProgress("A1", 10);
  
//  /updateItemStatus('item-progress', 'staus '+progress_prog, status_dot)

//updateChecks(true, true, true, 100);
//updateChecks('assesment', assessment_prog);
//updateChecks('profile', profile_prog);

            //moveXY(grandDivId, 590, 0);
            // ⭕ Initialize circular progress bar
          //  setTimeout(() => {
   // const update = makeCircleProgress("leftone");
    //${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields}
   // update(grandTotals.answeredRequiredFields, grandTotals.requiredFields);
    // }, 50);
            // Position the panel
            const panel = document.getElementById(grandDivId);
            if (panel) {
                panel.style.right = "10px";
                panel.style.top = "20px";
              //  dragDiv(grandDivId);
            }
        } else {
            // Just update the content if panel exists
            const contentDiv = document.querySelector(
                `#${grandDivId} .panel-body`,
            );
            if (contentDiv) {
               // contentDiv.innerHTML = html;
            }
        }
        // Update progress toast at BR position
       
        // Update other panels
        if (!document.getElementById("requirementProgress")) {
          //  createRequirementProgressPanel();
        }
        if (!window.allReady) { 
      console.log("no yet");
      if (document.getElementById("timing_right")) {
          etr=document.getElementById("timing_right");
          etr.style.display="none";      
          

      }
      setr=document.getElementById("statusDisplay");
          setr.innerHTML="WAIT";
          document.getElementById("statusRedDot").classList.replace("greenDot", "redDot");
      } else {
         setr=document.getElementById("statusDisplay");
          setr.innerHTML="READY";
        document.getElementById("statusRedDot").classList.replace("redDot", "greenDot");
      }
        //updateRequirementProgress(            grandTotals.answeredRequiredFields || 0,            grandTotals.requiredFields || 0,        );

        //if (!document.getElementById("requirementChecklist")) {            createRequirementChecklist();        }
// updateRequirementChecklist(containerStatuses.map((container) => ({...container,data:containers.find((c) => c.name === container.name)?.data ||{},})),);
    }      
function checksubmit(){
  sb=localStorage.getItem("submit_status");
  if (!sb) {
    if (!window.allReady)  { localStorage.setItem("submit_status","");alert("Not Ready for Submitted");location.reload(true);}

    if (window.allReady) { 
      //alert(panelId);  
      Object.assign(window.board, {
    status: "submitted",
    submitDateTime: new Date().toISOString()
  });
    saveToServerM(userid);
    
      alert("Thank you for Submitted");
      localStorage.setItem("submit_status","submitted");
    }
    
    location.reload(true);


  } else { 
      Object.assign(window.board, {
    status: "resubmitted",
    submitDateTime: new Date().toISOString()
  });
    alert("You are already Submitted but Still have time for Ensure-checked,Unlocked for allowing submit");
        //alert(panelId);
        if (isExpired) {alert("Time Expired ,No more allowed Re-submit");
            
              alert("⛔ Deadline has passed. No further submissions are allowed.");
    document.getElementById("confirm_btn")?.setAttribute("disabled", true);
    return;
    
        } else localStorage.setItem("submit_status","");
location.reload(true);
    //localStorage.setItem("submit_status","");
    return;}
}    
function checksubmitbtn(){
   sb=localStorage.getItem("submit_status");
  if (sb==="submitted") bbb="✓ Re-Submit"; else bbb="Submit";
 
  return butt;
}
// Add this JavaScript function to update the clock
function updateClock() {
    const now = new Date();
    const clockElement = document.getElementById('cclock');
    
    if (!clockElement) return;
    
    // Set default expiration date if not defined
   // window.dateExpired = window.dateExpired || new Date(now.getTime() + 7 * 24 * 60 * 60 * 1000); // Default: 7 days from now
    window.dateExpired = new Date('2025-08-22T23:59:59');
//August 22, 2025, at 23:59:59 (just before midnight of August 23).
//The time 23:59:59 ensures the date expires at the end of August 22 (not the start).
//Uses the ISO 8601 format (YYYY-MM-DDTHH:mm:ss), which is reliably parsed by browsers.
    
    const expiredDate = new Date(window.dateExpired);
    const timeLeft = expiredDate - now;
    
    // Format dates and times
    const currentDateText = now.toLocaleDateString();
    const currentTimeText = now.toLocaleTimeString();
    const expiredDateText = expiredDate.toLocaleDateString();
    
    // Countdown calculation
    let countdownText;
     isExpired = timeLeft <= 0;
    
    if (isExpired) {
        countdownText = "Expired";
    } else {
        const days = Math.floor(timeLeft / (1000 * 60 * 60 * 24));
        const hours = Math.floor((timeLeft % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        const minutes = Math.floor((timeLeft % (1000 * 60 * 60)) / (1000 * 60));
        const seconds = Math.floor((timeLeft % (1000 * 60)) / 1000);
        countdownText = `${days}d ${hours}h ${minutes}m ${seconds}s`;
    }

    clockElement.innerHTML = `
        <div style="
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 10px;
            width: 100%;
            font-family: sans-serif;
            font-size: 13px;
        ">
            <!-- First Row -->
            <div style="display: flex; align-items: center; gap: 6px;">
                <span>📅</span>
                <span>Expires: ${expiredDateText}</span>
            </div>
            <div style="display: flex; align-items: center; gap: 6px; justify-content: flex-end;
                 color: ${isExpired ? '#F44336' : '#2196F3'}">
                <span>⏳</span>
                <span>${countdownText}</span>
            </div>
            
            <!-- Second Row -->
            <div style="display: flex; align-items: center; gap: 6px;">
                <span>📅</span>
                <span>Today: ${currentDateText}</span>
            </div>
            <div style="display: flex; align-items: center; gap: 6px; justify-content: flex-end;">
                <span>🕒</span>
                <span>${currentTimeText}</span>
            </div>
        </div>
    `;
}// Initialize clock (call this once)
function initClock() {
    updateClock();
    setInterval(updateClock, 1000);
}
// Usage:
// 1. Set your expiration date first:
// window.dateExpired = "2023-12-31T23:59:59"; 
// 2. Then initialize the clock:
// initClock();
// Initialize clock and update every second
initClock();
//setInterval(updateClock, 1000);
// Helper function to update both summary panels
function updateSummaryPanels(lang) {
        console.log("UpdateSunp");
        if (document.getElementById("summan")) {
            renderSchemaStructureToSumman(bucket, "gform", lang);
        }
        if (document.getElementById("jumperhelper")) {
            updateJumperHelperWithUnanswered(QSummary(bucket).summary, bucket);
        }
    }    
async function loadAndUpdateGS(id) {
   idx = "myPanel";
  const existing = document.getElementById(id);
// Check and remove existing panel if it exists
  const existingPanel = document.getElementById(idx);
  if (existingPanel) {
    try {
      // Try to use panel system's close method if available
      if (existingPanel.close) {
        existingPanel.close();
      } else {
        // Fallback removal
        existingPanel.remove();
      }
    } catch (e) {
      console.error("Error removing existing panel:", e);
    }
  }

  // Check and remove existing progress circle if it exists
  const existingLeftOne = document.getElementById("leftone");
  if (existingLeftOne) {
    try {
      existingLeftOne.remove();
    } catch (e) {
      console.error("Error removing existing leftone:", e);
    }
  }

  // Check and remove right content if it exists
  const existingRightOne = document.getElementById("rightone");
  if (existingRightOne) {
    try {
      existingRightOne.remove();
    } catch (e) {
      console.error("Error removing existing rightone:", e);
    }
  }
  aa = 0;
  bb = 0;
  lbb = 0;
console.log(id);
  try {
    const data = await loadDataOnly(id);
    console.log("✔️ Raw data from loadDataOnly():", data);

    bucket = safeParseJSON(data.bucket) || {};
    cup = safeParseJSON(data.cup) || {};
    board = safeParseJSON(data.board) || {};

    console.log("✔️ Parsed bucket:", bucket);
    console.log("✔️ Parsed cup:", cup);
    console.log("✔️ Parsed board:", board);

/*all */
    const containers = [
      { data: bucket, name: "Bucket" },
      { data: cup, name: "Cup" },
      { data: board, name: "Board" },
    ].filter(c => c.data && Object.keys(c.data).length);
    
/* only bucket show 
    const containers = [
  { data: bucket, name: "Bucket" }
].filter(c => c.data && Object.keys(c.data).length);
*/    
    if (containers.length === 0) {
      console.warn("⚠️ No valid containers with data.");
      return;
    }

// keep score into board
// --- inside loadAndUpdateGS, after the containers.forEach(...) ---

/* 1. overall (bucket + cup + board) */
const overallforBoard = containers.reduce(
  (a, { data }) => {
    const s = QSummary(data)?.summary?.totals ?? { totalScoreWeighted: 0, maxPossibleScoreWeighted: 0 };
    return {
      achieved: a.achieved + s.totalScoreWeighted,
      max:      a.max      + s.maxPossibleScoreWeighted
    };
  },
  { achieved: 0, max: 0 }
);

/* 2. bucket only (Assessment) */
const bucketStat = QSummary(bucket)?.summary?.totals ?? { totalScoreWeighted: 0, maxPossibleScoreWeighted: 0 };

/* 3. cup only (Profile) */
const cupStat    = QSummary(cup)?.summary?.totals    ?? { totalScoreWeighted: 0, maxPossibleScoreWeighted: 0 };

/* 4. merge into existing window.board (keeps all old keys) */
Object.assign(window.board, {
  overallScore: {
    achieved : overallforBoard.achieved,
    max      : overallforBoard.max,
    percent  : overallforBoard.max
                 ? (overallforBoard.achieved / overallforBoard.max * 100).toFixed(1)
                 : 0
  },
  assessment: {
    achieved : bucketStat.totalScoreWeighted,
    max      : bucketStat.maxPossibleScoreWeighted,
    percent  : bucketStat.maxPossibleScoreWeighted
                 ? (bucketStat.totalScoreWeighted / bucketStat.maxPossibleScoreWeighted * 100).toFixed(1)
                 : 0
  },
  profile: {
    achieved : cupStat.totalScoreWeighted,
    max      : cupStat.maxPossibleScoreWeighted,
    percent  : cupStat.maxPossibleScoreWeighted
                 ? (cupStat.totalScoreWeighted / cupStat.maxPossibleScoreWeighted * 100).toFixed(1)
                 : 0
  }
});
// end keep score
    const summaryData = [];  // ✅ define inside try block

    let totalAnsweredRequired = 0;
    let totalRequired = 0;
let totalScoreWeighted = 0;
    let maxPossibleScoreWeighted = 0;
    console.log("=== Summary ===");

    containers.forEach(container => {
      const summaryResult = QSummary(container.data);
      if (!summaryResult?.summary?.totals) {
        console.warn(`⚠️ QSummary failed for ${container.name}`);
        return;
      }

      const s = summaryResult.summary.totals;
        // Add debug output for the scores
  console.log(`🔍 ${container.name} Score Details:`, {
    totalScoreWeighted: s.totalScoreWeighted,
    maxPossibleScoreWeighted: s.maxPossibleScoreWeighted,
    scoreFields: s.totalScore,
    maxScoreFields: s.maxPossibleScore,
    calculated: {
      current: calculateCurrentScore({ score: 1 }), // Test with simple field
      max: calculateMaxScore({ score: 1 })         // Test with simple field
    }
  });
  totalScoreWeighted += s.totalScoreWeighted;
      maxPossibleScoreWeighted += s.maxPossibleScoreWeighted;
      const requiredPercent = s.requiredFields > 0
        ? Math.round((s.answeredRequiredFields / s.requiredFields) * 100)
        : 0;
 // Calculate score percentage
    const scorePercentage = maxPossibleScoreWeighted > 0 
      ? (totalScoreWeighted / maxPossibleScoreWeighted * 100).toFixed(1)
      : 0;
      summaryData.push({
        title: `📦 ${container.name}`,
        required: `${s.answeredRequiredFields}/${s.requiredFields}`,
        totalFields: `${s.answeredFields}/${s.allFields}`,
        files: s.totalFiles || 0,
        progress: requiredPercent,
      });

      totalAnsweredRequired += s.answeredRequiredFields;
      totalRequired += s.requiredFields;

      console.log(`📦 ${container.name}`);
      console.log(`  - Required: ${s.answeredRequiredFields}/${s.requiredFields}`);
      console.log(`  - Total Fields: ${s.answeredFields}/${s.allFields}`);
      console.log(`  - Files: ${s.totalFiles || 0}`);
      console.log(`  - Progress: ${requiredPercent}%`);
    });

    // Render panel
    //bb = ``;//Total Fields: ${aa}/${bb}`;
    //pcs=(totalScoreWeighted / maxPossibleScoreWeighted * 100).toFixed(1);
    /* ---- overall (all 3 containers) ---- */
const overall = containers.reduce((acc, { data }) => {
  const s = QSummary(data)?.summary?.totals ?? { totalScoreWeighted: 0, maxPossibleScoreWeighted: 0 };
  acc.total += s.totalScoreWeighted;
  acc.max   += s.maxPossibleScoreWeighted;
  return acc;
}, { total: 0, max: 0 });
const overallPct = overall.max ? (overall.total / overall.max * 100).toFixed(1) : 0;

/* ---- bucket only ---- */
const bucketOnly = containers
  .filter(c => c.name === 'Bucket')
  .reduce((acc, { data }) => {
    const s = QSummary(data)?.summary?.totals ?? { totalScoreWeighted: 0, maxPossibleScoreWeighted: 0 };
    acc.total += s.totalScoreWeighted;
    acc.max   += s.maxPossibleScoreWeighted;
    return acc;
  }, { total: 0, max: 0 });
const bucketPct = bucketOnly.max ? (bucketOnly.total / bucketOnly.max * 100).toFixed(1) : 0;

/* ---- build the HTML ---- */
bb = `
  <div style="margin:0 10px 6px; padding:2px 0; border-radius:8px; font-size:14px; background:#f5f5f5; text-align:center;">


    Overall <b>${overall.total}</b> / ${overall.max} (${overallPct}%)
  </div>
  <div style="margin:0 10px 6px; padding:2px 0; border-radius:8px;font-size:14px;background:#e8f4fd;text-align:center;">
    Assessment: <b>${bucketOnly.total}</b> / ${bucketOnly.max} (${bucketPct}%)
  </div>`;
     bbalone = `<div style="margin-bottom:12px;padding:12px;border-radius:8px;font-size:14px;background:#f5f5f5;text-align:center">Score: <b>${totalScoreWeighted}</b> / ${maxPossibleScoreWeighted}) </div>`;
    createPanel(idx, "CC", "ctc", 600, window.innerHeight-60, {
      title: "my",
      noFooter: true,
      noDrag: false,
      radius: "8px",
      forceReload:true,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
       <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 2px;">
    <p><div id="leftone"><div class="myBox" style="margin-top: 1px;"><div id="leftonecp"></div>${bb}</div></div></p>
    
  </div>
  <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px;">
    <div id="rightone">
    </div>

    
  </div>
      </div>`
    });

    // ⭕ Initialize circular progress bar
    
    const update = makeCircleProgress("leftonecp");
    update(totalAnsweredRequired, totalRequired);

    // ✅ Now render the summary
    


    renderSummary(summaryData, "rightone");
    
    document.getElementById("leftone").insertAdjacentHTML("beforeend", `
<div class="myBox" style="margin-top: 1px;">
 
      <div id="analogClock"></div>
    
    <div class="myBox" style="margin-top: 1px;">
      <div id="digitalClock"></div>
    </div>
    <div id="expdate"></div>
    </div>
   
`);

makeAnalogClock("analogClock");
makeDigitalClock("digitalClock");
//makeCountdown("countdownClock");
  } catch (e) {
    console.error("❌ Error loading and summarizing:", e);
  }
}    

function updateMyDotStatus(online) {
  const dot = document.getElementById('my_dot');
  const status = document.getElementById('my_status');
  if (online) {
    dot.style.backgroundColor = '#4CAF50';
    status.textContent = 'Online';
  } else {
    dot.style.backgroundColor = '#F44336';
    status.textContent = 'Offline';
  }
}
// Update progress function

function updateMyProgress(statusText, percent) {
  // Ensure elements exist before updating
  const statusElement = document.getElementById('progressStatus');
  if (!statusElement) return;

  statusElement.textContent = statusText;

  const avatar = document.getElementById('progressAvatar');
  if (!avatar) return;

  const circle = avatar.querySelector('.progress-circle') || 
                document.getElementById('progressCircle');
  const percentText = avatar.querySelector('.progress-percent') || 
                     document.getElementById('progressPercent');

  if (!circle || !percentText) return;

  // Initialize with no visible progress
  circle.style.background = `conic-gradient(#4CAF50 360deg, transparent 0deg 360deg)`;

  // Calculate the angle for conic-gradient
  const normalizedPercent = Math.min(Math.max(percent, 0), 100);
  const angle = (normalizedPercent / 100) * 360;

  // Animate the progress
  const duration = 1000; // 1 second animation
  const startTime = performance.now();
  const startPercent = parseFloat(percentText.textContent) || 0;

  function animate(currentTime) {
    const elapsed = currentTime - startTime;
    const progress = Math.min(elapsed / duration, 1);
    const currentPercent = startPercent + (normalizedPercent - startPercent) * progress;
    const currentAngle = (currentPercent / 100) * 360;

    // Update elements - green progress with transparent unfilled portion
    circle.style.background = `conic-gradient(#4CAF50 ${currentAngle}deg, transparent ${currentAngle}deg 360deg)`;
    percentText.textContent = `${Math.round(currentPercent)}%`;

    // Change text color if complete
    if (currentPercent >= 100) {
      percentText.style.color = '#4CAF50';
      percentText.style.color = 'white';
    } else {
      percentText.style.color = 'white';
    }

    if (progress < 1) {
      requestAnimationFrame(animate);
    }
  }

  requestAnimationFrame(animate);
}

// Updated styles to ensure ring visibility and no white overlay
addStyle(`
.progress-avatar {
  position: relative;
  width: 60px;
  height: 60px;
  display: flex;
  align-items: center;
  justify-content: center;
  background: transparent;
  border-radius: 50%;
}

.progress-circle {
  position: absolute;
  width: 100%;
  height: 100%;
  border-radius: 50%;
  background: conic-gradient(#4CAF50 0deg, transparent 0deg 360deg);
  z-index: 1;
}

.progress-circle::after {
  content: '';
  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  width: 36px; /* Adjusted for a ~7px thick ring */
  height: 36px;
  background: transparent; /* Transparent to show page background */
  border: 2px solid #eee; /* Light gray inner border for ring definition */
  border-radius: 50%;
  z-index: 2;
}

.progress-percent {
  position | relative;
  font-size: 14px;
  font-weight: bold;
  color: white;
  z-index: 3;
  text-shadow: 0 0 3px rgba(0,0,0,0.5);
}
  /* Progress Text */
  .progress-text {
    font-size: 13px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
  
  /* Circular Progress Avatar */
  .progress-avatar {
    width: 36px;
    height: 36px;
    border-radius: 50%;
    border: 2px solid #ddd;
    position: relative;
    display: flex;
    align-items: center;
    justify-content: center;
    background: rgba(200,200,200,.5);
  }
  
  /* Progress Circle */
  .progress-circle {
    position: absolute;
    width: 36px;
    height: 36px;
    border-radius: 50%;
    border: 3px solid #f0f0f0; /* Track color */
    //border-top-color: #2196F3; /* Progress color */
    //transform: rotate(-90deg);
    transition: all 0.3s ease;
  }
  
  /* Progress Percentage */
  .progress-percent {
    font-size: 12px;
    //font-weight: bold;
    //color: #2196F3;
  }
`);
 // loader
   addStyle(`
/* Default styles (e.g., light mode) */
body {
  background-color: rgba(184, 201, 217, 1);
  
  //background: #96cbff;

    }
 #test2 {

background:#eeee;

}
.menuButton {
background:#ff;
color:rgba(10,10,10,1);
box-shadow: 0 14px 12px rgba(0, 0, 0, 0.05);
}
.groupTitle{
color:rgba(100,100,100,.4);
font-size:10px;
}
#dayNight{
background:rgba(255, 65, 13, 1);
padding:0px 12px;
border-radius: 8px;
color:white;
}
/* Styles for dark mode */
@media (prefers-color-scheme: dark) {
  body {
    background-color: rgba(56, 98, 144, 0.4);
  }
    #test2 {
background:#333;

}
.lang-label{
color:rgba(250,250,250,.4);

}
#statusDisplay{
color:rgba(250,250,250,.8);
}

.menuButton {
background:rgba(100,100,100,.2);
color:rgba(250,250,250,.8);
}
.groupTitle{
color:#aaa;
}
#dayNight{
background:rgba(255, 227, 13, 1);
padding:0px 12px;
border-radius: 8px;
color:black;
}
   }
                 body {
                 //background: #6b99c2;
}
                
                    .loader {
                        position: relative;
                        display: flex;
                        align-items: center;
                        justify-content: center;
                        width: 100%;
                        max-width: 6rem;
                        margin-top: 3rem;
                        margin-bottom: 3rem;
                      }
                      .loader:before,
                      .loader:after {
                        content: "";
                        position: absolute;
                        border-radius: 50%;
                        animation: pulsOut 2.2s ease-in-out infinite;
                        filter: drop-shadow(0 0 1rem rgba(255, 255, 255, 0.95));
                      }
                      .loader:before {
                        width: 100%;
                        padding-bottom: 100%;
                        box-shadow: inset 0 0 0 1rem #fff;
                        animation-name: pulsIn;
                      }
                      .loader:after {
                        width: calc(100% - 2rem);
                        padding-bottom: calc(100% - 2rem);
                        box-shadow: 0 0 0 0 #fff;
                      }

                      @keyframes pulsIn {
                        0% {
                          box-shadow: inset 0 0 0 1rem rgba(200,200,200,.9);
                          opacity: 1;
                        }
                        50%, 100% {
                          box-shadow: inset 0 0 0 0 rgba(200,200,200,.9);
                          opacity: 0;
                        }
                      }

                      @keyframes pulsOut {
                        0%, 50% {
                          box-shadow: 0 0 0 0 #fff;
                          opacity: 0;
                        }
                        100% {
                          box-shadow: 0 0 0 1rem #fff;
                          opacity: 1;
                        }
                      }
.footer-buttons button{
background:rgba(200,200,200,.5);
margin:5px;
border:2px solid rgba(200,200,200,.1);
border-radius:5px;
outline:2px solid rgba(76, 175, 80, 0.01);
}
.footer-buttons button:hover {
background:rgba(200,200,200,1);
outline:2px solid rgba(76, 175, 80, 0.8);
}

.menuButton:hover {

outline:2px solid rgba(72, 120, 222, 0.5);
}
#test2 {



}
                `);
function showcoc(){
  
createPanel("coc", "CC", "btt", 900, window.innerHeight-50, {
    title: "KTB COC 2024",
    noFooter: true,
    bodyCloseButton: false,
    overflow:true,
    bodyContent: `<div id="IMGCOC" style="height:100%;"> <img src="coc.jpg"></div>`,
  });
}
function renderSummary(data, targetId) {
  const container = document.getElementById(targetId);
  if (!container) return;

  container.innerHTML = ''; // Clear old content

  let totalRequired = 0;
  let totalAnswered = 0;
      BucketName = "Assessment";
        CupName = "Profile";
  // Calculate summary stats
  if (data.length === 0) {
            submitStatus = "NO DATA";
}
console.log(data);
  data.forEach(item => {
    const [answeredReq, totalReq] = item.required.split('/').map(Number);
    totalAnswered += answeredReq;
    totalRequired += totalReq;
  });

  let  overallPercent = totalRequired > 0 ? Math.min(100, Math.round((totalAnswered / totalRequired) * 100)) : 0;

  // Summary Card
  const summaryBox = document.createElement("div");
  summaryBox.className = "itemBox";
  //summaryBox.style.background = "#e3f2fd";
head1= `
    <div class="title"> Progress ${overallPercent}%</div>        

    <progress id="file" value="${overallPercent}" max="100"> ${overallPercent} %</progress>
      <div>Answered: ${totalAnswered},Required: ${totalRequired}</div>
      
  `;
  summaryBox.innerHTML ="";//head1;
  updateProgress("A1",overallPercent);
  //updateBadge("profile",111,"red");
  container.appendChild(summaryBox);
  prog=`Progress (${totalAnswered}/${totalRequired}) `+overallPercent+"%";
updateStatus("A1",prog);
updateBadge("A1",totalRequired-totalAnswered,"red");
updateBadge("A1",totalRequired-totalAnswered,"red");
Title="";
bodies="";
body1="";body2="";
other=false;

  // Each Item Card
  data.forEach(item => {
    const box = document.createElement("div");
    box.className = "itemBox";

    // Clean item.title to remove duplicate emoji if present
    const cleanTitle = item.title.replace(/^📦\s*/, ''); // Remove leading 📦 emoji
if (cleanTitle==="Bucket") Title="Assessment"; 
if (cleanTitle==="Cup") Title="Profile";

 if (cleanTitle==="Bucket") {
                updateProgress("Profile",999);
                prog=`${Math.min(100, item.progress)}% (${item.required}) `;
                
                body1+= `
    <div class="stats">  <div class="title">${Title}<label for="file"> ${item.progress}%</label></div>     
    <progress id="file" value="${Math.min(100, item.progress)}" max="100"> ${Math.min(100, item.progress)}% </progress>
    <div>${item.required}, Files: ${item.files}</div>
    </div>
    `;
    
                box.innerHTML ="";
                //body1;
    const [BansweredReq, BtotalReq] = item.required.split('/').map(Number);
      updateBadge("assessment",BtotalReq-BansweredReq,"red");

    container.appendChild(box);
            }
if (cleanTitle==="Cup") {
                updateProgress("Profile",item.progress);
                  prog=`${Math.min(100, item.progress)}% (${item.required}) `;
                updateStatus("Profile",prog);
                body2=`
    <div class="stats">  <div class="title">${Title}<label for="file"> ${item.progress}%</label></div>     
    <progress id="file" value="${Math.min(100, item.progress)}" max="100"> ${Math.min(100, item.progress)}% </progress>
    <div>${item.required}, Files: ${item.files}</div>
    </div>
    `;
                box.innerHTML ="";// body2;
    //updateBadge("Profile", item.required-item,"red");
    const [CansweredReq, CtotalReq] = item.required.split('/').map(Number);
      updateBadge("Profile",CtotalReq-CansweredReq,"red");
    container.appendChild(box);
    
            }            

    
   
  });
  
  bodies=body1+body2;
    const boxsum = document.createElement("div");
    submit_status = "ON GOING";
  boxsum.className = "itemBox";
    allReady = true;
   
    //submitStatus = "NO DATA";
if (overallPercent>=100) submit_status = "READY ✓";
  boxsum.innerHTML = ``;
    // <div class="title">STATUS : `+submit_status+`</div>            <div class="stats">   </div>`;
    p_status=`STATUS : `+submit_status;
      // Set profile image
    defaultAvatar = 'png.png';
  user_imgr = localStorage.getItem("img") || "";
  let user_img = defaultAvatar;
  if (user_imgr && /^https?:\/\//.test(user_imgr)) {
    user_img = user_imgr;
  } else if (user_imgr) {
    console.warn("Invalid image URL in localStorage, using default:", user_imgr);
    localStorage.removeItem("img");
  }
boxsum.innerHTML += `
<style>
  /* Progress Container - matches profileContainer width */
  #progressMyContainer {
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
    font-family: Arial, sans-serif;
    margin-top: 5px; /* Spacing from profile */
    margin-bottom: 20px; /* Spacing from profile */
border-radius: 8px 8px 8px 8px;
  }
  
  /* Header Row */
  #progressHeader {
    display: flex;
    align-items: center;
    padding: 8px 12px;
    background:rgba(240,240,200,.5);
    border-radius: 8px 8px 0 0;
    border: 1px solid #ddd;
  }
  
  /* Progress Status Area */
  .progress-status-area {
    display: flex;
    align-items: center;
    flex: 1;
    min-width: 0;
    gap: 8px;
  }
  
  /* Status Dot */
  .progress-dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background: #2196F3; /* Blue for progress */
    flex-shrink: 0;
  }
  
  
  
  /* Content Area */
  #divprogress {
    padding: 6px 12px;
    height: 120px;
    overflow-y: auto;
    background:rgba(200,200,200,.5);
    border: 1px solid #ddd;
    border-top: none;
    border-radius:  0 0 8px 8px;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
  }
     #dateInfo ,#dayInfo {
      padding:0px 6px;
      border-radius:8px;
    }
.myBox{
 margin-top: 5px; /* Spacing from profile */
    margin-bottom: 10px; /* Spacing from profile */
    //background:rgba(200,200,200,.9);
    padding: 2px;
    border-radius:  8px 8px 8px 8px;
    backdrop-filter: blur(5px);
    outline:1px solid rgba(183, 204, 255, 0.7);
}      
</style>

<div id="progressMyContainer">
  <div id="progressHeader">
    <div class="progress-status-area">
      <div class="progress-dot" id="progressDot"></div>
      <div class="progress-text" id="progressStatus">Processing Files...</div>
    </div>
    <div class="progress-avatar" id="progressAvatar">
  <div class="progress-circle" id="progressCircle"></div>
  <div class="progress-percent" id="progressPercent">0%</div>
</div>
  </div>
  
  <div id="divprogress">
    `+bodies+`
  </div>
</div>
`;

   boxsum.innerHTML += `
      <style>
  /* Profile Container */
 /* Main Container */
   #profileContainer {
    width: 100%;
    max-width: 600px;
    margin: 0 auto;
    display: flex;
    flex-direction: column;
    gap: 0; /* Changed from 5px to 0 to remove gap */
   background:rgba(240,240,240,.5);
   border-radius: 8px 8px 8px 8px;
  }
  
  /* Header Row */
  #profileHeader {
    display: flex;
    align-items: center;
    width: 100%;
    padding: 8px 12px;
    
    border-radius: 8px 8px 0 0;
    //border: 1px solid #ddd;
    box-sizing: border-box;
  }
  
  /* Username with Status Dot */
  #usernameContainer {
    display: flex;
    align-items: center;
    flex: 1;
    min-width: 0;
    gap: 8px;
  }
  
  /* Status Dot */
  #my_dot {
    width: 10px;
    height: 10px;
    border-radius: 50%;
    background-color: #4CAF50;
    flex-shrink: 0;
  }
  
  /* Username Text */
  #my_username {
    font-size:13px;
    white-space: nowrap;
    overflow: hidden;
    text-overflow: ellipsis;
  }
  
  /* Profile Image */
  #profileImage {
    height: 40px;
    width: 40px;
    border-radius: 50%;
    border: 2px solid #ddd;
    overflow: hidden;
    flex-shrink: 0;
  }
  
  #profileImage img {
    width: 100%;
    height: 100%;
    object-fit: cover;
  }
  
  /* Content Area */
  #divprofile {
    width: 100%;
    height: 220px;
    padding: 12px;
    font-size: 13px;
    overflow-y: auto;
    border-radius: 0 0 8px 8px;
    background:rgba(90,90,90,.1);
    
    border: 1px solid #ddd;
    border-top: none; /* This ensures no double border */
    box-sizing: border-box;
    box-shadow: 0 2px 4px rgba(0,0,0,0.05);
    margin-top: -1px; /* This pulls up to eliminate any remaining gap */
  }
    /* Load Button */
  #profileuserid3,#COC {
    padding: 2px 8px;
    background: #008cffb2;
    color: white;
    border: none;
    border-radius: 18px;
    cursor: pointer;
    text-align: center;
    font-size: 13px;
    margin-top: 10px;
  }

  #profileuserid3:hover ,#COC:hover {
    background: #0086f3ff;
  }
    .stats {
  font-size: 12px;
}

</style>

<div id="profileContainer">
  <div id="profileHeader">
    <!-- Username with Status Dot -->
    <div id="usernameContainer">
      <div id="my_dot"></div>
      <div id="my_username">${window.user_name}</div>
    </div>
    
    <!-- Profile Image -->
    <div id="profileImage">
      <img id="userProfileImage" src="${user_img}" alt="Profile">
    </div>
  </div>
  
  <!-- Profile Content -->
  <div id="divprofile">
    Profile content goes here. Scrollable when content overflows.
  </div>
</div>
      <div id="profileuserid3">Refresh Profile </div>
      <div id="COC">COC</div>
  `;
     
  container.appendChild(boxsum);
document
            .getElementById("COC")
            .addEventListener("click", () => {
                showcoc();
                

            });
document
            .getElementById("profileuserid3")
            .addEventListener("click", () => {
                renderCupToDivProfileML(userid);
                updateProfileAvatar(); // Update avatar on refresh
                //updateMyProgress(`${overallPercent}% ${p_status}`, overallPercent); 

            });            
            // Set the profile image
           // Set onerror handler for profile image
  const profileImg = document.getElementById('userProfileImage');
  if (profileImg) {
    profileImg.onerror = () => {
      console.warn("Failed to load profile image, reverting to default.");
      profileImg.src = defaultAvatar;
    };
  }
  
  //document.getElementById('userProfileImage').src = user_img;
    // Example status update
      updateMyProgress(`${overallPercent}% ${p_status}`, overallPercent);  // 25% progress

}
// Global function to update profile avatar across panels
function updateProfileAvatar() {
  const defaultAvatar = 'png.png'; // Your 40x40 PNG
  const user_imgr = localStorage.getItem("img") || "";
  let user_img = defaultAvatar;
  if (user_imgr && /^https?:\/\//.test(user_imgr)) {
    user_img = user_imgr;
  } else if (user_imgr) {
    console.warn("Invalid image URL in localStorage, using default:", user_imgr);
    localStorage.removeItem("img");
  }

  const profileImg = document.getElementById('userProfileImage');
  if (profileImg) {
    profileImg.src = user_img;
    profileImg.onerror = () => {
      console.warn("Failed to load profile image, reverting to default.");
      profileImg.src = defaultAvatar;
    };
  }

  // Sync with draggable pill if loaded
  if (typeof window.updateAvatar === 'function') {
    window.updateAvatar();
  }
}


 
