window.debug = false;
window.logomode = true;

function displayMessage(message, isError = false, isInfo = false) {
    let msgDiv = document.getElementById("message");
    if (!msgDiv) {
        msgDiv = document.createElement("div");
        msgDiv.id = "message";
        document.body.insertBefore(msgDiv, document.body.firstChild);
    }
    msgDiv.textContent = message;
    msgDiv.className = "message " + (isError ? "error" : isInfo ? "info" : "success");
    if (isInfo) {
        setTimeout(() => {
            if (msgDiv.className.includes("info")) {
                msgDiv.textContent = "";
                msgDiv.className = "message";
            }
        }, 3000);
    }
}

function logoset(targetId, previewId = "addImgPreview") {
    const stringText = window.imgsrc;
    const targetInput = document.getElementById(targetId);
    const previewDiv = document.getElementById(previewId);
    const defaultAvatar = 'https://placehold.co/100x100/666/fff/png';
    if (targetInput && typeof stringText !== "undefined") {
        targetInput.value = stringText;
        if (previewDiv) {
            previewDiv.innerHTML = `<img src="${stringText}" alt="preview" style="max-width: 100px; max-height: 100px; object-fit: cover; border-radius: 4px;">`;
            const img = previewDiv.querySelector('img');
            img.onerror = () => {
                console.warn("Failed to load preview image, reverting to default.");
                img.src = defaultAvatar;
            };
        }
    }
}

function togglePassword(inputId, buttonId) {
    const input = document.getElementById(inputId);
    if (input) {
        input.type = input.type === "password" ? "text" : "password";
        const button = document.getElementById(buttonId);
        if (button)
            button.textContent = input.type === "password" ? "Show" : "Hide";
    }
}

async function postto(apiUrl = "", payload = {}) {
    try {
        const response = await fetch(apiUrl, {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ data: payload }),
        });
        if (!response.ok) {
            const errorData = await response.json().catch(() => ({}));
            throw new Error(errorData.error || `HTTP error! status: ${response.status}`);
        }
        return await response.json();
    } catch (error) {
        console.error("Request failed:", error);
        displayMessage(error.message, true);
        throw error;
    }
}

async function checkUsernameExists(username) {
    try {
        const response = await postto('https://i.kunok.com/aui.php?action=check_username', { username });
        return response.exists;
    } catch (error) {
        console.error("Check username error:", error);
        return false;
    }
}

function closePanel(id) {
    const panel = document.getElementById(id);
    if (panel) panel.remove();
}

async function addUserPanel() {
    const defaultAvatar = 'https://placehold.co/100x100/666/fff/png';
    const formHTML = `
        <style>
            .form-row { display: flex; gap: 10px; }
            .form-row > div { flex: 1; }
            #addImgPreview img {
                max-width: 100px;
                max-height: 100px;
                object-fit: cover;
                border-radius: 4px;
            }
        </style>
        <div class="logo-controls">
            <div id="addImgPreview"><img src="${defaultAvatar}" alt="preview"></div>
            <div class="button-group" style="display: flex; gap: 10px; justify-content: center; margin-top: 10px;">
                <button type="button" id="addUploadLogoBtn">Upload logo</button>
                <button type="button" id="addApplyLogoBtn">Apply Logo</button>
            </div>
        </div>
        <form id="addUserForm">
            <div><label for="addId">ID:</label> <input type="text" id="addId" required></div>
            <div><label for="addName">Name:</label> <input type="text" id="addName" required></div>
            <div><label for="addUsername">Username:</label> <input type="text" id="addUsername" required></div>
            <div>
                <label for="addPassword">Password:</label>
                <input type="password" id="addPassword" required>
                <button type="button" id="toggleAddPasswordBtn">Show</button>
            </div>
            <div class="form-row">
                <div>
                    <label for="addFlag">Flag:</label>
                    <select id="addFlag">
                        <option value="1">1 (Active)</option>
                        <option value="0">0 (Suspended)</option>
                        <option value="3">3 (Wait)</option>
                    </select>
                </div>
                <div>
                    <label for="addLevel">Level:</label>
                    <select id="addLevel">
                        <option value="1">1 (User)</option>
                        <option value="2">2 (Moderator)</option>
                        <option value="3">3 (Admin)</option>
                    </select>
                </div>
            </div>
            <div>
                <label for="addImg">Image URL:</label>
                <input type="text" id="addImg" placeholder="Enter image URL">
            </div>
            <button type="submit">Add User</button>
        </form>
        <div id="message" class="message"></div>
    `;

    if (typeof createPanel !== "function") {
        console.error("Missing createPanel(). Please include panel system.");
        return;
    }

    createPanel("addUserPanel", "CC", "ctc", 400, 600, {
        bodyContent: formHTML,
        noFooter: true,
        title: 'Add New User'
    });

    const form = document.getElementById("addUserForm");
    if (form) {
        form.addEventListener("submit", async (e) => {
            e.preventDefault();
            const userId = document.getElementById("addId").value;
            const username = document.getElementById("addUsername").value;
            displayMessage(`Starting to add user ${userId}...`, false, true);

            try {
                const exists = await checkUsernameExists(username);
                if (exists) {
                    displayMessage(`Username ${username} already exists.`, true);
                    return;
                }

                const payload = {
                    id: userId,
                    name: document.getElementById("addName").value,
                    username: username,
                    password: document.getElementById("addPassword").value,
                    flag: parseInt(document.getElementById("addFlag").value),
                    level: parseInt(document.getElementById("addLevel").value),
                    img: document.getElementById("addImg").value ? btoa(document.getElementById("addImg").value) : ''
                };

                const response = await postto("https://i.kunok.com/aui.php?action=add", payload);
                displayMessage(response.message || `User ${userId} added successfully`);
                form.reset();
                document.getElementById("addImgPreview").innerHTML = `<img src="${defaultAvatar}" alt="preview">`;
                closePanel("addUserPanel");
                window.location.href = "index.html";
            } catch (error) {
                console.error("Add user error:", error);
                displayMessage(`Error adding user ${userId}: ${error.message}`, true);
            }
        });

        document.getElementById("toggleAddPasswordBtn").addEventListener("click", () =>
            togglePassword("addPassword", "toggleAddPasswordBtn")
        );
        document.getElementById("addUploadLogoBtn").addEventListener("click", () => {
            window.logomode = true;
            toggleUploadPanel(); // must be from upl3.js
        });
        document.getElementById("addApplyLogoBtn").addEventListener("click", () =>
            logoset("addImg", "addImgPreview")
        );
    }
}
