bucket = {
  grouping: {
    data_type: "grouping",
    name: ["personal", "farmer", "basic_info", "info"],
    label: {
      en: ["Personal", "Farmer", "Basic Information", "Additional Information"],
      th: ["ข้อมูลส่วนตัว", "เกษตรกร", "ข้อมูลพื้นฐาน", "ข้อมูลเพิ่มเติม"],
    },
    type: ["segment", "segment", "section", "section"],
  },
  basic_info: {
    data_type: "section",
    type: "section",
    label: { en: "Basic Information", th: "ข้อมูลพื้นฐาน" },
  },
  info: {
    data_type: "section",
    type: "section",
    label: { en: "Additional Information", th: "ข้อมูลเพิ่มเติม" },
  },
  full_name: {
    data_type: "string",
    type: "field",
    label: { en: "Full Name", th: "ชื่อเต็ม" },
    value: "Mr. John Doe",
    required: true,
    score: 1,
    weight: 1,
    segment: ["personal"],
    section: "basic_info",
  },
  gender: {
    data_type: "radio",
    type: "field",
    label: { en: "Gender", th: "เพศ" },
    value: 0,
    options: { en: ["Male", "Female"], th: ["ชาย", "หญิง"] },
    required: true,
    score: 1,
    weights: [1, 1],
    segment: ["personal"],
    section: "basic_info",
  },
  hobbies: {
    data_type: "checkbox",
    type: "field",
    label: { en: "Hobbies", th: "งานอดิเรก" },
    value: [],
    options: {
      en: ["Reading", "Gaming", "Traveling"],
      th: ["อ่านหนังสือ", "เล่นเกม", "ท่องเที่ยว"],
    },
    required: false,
    score: 1,
    weights: [0.5, 0.5, 1],
    segment: ["personal"],
    section: "basic_info",
  },
  occupation: {
    data_type: "select",
    type: "field",
    label: { en: "Occupation", th: "อาชีพ" },
    value: "", // Changed from DEFAULT_OCCUPATION to empty string
    options: {
      en: ["Select Occupation", "Engineer", "Teacher", "Farmer"],
      th: ["เลือกอาชีพ", "วิศวกร", "ครู", "เกษตรกร"],
    },
    required: true,
    score: 1,
    weights: [0, 1, 1, 1], // First weight is 0 for "Select Occupation"
    segment: ["personal"],
    section: "basic_info",
  },
  document_attachment: {
    label: { en: "Supporting Document", th: "เอกสารสนับสนุน" },
    type: "attachment",
    value: "report.pdf",
    score: 2,
    weight: 1,
    required: true,
    segment: ["farmer"],
    section: "info",
  },
  additional_docs: {
    label: { en: "Additional Documents", th: "เอกสารเพิ่มเติม" },
    type: "attachment",
    value: "doc1.pdf,doc2.pdf",
    score: 1,
    weight: 1,
    required: false,
    segment: ["farmer"],
    section: "info",
  },
  safety_training: {
    data_type: "radio",
    type: "field",
    label: { en: "Fire Safety Training?", th: "ฝึกอบรมดับเพลิง?" },
    value: null,
    options: {
      en: ["Yes", "No", "In Progress"],
      th: ["ใช่", "ไม่", "กำลังดำเนินการ"],
    },
    required: false,
    score: 1,
    weights: [1, 0, 0.5],
    segment: ["farmer"],
    section: "info",
  },
  12: {
    data_type: "radio",
    type: "field",
    label: {
      en: "1.บริษัทได้รับการรับรองระบบการจัดการด้านอาชีวอนามัยและความปลอดภัย (ISO 45001) หรือไม่",
      th: "1.บริษัทได้รับการรับรองระบบการจัดการด้านอาชีวอนามัยและความปลอดภัย (ISO 45001) หรือไม่",
    },
    value: null,
    required: false,
    score: 1,
    weight: 1,
    segment: ["personal"],
    section: "basic_info",
    options: {
      en: [
        "ได้รับการรับรอง หรือได้รับการตรวจตาม  ISO 45001 , หรือมาตรฐานการจัดการความปลอดภัยอื่น",
        "มีการประยุกต์ใช้ระบบ ISO 45001 แต่ไม่ได้มีการรับรองโดยหน่วยงานภายนอก",
        "ไม่มีการดำเนินการดังกล่าว",
      ],
      th: [
        "ได้รับการรับรอง หรือได้รับการตรวจตาม  ISO 45001 , หรือมาตรฐานการจัดการความปลอดภัยอื่น",
        "มีการประยุกต์ใช้ระบบ ISO 45001 แต่ไม่ได้มีการรับรองโดยหน่วยงานภายนอก",
        "ไม่มีการดำเนินการดังกล่าว",
      ],
    },
    weights: [1, 1, 1],
  },
};

abucket = {
  12: {
    data_type: "radio",
    type: "field",
    label: {
      en: "1.บริษัทได้รับการรับรองระบบการจัดการด้านอาชีวอนามัยและความปลอดภัย (ISO 45001) หรือไม่",
      th: "1.บริษัทได้รับการรับรองระบบการจัดการด้านอาชีวอนามัยและความปลอดภัย (ISO 45001) หรือไม่",
    },
    value: 2,
    required: false,
    score: 1,
    weight: 1,
    segment: ["personal"],
    section: "basic_info",
    options: {
      en: [
        "ได้รับการรับรอง หรือได้รับการตรวจตาม  ISO 45001 , หรือมาตรฐานการจัดการความปลอดภัยอื่น",
        "มีการประยุกต์ใช้ระบบ ISO 45001 แต่ไม่ได้มีการรับรองโดยหน่วยงานภายนอก",
        "ไม่มีการดำเนินการดังกล่าว",
      ],
      th: [
        "ได้รับการรับรอง หรือได้รับการตรวจตาม  ISO 45001 , หรือมาตรฐานการจัดการความปลอดภัยอื่น",
        "มีการประยุกต์ใช้ระบบ ISO 45001 แต่ไม่ได้มีการรับรองโดยหน่วยงานภายนอก",
        "ไม่มีการดำเนินการดังกล่าว",
      ],
    },
    weights: [1, 1, 1],
  },
  grouping: {
    data_type: "grouping",
    name: ["personal", "farmer", "basic_info", "info"],
    label: {
      en: ["Personal", "Farmer", "Basic Information", "Additional Information"],
      th: ["ข้อมูลส่วนตัว", "เกษตรกร", "ข้อมูลพื้นฐาน", "ข้อมูลเพิ่มเติม"],
    },
    type: ["segment", "segment", "section", "section"],
  },
  basic_info: {
    data_type: "section",
    type: "section",
    label: {
      en: "Basic Information",
      th: "ข้อมูลพื้นฐาน",
    },
  },
  info: {
    data_type: "section",
    type: "section",
    label: {
      en: "Additional Information",
      th: "ข้อมูลเพิ่มเติม",
    },
  },
  full_name: {
    data_type: "string",
    type: "field",
    label: {
      en: "Full Name",
      th: "ชื่อเต็ม",
    },
    value: "babra",
    required: true,
    score: 1,
    weight: 1,
    segment: ["personal"],
    section: "basic_info",
  },
  gender: {
    data_type: "radio",
    type: "field",
    label: {
      en: "Gender",
      th: "เพศ",
    },
    value: 1,
    options: {
      en: ["Male", "Female"],
      th: ["ชาย", "หญิง"],
    },
    required: true,
    score: 1,
    weights: [1, 1],
    segment: ["personal"],
    section: "basic_info",
  },
  hobbies: {
    data_type: "checkbox",
    type: "field",
    label: {
      en: "Hobbies",
      th: "งานอดิเรก",
    },
    value: [],
    options: {
      en: ["Reading", "Gaming", "Traveling"],
      th: ["อ่านหนังสือ", "เล่นเกม", "ท่องเที่ยว"],
    },
    required: false,
    score: 1,
    weights: [0.5, 0.5, 1],
    segment: ["personal"],
    section: "basic_info",
  },
  occupation: {
    data_type: "select",
    type: "field",
    label: {
      en: "Occupation",
      th: "อาชีพ",
    },
    value: "",
    options: {
      en: ["Select Occupation", "Engineer", "Teacher", "Farmer"],
      th: ["เลือกอาชีพ", "วิศวกร", "ครู", "เกษตรกร"],
    },
    required: true,
    score: 1,
    weights: [0, 1, 1, 1],
    segment: ["personal"],
    section: "basic_info",
  },
  document_attachment: {
    label: {
      en: "Supporting Document",
      th: "เอกสารสนับสนุน",
    },
    type: "attachment",
    value: "111222321222,hjhgjghjg",
    score: 2,
    weight: 1,
    required: true,
    segment: ["farmer"],
    section: "info",
  },
  additional_docs: {
    label: {
      en: "Additional Documents",
      th: "เอกสารเพิ่มเติม",
    },
    type: "attachment",
    value: "doc1.pdf,doc2.pdf",
    score: 1,
    weight: 1,
    required: false,
    segment: ["farmer"],
    section: "info",
  },
  safety_training: {
    data_type: "radio",
    type: "field",
    label: {
      en: "Fire Safety Training?",
      th: "ฝึกอบรมดับเพลิง?",
    },
    value: 2,
    options: {
      en: ["Yes", "No", "In Progress"],
      th: ["ใช่", "ไม่", "กำลังดำเนินการ"],
    },
    required: false,
    score: 1,
    weights: [1, 0, 0.5],
    segment: ["farmer"],
    section: "info",
  },
};
cup = {
  grouping: {
    data_type: "grouping",
    name: ["personal", "farmer", "basic_info", "info"],
    label: {
      en: ["Personal", "Farmer", "Basic Information", "Additional Information"],
      th: ["ข้อมูลส่วนตัว", "เกษตรกร", "ข้อมูลพื้นฐาน", "ข้อมูลเพิ่มเติม"],
    },
    type: ["segment", "segment", "section", "section"],
  },
  basic_info: {
    data_type: "section",
    type: "section",
    label: {
      en: "Basic Information",
      th: "ข้อมูลพื้นฐาน",
    },
  },
  info: {
    data_type: "section",
    type: "section",
    label: {
      en: "Additional Information",
      th: "ข้อมูลเพิ่มเติม",
    },
  },
  full_name: {
    data_type: "string",
    type: "field",
    label: {
      en: "Full Name",
      th: "ชื่อเต็ม",
    },
    value: "babra",
    required: true,
    score: 1,
    weight: 1,
    segment: ["personal"],
    section: "basic_info",
  },
  gender: {
    data_type: "radio",
    type: "field",
    label: {
      en: "Gender",
      th: "เพศ",
    },
    value: 1,
    options: {
      en: ["Male", "Female"],
      th: ["ชาย", "หญิง"],
    },
    required: true,
    score: 1,
    weights: [1, 1],
    segment: ["personal"],
    section: "basic_info",
  },
};
