async function saveToServer(id) {
  if (!navigator.onLine) {
    console.warn("⚠️ Offline — cannot save to server");
    return;
  }

  if (!id) {
    console.warn("⚠️ ID is required");
    return;
  }

  const payload = {
    data: {
      id,
      name: id,
      bucket: JSON.stringify(bucket || {}),
      cup: JSON.stringify(cup || {}),
      board: JSON.stringify(board || {})
    }
  };

  console.log("🚀 Start: save to server");
  const bodySize = new Blob([JSON.stringify(payload)]).size;
  console.log(`📤 Send request... https://j.kunok.com/api62.php`);
  console.log(`Payload size: ${bodySize} bytes`);

  try {
    const startTime = Date.now();
    const response = await fetch("https://j.kunok.com/api62.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify(payload)
    });

    const text = await response.text();
    const responseSize = new Blob([text]).size;
    console.log(`Response size: ${responseSize} bytes`);
    console.log("📖 Read data...");

    if (!response.ok) {
      throw new Error(`HTTP ${response.status}: ${text.slice(0, 100)}...`);
    }

    console.log("✅ Stop read data.");
    const duration = Date.now() - startTime;
    console.log(`✅✅ End: Save completed in ${duration}ms`);
    alert("✅ Saved to server");
  } catch (e) {
    console.error("❌ Save failed:", e.message);
    alert("❌ Save failed: " + e.message);
  }
}


async function loadFromServer(id) {
      //let bucket = {};
  //let cup = {};
  //let board = {};

  if (!navigator.onLine) {
    console.warn("⚠️ Offline — cannot load from server");
    return;
  }

  if (!id) {
    console.warn("⚠️ ID is required");
    return;
  }

  const url = `https://j.kunok.com/api62.php?id=${encodeURIComponent(id)}`;
  console.log("🚀 Start: load from server");
  console.log(`📤 Send request... ${url}`);

  try {
    const startTime = Date.now();
    const response = await fetch(url);
    const text = await response.text();
    const responseSize = new Blob([text]).size;
    console.log(`Response size: ${responseSize} bytes`);
    console.log("📖 Read data...");

    if (!response.ok) {
      throw new Error(`HTTP ${response.status}: ${text.slice(0, 100)}...`);
    }

    const json = JSON.parse(text);
    const data = json?.data;
    if (!data) {
      console.warn("⚠️ No 'data' field in response");
      return;
    }

    const tryParse = (str, name) => {
      try {
        const parsed = JSON.parse(str);
        if (parsed && typeof parsed === "object") {
          console.log(`✅ Loaded schema: ${name}`);
          return parsed;
        }
      } catch (e) {
        console.warn(`⚠️ Failed to parse ${name}`);
      }
      return {};
    };

    bucket = tryParse(data.bucket || "{}", "bucket");
    cup    = tryParse(data.cup    || "{}", "cup");
    board  = tryParse(data.board  || "{}", "board");

    console.log("✅ Stop read data.");
    const duration = Date.now() - startTime;
    console.log(`✅✅ End: Load completed in ${duration}ms`);
  } catch (e) {
    console.error("❌ Load failed:", e.message);
  }
}


// const schema1 = { full_name: "John Doe", key: "test" };
// panel=schema1;
//    saveToServer("123");
async function saveToServerbucket(id) {
  if (!navigator.onLine) {
    console.warn("⚠️ Cannot save: Offline");
    return;
  }

  if (!id) {
    console.warn("⚠️ Cannot save: ID is required");
    return;
  }

  const url = "https://j.kunok.com/api62.php";
  const payload = {
    data: {
      id,
      name: id,
      bucket: JSON.stringify(panel)
    }
  };

  const bodyString = JSON.stringify(payload);
  const bodySize = new Blob([bodyString]).size;

  try {
    console.log("🚀 Start: connect to server");
    const startTime = Date.now();

    console.log(`📤 Send request... ${url}`);
    console.log(`Payload size: ${bodySize} bytes`);
    const response = await fetch(url, {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: bodyString
    });

    console.log("📥 Get response...");
    const text = await response.text();
    const responseSize = new Blob([text]).size;
    console.log(`Response size: ${responseSize} bytes`);

    console.log("📖 Read data...");

    if (!response.ok) {
      throw new Error(`HTTP ${response.status}: ${text.slice(0, 100)}...`);
    }

    console.log("✅ Stop read data.");
    const duration = Date.now() - startTime;
    console.log(`✅✅ End: Save completed in ${duration}ms`);
  } catch (e) {
    console.error("❌ Save failed:", e.message);
  }
}