function makeAvatar(divId, scale = 1) {
  const container = document.getElementById(divId);
  if (!container) return;

  const user_imgr = localStorage.getItem("img") || "";
  let user_img = "https://i.pravatar.cc/40?u=yanyong";
  try {
    if (user_imgr) user_img = atob(user_imgr);
  } catch (e) {
    console.warn("Invalid base64 image, using default:", e);
  }

  const avatar = document.createElement("img");
  avatar.src = user_img;
  avatar.alt = "User Avatar";

  // Initial styling
  avatar.style.width = "28px";
  avatar.style.height = "28px";
  avatar.style.borderRadius = "50%";
  avatar.style.objectFit = "cover";
  avatar.style.border = "1px solid #888";
  avatar.style.cursor = "move";
  avatar.style.display = "inline-block";
  avatar.style.transform = `scale(${scale})`;
  avatar.style.transformOrigin = "top left";
  avatar.title = "Double click to reset";

  // Save original position
  container.style.position = "relative";
  avatar.dataset.originalLeft = "0px";
  avatar.dataset.originalTop = "0px";
  avatar.style.position = "relative";
  avatar.style.left = "0px";
  avatar.style.top = "0px";

  // Dblclick = alert + reset position
  avatar.addEventListener("dblclick", () => {
//    alert(avatar.title || "Avatar");
showUserInfoPanel();
    avatar.style.left = avatar.dataset.originalLeft;
    avatar.style.top = avatar.dataset.originalTop;
  });

  container.style.display = "inline-block";
  container.appendChild(avatar);
}

// Set avatar tooltip
function setAvatarTitle(divId, newTitle) {
  const div = document.getElementById(divId);
  if (!div) return;
  const img = div.querySelector("img");
  if (img) img.title = newTitle;
}

// Make avatar inside given div draggable
function dragOn(divId) {
  const container = document.getElementById(divId);
  if (!container) return;
  const avatar = container.querySelector("img");
  if (!avatar) return;

  let isDragging = false;
  let startX = 0;
  let startY = 0;
  let startLeft = 0;
  let startTop = 0;

  avatar.addEventListener("mousedown", (e) => {
    isDragging = true;
    startX = e.clientX;
    startY = e.clientY;
    startLeft = parseFloat(avatar.style.left) || 0;
    startTop = parseFloat(avatar.style.top) || 0;
    document.body.style.userSelect = "none";
  });

  document.addEventListener("mousemove", (e) => {
    if (!isDragging) return;
    const dx = e.clientX - startX;
    const dy = e.clientY - startY;
    avatar.style.left = startLeft + dx + "px";
    avatar.style.top = startTop + dy + "px";
  });

  document.addEventListener("mouseup", () => {
    if (isDragging) {
      isDragging = false;
      document.body.style.userSelect = "";
    }
  });
}
