(function () {
     const style = document.createElement('style');
  style.textContent = `
    body {
      margin: 0;
      font-family: sans-serif;
    }
    html {
      font-family: sans-serif;
      padding: 20px;
      background: #f4f4f4;
    }
    #smartBar {
      position: fixed;
      top: 0;
      left: 0;
      width: 220px;
      height: 100vh;
      background: #f0f0f0;
      box-shadow: 2px 0 5px rgba(0,0,0,0.2);
      padding: 12px;
      border: 0px solid #ccc;
      box-sizing: border-box;
      display: flex;
      flex-direction: column;
      gap: 10px;
      max-width: 340px;
    }
    .menuGroup {
      margin-bottom: 10px;
    }
    .groupTitle {
      font-weight: bold;
      margin-top: 12px;
      margin-bottom: 6px;
      font-size: 14px;
      color: #444;
    }
    .menuButton {
      background: #fff;
      border: 0px solid #ccc;
      border-radius: 6px;
      padding: 8px 16px;
      margin-bottom: 2px;
      display: flex;
      flex-direction: column;
      cursor: pointer;
      position: relative;
      font-size: 13px;
    }
    .menuTop {
      display: flex;
      align-items: center;
      gap: 8px;
    }
    .badge {
      position: absolute;
      top: 6px;
      right: 10px;
      background: red;
      color: white;
      font-size: 11px;
      border-radius: 12px;
      padding: 1px 4px;
      display: none;
    }
    .icon {
      font-size: 18px;
    }
    .labelText {
      flex-grow: 1;
      font-weight: 500;
    }
    .statusLabel {
      font-size: 11px;
      margin-left: 26px;
    }
    .statusLabel[data-status="done"]    { color: green; }
    .statusLabel[data-status="pending"] { color: orange; }
    .statusLabel[data-status="start"]   { color: gray; }
    .statusLabel[data-status="in progress"] { color: dodgerblue; }
    .progressBar {
      height: 6px;
      background: #ddd;
      border-radius: 3px;
      overflow: hidden;
      margin-left: 26px;
      margin-right: 8px;
    }
    .progressInner {
      height: 100%;
      background: #007bff;
      width: 0%;
      transition: width 0.3s;
    }
    .checklistItem {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-left: 26px;
      font-size: 13px;
      color: #333;
    }
    .lang-toggle {
      display: flex;
      align-items: center;
      gap: 10px;
      padding: 2px 6px;
      cursor: pointer;
      font-size: 13px;
    }
    .lang-switch {
      position: relative;
      display: inline-block;
      width: 40px;
      height: 20px;
    }
    .lang-switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }
    .lang-slider {
      position: absolute;
      cursor: pointer;
      top: 0; left: 0; right: 0; bottom: 0;
      background-color: #bbb;
      transition: 0.3s;
      border-radius: 20px;
    }
    .lang-slider:before {
      position: absolute;
      content: "";
      height: 14px;
      width: 14px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: 0.3s;
      border-radius: 50%;
    }
    .lang-switch input:checked + .lang-slider {
      background-color: #6da7ff;
    }
    .lang-switch input:checked + .lang-slider:before {
      transform: translateX(20px);
    }
    .lang-label {
      font-size: 12px;
      color: #444;
      user-select: none;
    }
    .bottomBar {
      margin-top: auto;
      display: flex;
      flex-direction: column;
      gap: 4px;
    }
    .statusDisplay {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 12px;
      background: #fff;
      padding: 5px;
      border-radius: 5px;
      color: #333;
    }
    .statusDot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
    }
    .greenDot {
      background: green;
    }
    .redDot {
      background: red;
    }
    .bottomRow {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    #avatar {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: url('https://i.pravatar.cc/24') no-repeat center;
      background-size: cover;
    }
    #loginToggle {
      font-size: 12px;
      cursor: pointer;
      color: #007BFF;
    }
    #toggleBarWrapper {
      display: flex;
      align-items: center;
      gap: 10px;
      padding: 6px 12px;
    }
  `;
  document.head.appendChild(style);
  const menuData = [
    {
      group: "Main",
      items: [
        {
          item: "A1",
          icon: "💎",
          text: "KTB2025",
          badgeCount: 1,
          progress: 45,
          status: "in progress",
          onclick: () => loadAndUpdateSummaries(userid)
        }
      ]
    },
    {
      group: "Tracking",
      items: [
        {
          item: "assessment",
          icon: "📦",
          text: "Assessment",
          status: "pending",
          progress: 10,
          onclick: () => { PanelTR(); genpaN(userid); },
        },
        {
          item: "Profile",
          icon: "💳",
          text: "Profile",
          status: "done",
          progress: 100,
          onclick: () => { PanelTR(); profilepaN(userid); }
        }
      ]
    },
    {
      group: " Actions",
      items: [
        {
          item: "save",
          icon: "💾",
          text: "save",
          badgeCount: 2,
          onclick: () => saveToServerM(userid)
        },
      ]
    },
    {
      group: "User Actions",
      items: [
        {
          item: "profile",
          icon: "👤",
          text: "User Profile",
          badgeCount: 2,
          onclick: () => showUserUpdatePanel()
        },
        {
          item: "settings",
          icon: "⚙️",
          text: "Settings",
          badgeCount: 1,
          onclick: () => loadAndUpdateGS(userid)
        }
      ]
    }
  ];

  function renderMenu() {
    const bar = document.getElementById('smartBarIn');
    bar.innerHTML = '';

    menuData.forEach(group => {
      const groupDiv = document.createElement('div');
      groupDiv.className = 'menuGroup';

      const title = document.createElement('div');
      title.className = 'groupTitle';
      title.textContent = group.group;
      groupDiv.appendChild(title);

      group.items.forEach(item => {
        const btn = document.createElement('div');
        btn.className = 'menuButton';
        btn.id = item.item;

        const topRow = document.createElement('div');
        topRow.className = 'menuTop';
        topRow.innerHTML = `
          <span class="icon">${item.icon || ''}</span>
          <span class="labelText">${item.text || item.item}</span>
          <span class="badge" id="badge_${item.item}">${item.badgeCount || ''}</span>
        `;
        btn.appendChild(topRow);

        if (item.status) {
          const status = document.createElement('div');
          status.className = 'statusLabel';
          status.setAttribute("id", `status_${item.item}`);
          status.setAttribute("data-status", item.status.toLowerCase());
          status.textContent = item.status;
          btn.appendChild(status);
        }

        if (typeof item.progress === 'number') {
          const progressBar = document.createElement('div');
          progressBar.className = 'progressBar';

          const progressInner = document.createElement('div');
          progressInner.className = 'progressInner';
          progressInner.style.width = `${item.progress}%`;
          progressInner.id = `progress_${item.item}`;

          progressBar.appendChild(progressInner);
          btn.appendChild(progressBar);
        }

        if (item.checklist) {
          const checkDiv = document.createElement('div');
          checkDiv.className = 'checklistItem';

          const checkbox = document.createElement('input');
          checkbox.type = 'checkbox';
          checkbox.checked = !!item.checked;
          checkbox.id = `check_${item.item}`;
          checkbox.addEventListener('change', () => {
            item.checked = checkbox.checked;
            alert(`Checklist ${item.item}: ${checkbox.checked ? 'Done' : 'Not Done'}`);
          });

          const label = document.createElement('label');
          label.textContent = "Complete?";
          label.setAttribute("for", checkbox.id);

          checkDiv.appendChild(checkbox);
          checkDiv.appendChild(label);
          btn.appendChild(checkDiv);
        }

        if (typeof item.onclick === 'function') {
          btn.addEventListener('click', item.onclick);
        }

        groupDiv.appendChild(btn);
        updateBadge(item.item, item.badgeCount || 0);
      });

      bar.appendChild(groupDiv);
    });
  }

  function updateBadge(id, count) {
    const badge = document.getElementById(`badge_${id}`);
    if (!badge) return;
    badge.textContent = count;
    badge.style.display = count > 0 ? 'inline-block' : 'none';
  }

  
function updateProgress(id, percent) {
  const progress = document.getElementById(`progress_${id}`);
  if (progress) {
    const clamped = Math.min(percent, 100); // ⛑ cap at 100
    progress.style.width = `${clamped}%`;
    progress.title = `${percent}%`; // Optional: show actual value on hover
  }
}
window.updateProgress = updateProgress;

  function updateStatus(id, status) {
    const statusDiv = document.getElementById(`status_${id}`);
    if (statusDiv) {
      statusDiv.textContent = status;
      statusDiv.setAttribute('data-status', status.toLowerCase());
    }
  }

  function updateChecklist(id, isChecked) {
    const checkbox = document.getElementById(`check_${id}`);
    if (checkbox) checkbox.checked = !!isChecked;
  }

  function runRandomUpdates() {
    menuData.forEach(group => {
      group.items.forEach(item => {
        const randBadge = Math.floor(Math.random() * 5);
        const randProgress = Math.floor(Math.random() * 101);
        const statuses = ['pending', 'in progress', 'start', 'done'];
        const randStatus = statuses[Math.floor(Math.random() * statuses.length)];
        const randCheck = Math.random() > 0.5;

        updateBadge(item.item, randBadge);
        if ('progress' in item) updateProgress(item.item, randProgress);
        if ('status' in item) updateStatus(item.item, randStatus);
        if (item.checklist) updateChecklist(item.item, randCheck);
      });
    });
  }

  // Initialize
  renderMenu();
  window.runRandomUpdates = runRandomUpdates; // expose if needed globally
})();

