  const hourHand = document.getElementById('hourHand');
    const minuteHand = document.getElementById('minuteHand');
    const secondHand = document.getElementById('secondHand');
    const digitalClock = document.getElementById('digitalClock');
    const countdown = document.getElementById('countdown');
    const dateInfo = document.getElementById('dateInfo');
    const dayInfo = document.getElementById('dayInfo');
    const dayNight = document.getElementById('dayNight');
    const dayNightIndicator = document.getElementById('dayNightIndicator');
    const analogClock = document.getElementById("analogClock");
    const expireDate = new Date("2025-12-31T23:59:59");

    // ✅ Apply scale factor
    const scaleFactor = 1; // Change to 1.0, 0.8, 2.0, etc.
    document.getElementById("clockScale").style.transform = `scale(${scaleFactor})`;

    function padZero(num) {
      return num < 10 ? `0${num}` : num;
    }

    function createNumbers(large = false, radius = 93) {
      for (let i = 1; i <= 12; i++) {
        const num = document.createElement("div");
        num.className = "clock-number";
        num.textContent = i;

        const angle = (i - 3) * 30;
        const x = 120 + radius * Math.cos(angle * Math.PI / 180);
        const y = 120 + radius * Math.sin(angle * Math.PI / 180);

        num.style.left = `${x}px`;
        num.style.top = `${y}px`;

        if (large && [3, 6, 9, 12].includes(i)) {
          num.classList.add("large");
        }

        analogClock.appendChild(num);
      }
    }

    function createTicks() {
      for (let i = 0; i < 60; i++) {
        const tick = document.createElement("div");
        tick.className = (i % 5 === 0) ? "tickHour" : "tick";
        tick.style.transform = `rotate(${i * 6}deg) translate(-50%, 0)`;
        analogClock.appendChild(tick);
      }
    }

    let countdownEndTime = new Date();
    countdownEndTime.setHours(countdownEndTime.getHours() + 1);

    function updateCountdown() {
      const now = new Date();
      const diff = countdownEndTime - now;

      if (diff <= 0) {
        countdown.textContent = "Countdown: 00:00:00";
        countdownEndTime = new Date();
        countdownEndTime.setHours(countdownEndTime.getHours() + 1);
        return;
      }

      const hours = Math.floor(diff / (1000 * 60 * 60));
      const minutes = Math.floor((diff % (1000 * 60 * 60)) / (1000 * 60));
      const seconds = Math.floor((diff % (1000 * 60)) / 1000);

      countdown.textContent = `Countdown: ${padZero(hours)}:${padZero(minutes)}:${padZero(seconds)}`;
    }

    function updateClock() {
      const now = new Date();
      const hour = now.getHours();
      const isDay = hour >= 6 && hour < 18;
      dayNightIndicator.className = isDay ? "day-night-indicator day" : "day-night-indicator night";

      const ms = now.getMilliseconds();
      const sec = now.getSeconds() + ms / 1000;
      const min = now.getMinutes() + sec / 60;
      const hr = now.getHours() % 12 + min / 60;

      hourHand.style.transform = `rotate(${hr * 30}deg)`;
      minuteHand.style.transform = `rotate(${min * 6}deg)`;
      secondHand.style.transform = `rotate(${sec * 6}deg)`;

      const pad = (n) => n.toString().padStart(2, '0');
      digitalClock.textContent = `${pad(now.getHours())}:${pad(now.getMinutes())}:${pad(now.getSeconds())}`;

      const days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
      const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
      dateInfo.textContent = `Date: ${now.getDate()} ${months[now.getMonth()]} ${now.getFullYear()}`;
      dayInfo.textContent = `${days[now.getDay()]}`;
      dayNight.textContent = `${hour >= 6 && hour < 18 ? "Day" : "Night"}`;

      const diff = expireDate - now;
      if (diff <= 0) {
        document.getElementById('countdown').textContent = "Countdown: EXPIRED";
        document.getElementById('expiredMsg').style.display = "block";
      } else {
        document.getElementById('expiredMsg').style.display = "none";
        const daysLeft = Math.floor(diff / (1000 * 60 * 60 * 24));
        const hoursLeft = Math.floor((diff / (1000 * 60 * 60)) % 24);
        const minsLeft = Math.floor((diff / (1000 * 60)) % 60);
        const secsLeft = Math.floor((diff / 1000) % 60);
        document.getElementById('countdown').textContent =
          `Countdown: ${daysLeft}d ${padZero(hoursLeft)}h ${padZero(minsLeft)}m ${padZero(secsLeft)}s`;
      }

      requestAnimationFrame(updateClock);
    }