// Create or update notification badge
// Create or update notification badge
function updateBadge(elementId, count) {
  // Special handling for menu items
 if (elementId.startsWith('menuContainer-')) {
    updateMenuBadge(elementId, count);
    return;
  }

  const container = document.getElementById(elementId);
  if (!container) return;

  // Check element types
  const isTriggerIcon = elementId === 'triggerIcon';
  const isCircleBtn = container.classList.contains('circle-btn');
  const isMenuItem = container.classList.contains('menu-item');

  // Set container styles
  container.style.position = 'relative';
  container.style.display = isTriggerIcon ? 'block' : 'inline-flex';
  if (!isTriggerIcon) {
    container.style.alignItems = 'center';
    container.style.justifyContent = 'center';
  }
  container.classList.add('badge-container');

  // Find or create badge element
  let badge = container.querySelector('.notification-badge');
  if (!badge) {
    badge = document.createElement('span');
    badge.className = 'notification-badge';
    container.appendChild(badge);
  }

  // Set badge content
  badge.textContent = count > 9 ? '9+' : count;
  
  // Position and style the badge
  badge.style.cssText = `
    position: absolute;
    top: ${isTriggerIcon ? '-4px' : isCircleBtn ? '-4px' : '-6px'};
    right: ${isTriggerIcon ? '-4px' : isCircleBtn ? '-4px' : '-6px'};
    min-width: ${isTriggerIcon ? '20px' : isCircleBtn ? '14px' : '16px'};
    height: ${isTriggerIcon ? '20px' : isCircleBtn ? '14px' : '16px'};
    padding: 0 ${isTriggerIcon ? '4px' : isCircleBtn ? '2px' : '4px'};
    background: #e31515;
    color: white;
    border-radius: 50%;
    display: ${count === 0 ? 'none' : 'flex'};
    align-items: center;
    justify-content: center;
    font-size: ${isTriggerIcon ? '12px' : isCircleBtn ? '10px' : '10px'};
    font-weight: bold;
    font-family: Arial, sans-serif;
    box-sizing: border-box;
    z-index: 100;
    pointer-events: none;
    border: ${isTriggerIcon || isCircleBtn ? '2px solid white' : 'none'};
  `;
}

// Special handler for menu item badges
function updateMenuBadgeAA(menuItemId, count) {
  const menuItem = document.getElementById(menuItemId);
  if (!menuItem) return;

  let badge = menuItem.querySelector('.badge');
  if (!badge) {
    badge = document.createElement('span');
    badge.className = 'badge';
    menuItem.appendChild(badge);
  }

  badge.textContent = count > 9 ? '9+' : count;
  badge.style.display = count === 0 ? 'none' : 'inline-block';
}
function updateBadgeX(elementId, count) {
  // Special handling for menu items
  if (elementId.startsWith('menuContainer-')) {
    updateMenuBadge(elementId, count);
    return;
  }

  // ... rest of your existing non-menu badge code ...
}

function updateMenuBadge(menuItemId, count) {
  const menuItem = document.getElementById(menuItemId);
  if (!menuItem) {
    console.warn(`Menu item not found: ${menuItemId}`);
    return;
  }

  // Find or create the menu-text container
  let menuText = menuItem.querySelector('.menu-text');
  if (!menuText) {
    menuText = document.createElement('div');
    menuText.className = 'menu-text';
    menuItem.appendChild(menuText);
  }

  // Find or create the badge element
  let badge = menuText.querySelector('.badge');
  if (!badge) {
    badge = document.createElement('span');
    badge.className = 'badge';
    menuText.appendChild(badge);
  }

  // Update badge content and visibility
  badge.textContent = count > 9 ? '9+' : count;
  badge.style.display = count > 0 ? 'inline-block' : 'none';
  
  // Ensure proper badge styling
  badge.style.cssText = `
    display: ${count > 0 ? 'inline-block' : 'none'};
    background-color: #e31515;
    color: white;
    border-radius: 10px;
    padding: 2px 6px;
    font-size: 12px;
    margin-left: 8px;
    vertical-align: middle;
  `;
}
// Initialize default styles

function updateMenuBadge(menuItemId, count) {
  // Handle both item and badge IDs
  const baseId = menuItemId.replace('-badge', '');
  const menuItem = document.getElementById(baseId);
  
  if (!menuItem) {
    console.warn(`Menu item not found: ${baseId}`);
    return;
  }

  // Find the badge element
  let badge = document.getElementById(`${baseId}-badge`);
  if (!badge) {
    const menuText = menuItem.querySelector('.menu-text');
    if (menuText) {
      badge = document.createElement('span');
      badge.className = 'badge';
      badge.id = `${baseId}-badge`;
      menuText.appendChild(badge);
    }
  }

  if (badge) {
    badge.textContent = count > 9 ? '9+' : count;
    badge.style.display = count > 0 ? 'inline-block' : 'none';
  }
}
// Initialize when DOM is loaded
//document.addEventListener('DOMContentLoaded', initStyles);

// Update button/container content
function updateButton(elementId, icon, text) {
  const element = document.getElementById(elementId);
  if (element) {
    element.innerHTML = `${icon} ${text} <span class="notification-badge"></span>`;
  }
}

// Update element styles
function updateStyle(elementId, style) {
  const element = document.getElementById(elementId);
  if (element) {
    element.style.cssText = style;
  }
}

// Initialize default styles if needed
function initStyles() {
  const style = document.createElement('style');
  style.textContent = `
    .notification-badge {
      position: absolute;
      top: -6px;
      right: -6px;
      min-width: 16px;
      height: 16px;
      padding: 0 4px;
      background: #e31515;
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 10px;
      font-weight: bold;
      font-family: Arial, sans-serif;
      box-sizing: border-box;
      z-index: 100;
      pointer-events: none;
    }
    
    #triggerIcon .notification-badge {
      top: -4px;
      right: -4px;
      min-width: 20px;
      height: 20px;
      font-size: 12px;
      border: 2px solid white;
    }
    
    .badge-container {
      position: relative;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      margin-right: 12px;
      padding-right: 6px;
    }
    
    #triggerIcon.badge-container {
      display: block;
      width: 60px;
      height: 60px;
      padding-right: 0;
    }
    
    .username-wrapper {
      position: relative;
      display: inline-flex;
      align-items: center;
      min-width: 50px;
      padding-right: 10px;
    }
    
    .other-group {
      display: flex;
      align-items: center;
      gap: 8px;
      overflow: visible;
    }
    
    .bar-left {
      display: flex;
      align-items: center;
      gap: 4px;
      overflow: visible;
    }

    /* Tooltip Styles */
    .tooltip {
      position: relative;
      display: inline-block;
      margin: 30px;
      cursor: pointer;
    }

    .tooltip .tooltiptext {
      width: 120px;
      color: #fff;
      text-align: center;
      border-radius: 6px;
      padding: 5px 0;
      position: absolute;
      z-index: 1;
      visibility: visible;
    }

    .tooltip .tooltiptext.hover {
      visibility: hidden;
    }
    .tooltip:hover .tooltiptext.hover {
      visibility: visible;
    }

    .tooltip .tooltiptext.top {
      bottom: 125%;
      left: 50%;
      transform: translateX(-50%);
    }

    .tooltip .tooltiptext.right {
      top: 50%;
      left: 110%;
      transform: translateY(-50%);
    }

    .tooltip .tooltiptext.bottom {
      top: 125%;
      left: 50%;
      transform: translateX(-50%);
    }

    .tooltip .tooltiptext.left {
      top: 50%;
      right: 110%;
      transform: translateY(-50%);
    }

    .tooltip .tooltiptext.red { background-color: #ff4444; }
    .tooltip .tooltiptext.blue { background-color: #4444ff; }
    .tooltip .tooltiptext.green { background-color: #44aa44; }
    .tooltip .tooltiptext.purple { background-color: #aa44aa; }
    .tooltip .tooltiptext.orange { background-color: #ffaa44; }
    .tooltip .tooltiptext.gray { background-color: #666666; }

    .tooltip .tooltiptext::after {
      content: "";
      position: absolute;
      border-width: 5px;
      border-style: solid;
    }

    .tooltip .tooltiptext.left::after {
      top: 50%;
      left: 100%;
      margin-top: -5px;
      border-color: transparent transparent transparent;
    }
    .tooltip .tooltiptext.left.red::after { border-left-color: #ff4444; }
    .tooltip .tooltiptext.left.blue::after { border-left-color: #4444ff; }
    .tooltip .tooltiptext.left.green::after { border-left-color: #44aa44; }
    .tooltip .tooltiptext.left.purple::after { border-left-color: #aa44aa; }
    .tooltip .tooltiptext.left.orange::after { border-left-color: #ffaa44; }
    .tooltip .tooltiptext.left.gray::after { border-left-color: #666666; }

    .tooltip .tooltiptext.right::after {
      top: 50%;
      right: 100%;
      margin-top: -5px;
      border-color: transparent transparent transparent;
    }
    .tooltip .tooltiptext.right.red::after { border-right-color: #ff4444; }
    .tooltip .tooltiptext.right.blue::after { border-right-color: #4444ff; }
    .tooltip .tooltiptext.right.green::after { border-right-color: #44aa44; }
    .tooltip .tooltiptext.right.purple::after { border-right-color: #aa44aa; }
    .tooltip .tooltiptext.right.orange::after { border-right-color: #ffaa44; }
    .tooltip .tooltiptext.right.gray::after { border-right-color: #666666; }

    .tooltip .tooltiptext.top::after {
      top: 100%;
      left: 50%;
      margin-left: -5px;
      border-color: transparent transparent transparent;
    }
    .tooltip .tooltiptext.top.red::after { border-top-color: #ff4444; }
    .tooltip .tooltiptext.top.blue::after { border-top-color: #4444ff; }
    .tooltip .tooltiptext.top.green::after { border-top-color: #44aa44; }
    .tooltip .tooltiptext.top.purple::after { border-top-color: #aa44aa; }
    .tooltip .tooltiptext.top.orange::after { border-top-color: #ffaa44; }
    .tooltip .tooltiptext.top.gray::after { border-top-color: #666666; }

    .tooltip .tooltiptext.bottom::after {
      bottom: 100%;
      left: 50%;
      margin-left: -5px;
      border-color: transparent transparent transparent;
    }
    .tooltip .tooltiptext.bottom.red::after { border-bottom-color: #ff4444; }
    .tooltip .tooltiptext.bottom.blue::after { border-bottom-color: #4444ff; }
    .tooltip .tooltiptext.bottom.green::after { border-bottom-color: #44aa44; }
    .tooltip .tooltiptext.bottom.purple::after { border-bottom-color: #aa44aa; }
    .tooltip .tooltiptext.bottom.orange::after { border-bottom-color: #ffaa44; }
    .tooltip .tooltiptext.bottom.gray::after { border-bottom-color: #666666; }
  `;
  document.head.appendChild(style);
}
// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', initStyles);