function addStyle(css) {
  const style = document.createElement('style');
  style.textContent = css;
  document.head.appendChild(style);
}


function createSmartBarElements() {
  const wrapper = document.createElement('div');
  wrapper.innerHTML = `
    <div id="pillBar">
      <div id="triggerIcon" title="Drag me!"></div>
      <div id="smartBar">        
        <div class="bar-left">
          <button class="toggleBtn" title="Expand/Collapse" id="toggleBarBtn"></button>    
          <div id="otherGroup" class="other-group">
            <div class="menuButton" id="menuButton">Menu</div>
            <button class="btn circle-btn" id="exButton"></button>
            <span class="label">[info]</span>
            <span class="username" id="username">User</span>
            <button class="btn circle-btn" id="langBtn"></button>
            <button class="btn circle-btn" id="logoutBtn"></button>
            <button class="btn circle-btn" id="clearBtn"></button>
          </div>
        </div>
      </div>
    </div>
    <div id="barPanel" class="bar-panel"></div>
    <div id="menuContainer" class="menu-container"></div>
    <div id="menuOverlay" class="menu-overlay"></div>
  `;
  document.body.appendChild(wrapper);
}
function renderMenu(data, container) {
  container.innerHTML = "";
  data.forEach((group, groupIndex) => {
    const groupDiv = document.createElement("div");
    groupDiv.className = "menu-group";
    group.items.forEach((entry, itemIndex) => {
      const item = document.createElement("div");
      item.className = "menu-item";
      item.id = `menuContainer-${entry.item}`; // This ID is important

      item.innerHTML = `
        <div class="menu-icon">${entry.icon}</div>
        <div class="menu-text">
          ${entry.text}
          <!-- Badge will be inserted here by updateBadge -->
        </div>
      `;

      item.onclick = () => {
        entry.onclick();
        if (container === menuContainer) {
          closeMenu();
        }
      };
      groupDiv.appendChild(item);
    });
    container.appendChild(groupDiv);
  });
}
function listenSmartBar() {
  const toggleBarBtn = document.getElementById("toggleBarBtn");
  const menuButton = document.getElementById("menuButton");
  const exButton = document.getElementById("exButton");

  toggleBarBtn.addEventListener("click", function () {
    const oldWidth = smartBar.offsetWidth;
    const isExpanding = oldWidth <= 150;
    const newWidth = isExpanding ? 300 : 100;

    const zone = getZone(trigger.getBoundingClientRect());
    const currentLeft = parseInt(smartBar.style.left || "0");

    if (["TR", "CR", "BR"].includes(zone)) {
      smartBar.style.left = isExpanding
        ? currentLeft - (newWidth - oldWidth) + "px"
        : currentLeft + (oldWidth - newWidth) + "px";
    }

    smartBar.style.width = newWidth + "px";
    positionSmartBar();
    if (barPanelVisible) positionBarPanel();
    saveSmartBarState();
  });

  exButton.addEventListener("click", function () {
    if (justDragged) {
      justDragged = false;
      return;
    }
    barPanelVisible = !barPanelVisible;
    barPanel.style.display = barPanelVisible ? "block" : "none";
    if (barPanelVisible) positionBarPanel();
  });

  menuButton.addEventListener("click", function (e) {
    const show = menuContainer.style.display !== "block";
    menuContainer.style.display = show ? "block" : "none";
    menuOverlay.style.display = show ? "block" : "none";
    if (show) {
      renderMenu(menuData, menuContainer);
      positionMenuSmart(e.target);
    }
  });

  menuOverlay.addEventListener("click", function () {
    menuContainer.style.display = "none";
    menuOverlay.style.display = "none";
  });
}
function positionMenuSmart(triggerEl) {
  const iconRect = triggerEl.getBoundingClientRect();
  const menu = menuContainer;
  const menuWidth = menu.offsetWidth || 180;
  const menuHeight = menu.offsetHeight || 200;
  const zone = getZone(iconRect);
  let top = 0, left = 0;

  switch (zone) {
    case "TL":
    case "TC":
      top = iconRect.bottom + 8;
      left = iconRect.left;
      break;
    case "TR":
      top = iconRect.bottom + 8;
      left = iconRect.right - menuWidth;
      break;
    case "CL":
    case "CR":
    case "CC":
      top = iconRect.bottom + 8;
      left = iconRect.left;
      break;
    case "BL":
    case "BC":
    case "BR":
      top = iconRect.top - menuHeight - 8;
      left = iconRect.left;
      break;
  }

  top = Math.max(0, Math.min(top, window.innerHeight - menuHeight - 10));
  left = Math.max(0, Math.min(left, window.innerWidth - menuWidth - 10));

  menu.style.top = `${top}px`;
  menu.style.left = `${left}px`;
}
function getZone(rect) {
  const centerX = rect.left + rect.width / 2;
  const centerY = rect.top + rect.height / 2;
  const thirdW = window.innerWidth / 3;
  const thirdH = window.innerHeight / 3;
  const horiz = centerX < thirdW ? "L" : centerX < thirdW * 2 ? "C" : "R";
  const vert = centerY < thirdH ? "T" : centerY < thirdH * 2 ? "C" : "B";
  return vert + horiz;
}

// --- INIT
let smartBarMode = true;
let justDragged = false;
let barPanelVisible = false;

 const menuData = [
            {
                group: "View Options",
                items: [
                    {
                        item: "togglebar",
                        icon: "🟦",
                        text: "Assessment",
                        onclick: () => {
                            smartBarMode = true;
                            menuContainer.style.display = "none";
                            menuOverlay.style.display = "none";
                            saveSmartBarState();
                        },
                    },
                    {
                        item: "togglelist",
                        icon: "📋",
                        text: "Profile",
                        onclick: () => alert("Switched to list (simulated)"),
                    },
                ],
            },
            {
                group: "User Actions",
                items: [
                    {
                        item: "profile",
                        icon: "👤",
                        text: "User",
                        onclick: () => alert("Profile clicked"),
                    },
                    {
                        item: "settings",
                        icon: "⚙️",
                        text: "Settings",
                        onclick: () => alert("Settings clicked"),
                    },
                ],
            },
            {
                group: "Support",
                items: [
                    {
                        item: "help",
                        icon: "❓",
                        text: "Help",
                        onclick: () => alert("Help clicked"),
                    },
                    {
                        item: "logout",
                        icon: "🚪",
                        text: "Logout",
                        onclick: () => alert("Logged out"),
                    },
                ],
            },
        ];
