// avatar.js
(function () {
   
  // CSS Styles
  const style = document.createElement("style");
  style.textContent = `
    #avt_myDiv {
      position: fixed;
      height: 60px;
      display: flex;
      align-items: center;
      border-radius: 8px;
      padding: 5px;
      cursor: grab;
      user-select: none;
      z-index: 1000;
      transition: flex-direction 0.2s ease;
      //background: rgba(255,255,255,0.9);
      //box-shadow: 0 2px 10px rgba(0,0,0,0.2);
    }
    #avt_avatar {
      width: 50px;
      height: 50px;
      border-radius: 50%;
      background-color: #ccc;
      background-size: cover;
      background-position: center;
      background-repeat: no-repeat;
      box-shadow: 0 2px 5px rgba(0,0,0,0.2);
      cursor: pointer;
      flex-shrink: 0;
      position: relative;
    }
    #avt_rightContent {
      width: 200px;
      height: 100%;
      background: white;
      margin-left: 8px;
      margin-right: 8px;
      padding: 8px;
      border-radius: 8px;
      box-shadow: 0 4px 10px rgba(0,0,0,0.2);
      display: flex;
      flex-direction: column;
      justify-content: center;
      transition: opacity 0.2s ease, visibility 0.2s ease;
    }
    #avt_rightContent.hidden {
      opacity: 0;
      visibility: hidden;
      display: none;
    }
    #avt_info {
      font-size: 12px;
    }
    .btns {
      margin-top: 6px;
      display: flex;
      gap: 4px;
      flex-wrap: wrap;
      align-items: center;
    }
    button {
      font-size: 11px;
      padding: 3px 6px;
      border: none;
      border-radius: 4px;
      background: #2196F3;
      color: white;
      cursor: pointer;
    }
    .btnReset {
      background: #9e9e9e;
    }
    .btnHide, #avt_closePanelBtn {
      background: #f44336;
      border-radius: 50%;
      width: 18px;
      height: 18px;
      line-height: 20px;
      padding: 0;
      margin-left: auto;
    }
    #avt_panel {
      position: absolute;
      width: 200px;
      height: 200px;
      background: #3f51b5;
      color: white;
      border-radius: 8px;
      padding: 10px;
      display: none;
      opacity: 0;
      transition: transform 0.3s ease, opacity 0.3s ease;
      z-index: 1001;
    }
    #avt_panel.show {
      display: block;
      opacity: 1;
      transform: translateY(0);
    }
    #avt_closePanelBtn {
      position: absolute;
      top: 8px;
      right: 5px;
      background: rgba(0,0,0,0.2);
      color: white;
      border: none;
      font-size: 16px;
      font-weight: bold;
      cursor: pointer;
      padding: 2px 6px;
      border-radius: 50%;
      line-height: 1;
    }
    .notification-badge {
      position: absolute;
      top: -6px;
      right: -6px;
      width: 20px;
      height: 20px;
      background: red;
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 12px;
      font-weight: bold;
      line-height: 1;
      border: 2px solid white;
      z-index: 1001;
    }
    .notification-badge.hidden {
      display: none;
    }
  `;
  document.head.appendChild(style);
 
  // Create UI Elements
  const div = document.createElement("div");
  div.id = "avt_myDiv";
  div.innerHTML = `
    <div id="avt_avatar" title="Double-click to toggle info">
      <span class="notification-badge hidden"></span>
    </div>
    <div id="avt_rightContent">
      <div id="avt_info">
        <div id="avt_userName"><strong>User</strong></div>
        <div id="avt_userInfo">Info here</div>
      </div>
      <div class="btns">
        <button id="avt_togglePanelBtn">Panel</button>
        <button class="btnReset" id="avt_resetBtn">R</button>
        <button class="btnLANG" id="avt_btnLANG">L</button>
        <button class="btnHide" id="avt_hideBtn"></button>
        <button onclick="nnn()">Click me</button>

      </div>
    </div>
  `;
 
  const panel = document.createElement("div");
  panel.id = "avt_panel";
  panel.innerHTML = `
    <button id="avt_closePanelBtn" title="Close Panel">×</button>
    <div id="avt_panel_body">
      <h3>Notification Panel</h3>
      <div id="avt_notifications"></div>
      <button id="avt_clearNotifications">Clear All</button>
    </div>
  `;
  
  document.body.appendChild(div);
  document.body.appendChild(panel);

  // DOM Elements
  const avatar = document.getElementById('avt_avatar');
  const rightContent = document.getElementById('avt_rightContent');
  const panelEl = document.getElementById('avt_panel');
  const toggleBtn = document.getElementById('avt_togglePanelBtn');
  const hideBtn = document.getElementById('avt_hideBtn');
  const resetBtn = document.getElementById('avt_resetBtn');
  const langBtn = document.getElementById('avt_btnLANG');
  const closeBtn = document.getElementById('avt_closePanelBtn');
  const badge = avatar.querySelector('.notification-badge');
    const notificationsPanel = document.getElementById('avt_notifications');

  const clearBtn = document.getElementById('avt_clearNotifications');

  // Initialize Avatar
  function initAvatar() {
    // Set avatar image
    const user_imgr = localStorage.getItem("img") || "https://i.pravatar.cc/80";
    let user_img;
    try {
      user_img = atob(user_imgr);
    } catch {
      user_img = "https://i.pravatar.cc/80?u=yanyong";
    }
    avatar.style.backgroundImage = `url(${user_img})`;
    
    // Load position and visibility
    loadPosition();
    loadVisibility();
    
    // Initialize language
    window.lang = localStorage.getItem("lang") || "en";
    updateLangButton();
  }
  
 // Notification functions
  window.avatarNotifications = {
    add: function(message) {
      const notification = document.createElement('div');
      notification.className = 'notification';
      notification.textContent = message;
      notificationsPanel.appendChild(notification);
      
      // Update badge count
      const count = notificationsPanel.children.length;
      updateBadge('avt_avatar', count);
    },
    clear: function() {
      notificationsPanel.innerHTML = '';
      updateBadge('avt_avatar', 0);
    }
  };
    clearBtn.addEventListener('click', avatarNotifications.clear);

  // Position Management
  function loadPosition() {
    const savedX = localStorage.getItem("myDivX");
    const savedY = localStorage.getItem("myDivY");
    const defaultX = 20;
    const defaultY = window.innerHeight - 80;

    if (savedX !== null && savedY !== null) {
      const parsedX = parseInt(savedX);
      const parsedY = parseInt(savedY);
      
      if (checkAvatarPosition(parsedX, parsedY)) {
        div.style.left = savedX + "px";
        div.style.top = savedY + "px";
      } else {
        localStorage.removeItem("myDivX");
        localStorage.removeItem("myDivY");
        div.style.left = defaultX + "px";
        div.style.top = defaultY + "px";
      }
    } else {
      div.style.left = defaultX + "px";
      div.style.top = defaultY + "px";
    }
    
    updateDirection();
  }

  function loadVisibility() {
    const hiddenState = localStorage.getItem("avt_rightContent_hidden");
    if (hiddenState === "1") {
      rightContent.classList.add("hidden");
      isHidden = true;
    } else {
      rightContent.classList.remove("hidden");
      isHidden = false;
    }
  }

  // Drag Functionality
  let offsetX = 0, offsetY = 0, dragging = false;
  let isHidden = false;

  div.addEventListener("mousedown", (e) => {
    if (e.target.tagName === "BUTTON") return;
    dragging = true;
    offsetX = e.clientX - div.offsetLeft;
    offsetY = e.clientY - div.offsetTop;
    div.style.cursor = "grabbing";
  });

  document.addEventListener("mouseup", () => {
    if (dragging) {
      localStorage.setItem("myDivX", div.offsetLeft);
      localStorage.setItem("myDivY", div.offsetTop);
      localStorage.setItem("avt_rightContent_hidden", isHidden ? "1" : "0");
    }
    dragging = false;
    div.style.cursor = "grab";
  });

  document.addEventListener("mousemove", (e) => {
    if (!dragging) return;
    const pos = clampToViewport(e.clientX - offsetX, e.clientY - offsetY, div);
    div.style.left = pos.x + "px";
    div.style.top = pos.y + "px";
    updateDirection();
    if (panelEl.classList.contains("show")) positionPanel();
  });

  // UI Interactions
  function toggleInfo() {
    const mouseX = event ? event.clientX : 0;
    if (mouseX + 240 > window.innerWidth) return;

    if (window.avatarOnRight && !isHidden) {
      rightContent.style.visibility = "visible";
      return;
    }

    rightContent.classList.toggle("hidden");
    isHidden = rightContent.classList.contains("hidden");
    localStorage.setItem("avt_rightContent_hidden", isHidden ? "1" : "0");
  }

  function positionPanel() {
    const rect = div.getBoundingClientRect();
    const panelWidth = 200;
    const panelHeight = 200;
    const margin = 10;
    
    let top = rect.bottom + panelHeight + margin > window.innerHeight
      ? rect.top - panelHeight - margin - 20
      : rect.bottom + margin;
    
    panelEl.classList.toggle("slide-down", top > rect.top);
    panelEl.classList.toggle("slide-up", top <= rect.top);

    const left = rect.left > window.innerWidth / 2
      ? rect.left + 60
      : rect.right - (margin + panelWidth) - 60;

    panelEl.style.left = `${left}px`;
    panelEl.style.top = `${top}px`;
    panelEl.style.display = "block";
    requestAnimationFrame(() => panelEl.classList.add("show"));
  }

  function updateLangButton() {
    langBtn.textContent = window.lang === "en" ? "E" : "T";
    langBtn.style.backgroundColor = window.lang === "en" ? "#4CAF50" : "#2196F3";
  }

  // Event Listeners
  avatar.addEventListener("dblclick", toggleInfo);
  hideBtn.addEventListener("click", toggleInfo);
  
  resetBtn.addEventListener("click", () => {
    localStorage.removeItem("myDivX");
    localStorage.removeItem("myDivY");
    div.style.left = "20px";
    div.style.top = (window.innerHeight - 80) + "px";
    updateDirection();
  });

  toggleBtn.addEventListener("click", () => {
    if (panelEl.classList.contains("show")) {
      panelEl.classList.remove("show", "slide-up", "slide-down");
      setTimeout(() => panelEl.style.display = "none", 50);
    } else {
      positionPanel();
      panelEl.classList.add("show");
    }
  });

  closeBtn.addEventListener("click", () => {
    panelEl.classList.remove("show", "slide-up", "slide-down");
    setTimeout(() => panelEl.style.display = "none", 200);
  });

  langBtn.addEventListener("click", () => {
    window.lang = window.lang === "en" ? "th" : "en";
    localStorage.setItem("lang", window.lang);
    updateLangButton();
  });

  // Helper Functions
  function updateDirection() {
    const rect = div.getBoundingClientRect();
    window.avatarOnRight = rect.left + 400 > window.innerWidth && rect.left - 400 > 0;
    
    if (window.avatarOnRight) {
      div.style.flexDirection = "row-reverse";
      rightContent.style.marginLeft = "0";
      rightContent.style.marginRight = "8px";
    } else {
      div.style.flexDirection = "row";
      rightContent.style.marginRight = "0";
      rightContent.style.marginLeft = "8px";
    }
  }

  function clampToViewport(x, y, element) {
    const w = element.offsetWidth;
    const h = element.offsetHeight;
    return {
      x: Math.max(0, Math.min(x, window.innerWidth - (w + 5))),
      y: Math.max(0, Math.min(y, window.innerHeight - (h + 5)))
    };
  }

  function checkAvatarPosition(x, y) {
    const avatarWidth = 50;
    const avatarHeight = 60;
    const buffer = 5;
    
    return (
      x >= -buffer && 
      y >= -buffer &&
      x <= window.innerWidth - avatarWidth + buffer &&
      y <= window.innerHeight - avatarHeight + buffer
    );
  }

  // Initialize
  initAvatar();

  // Public API
  window.avatar = {
    updateBadge: function(count) {
      if (count > 0) {
        badge.textContent = count > 9 ? '9+' : count;
        badge.classList.remove('hidden');
      } else {
        badge.classList.add('hidden');
      }
    },
    setBadgeColor: function(color) {
      badge.style.background = color;
    },
    setPosition: function(x, y) {
      const pos = clampToViewport(x, y, div);
      div.style.left = pos.x + 'px';
      div.style.top = pos.y + 'px';
      localStorage.setItem("myDivX", pos.x);
      localStorage.setItem("myDivY", pos.y);
    }
  };
})();