// Create or update notification badge
function updateBadge(elementId, count) {
  const container = document.getElementById(elementId);
  if (!container) return;
  
  // Find or create badge element
  let badge = container.querySelector('.notification-badge');
  if (!badge) {
    badge = document.createElement('span');
    badge.className = 'notification-badge';
    container.appendChild(badge);
  }
  
  // Update badge content and visibility
  badge.textContent = count;
  badge.style.display = count === 0 ? 'none' : 'flex';
}

// Update button/container content
function updateButton(elementId, icon, text) {
  const element = document.getElementById(elementId);
  if (element) {
    element.innerHTML = `${icon} ${text} <span class="notification-badge"></span>`;
  }
}

// Update element styles
function updateStyle(elementId, style) {
  const element = document.getElementById(elementId);
  if (element) {
    element.style.cssText = style;
  }
}

// Initialize default styles if needed
function initStyles() {
  const style = document.createElement('style');
  style.textContent = `
    .notification-badge {
      position: absolute;
      top: -6px;
      right: -6px;
      width: 20px;
      height: 20px;
      background: red;
      color: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      font-size: 12px;
      font-weight: bold;
      line-height: 1;
    }
  `;
  document.head.appendChild(style);
}

// Initialize when DOM is loaded
document.addEventListener('DOMContentLoaded', initStyles);