(function () {
  function createProgressBar(div) {
    if (div._initialized) return;

    div.style.position = "relative";
    div.style.background = "#ddd";
    div.style.borderRadius = "4px";
    div.style.overflow = "hidden";

    const fill = document.createElement("div");
    fill.style.background = "#4caf50";
    fill.style.height = "100%";
    fill.style.width = "0%";
    fill.style.transition = "width 0.3s";
    div.appendChild(fill);

    const label = document.createElement("div");
    label.style.position = "absolute";
    label.style.top = "0";
    label.style.left = "0";
    label.style.width = "100%";
    label.style.height = "100%";
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.style.justifyContent = "center";
    label.style.fontSize = "12px";
    label.style.fontFamily = "sans-serif";
    label.style.color = "#000";
    div.appendChild(label);

    div._fill = fill;
    div._label = label;
    div._initialized = true;
  }

  function ProgressBar(divId, percent) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    createProgressBar(div);

    const clamped = Math.min(Math.max(percent, 0), 100);

    if (!div._hasSet) {
      div._fill.style.width = "0%";
      setTimeout(() => {
        div._fill.style.width = clamped + "%";
        div._label.textContent = clamped + "%";
        div.title = `${clamped}%`;
      }, 50);
      div._hasSet = true;
    } else {
      div._fill.style.width = clamped + "%";
      div._label.textContent = clamped + "%";
      div.title = `${clamped}%`;
    }
  }

  window.ProgressBar = ProgressBar;

  //ProgressBar("visualBar", 10);
  // later on call ProgressBar("visualBar", 60); etc.

  function createProgressLine(div) {
    if (div._initialized) return;

    div.style.position = "relative";
    div.style.background = "#ddd";
    div.style.borderRadius = "1px";
    div.style.overflow = "hidden";
    div.style.height = "2px";

    const fill = document.createElement("div");
    fill.style.background = "#4caf50";
    fill.style.height = "100%";
    fill.style.width = "0%";
    fill.style.transition = "width 0.3s ease";
    div.appendChild(fill);

    div._fill = fill;
    div._initialized = true;
  }

  function ProgressLine(divId, percent) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    createProgressLine(div);

    const clamped = Math.min(Math.max(percent, 0), 100);

    if (!div._hasSet) {
      div._fill.style.width = "0%";
      setTimeout(() => {
        div._fill.style.width = clamped + "%";
      }, 50);
      div._hasSet = true;
    } else {
      div._fill.style.width = clamped + "%";
    }
  }
  

  window.ProgressLine = ProgressLine;
  
   // Inject pulse animation once
  const style = document.createElement("style");
  style.textContent = `
    @keyframes pulseBadge {
      0% { box-shadow: 0 0 0 0 rgba(255,0,0, 0.3); }
      70% { box-shadow: 0 0 0 6px rgba(255,0,0, 0); }
      100% { box-shadow: 0 0 0 0 rgba(255,0,0, 0); }
    }
  `;
  document.head.appendChild(style);

  window.progressBadge = function (divId, value) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    // Auto-hide if 0, null, undefined, or empty string
    if (!value || value === 0 || value === "0") {
      progressBadgeRemove(divId);
      return;
    }

    const parent = div.parentElement;
    if (getComputedStyle(parent).position === "static") {
      parent.style.position = "relative";
    }

    // Clear previous content
    div.innerHTML = "";

    const badge = document.createElement("div");
    badge.textContent = value;

    const isShort = (value + "").length <= 2;

    Object.assign(div.style, {
      position: "absolute",
      top: "-8px",
      right: "-20px",
      background: "red",
      color: "white",
      fontSize: "10px",
      lineHeight: "17px",
      textAlign: "center",
      padding: isShort ? "0" : "0 6px",
      borderRadius: isShort ? "50%" : "10px",
      minWidth: "16px",
      height: "16px",
      display: "inline-block",
      whiteSpace: "nowrap",
      fontFamily: "sans-serif",
      zIndex: 10,
      animation: "pulseBadge 2.5s infinite",
    });

    div.appendChild(badge);
  };

  window.progressBadgeRemove = function (divId) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (div) div.innerHTML = "";
  };
})();
