<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>SmartBar Menu with Badge</title>
  <style>
    body {
      margin: 0;
      font-family: sans-serif;
    }

    #triggerIcon {
      width: 40px;
      height: 40px;
      background: #3498db;
      border-radius: 50%;
      margin: 10px;
      cursor: pointer;
      position: relative;
    }

    #smartBar {
      display: none;
      position: absolute;
      top: 60px;
      left: 10px;
      background: #eee;
      padding: 5px 10px;
      border-radius: 8px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      z-index: 1000;
      white-space: nowrap;
    }

    .menuButton {
      position: relative;
      margin: 0 5px;
      padding: 5px 10px;
      background: #fff;
      border: 1px solid #ccc;
      border-radius: 6px;
      cursor: pointer;
      display: inline-block;
    }

    .badge {
      position: absolute;
      top: -6px;
      right: -6px;
      background: red;
      color: white;
      font-size: 12px;
      padding: 2px 6px;
      border-radius: 20px;
      display: none;
    }

    .menuButton:hover {
      background: #f9f9f9;
    }
  </style>
</head>
<body>

  <div id="triggerIcon" title="Open Menu"></div>

  <div id="smartBar">
    <div class="menuButton" id="menuItem1">Inbox<span class="badge" id="badge_menuItem1"></span></div>
    <div class="menuButton" id="menuItem2">Alerts<span class="badge" id="badge_menuItem2"></span></div>
    <div class="menuButton" id="menuItem3">Tasks<span class="badge" id="badge_menuItem3"></span></div>
  </div>

  <script>
    const trigger = document.getElementById('triggerIcon');
    const bar = document.getElementById('smartBar');

    trigger.addEventListener('click', () => {
      bar.style.display = bar.style.display === 'block' ? 'none' : 'block';
    });

    function updateBadge(id, count) {
      const badge = document.getElementById('badge_' + id);
      if (!badge) return;

      if (count > 0) {
        badge.textContent = count;
        badge.style.display = 'inline-block';
      } else {
        badge.style.display = 'none';
      }
    }

    // Example usage
    updateBadge('menuItem1', 5);
    updateBadge('menuItem2', 0); // hides badge
    updateBadge('menuItem3', 12);
  </script>

</body>
</html>
