(function () {
    function createProgressBar(div) {
      if (div._initialized) return;

      div.style.position = "relative";
      div.style.background = "#ddd";
      div.style.borderRadius = "4px";
      div.style.overflow = "hidden";

      const fill = document.createElement("div");
      fill.style.background = "#4caf50";
      fill.style.height = "100%";
      fill.style.width = "0%";
      fill.style.transition = "width 0.3s";
      div.appendChild(fill);

      const label = document.createElement("div");
      label.style.position = "absolute";
      label.style.top = "0";
      label.style.left = "0";
      label.style.width = "100%";
      label.style.height = "100%";
      label.style.display = "flex";
      label.style.alignItems = "center";
      label.style.justifyContent = "center";
      label.style.fontSize = "12px";
      label.style.fontFamily = "sans-serif";
      label.style.color = "#000";
      div.appendChild(label);

      div._fill = fill;
      div._label = label;
      div._initialized = true;
    }

    function ProgressBar(divId, percent) {
      const div = typeof divId === "string" ? document.getElementById(divId) : divId;
      if (!div) return;

      createProgressBar(div);

      const clamped = Math.min(Math.max(percent, 0), 100);
      div._fill.style.width = clamped + "%";
      div._label.textContent = clamped + "%";
      div.title = `${clamped}%`;
    }

    // Expose globally
    window.ProgressBar = ProgressBar;
  })();