function addStyle(css) {
  const style = document.createElement('style');
  style.textContent = css;
  document.head.appendChild(style);
}

addStyle(`
#triggerIcon.dragging {
  border: 1px solid rgba(190, 124, 28, 0.5);
  outline: 5px solid rgba(14, 181, 227, 0.2);
  box-sizing: border-box;
}
     html, body {
            margin: 0;
            padding: 0;
            height: 100%;
            animation: myanimation 30s infinite;
            transition: all 1.5s ease;
        }

        @keyframes myanimation {
            0% {
                background: linear-gradient(90deg, rgba(140, 224, 255, .2) 0%, rgba(108, 230, 157, .5) 50%, rgba(255, 255, 255, 1) 100%);
            }
            25% {
                background: linear-gradient(90deg, rgba(155, 151, 42, .5) 0%, rgba(188, 199, 87, .5) 50%, rgba(255, 255, 255, 1) 100%);
            }
            50% {
                background: linear-gradient(90deg, rgba(42, 123, 155, .2) 0%, rgba(87, 199, 133, .5) 50%, rgba(252, 249, 220, 1) 100%);
            }
            75% {
                background: linear-gradient(90deg, rgba(156, 165, 173, .2) 0%, rgba(87, 199, 133, .5) 50%, rgba(230, 230, 230, 1) 100%);
            }
            100% {
                background: linear-gradient(90deg, rgba(255, 107, 107, .2) 0%, rgba(247, 150, 64, .2) 50%, rgba(255, 254, 252, 1) 100%);
            }
        }

        #triggerIcon {
            position: absolute;
            width: 60px;
            height: 60px;
            border-radius: 50%;
            background-color: #444;
            background-image: url('https://i.pravatar.cc/60');
      background-size: cover;
      background-position: center;
            z-index: 10;
        }

        #triggerIcon.dragging {
            border: 1px solid rgba(190, 124, 28, 0.5);
            outline: 5px solid rgba(14, 181, 227, 0.2);
            box-sizing: border-box;
        }

        #smartBar {
            position: absolute;
            width: 300px;
            height: 40px;
            border: 1px solid rgba(200, 200, 200, 0.5);
            border-radius: 20px;
            box-shadow: 0 4px 12px rgba(97, 97, 97, 0.55);
            z-index: 9;
            padding: 8px 8px;
            display: flex;
            align-items: center;
            justify-content: space-between;
            overflow: hidden;
            box-sizing: border-box;
            background: rgba(0, 0, 0, 0.1);
            backdrop-filter: blur(20px);
        }
.other-group {
            display: flex;
            align-items: center;
            gap: 8px;
            overflow: hidden;
                        //position: relative;
                     

        }
        .bar-left {
            display: flex;
            align-items: center;
            gap: 0px;
            overflow: hidden;
        }

        .label {
            font-weight: bold;
            font-size: 14px;
            white-space: nowrap;
        }

        .username {
            font-weight: bold;
            font-size: 14px;
            white-space: nowrap;
        }

        .btn {
            font-size: 12px;
            padding: 4px 8px;
            border: none;
            background: #eee;
            cursor: pointer;
            border-radius: 4px;
        }

        .ex-button, .menu-button {
            font-size: 12px;
            padding: 4px 8px;
            border: none;
            background: #eee;
            cursor: pointer;
            border-radius: 4px;
        }

     .toggleBtn {
    border: solid 1px rgba(200, 200, 200, 0.5);
    width: 14px;
    height: 14px;
    min-width: 14px; /* Ensure it doesn't grow/shrink */
    min-height: 14px;
    border-radius: 50%;
    background: #2196f3;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    margin: 0;
    flex-shrink: 0; /* Prevent size changes */
}
.circle-btn {
    border: solid 1px rgba(200, 200, 200, 0.5);
    width: 14px;
    height: 14px;
    min-width: 14px;
    min-height: 14px;
    border-radius: 50%;
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    margin: 0;
    flex-shrink: 0;
    font-size: 8px;
    color: white;
}
/* Language Button (Green) */
#langBtn {
    background: #4CAF50;
}

/* Expand Button (Gold) */
#exButton {
    background: #FFD700;
}

/* Logout Button (Red) */
#logoutBtn {
    background: #f44336;
}

/* Clear Button (Orange) */
#clearBtn {
    background: #ff9800;
}
        .bar-panel {
            position: fixed;
            background-color: rgba(155, 151, 152, .1);
            backdrop-filter: blur(10px);
            //border-radius: 30px 30px 0 0;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.3);
            //z-index: 99;
            display: none;
            overflow: hidden;
            color: white;
            padding: 50px;
            box-sizing: border-box;
            height: 400px;
           
        }

        .menu-container {
            position: fixed;
            background-color: rgba(55, 51, 52, .1);
            backdrop-filter: blur(20px);
            border-radius: 8px;
            box-shadow: 0 4px 12px rgba(0, 0, 0, 0.75);
            padding: 8px 0;
            z-index:   111;
            min-width: 180px;
            display: none;
        }

        .menu-group {
            margin: 8px 0;
        }

        .menu-group:not(:last-child) {
            border-bottom: 1px solid #eee;
        }

        .menu-item {
          padding: 10px 16px;
    cursor: pointer;
    color: #333;
    display: flex;
    align-items: center;
    gap: 8px;
    transition: background-color 0.3s ease, color 0.3s ease; /* Smooth transition */
        }

        .menu-item:hover {
background-color: #252553; /* Dark purple background */
    color: #ffffff; /* White text for better contrast */        }

        .menu-icon {
            width: 20px;
            text-align: center;
        }

        .menu-text {
            flex: 1;
        }

        .menu-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 100;
            display: none;
        }

        .badge {
            background-color: #e31515;
            border-radius: 10px;
            padding: 2px 6px;
            font-size: 12px;
            color: #eedfdf;
        }
        #pillbar {            
             box-shadow: 0 4px 12px rgba(0, 0, 0, 0.55);          
            background-color: #8b3131;
            display: flex;
            align-items: center;
            padding: 0 20px;
            box-sizing: border-box;
        }
        .menuButton{
            font-size: 12px;
            padding: 4px 8px;
            border: none;
            
            cursor: pointer;
            border-radius: 4px;
        }
        #logoutBtn {
    border: solid 1px rgba(200, 200, 200, 0.5);
    width: 13px;
    height: 13px;
    border-radius: 50%;
    background: #f44336; /* Red color */
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 8px;
}
#clearBtn {
    border: solid 1px rgba(200, 200, 200, 0.5);
    width: 13px;
    height: 13px;
    border-radius: 50%;
    background: #ff9800; /* Orange color */
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 8px;
}
#langBtn {
    
    
    background: #4CAF50; /* Green color */
    border: solid 1px rgba(200, 200, 200, 0.5);
    width: 13px;
    height: 13px;
    border-radius: 50%;
    
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 8px;
}
#exButton {
    
    
    background: #a9f51b; /* Green color */
    border: solid 1px rgba(255, 255, 255, 0.5);
    width: 13px;
    height: 13px;
    border-radius: 50%;
    
    padding: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 8px;
    
}
`);

function createSmartBarElements() {
  const wrapper = document.createElement('div');
  wrapper.innerHTML = `
    <div id="pillBar">
      <div id="triggerIcon" title="Drag me!"></div>
      <div id="smartBar">        
        <div class="bar-left">
          <button class="toggleBtn" title="Expand/Collapse" id="toggleBarBtn"></button>    
          <div id="otherGroup" class="other-group">
            <div class="menuButton" id="menuButton">Menu</div>
            <button class="btn circle-btn" id="exButton"></button>
            <span class="label">[info]</span>
            <span class="username" id="username">User</span>
            <button class="btn circle-btn" id="langBtn"></button>
            <button class="btn circle-btn" id="logoutBtn"></button>
            <button class="btn circle-btn" id="clearBtn"></button>
          </div>
        </div>
      </div>
    </div>
    <div id="barPanel" class="bar-panel"></div>
    <div id="menuContainer" class="menu-container"></div>
    <div id="menuOverlay" class="menu-overlay"></div>
  `;
  document.body.appendChild(wrapper);
}

function assignTriggerImage(url) {
  const trigger = document.getElementById("triggerIcon");
  if (trigger) {
    trigger.style.backgroundImage = `url('${url}')`;
    trigger.style.backgroundSize = "cover";
    trigger.style.backgroundPosition = "center";
  }
}

function dragon(trigger) {
  let isDragging = false;
  let offsetX = 0, offsetY = 0;

  trigger.addEventListener("mousedown", function (e) {
    isDragging = true;
    offsetX = e.clientX - trigger.offsetLeft;
    offsetY = e.clientY - trigger.offsetTop;
    trigger.style.cursor = "grabbing";
    trigger.classList.add("dragging");
    justDragged = true;
  });

  document.addEventListener("mousemove", function (e) {
    if (!isDragging) return;
    const x = e.clientX - offsetX;
    const y = e.clientY - offsetY;
    const bounds = clampToViewport(x, y, trigger);
    trigger.style.left = bounds.x + "px";
    trigger.style.top = bounds.y + "px";
    positionSmartBar();
    if (barPanelVisible) positionBarPanel();

  });

  document.addEventListener("mouseup", function () {
    if (isDragging) {
      savePosition();
      positionSmartBar();
      saveSmartBarState();
      setTimeout(() => {
        justDragged = false;
      }, 100);
    }
    isDragging = false;
    trigger.style.cursor = "grab";
    trigger.classList.remove("dragging");
  });
}

function clampToViewport(x, y, el) {
  const maxX = window.innerWidth - el.offsetWidth - 5;
  const maxY = window.innerHeight - el.offsetHeight - 5;
  return {
    x: Math.max(0, Math.min(x, maxX)),
    y: Math.max(0, Math.min(y, maxY)),
  };
}

function savePosition() {
  localStorage.setItem("triggerX", trigger.offsetLeft);
  localStorage.setItem("triggerY", trigger.offsetTop);
}

function loadPosition() {
  const x = parseInt(localStorage.getItem("triggerX"));
  const y = parseInt(localStorage.getItem("triggerY"));
  if (!isNaN(x) && !isNaN(y)) {
    const clamped = clampToViewport(x, y, trigger);
    trigger.style.left = clamped.x + "px";
    trigger.style.top = clamped.y + "px";
  } else {
    trigger.style.left = "40px";
    trigger.style.top = "40px";
  }
}

function saveSmartBarState() {
  localStorage.setItem("smartBarWidth", parseInt(smartBar.style.width));
  localStorage.setItem("smartBarTop", smartBar.style.top);
  localStorage.setItem("smartBarLeft", smartBar.style.left);
  localStorage.setItem("smartBarMode", smartBarMode ? "1" : "0");
}

function loadSmartBarState() {
  const width = localStorage.getItem("smartBarWidth") || "300";
  const top = localStorage.getItem("smartBarTop");
  const left = localStorage.getItem("smartBarLeft");

  smartBar.style.width = width + "px";
  if (top && left) {
    smartBar.style.top = top;
    smartBar.style.left = left;
  } else {
    positionSmartBar();
  }

  smartBarMode = localStorage.getItem("smartBarMode") === "1";
  smartBar.style.display = smartBarMode ? "flex" : "none";
}

function getZone(rect) {
  const centerX = rect.left + rect.width / 2;
  const centerY = rect.top + rect.height / 2;
  const thirdW = window.innerWidth / 3;
  const thirdH = window.innerHeight / 3;
  const horiz = centerX < thirdW ? "L" : centerX < thirdW * 2 ? "C" : "R";
  const vert = centerY < thirdH ? "T" : centerY < thirdH * 2 ? "C" : "B";
  return vert + horiz;
}

function positionSmartBarA() {
  const iconRect = trigger.getBoundingClientRect();
  const barWidth = smartBar.offsetWidth;
  const barHeight = smartBar.offsetHeight;
  const zone = getZone(iconRect);
  let top = iconRect.top + (iconRect.height - barHeight) / 2;
  let left;
  const SPACING = 15;

  if (["TL", "CL", "BL"].includes(zone)) {
    left = iconRect.right + SPACING;
  } else if (["TR", "CR", "BR"].includes(zone)) {
    left = iconRect.left - barWidth - SPACING;
  } else {
    if (iconRect.right + barWidth + SPACING < window.innerWidth) {
      left = iconRect.right + SPACING;
    } else {
      left = iconRect.left - barWidth - SPACING;
    }
  }

  top = Math.max(10, Math.min(top, window.innerHeight - barHeight - 10));
  left = Math.max(10, Math.min(left, window.innerWidth - barWidth - 10));

  smartBar.style.top = `${top}px`;
  smartBar.style.left = `${left}px`;
}
function positionSmartBar() {
  const iconRect = trigger.getBoundingClientRect();
  const barWidth = smartBar.offsetWidth;
  const barHeight = smartBar.offsetHeight;
  const zone = getZone(iconRect);
  const barLeft = smartBar.querySelector(".bar-left");
const toggleBtn = document.getElementById("toggleBarBtn");

  let top = iconRect.top + (iconRect.height - barHeight) / 2;
  let left;
  const SPACING = 15;

  if (["TL", "CL", "BL"].includes(zone)) {
    left = iconRect.right + SPACING;
    barLeft.style.flexDirection = "row";
      toggleBtn.style.marginLeft = "4px";   // space between triggerIcon and button
  toggleBtn.style.marginRight = "0px";  // no trailing space
  } else {
    left = iconRect.left - barWidth - SPACING;
    if (smartBar.style.width === "300px") {    
       console.log("SmartBar is expanded, adjusting left position");
        barLeft.style.flexDirection = "row-reverse";
        toggleBtn.style.marginLeft = "28px";   // space before toggleBarBtn
        toggleBtn.style.marginRight = "8px";  // space after toggleBarBtn
        barLeft.style.justifyContent = "flex-end"; // align button+trigger to right
    } else {
      barLeft.style.flexDirection = "row";
      toggleBtn.style.marginLeft = "4px";   // space between triggerIcon and button
      toggleBtn.style.marginRight = "0px";  // no trailing space
              barLeft.style.justifyContent = "flex-end"; // align button+trigger to right

    }

  }

  top = Math.max(10, Math.min(top, window.innerHeight - barHeight - 10));
  left = Math.max(10, Math.min(left, window.innerWidth - barWidth - 10));

  smartBar.style.top = `${top}px`;
  smartBar.style.left = `${left}px`;

  if (barPanelVisible) positionBarPanel();
}

function positionBarPanelA() {
  const pillRect = smartBar.getBoundingClientRect();
  barPanel.style.width = smartBar.offsetWidth + "px";
  barPanel.style.left = pillRect.left + "px";

  const below = window.innerHeight - pillRect.bottom;
  const top = below >= barPanel.offsetHeight ? pillRect.bottom : pillRect.top - barPanel.offsetHeight;

  barPanel.style.top = top + "px";
}
function positionBarPanel() {
  const pillRect = smartBar.getBoundingClientRect();
  const triggerRect = trigger.getBoundingClientRect();
  const triggerTop = triggerRect.top;
  const panelHeight = barPanel.offsetHeight;
  const spaceBelow = window.innerHeight - pillRect.bottom;
  const spaceRight = window.innerWidth - trigger.offsetLeft + trigger.offsetWidth;

  barPanel.style.width = smartBar.offsetWidth + "px";

  if (spaceBelow >= panelHeight || spaceBelow >= pillRect.top) {
    barPanel.style.top = triggerTop+ "px";
    barPanel.style.bottom = "auto";
    barPanel.style.border = "solid 10px rgba(200, 200, 200, 0.5)";
    barPanel.style.borderRadius = "30px 30px 10px 10px";
  } else {
    barPanel.style.top = "auto";
    barPanel.style.bottom = (window.innerHeight - (pillRect.top + pillRect.height) - 10) + "px";
    barPanel.style.border = "solid 10px rgba(200, 200, 200, 0.5)";
    barPanel.style.borderRadius = "30px 30px 30px 30px";
  }

  if (spaceRight > trigger.offsetWidth) {
    barPanel.style.left = trigger.offsetLeft + "px";
    barPanel.style.right = "10px";
    barPanel.style.width = smartBar.offsetWidth + trigger.offsetWidth + 20 + "px";
  } else {
    barPanel.style.left = pillRect.offsetWidth + "px";
    barPanel.style.width = smartBar.offsetWidth + trigger.offsetWidth + 20 + "px";
  }

  if (trigger.offsetLeft + trigger.offsetWidth + barPanel.offsetWidth > window.innerWidth) {
    barPanel.style.left = (trigger.offsetLeft + trigger.offsetWidth - barPanel.offsetWidth) + "px";
    barPanel.style.width = smartBar.offsetWidth + trigger.offsetWidth + 20 + "px";
    barPanel.style.borderRadius = "30px 30px 30px 30px";
  }

  console.log("BarPanel position:", barPanel.style.top, barPanel.style.left, barPanel.style.width);
}

function positionMenuSmart(triggerEl) {
  const iconRect = triggerEl.getBoundingClientRect();
  const menu = menuContainer;
  const menuWidth = menu.offsetWidth || 180;
  const menuHeight = menu.offsetHeight || 200;
  const zone = getZone(iconRect);
  let top = 0, left = 0;

  switch (zone) {
    case "TL":
    case "TC":
      top = iconRect.bottom + 8;
      left = iconRect.left;
      break;
    case "TR":
      top = iconRect.bottom + 8;
      left = iconRect.right - menuWidth;
      break;
    case "CL":
    case "CR":
    case "CC":
      top = iconRect.bottom + 8;
      left = iconRect.left;
      break;
    case "BL":
    case "BC":
    case "BR":
      top = iconRect.top - menuHeight - 8;
      left = iconRect.left;
      break;
  }

  top = Math.max(0, Math.min(top, window.innerHeight - menuHeight - 10));
  left = Math.max(0, Math.min(left, window.innerWidth - menuWidth - 10));

  menu.style.top = `${top}px`;
  menu.style.left = `${left}px`;
}

function renderMenuSSSS(data, container) {
  container.innerHTML = "";
  data.forEach((group) => {
    const groupDiv = document.createElement("div");
    groupDiv.className = "menu-group";
    group.items.forEach((entry) => {
      const item = document.createElement("div");
      item.className = "menu-item";
      item.innerHTML = `<div class="menu-icon">${entry.icon}</div><div class="menu-text">${entry.text}</div>`;
      item.onclick = () => {
        entry.onclick();
        menuContainer.style.display = "none";
        menuOverlay.style.display = "none";
      };
      groupDiv.appendChild(item);
    });
    container.appendChild(groupDiv);
  });
}
function renderMenu(data, container) {
  container.innerHTML = "";
  data.forEach((group, groupIndex) => {
    const groupDiv = document.createElement("div");
    groupDiv.className = "menu-group";
    group.items.forEach((entry, itemIndex) => {
      const item = document.createElement("div");
      item.className = "menu-item";
      item.id = `menuContainer-${entry.item}`; // This ID is important

      item.innerHTML = `
        <div class="menu-icon">${entry.icon}</div>
        <div class="menu-text">
          ${entry.text}
          <!-- Badge will be inserted here by updateBadge -->
        </div>
      `;

      item.onclick = () => {
        entry.onclick();
        if (container === menuContainer) {
          closeMenu();
        }
      };
      groupDiv.appendChild(item);
    });
    container.appendChild(groupDiv);
  });
}


function listenSmartBar() {
  const toggleBarBtn = document.getElementById("toggleBarBtn");
  const menuButton = document.getElementById("menuButton");
  const exButton = document.getElementById("exButton");

  toggleBarBtn.addEventListener("click", function () {
    const oldWidth = smartBar.offsetWidth;
    const isExpanding = oldWidth <= 150;
    const newWidth = isExpanding ? 300 : 100;

    const zone = getZone(trigger.getBoundingClientRect());
    const currentLeft = parseInt(smartBar.style.left || "0");

    if (["TR", "CR", "BR"].includes(zone)) {
      smartBar.style.left = isExpanding
        ? currentLeft - (newWidth - oldWidth) + "px"
        : currentLeft + (oldWidth - newWidth) + "px";
    }

    smartBar.style.width = newWidth + "px";
    positionSmartBar();
    if (barPanelVisible) positionBarPanel();
    saveSmartBarState();
  });

  exButton.addEventListener("click", function () {
    if (justDragged) {
      justDragged = false;
      return;
    }
    barPanelVisible = !barPanelVisible;
    barPanel.style.display = barPanelVisible ? "block" : "none";
    if (barPanelVisible) positionBarPanel();
  });

  menuButton.addEventListener("click", function (e) {
    const show = menuContainer.style.display !== "block";
    menuContainer.style.display = show ? "block" : "none";
    menuOverlay.style.display = show ? "block" : "none";
    if (show) {
      renderMenu(menuData, menuContainer);
      positionMenuSmart(e.target);
    }
  });

  menuOverlay.addEventListener("click", function () {
    menuContainer.style.display = "none";
    menuOverlay.style.display = "none";
  });
}

// --- INIT
let smartBarMode = true;
let justDragged = false;
let barPanelVisible = false;

 const menuData = [
            {
                group: "View Options",
                items: [
                    {
                        item: "togglebar",
                        icon: "🟦",
                        text: "Assessment",
                        onclick: () => {
                            smartBarMode = true;
                            menuContainer.style.display = "none";
                            menuOverlay.style.display = "none";
                            saveSmartBarState();
                        },
                    },
                    {
                        item: "togglelist",
                        icon: "📋",
                        text: "Profile",
                        onclick: () => alert("Switched to list (simulated)"),
                    },
                ],
            },
            {
                group: "User Actions",
                items: [
                    {
                        item: "profile",
                        icon: "👤",
                        text: "User",
                        onclick: () => alert("Profile clicked"),
                    },
                    {
                        item: "settings",
                        icon: "⚙️",
                        text: "Settings",
                        onclick: () => alert("Settings clicked"),
                    },
                ],
            },
            {
                group: "Support",
                items: [
                    {
                        item: "help",
                        icon: "❓",
                        text: "Help",
                        onclick: () => alert("Help clicked"),
                    },
                    {
                        item: "logout",
                        icon: "🚪",
                        text: "Logout",
                        onclick: () => alert("Logged out"),
                    },
                ],
            },
        ];


// Auto-run on load
createSmartBarElements();

const trigger = document.getElementById("triggerIcon");
const smartBar = document.getElementById("smartBar");
const barPanel = document.getElementById("barPanel");
const menuContainer = document.getElementById("menuContainer");
const menuOverlay = document.getElementById("menuOverlay");

assignTriggerImage("https://i.pravatar.cc/60");
dragon(trigger);
loadSmartBarState();
loadPosition();
positionSmartBar();
listenSmartBar();
