<?php
header('Access-Control-Allow-Origin: *');

// Sanitize input
$folder = isset($_POST['folder']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folder']) : 'default';
$foldergroup = isset($_POST['foldergroup']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['foldergroup']) : '';
$folderuser = isset($_POST['folderuser']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folderuser']) : 'unknown';
$isLogo = isset($_POST['subfolder']) && $_POST['subfolder'] === 'logo';

// Build upload directory
$uploadDir = "./s/$folder/";
if ($foldergroup) $uploadDir .= "$foldergroup/";
$uploadDir .= "$folderuser/";

// Ensure directory exists
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0777, true)) {
        echo "ERROR: Failed to create directory $uploadDir";
        exit;
    }
}

// Handle uploaded file
if (!empty($_FILES['fileUpload'])) {
    $originalName = $_FILES['fileUpload']['name'];
    $fileExt = pathinfo($originalName, PATHINFO_EXTENSION);
    $baseName = pathinfo($originalName, PATHINFO_FILENAME);
    $baseName = preg_replace('/[^a-zA-Z0-9_-]/', '_', $baseName);

    if ($isLogo) {
        $filename = "logo_" . $baseName . '.' . $fileExt;
    } else {
       // $timestamp = time();
        //$filename = $baseName . '-' . $timestamp . '.' . $fileExt;
        $filename = $originalName;
    }

    $location = $uploadDir . $filename;

    // Avoid overwrite for regular files
    if (!$isLogo && file_exists($location)) {
        $counter = 1;
        $fileBase = $baseName . '-' . $timestamp;
        while (file_exists($location)) {
            $filename = $fileBase . "($counter)." . $fileExt;
            $location = $uploadDir . $filename;
            $counter++;
        }
    }

    if (move_uploaded_file($_FILES['fileUpload']['tmp_name'], $location)) {
        $relativePath = "s/$folder/" . ($foldergroup ? "$foldergroup/" : "") . "$folderuser/$filename";
        echo $relativePath;
    } else {
        echo "ERROR: File move failed";
    }
} else {
    echo "ERROR: No file uploaded";
}
?>
