const responseCache = new Map();
async function loadPanelDataNoCOmpressx01(id, panelId, formId, objectKey) {
        // Show loading started toast
        toast(
            `⏳ Loading ${panelId}...`,
            { pos: "TR", slide: "rtl" },
            { background: "#2196F3" },
            1500,
        );

        const panel = document.getElementById(panelId);
    // First try to load from localStorage
    if (loadFromLocalStorage(id)) {
        console.log(`✅ Loaded ${panelId} data from localStorage`);
        processCachedDataFromLocalStorage(panelId, formId, objectKey);
        toast(
            `✅ ${panelId} loaded from cache`,
            { pos: "BR", slide: "rtl" },
            { background: "#4CAF50" },
            500,
        );
        return; // Exit after successful localStorage load
    }
        if (!panel) {
            createPanelWrapper(panelId, formId);
            const targetEl = document.getElementById(formId);
            if (targetEl) {
                targetEl.innerHTML = `<div style="
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    margin: auto;
                    color: white;
                    min-height: 500px;" class="loader">.</div>`;
            }
        }

        if (!navigator.onLine) {
            const message = `⚠️ Offline — loading ${panelId} from cache if available`;
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data for ${panelId}`);
                processCachedData(cached.data, panelId, formId, objectKey);
                toast(
                    `✅ ${panelId} loaded from cache`,
                    { pos: "BR", slide: "btt" },
                    { background: "#af6f4cff" },
                    500,
                );
                return;
            }
            toast(
                `❌ No cached data for ${panelId}`,
                { pos: "BR", slide: "rtl" },
                { background: "#F44336" },
                2000,
            );
            return;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return;
        }

        const url = `https://i.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading for ${panelId}`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                `🔍 Fetching ${panelId} data...`,
                { pos: "BR", slide: "btt" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ ${panelId} not modified, using cached data`);
                if (cached && cached.data) {
                    processCachedData(cached.data, panelId, formId, objectKey);
                    const loadTime = Date.now() - startTime;
                    console.log(
                        `✅ ${panelId} load completed in ${loadTime}ms`,
                    );
                    toast(
                        `✅ ${panelId} loaded (cached) in ${loadTime}ms`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                `📦 Processing ${panelId} data...`,
                { pos: "BR", slide: "btt" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = `⚠️ No 'data' field in ${panelId} response`;
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }
// Save to localStorage
        saveToLocalStorage(id);
            processCachedData(data, panelId, formId, objectKey);
            const loadTime = Date.now() - startTime;
            console.log(`✅ ${panelId} load completed in ${loadTime}ms`);
            toast(
                `✅ ${panelId} loaded in ${loadTime}ms`,
                { pos: "CR", slide: "rtl" },
                { background: "#4CAF50" },
                1500,
            );
        } catch (e) {
            console.error(`❌ ${panelId} load failed:`, e.message);
            toast(
                `❌ ${panelId} load failed: ${e.message}`,
                { pos: "CR", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
        }
    }
function processCachedData(data, panelId, formId, objectKey) {
        const tryParse = (str) => {
            try {
                return JSON.parse(str);
            } catch {
                return {};
            }
        };

        bucket = tryParse(data.bucket || "{}");
        cup = tryParse(data.cup || "{}");
        board = tryParse(data.board || "{}");

        const objectMap = { bucket, cup };
        const targetObj = objectMap[objectKey];

        const panel = document.getElementById(panelId);
        if (!panel) {
            createPanelWrapper(panelId, formId);
        } else {
            genform(formId, targetObj);
        }
    }
        
// New helper function for localStorage data processing
function processCachedDataFromLocalStorage(panelId, formId, objectKey) {
    const objectMap = { bucket, cup };
    const targetObj = objectMap[objectKey];

    const panel = document.getElementById(panelId);
    if (!panel) {
        createPanelWrapper(panelId, formId);
    } else {
        genform(formId, targetObj);
    }
    
    // Trigger any necessary UI updates
    if (document.getElementById("summan")) {
        renderSchemaStructureToSumman(bucket, "gform", window.lang);
    }
    if (document.getElementById("jumperhelper")) {
        updateJumperHelperWithUnanswered(QSummary(bucket).summary, bucket);
    }
}    
// Helper function to process data (cached or fresh)
    function processCachedData(data, panelId, formId, objectKey) {
        const tryParse = (str) => {
            try {
                return JSON.parse(str);
            } catch {
                return {};
            }
        };

        bucket = tryParse(data.bucket || "{}");
        cup = tryParse(data.cup || "{}");
        board = tryParse(data.board || "{}");

        const objectMap = { bucket, cup };
        const targetObj = objectMap[objectKey];

        const panel = document.getElementById(panelId);
        if (!panel) {
            createPanelWrapper(panelId, formId);
        } else {
            genform(formId, targetObj);
        }
    }
    
async function saveToServerMO(id) {
        // Early exit checks
        if (!navigator.onLine) {
            console.warn("⚠️ Offline — cannot save to server");
            toast(
                "⚠️ Offline - cannot save",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        if (!id) {
            console.warn("⚠️ ID is required");
            toast(
                "⚠️ ID is required",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        // Check for actual data content
        const hasValidData = () => {
            const hasBucket = bucket && Object.keys(bucket).length > 0;
            const hasCup = cup && Object.keys(cup).length > 0;
            const hasBoard = board && Object.keys(board).length > 0;
            return hasBucket || hasCup || hasBoard;
        };

        if (!hasValidData()) {
            toast(
                "⚠️ No data to save",
                { pos: "TR", slide: "rtl" },
                { background: "red" },
            );
            return false;
        }
    const bucketStats = getFieldStats(bucket);
    const cupStats = getFieldStats(cup);
    
    
    cp="";

    window.bucket_answeredRequired=bucketStats.answeredRequired;
    window.bucket_totalRequired=bucketStats.totalRequired;
    window.cup_answeredRequired=cupStats.answeredRequired;
    window.cup_totalRequired=cupStats.totalRequired;
        let aap=window.bucket_totalRequired+window.cup_totalRequired;
        window.totalRequired=aap;
        let asp=window.bucket_answeredRequired+window.cup_answeredRequired;
        window.answeredRequired=asp;
          let  overallPercent = aap > 0 ? Math.min(100, Math.round((asp / aap) * 100)) : 0;
          stillneed=aap-asp;
prog=`Progress (${asp}/${aap}) `+overallPercent+"%";
updateStatus("A1",prog);
if (overallPercent>0) updateBadge("A1",stillneed,"red");
if (overallPercent===100) updateBadge("A1","Ready","green");

// Format current time (your existing code)
const now = new Date();
const formattedTime = 
    now.getFullYear() + '-' + 
    String(now.getMonth() + 1).padStart(2, '0') + '-' + 
    String(now.getDate()).padStart(2, '0') + ' ' + 
    String(now.getHours()).padStart(2, '0') + ':' + 
    String(now.getMinutes()).padStart(2, '0') + ':' + 
    String(now.getSeconds()).padStart(2, '0');

// Initialize board if it doesn't exist
if (!board) {
    board = {
        userid: userid,
        user: user,
        user_name: window.user_name,
        totalRequired: window.totalRequired,
        answeredRequired: window.answeredRequired,
        save: "saved",
        time: formattedTime
    };
}

// Update board with current values
board.userid = userid;
board.user = user;
board.user_name = window.user_name;
board.totalRequired = window.totalRequired;
board.answeredRequired = window.answeredRequired;
board.save = "saved";
board.time = formattedTime;

// Check current answer status
const hasCupAnswers = window.cup_answeredRequired > 0;
const hasBucketAnswers = window.bucket_answeredRequired > 0;

// FIRST-TIME LOGIC - This is the guaranteed solution
if (hasCupAnswers || hasBucketAnswers) {
    // Set main firsttime if not already set
    if (typeof board.firsttime === 'undefined') {
        board.firsttime = formattedTime;
    }
    
    // Set cup_firsttime if has cup answers and not set
    if (hasCupAnswers && typeof board.cup_firsttime === 'undefined') {
        board.cup_firsttime = formattedTime;
    }
    
    // Set bucket_firsttime if has bucket answers and not set
    if (hasBucketAnswers && typeof board.bucket_firsttime === 'undefined') {
        board.bucket_firsttime = formattedTime;
    }
}

// Update statistics
board.bucket_totalRequired = window.bucket_totalRequired;
board.cup_totalRequired = window.cup_totalRequired;
board.bucket_answeredRequired = window.bucket_answeredRequired;
board.cup_answeredRequired = window.cup_answeredRequired;
        // Create progress panel
        createPanel("verticalProgressPanel2", "TR", "ctc", 60, 50, {
            title: "SAVE",
            verticalProgressBar: 100,
            noHeader: true,
            progressBar: 100,
            noFooter: true,
            bodyContent: `
            <div class="progress-container" style="overflow:hidden;display: flex; flex-direction: column; align-items: center;">
                <span class="progress-label">Saving...</span>
                <div class="progress-bar vertical">
                    <div class="progress-fill vertical" style="height: 0%"></div>
                </div>
            </div>`,
        });
        setTimeout(() => {
            toast(
                " Start saving ...",
                { pos: "TR", slide: "ttb" },
                { background: "red", width: 200 },
                2000,
            );
            moveXY("verticalProgressPanel2", window.innerWidth - 60, 40);
        }, 50);

        const panel = document.getElementById("verticalProgressPanel2");
        panel.style.left = window.innerWidth - 70 + "px";
        panel.style.top = "10px";

        try {
            const startTime = Date.now();

            // Prepare payload with all data
            const payload = {
                data: {
                    id,
                    name: user,
                    bucket: JSON.stringify(bucket || {}),
                    cup: JSON.stringify(cup || {}),
                    board: JSON.stringify(board || {}),
                    timestamp: new Date().toISOString(),
                },
            };

            // Get cached ETag if available
            const getUrl = `https://i.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
            const cachedETag = sessionStorage.getItem(`etag:${getUrl}`);
            const headers = {
                "Content-Type": "application/json",
                ...(cachedETag && { "If-Match": cachedETag }),
            };

            // Show saving progress
            updateProgress(panel, 30, "Uploading data...");

            const response = await fetch("https://i.kunok.com/api622.php", {
                method: "POST",
                headers: headers,
                body: JSON.stringify(payload),
            });

            if (!response.ok) {
                const text = await response.text();
                if (response.status === 412) {
                    throw new Error(
                        "Data was modified by another user. Please reload and try again.",
                    );
                }
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            // Update progress
            updateProgress(panel, 70, "Verifying save...");

            // Update ETag if available
            const etag = response.headers.get("ETag");
            if (etag) {
                sessionStorage.setItem(`etag:${getUrl}`, etag);
            }

            // Verify the save by fetching the data back
            const verifyResponse = await fetch(getUrl);
            if (!verifyResponse.ok) {
                throw new Error("Failed to verify saved data");
            }

            const verifiedData = await verifyResponse.json();
            if (!verifiedData.data) {
                throw new Error("No data in verification response");
            }

            // Compare the saved data with what we sent
            const isDataValid = compareSavedData(
                payload.data,
                verifiedData.data,
            );
            if (!isDataValid) {
                throw new Error("Saved data verification failed");
            }

            // Update progress to complete
            updateProgress(panel, 100, "Save verified!");

            console.log(`✅ Save completed in ${Date.now() - startTime}ms`);
            toast(
                "✅ Saved successfully",
                { pos: "TR", slide: "ttb" },
                { background: "green" },
            );

            // Also save to local storage as backup
            saveToLocalStorage(id);
// Check if summan-grand panel exists and close it
        const summanPanel = document.getElementById('summan-grand');
        if (summanPanel) {
            closePanel('summan-grand');
        }
            return true;
        } catch (e) {
            console.error("❌ Save failed:", e.message);
            toast(
                `❌ Save failed: ${e.message}`,
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
            return false;
        } finally {
            // Close progress panel after a delay
            setTimeout(() => closePanel("verticalProgressPanel2"), 1500);
        }
    }
async function saveToServerM(id) {
    // Early exit checks
    if (!navigator.onLine) {
        console.warn("⚠️ Offline — cannot save to server");
        toast("⚠️ Offline - cannot save", { pos: "TR", slide: "ttb" }, { background: "orange" });
        return false;
    }

    if (!id) {
        console.warn("⚠️ ID is required");
        toast("⚠️ ID is required", { pos: "TR", slide: "ttb" }, { background: "orange" });
        return false;
    }

    // Check for actual data content
    const hasValidData = () => {
        const hasBucket = bucket && Object.keys(bucket).length > 0;
        const hasCup = cup && Object.keys(cup).length > 0;
        const hasBoard = board && Object.keys(board).length > 0;
        return hasBucket || hasCup || hasBoard;
    };

    if (!hasValidData()) {
        toast("⚠️ No data to save", { pos: "TR", slide: "rtl" }, { background: "red" });
        return false;
    }

    // Calculate statistics
    const bucketStats = getFieldStats(bucket);
    const cupStats = getFieldStats(cup);
    
    // Update window variables
    window.bucket_answeredRequired = bucketStats.answeredRequired;
    window.bucket_totalRequired = bucketStats.totalRequired;
    window.cup_answeredRequired = cupStats.answeredRequired;
    window.cup_totalRequired = cupStats.totalRequired;
    
    // Calculate progress
    let aap = window.bucket_totalRequired + window.cup_totalRequired;
    window.totalRequired = aap;
    let asp = window.bucket_answeredRequired + window.cup_answeredRequired;
    window.answeredRequired = asp;
    let overallPercent = aap > 0 ? Math.min(100, Math.round((asp / aap) * 100)) : 0;
    let stillneed = aap - asp;
    
    // Update UI
    let prog = `Progress (${asp}/${aap}) ` + overallPercent + "%";
    updateStatus("A1", prog);
    if (overallPercent > 0) updateBadge("A1", stillneed, "red");
    if (overallPercent === 100) updateBadge("A1", "Ready", "green");

    // Format current time
  const now = new Date();
const formattedTime = 
    now.getFullYear() + '-' + 
    String(now.getMonth() + 1).padStart(2, '0') + '-' + 
    String(now.getDate()).padStart(2, '0') + ' ' + 
    String(now.getHours()).padStart(2, '0') + ':' + 
    String(now.getMinutes()).padStart(2, '0') + ':' + 
    String(now.getSeconds()).padStart(2, '0');

// Initialize or update board object
if (!board) {
    board = {
        userid: userid,
        user: user,
        user_name: window.user_name,
        totalRequired: window.totalRequired,
        answeredRequired: window.answeredRequired,
        save: "saved",
        time: formattedTime,
        firstTime: formattedTime // Set first time on creation
    };
} else {
    // Simple property updates - your original clear approach
    board.userid = userid;
    board.user = user;
    board.user_name = window.user_name;
    board.totalRequired = window.totalRequired;
    board.answeredRequired = window.answeredRequired;
    board.save = "saved";
    board.time = formattedTime;
    
    // Simple firstTime check
    if (!board.firstTime) board.firstTime = formattedTime;
    
    // Track first completion times
    if (window.cup_answeredRequired > 0 && !board.cup_firsttime) {
        board.cup_firsttime = formattedTime;
    }
    
    if (window.bucket_answeredRequired > 0 && !board.bucket_firsttime) {
        board.bucket_firsttime = formattedTime;
    }
    
    // Update statistics
    board.bucket_totalRequired = window.bucket_totalRequired;
    board.cup_totalRequired = window.cup_totalRequired;
    board.bucket_answeredRequired = window.bucket_answeredRequired;
    board.cup_answeredRequired = window.cup_answeredRequired;
}

    // Create progress panel
    createPanel("verticalProgressPanel2", "TR", "ctc", 60, 50, {
        title: "SAVE",
        verticalProgressBar: 100,
        noHeader: true,
        progressBar: 100,
        noFooter: true,
        bodyContent: `
        <div class="progress-container" style="overflow:hidden;display: flex; flex-direction: column; align-items: center;">
            <span class="progress-label">Saving...</span>
            <div class="progress-bar vertical">
                <div class="progress-fill vertical" style="height: 0%"></div>
            </div>
        </div>`,
    });
    
    setTimeout(() => {
        toast("Start saving...", { pos: "TR", slide: "ttb" }, { background: "red", width: 200 }, 2000);
        moveXY("verticalProgressPanel2", window.innerWidth - 60, 40);
    }, 50);

    const panel = document.getElementById("verticalProgressPanel2");
    panel.style.left = window.innerWidth - 70 + "px";
    panel.style.top = "10px";

    try {
        const startTime = Date.now();

        // Prepare payload with all data
        const payload = {
            data: {
                id,
                name: user,
                bucket: JSON.stringify(bucket || {}),
                cup: JSON.stringify(cup || {}),
                board: JSON.stringify(board || {}),
                timestamp: new Date().toISOString(),
            },
        };

        // Get cached ETag if available
        const getUrl = `https://i.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        const cachedETag = sessionStorage.getItem(`etag:${getUrl}`);
        const headers = {
            "Content-Type": "application/json",
            ...(cachedETag && { "If-Match": cachedETag }),
        };

        // Show saving progress
        updateProgress(panel, 30, "Uploading data...");

        const response = await fetch("https://i.kunok.com/api622.php", {
            method: "POST",
            headers: headers,
            body: JSON.stringify(payload),
        });

        if (!response.ok) {
            const text = await response.text();
            if (response.status === 412) {
                throw new Error("Data was modified by another user. Please reload and try again.");
            }
            throw new Error(`HTTP ${response.status}: ${text}`);
        }

        // Update progress
        updateProgress(panel, 70, "Verifying save...");

        // Update ETag if available
        const etag = response.headers.get("ETag");
        if (etag) {
            sessionStorage.setItem(`etag:${getUrl}`, etag);
        }

        // Verify the save by fetching the data back
        const verifyResponse = await fetch(getUrl);
        if (!verifyResponse.ok) {
            throw new Error("Failed to verify saved data");
        }

        const verifiedData = await verifyResponse.json();
        if (!verifiedData.data) {
            throw new Error("No data in verification response");
        }

        // Compare the saved data with what we sent
        const isDataValid = compareSavedData(payload.data, verifiedData.data);
        if (!isDataValid) {
            throw new Error("Saved data verification failed");
        }

        // Update progress to complete
        updateProgress(panel, 100, "Save verified!");

        console.log(`✅ Save completed in ${Date.now() - startTime}ms`);
        toast("✅ Saved successfully", { pos: "TR", slide: "ttb" }, { background: "green" });

        // Also save to local storage as backup
        saveToLocalStorage(id);
        
        // Check if summan-grand panel exists and close it
        const summanPanel = document.getElementById('summan-grand');
        if (summanPanel) {
            closePanel('summan-grand');
        }
        
        return true;
    } catch (e) {
        console.error("❌ Save failed:", e.message);
        toast(`❌ Save failed: ${e.message}`, { pos: "TR", slide: "ttb" }, { background: "red" });
        return false;
    } finally {
        // Close progress panel after a delay
        setTimeout(() => closePanel("verticalProgressPanel2"), 1500);
    }
}    
function loadFromLocalStorage(userId) {
        console.log("loadFromLocalStorage");
        try {
            const savedData = localStorage.getItem(`userData_${userId}`);
            if (!savedData) {
                console.log("ℹ️ No local data found for user:", userId);
                return false;
            }

            const data = JSON.parse(savedData);

            // Update the global objects
            bucket = data.bucket || {};
            cup = data.cup || {};
            board = data.board || {};

            console.log("✅ Loaded from LocalStorage for user:", userId);
            return true;
        } catch (e) {
            console.error("❌ LocalStorage load failed:", e);
            return false;
        }
    }
    function saveToLocalStorage(userId) {
        console.log("saveToLocalStorage");
        try {
            const data = {
                bucket: bucket || {},
                cup: cup || {},
                board: board || {},
                lastSaved: new Date().toISOString(),
            };

            localStorage.setItem(`userData_${userId}`, JSON.stringify(data));
            console.log("✅ Saved to LocalStorage for user:", userId);
            toast(
                "✅ Saved to LocalStorage",
                { pos: "BR", slide: "btt" },
                { background: "green", color: "white" },
                500,
            );
        } catch (e) {
            console.error("❌ LocalStorage save failed:", e);
            toast(
                "❌ LocalStorage save failed",
                { pos: "TR", slide: "ttb" },
                { background: "red", color: "white" },
                1000,
            );
        }
    }    
    //window.loadFromLocalStorage=false;
    async function loadPanelDataNoCOmpress(id, panelId, formId, objectKey) {
    // Show loading started toast
    toast(
        `⏳ Loading ${panelId}...`,
        { pos: "BR", slide: "btt" },
        { background: "#2196F3" },
        1500,
    );

    const panel = document.getElementById(panelId);
    const allowLocalStorage = window.loadFromLocalStorage === true; // Must be explicitly true

    // Check if we should try localStorage first (only if window.loadFromLocalStorage is true AND we're online)
    //console.log("window.loadFromLocalStorage"+window.loadFromLocalStorage);

if (allowLocalStorage && !navigator.onLine) {
        if (loadFromLocalStorage(id)) {
            console.log(`✅ Loaded ${panelId} data from localStorage (by request)`);
            processCachedDataFromLocalStorage(panelId, formId, objectKey);
            toast(
                `✅ ${panelId} loaded from localStorage`,
                { pos: "BR", slide: "btt" },
                { background: "#4CAF50" },
                500,
            );
            return; // Exit after successful localStorage load
        }
    }

    if (!panel) {
        createPanelWrapper(panelId, formId);
        const targetEl = document.getElementById(formId);
        if (targetEl) {
            targetEl.innerHTML = `<div style="
                display: flex;
                justify-content: center;
                align-items: center;
                margin: auto;
                color: white;
                min-height: 500px;" class="loader">.</div>`;
        }
    }

    if (!navigator.onLine) {
        const message = `⚠️ Offline — loading ${panelId} from cache if available`;
        console.warn(message);
        toast(
            message,
            { pos: "TR", slide: "rtl" },
            { background: "orange" },
            2000,
        );

        // Try localStorage first when offline
        if (loadFromLocalStorage(id)) {
            console.log(`✅ Loaded ${panelId} data from localStorage (offline)`);
            processCachedDataFromLocalStorage(panelId, formId, objectKey);
            toast(
                `✅ ${panelId} loaded from localStorage (offline)`,
                { pos: "BR", slide: "btt" },
                { background: "#4CAF50" },
                500,
            );
            return;
        }

        // Fall back to memory cache
        const cached = responseCache.get(id);
        if (cached && cached.data) {
            console.log(`🛠 Using cached data for ${panelId}`);
            processCachedData(cached.data, panelId, formId, objectKey);
            toast(
                `✅ ${panelId} loaded from memory cache`,
                { pos: "BR", slide: "btt" },
                { background: "#af704cff" },
                500,
            );
            return;
        }
        
        toast(
            `❌ No cached data for ${panelId}`,
            { pos: "BR", slide: "rtl" },
            { background: "#F44336" },
            2000,
        );
        return;
    }

    if (!id) {
        const message = "⚠️ ID is required";
        console.warn(message);
        toast(
            message,
            { pos: "TR", slide: "rtl" },
            { background: "orange" },
            2000,
        );
        return;
    }

    const url = `https://i.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
    console.log(`🚀 Start loading for ${panelId}`);

    try {
        const startTime = Date.now();
        const cached = responseCache.get(id);
        const headers = cached?.etag ? { "If-None-Match": cached.etag } : {};

        // Show fetching toast
        toast(
            `🔍 Fetching ${panelId} data...`,
            { pos: "BR", slide: "btt" },
            { background: "#2196F3" },
            1000,
        );

        const response = await fetch(url, { headers });

        if (response.status === 304) {
            console.log(`✅ ${panelId} not modified, using cached data`);
            if (cached && cached.data) {
                processCachedData(cached.data, panelId, formId, objectKey);
                const loadTime = Date.now() - startTime;
                console.log(`✅ ${panelId} load completed in ${loadTime}ms`);
                toast(
                    `✅ ${panelId} loaded (cached) in ${loadTime}ms`,
                    { pos: "TR", slide: "rtl" },
                    { background: "#4CAF50" },
                    1500,
                );
                return;
            }
            throw new Error("No cached data available for 304 response");
        }

        // Show parsing toast
        toast(
            `📦 Processing ${panelId} data...`,
            { pos: "BR", slide: "rtl" },
            { background: "#0087f5ff" },
            1000,
        );

        const text = await response.text();
        if (!response.ok) {
            throw new Error(`HTTP ${response.status}: ${text}`);
        }

        const json = JSON.parse(text);
        const data = json?.data;
        if (!data) {
            const message = `⚠️ No 'data' field in ${panelId} response`;
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return;
        }

        // Store in cache and localStorage
        const etag = response.headers.get("ETag");
        if (etag) {
            responseCache.set(id, { etag, data });
        }
        saveToLocalStorage(id);
        
        processCachedData(data, panelId, formId, objectKey);
        const loadTime = Date.now() - startTime;
        console.log(`✅ ${panelId} load completed in ${loadTime}ms`);
        toast(
            `✅ ${panelId} loaded in ${loadTime}ms`,
            { pos: "BR", slide: "btt" },
            { background: "#4CAF50" },
            500,
        );
    } catch (e) {
        console.error(`❌ ${panelId} load failed:`, e.message);
        
        // On error, try to load from localStorage as fallback
        if (loadFromLocalStorage(id)) {
            console.log(`🔄 Falling back to localStorage for ${panelId}`);
            processCachedDataFromLocalStorage(panelId, formId, objectKey);
            toast(
                `✅ ${panelId} loaded from localStorage (fallback)`,
                { pos: "BR", slide: "btt" },
                { background: "#4CAF50" },
                500,
            );
            return;
        }
        
        toast(
            `❌ ${panelId} load failed: ${e.message}`,
            { pos: "CR", slide: "rtl" },
            { background: "#F44336" },
            3000,
        );
    }
}
    function compareSavedData(sentData, receivedData) {
        try {
            // Compare bucket
            const sentBucket = JSON.parse(sentData.bucket || "{}");
            const receivedBucket = JSON.parse(receivedData.bucket || "{}");
            if (JSON.stringify(sentBucket) !== JSON.stringify(receivedBucket)) {
                console.warn("Bucket data mismatch");
                return false;
            }

            // Compare cup
            const sentCup = JSON.parse(sentData.cup || "{}");
            const receivedCup = JSON.parse(receivedData.cup || "{}");
            if (JSON.stringify(sentCup) !== JSON.stringify(receivedCup)) {
                console.warn("Cup data mismatch");
                return false;
            }

            // Compare board
            const sentBoard = JSON.parse(sentData.board || "{}");
            const receivedBoard = JSON.parse(receivedData.board || "{}");
            if (JSON.stringify(sentBoard) !== JSON.stringify(receivedBoard)) {
                console.warn("Board data mismatch");
                return false;
            }

            return true;
        } catch (e) {
            console.error("Comparison error:", e);
            return false;
        }
    }
    const visibleFields = ["Respondent Name", "Respondent Position","Telephone Number","Respondent Email"]; // Leave empty to show all fields in visible sections

  async function renderCupToDivProfileML(id, divId = "divprofile") {
    const data = await loadDataOnly(id);
    if (!data || !data.cup) {
        document.getElementById(divId).innerHTML = "<em>❌ No cup data found</em>";
        return;
    }

    const lang = window.lang || "en";
    const cupData = JSON.parse(data.cup || "{}");
    let html = "<pre style='white-space: pre-wrap; font-family: monospace;'>";

    // Create a case-insensitive version of visibleFields for comparison
    const visibleFieldsLower = visibleFields.map(field => field.toLowerCase());

    for (const key in cupData) {
        const field = cupData[key];
        if (!field || typeof field !== "object") continue;

        // Get label in the current language
        let label = key;
        if (field.label) {
            if (typeof field.label === "string") {
                label = field.label;
            } else if (field.label[lang]) {
                label = field.label[lang];
            } else if (field.label.en) {
                label = field.label.en; // Fallback to English
            } else if (Array.isArray(field.label)) {
                label = field.label[0]; // Use first array item
            }
        }

        const value = getReadableValueML(field, lang);

        if (value && value !== "") {
            // Check if we should show this field
            const shouldShow = visibleFields.length === 0 || 
                visibleFieldsLower.some(visibleField => 
                    label.toLowerCase().includes(visibleField) ||
                    (field.label?.en && field.label.en.toLowerCase().includes(visibleField)) ||
                    (field.label?.th && field.label.th.toLowerCase().includes(visibleField))
                );

            if (shouldShow) {
                html += `${label}: ${value}\n`;
            }
        }
    }

    html += "</pre>";
    document.getElementById(divId).innerHTML = html;
}

    function getReadableValueML(field, lang) {
        if (!field) return "";

        // Handle different data types
        switch (field.data_type) {
            case "string":
                return field.value || "";
            case "radiotext":
            case "radiotextatt":
                const radioValue = field.value.radio || "";
                let radioText = "";
                if (field.options && field.options[lang] && radioValue !== "") {
                    const index = parseInt(radioValue);
                    if (
                        !isNaN(index) &&
                        field.options[lang][index] !== undefined
                    ) {
                        radioText = field.options[lang][index];
                    }
                }
                return `${radioText} ${field.value.text || ""}`.trim();
            case "attachment":
                return field.value || "";
            case "checkbox":
                if (Array.isArray(field.value)) {
                    if (field.options && field.options[lang]) {
                        return field.value
                            .map((val) => field.options[lang][val])
                            .join(", ");
                    }
                    return field.value.join(", ");
                }
                return "";
            case "radio":
                if (
                    field.options &&
                    field.options[lang] &&
                    field.value !== undefined
                ) {
                    const index = parseInt(field.value);
                    if (
                        !isNaN(index) &&
                        field.options[lang][index] !== undefined
                    ) {
                        return field.options[lang][index];
                    }
                }
                return field.value || "";
            default:
                if (field.value !== undefined) {
                    return typeof field.value === "object"
                        ? JSON.stringify(field.value)
                        : String(field.value);
                }
                return "";
        }
    }
// Save data to localStorage
// Save data to localStorage
function saveTLS(userId, objectKey) {
    try {
        // Validate data for bucket
        let dataToSave = window[objectKey] || {};
        if (objectKey === "bucket") {
            if (!dataToSave.grouping || typeof dataToSave.grouping !== "object") {
                console.warn(`⚠️ Missing or invalid grouping in ${objectKey}, applying default`);
                dataToSave.grouping = {
                    name: ["default"],
                    type: ["segment"],
                    label: { en: ["Default"], th: ["ค่าเริ่มต้น"] }
                };
            }
        }
        
        const data = {
            [objectKey]: dataToSave,
            lastSaved: new Date().toISOString()
        };
        localStorage.setItem(`userData_${userId}`, JSON.stringify(data));
        console.log(`✅ Saved to localStorage for ${userId}:`, JSON.stringify(data, null, 2));
        toast(
            `✅ Saved ${objectKey} to localStorage`,
            { pos: "BR", slide: "btt" },
            { background: "green", color: "white" },
            500
        );
        return true;
    } catch (e) {
        console.error(`❌ Failed to save to localStorage: ${e.message}`);
        toast(
            `❌ Failed to save ${objectKey} to localStorage`,
            { pos: "TR", slide: "ttb" },
            { background: "red", color: "white" },
            1000
        );
        return false;
    }
}

// Load data from localStorage
function loadTLS(userId, objectKey, formId) {
    try {
        const savedData = localStorage.getItem(`userData_${userId}`);
        if (!savedData) {
            console.log(`ℹ️ No data found in localStorage for ${userId}`);
            toast(
                `ℹ️ No ${objectKey} data in localStorage`,
                { pos: "BR", slide: "btt" },
                { background: "orange", color: "white" },
                1000
            );
            return false;
        }
        const data = JSON.parse(savedData);
        if (!data[objectKey]) {
            console.log(`ℹ️ No ${objectKey} found in localStorage data for ${userId}`);
            toast(
                `ℹ️ No ${objectKey} in localStorage`,
                { pos: "BR", slide: "btt" },
                { background: "orange", color: "white" },
                1000
            );
            return false;
        }
        window[objectKey] = data[objectKey];
        console.log(`✅ Loaded ${objectKey} from localStorage for ${userId}:`, JSON.stringify(window[objectKey], null, 2));
        
        // Validate grouping for bucket only
        if (objectKey === "bucket" && (!window[objectKey].grouping || typeof window[objectKey].grouping !== "object")) {
            console.warn(`⚠️ Missing or invalid grouping in ${objectKey}, applying default`);
            window[objectKey].grouping = {
                name: ["default"],
                type: ["segment"],
                label: { en: ["Default"], th: ["ค่าเริ่มต้น"] }
            };
        }
        
        // Update UI
        if (document.getElementById("summan")) {
            renderSchemaStructureToSumman(window[objectKey], formId, window.lang || "en");
        }
        if (document.getElementById("jumperhelper")) {
            updateJumperHelperWithUnanswered(QSummary(window[objectKey]).summary, window[objectKey]);
        }
        
        toast(
            `✅ Loaded ${objectKey} from localStorage`,
            { pos: "BR", slide: "btt" },
            { background: "green", color: "white" },
            500
        );
        return true;
    } catch (e) {
        console.error(`❌ Failed to load from localStorage: ${e.message}`);
        toast(
            `❌ Failed to load ${objectKey} from localStorage`,
            { pos: "TR", slide: "ttb" },
            { background: "red", color: "white" },
            1000
        );
        return false;
    }
}