<?php
header('Access-Control-Allow-Origin: *');

// Get all parameters from POST data
$folder = isset($_POST['folder']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folder']) : 'default';
$foldergroup = isset($_POST['foldergroup']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['foldergroup']) : '';
$folderuser = isset($_POST['folderuser']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['folderuser']) : '';
$userid = isset($_POST['userid']) ? preg_replace('/[^a-zA-Z0-9_-]/', '', $_POST['userid']) : '';

// Determine if this is a logo upload (based on presence of userid)
$isLogoUpload = !empty($userid);

// Build the upload directory path
if ($isLogoUpload) {
    // For logos: ./s/logos/user_{userid}/
    $uploadDir = "./s/logos/user_" . $userid . "/";
} else {
    // For regular files: ./s/{folder}/{group}/{user}/
    $uploadDir = "./s/" . $folder . "/";
    if ($foldergroup) $uploadDir .= $foldergroup . "/";
    if ($folderuser) $uploadDir .= $folderuser . "/";
}


// Create directory if it doesn't exist
if (!file_exists($uploadDir)) {
    mkdir($uploadDir, 0777, true);
}

// Process file upload
if (!empty($_FILES['fileUpload'])) {
    $originalName = $_FILES['fileUpload']['name'];
    
    // Sanitize filename and make unique for logos
    if ($isLogoUpload) {
        $fileExt = pathinfo($originalName, PATHINFO_EXTENSION);
        $filename = "logo." . $fileExt; // Standardize logo filename
    } else {
        $filename = preg_replace('/[^a-zA-Z0-9._-]/', '', $originalName);
    }

    $location = $uploadDir . $filename;

    // Handle filename conflicts (except for logos which overwrite)
    if (!$isLogoUpload && file_exists($location)) {
        $fileBase = pathinfo($filename, PATHINFO_FILENAME);
        $counter = 1;
        while (file_exists($location)) {
            $filename = $fileBase . "($counter)." . $fileExt;
            $location = $uploadDir . $filename;
            $counter++;
        }
    }

    // Move the uploaded file
    if (move_uploaded_file($_FILES['fileUpload']['tmp_name'], $location)) {
        // Logging (modified for logo uploads)
        $host = $_SERVER['HTTP_HOST'];
        $currentDir = dirname($_SERVER['PHP_SELF']);
        
        if ($isLogoUpload) {
            $locationPath = $host . $currentDir . "/s/logos/user_" . $userid . "/" . $filename;
            $logEntry = "logo_upload=" . date("Y/m/d H:i:s") . ",userid=" . $userid . ",location=" . $locationPath;
            file_put_contents("./logos_log.txt", PHP_EOL . $logEntry, FILE_APPEND | LOCK_EX);
        } else {
            $locationPath = $host . $currentDir . "/s/" . $folder;
            if ($foldergroup) $locationPath .= "/" . $foldergroup;
            if ($folderuser) $locationPath .= "/" . $folderuser;
            $locationPath .= "/" . $filename;
            
            $logEntry = "locationdatetime=" . date("Y/m/d H:i:s") . ",file=" . $filename . ",location=" . $locationPath;
            
            // Maintain existing log files
            $logAll = $folder . "_log.txt";
            $logGroup = $foldergroup ? $folder . "_" . $foldergroup . "_log.txt" : '';
            $logUser = ($foldergroup && $folderuser) ? $folder . "_" . $foldergroup . "_" . $folderuser . "_log.txt" : '';
            
            file_put_contents("./" . $logAll, PHP_EOL . $logEntry, FILE_APPEND | LOCK_EX);
            if ($logGroup) file_put_contents("./" . $logGroup, PHP_EOL . $logEntry, FILE_APPEND | LOCK_EX);
            if ($logUser) file_put_contents("./" . $logUser, PHP_EOL . $logEntry, FILE_APPEND | LOCK_EX);
        }

        // Return the relative path
        if ($isLogoUpload) {
            echo "s/logos/user_" . $userid . "/" . $filename;
        } else {
            echo "s/" . $folder . "/" . ($foldergroup ? $foldergroup . "/" : "") . ($folderuser ? $folderuser . "/" : "") . $filename;
        }
    } else {
        echo "ERROR: File move failed";
    }
} else {
    echo "ERROR: No file uploaded";
}
?>