function showSmartUserStatus(
  user = "Johnny",
  avatarURL = "https://via.placeholder.com/32"
) {
  if (!document.body) {
    const body = document.createElement("body");
    document.documentElement.appendChild(body);
  }

  const existing = document.getElementById("smartUserStatus");
  if (existing) existing.remove();

  const box = document.createElement("div");
  box.id = "smartUserStatus";
  box.style.position = "absolute";
  box.style.left = "-400px"; // Off screen
  box.style.top = localStorage.getItem("smartStatusY") || "calc(100% - 80px)";
  box.style.padding = "6px 12px";
  box.style.borderRadius = "12px";
  box.style.fontSize = "14px";
  box.style.backdropFilter = "blur(20px)";
  box.style.background = "rgba(0,0,0,0.01)";
  box.style.boxShadow = "0 4px 12px rgba(0,0,0,0.3)";
  box.style.zIndex = "9999";
  box.style.transition = "all 0.3s ease";
  box.style.transform = "scale(1)";
  box.style.opacity = "0";
  box.style.display = "flex";
  box.style.alignItems = "center";
  box.style.gap = "8px";
  box.style.userSelect = "none";
  box.style.maxWidth = "max-content";

  const blueDot = document.createElement("div");
  blueDot.style.width = "14px";
  blueDot.style.height = "14px";
  blueDot.style.borderRadius = "50%";
  blueDot.style.background = "#2196f3";
  blueDot.style.flexShrink = "0";
  blueDot.style.cursor = "pointer";

  const redDot = document.createElement("div");
  redDot.style.width = "14px";
  redDot.style.height = "14px";
  redDot.style.borderRadius = "50%";
  redDot.style.background = "#f44336";
  redDot.style.flexShrink = "0";
  redDot.style.cursor = "pointer";
  redDot.title = "Logout";
  redDot.style.display = "none";

  const avatar = document.createElement("img");
  avatar.src = avatarURL;
  avatar.alt = "avatar";
  avatar.draggable = false; // Disable default image dragging
  avatar.style.width = "28px";
  avatar.style.height = "28px";
  avatar.style.borderRadius = "50%";
  avatar.style.objectFit = "cover";
  avatar.style.border = "1px solid #888";
  avatar.style.cursor = "move";
  avatar.ondblclick = () => {
    box.style.left = "20px";
    box.style.top = "calc(100% - 80px)";
    localStorage.removeItem("smartStatusX");
    localStorage.removeItem("smartStatusY");
  };
  avatar.addEventListener("dragstart", (e) => e.preventDefault()); // Prevent default drag

  const infoText = document.createElement("span");
  infoText.innerHTML = `Logged in as: ${user}
    <a href="#" id="langLink" style="border-radius:4px;background:rgba(200,200,200,.5);text-decoration:none;padding:0px 4px;color:rgba(200,250,200,1);margin-left:6px;">lang</a>
    <a href="#" id="infoLink" style="border-radius:4px;background:rgba(200,200,200,.5);text-decoration:none;padding:0px 4px;color:rgba(200,250,200,1);margin-left:6px;">Info</a>
    <a href="#" id="logoutLink" style="border-radius:4px;background:rgba(200,200,200,.5);text-decoration:none;padding:0px 4px;color:rgba(200,250,200,1);margin-left:6px;">Logout</a>`;
  infoText.style.whiteSpace = "nowrap";

  box.appendChild(avatar);
  box.appendChild(infoText);
  box.appendChild(blueDot);
  box.appendChild(redDot);

  document.body.appendChild(box);

  requestAnimationFrame(() => {
    box.style.left = "20px";
    box.style.opacity = "1";
  });

  let expanded = true;

  function collapse() {
    expanded = false;
    infoText.style.display = "none";
    redDot.style.display = "inline-block";
    box.style.padding = "6px";
    avatar.style.display = "inline-block";
  }

  function expand() {
    expanded = true;
    infoText.style.display = "inline";
    redDot.style.display = "none";
    box.style.padding = "6px 12px";
    avatar.style.display = "inline-block";
    box.style.left = localStorage.getItem("smartStatusX") || "20px";
  }

  blueDot.onclick = () => (expanded ? collapse() : expand());

  redDot.onclick = () => {
    if (confirm("Log out?")) {
      alert("Logging out...");
      localStorage.removeItem("logged");
    }
  };

  infoText.querySelector("#langLink").addEventListener("click", (e) => {
    e.preventDefault();
    showUserLangPanel();
  });

  infoText.querySelector("#infoLink").addEventListener("click", (e) => {
    e.preventDefault();
    showUserInfoPanel();
  });

  infoText.querySelector("#logoutLink").addEventListener("click", (e) => {
    e.preventDefault();
    if (confirm("Log out?")) {
      logout();
      localStorage.removeItem("logged");
    }
  });

  let isDragging = false,
    offsetX = 0,
    offsetY = 0;

  box.addEventListener(
    "mousedown",
    (e) => {
      if (e.target.tagName === "A" || e.target === blueDot || e.target === redDot) return;
      isDragging = true;
      offsetX = e.clientX - box.getBoundingClientRect().left;
      offsetY = e.clientY - box.getBoundingClientRect().top;
      box.style.transition = "none";
      document.addEventListener("mousemove", onDrag);
      document.addEventListener("mouseup", onRelease);
    },
    { passive: false }
  );

  box.addEventListener(
    "touchstart",
    (e) => {
      if (e.target.tagName === "A" || e.target === blueDot || e.target === redDot) return;
      isDragging = true;
      const touch = e.touches[0];
      offsetX = touch.clientX - box.getBoundingClientRect().left;
      offsetY = touch.clientY - box.getBoundingClientRect().top;
      box.style.transition = "none";
      document.addEventListener("touchmove", onTouchDrag, { passive: false });
      document.addEventListener("touchend", onTouchRelease, { passive: false });
    },
    { passive: false }
  );

  function onDrag(e) {
    if (!isDragging) return;
    document.body.style.userSelect = "none";
    const rect = box.getBoundingClientRect();
    const maxX = window.innerWidth - rect.width;
    const maxY = window.innerHeight - rect.height;
    let newX = e.clientX - offsetX;
    let newY = e.clientY - offsetY;
    newX = Math.max(0, Math.min(newX, maxX));
    newY = Math.max(0, Math.min(newY, maxY));
    box.style.left = newX + "px";
    box.style.top = newY + "px";
    box.style.transform = "translateX(0)";
  }

  function onRelease() {
    isDragging = false;
    document.body.style.userSelect = "";
    box.style.transition = "all 0.3s ease";
    localStorage.setItem("smartStatusX", box.style.left);
    localStorage.setItem("smartStatusY", box.style.top);
    document.removeEventListener("mousemove", onDrag);
tyle.top = newY + "px";
  }

  function onTouchDrag(e) {
    if (!isDragging) return;
    e.preventDefault(); // Prevent scrolling during drag
    document.body.style.userSelect = "none";
    const touch = e.touches[0];
    const rect = box.getBoundingClientRect();
    const maxX = window.innerWidth - rect.width;
    const maxY = window.innerHeight - rect.height;
    let newX = touch.clientX - offsetX;
    let newY = touch.clientY - offsetY;
    newX = Math.max(0, Math.min(newX, maxX));
    newY = Math.max(0, Math.min(newY, maxY));
    box.style.left = newX + "px";
    box.style.top = newY + "px";
    box.style.transform = "translateX(0)";
  }

  function onTouchRelease() {
    isDragging = false;
    document.body.style.userSelect = "";
    box.style.transition = "all 0.3s ease";
    localStorage.setItem("smartStatusX", box.style.left);
    localStorage.setItem("smartStatusY", box.style.top);
    document.removeEventListener("touchmove", onTouchDrag);
    document.removeEventListener("touchend", onTouchRelease);
  }
}
const user = localStorage.getItem("user");
const userid = localStorage.getItem("userid");
const flag = localStorage.getItem("flag");
const level = localStorage.getItem("level");
const img = localStorage.getItem("img");
const user_startDateTime = localStorage.getItem("user_startDateTime");
const user_startTimestamp = localStorage.getItem("user_startTimestamp");

const user_imgr = localStorage.getItem("img") || "";
let user_img = "https://i.pravatar.cc/40?u=yanyong";
try {
  if (user_imgr) user_img = atob(user_imgr);
} catch (e) {
  console.warn("Invalid base64 image, using default:", e);
}
//showSmartUserStatus(user, user_img);