// The Info Panel
function showUserLangPanel() {
  const userLanguageHTML = `
    <div style="line-height:1.5; text-align: center;">
      <div id="langsw">
        <div id="userLanguageHTML">
          <div class="lang-switcher-slide" id="slideSwitch" onclick="toggleLang()">
            <div class="lang-slide-option">EN</div>
            <div class="lang-slide-option">TH</div>
            <div class="lang-slide-indicator"></div>
          </div>
        </div>
      </div>
    </div>
  `;

  createPanel("LangInfo", "BR", "rtl", 200, 150, {
    headerTitle: "Language Info",
    bodyContent: userLanguageHTML,
    noFooter: true,
    bodyCloseButton: false,
    noHeader: true,
    noDrag: true,
    bodyCloseButton: true,
    radius: "8px",
  });
  
  // Initialize the switch after panel is created
  const savedLang = localStorage.getItem('language') || 'en';
  updateSwitch(savedLang);
  setTimeout(() => {
  moveXY("LangInfo",window.innerWidth - 220, window.innerHeight-170);
  },100);
}
     currentLang = window.lang || localStorage.getItem('language') || 'en';
 
   window.lang = currentLang;
// Toggle between EN/TH
function toggleLang() {
  const currentLang = localStorage.getItem('language') || 'en';
  const newLang = currentLang === 'en' ? 'th' : 'en';
  setLanguage(newLang);
  switchLang(newLang);
  window.lang = newLang; // Update global lang variable
}

// Update UI and storage
function setLanguage(lang) {
  localStorage.setItem('language', lang);
  updateSwitch(lang);
  console.log('Language set to:', lang);
  // Add your actual language switching logic here
}

// Visual update
function updateSwitch(lang) {
  const switchEl = document.getElementById('slideSwitch');
  if (switchEl) {
    switchEl.classList.toggle('active', lang === 'th');
  }
}
function switchLang(lang) {
        window.lang = lang;
        document.querySelectorAll(".lang-btn").forEach((btn) => {
            btn.classList.toggle("active", btn.dataset.lang === lang);
        });
        // Scan window.ps and call appropriate function
        window.lang = lang;

        // Refresh all forms in the stack
        formStack.forEach((panelId) => {
            if (panelId === "gen") {
                genpaN(userid); // Refresh main form
            } else if (panelId === "profile") {
                profilepaN(userid); // Refresh profile form
            }
            // Add more form types as needed
        });

        // Optional: Refresh summary panels if they exist
        if (document.getElementById("summan")) {
            renderSchemaStructureToSumman(bucket, "gform", lang);
        }
        if (document.getElementById("jumperhelper")) {
            updateJumperHelperWithUnanswered(QSummary(bucket).summary, bucket);
        }
    }
addStyle(`      
  /* Toggle slide switch */
  .lang-switcher-slide {
    font-family: Arial, sans-serif;
    position: relative;
    display: inline-block;
    width: 120px;
    height: 40px;
    background: #f0f0f0;
    border-radius: 20px;
    overflow: hidden;
    cursor: pointer;
  }
  .lang-slide-option {
    position: absolute;
    width: 50%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 2;
    color: #666;
    font-weight: bold;
    transition: color 0.3s;
  }
  .lang-slide-option:nth-child(1) { left: 0; }
  .lang-slide-option:nth-child(2) { left: 50%; }
  
  /* Active text color */
  .lang-switcher-slide:not(.active) .lang-slide-option:nth-child(1),
  .lang-switcher-slide.active .lang-slide-option:nth-child(2) {
    color: white;
  }
  
  /* Sliding indicator */
  .lang-slide-indicator {
    position: absolute;
    width: 50%;
    height: 100%;
    background: #007bff;
    border-radius: 20px;
    transition: all 0.3s ease;
    left: 0;
    z-index: 1;
  }
  .lang-switcher-slide.active .lang-slide-indicator {
    left: 50%;
    background: #28a745;
  }
  .lang-btn.active {
    background-color: blue;
    color: blue;
  }
  .lang-switcher {
    margin-bottom: 20px;
    display: flex;
    gap: 10px;
    align-items: center;
  }
  .lang-switcher button {
    padding: 10px 20px;
    font-size: 14px;
    border-radius: 4px;
    border: 1px solid #aaa;
    background: #f4f4f4;
    cursor: pointer;
    transition: background-color 0.2s;
  }
  .lang-switcher button:hover {
    background: #e0e0e0;
  }
  .lang-switcher button.active {
    background-color: #4CAF50;
    color: white;
    border-color: #4CAF50;
  }
`);