 bucket = {};
    cup = {};
    board = {};
    formStack = [];
// In-memory cache for ETags and responses
    const responseCache = new Map();
    async function loadPanelDataNoCOmpress(id, panelId, formId, objectKey) {
        // Show loading started toast
        toast(
            `⏳ Loading ${panelId}...`,
            { pos: "TR", slide: "rtl" },
            { background: "#2196F3" },
            1500,
        );

        const panel = document.getElementById(panelId);

        if (!panel) {
            createPanelWrapper(panelId, formId);
            const targetEl = document.getElementById(formId);
            if (targetEl) {
                targetEl.innerHTML = `<div style="
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    margin: auto;
                    color: white;
                    min-height: 500px;" class="loader">.</div>`;
            }
        }

        if (!navigator.onLine) {
            const message = `⚠️ Offline — loading ${panelId} from cache if available`;
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data for ${panelId}`);
                processCachedData(cached.data, panelId, formId, objectKey);
                toast(
                    `✅ ${panelId} loaded from cache`,
                    { pos: "TR", slide: "rtl" },
                    { background: "#4CAF50" },
                    1500,
                );
                return;
            }
            toast(
                `❌ No cached data for ${panelId}`,
                { pos: "TR", slide: "rtl" },
                { background: "#F44336" },
                2000,
            );
            return;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return;
        }

        const url = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading for ${panelId}`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                `🔍 Fetching ${panelId} data...`,
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ ${panelId} not modified, using cached data`);
                if (cached && cached.data) {
                    processCachedData(cached.data, panelId, formId, objectKey);
                    const loadTime = Date.now() - startTime;
                    console.log(
                        `✅ ${panelId} load completed in ${loadTime}ms`,
                    );
                    toast(
                        `✅ ${panelId} loaded (cached) in ${loadTime}ms`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                `📦 Processing ${panelId} data...`,
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = `⚠️ No 'data' field in ${panelId} response`;
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }

            processCachedData(data, panelId, formId, objectKey);
            const loadTime = Date.now() - startTime;
            console.log(`✅ ${panelId} load completed in ${loadTime}ms`);
            toast(
                `✅ ${panelId} loaded in ${loadTime}ms`,
                { pos: "TR", slide: "rtl" },
                { background: "#4CAF50" },
                1500,
            );
        } catch (e) {
            console.error(`❌ ${panelId} load failed:`, e.message);
            toast(
                `❌ ${panelId} load failed: ${e.message}`,
                { pos: "TR", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
        }
    }
    

    // Helper function to process data (cached or fresh)
    function processCachedData(data, panelId, formId, objectKey) {
        const tryParse = (str) => {
            try {
                return JSON.parse(str);
            } catch {
                return {};
            }
        };

        bucket = tryParse(data.bucket || "{}");
        cup = tryParse(data.cup || "{}");
        board = tryParse(data.board || "{}");

        const objectMap = { bucket, cup };
        const targetObj = objectMap[objectKey];

        const panel = document.getElementById(panelId);
        if (!panel) {
            createPanelWrapper(panelId, formId);
        } else {
            genform(formId, targetObj);
        }
    }
    async function saveToServerM(id) {
        // Early exit checks
        if (!navigator.onLine) {
            console.warn("⚠️ Offline — cannot save to server");
            toast(
                "⚠️ Offline - cannot save",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        if (!id) {
            console.warn("⚠️ ID is required");
            toast(
                "⚠️ ID is required",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        // Check for actual data content
        const hasValidData = () => {
            const hasBucket = bucket && Object.keys(bucket).length > 0;
            const hasCup = cup && Object.keys(cup).length > 0;
            const hasBoard = board && Object.keys(board).length > 0;
            return hasBucket || hasCup || hasBoard;
        };

        if (!hasValidData()) {
            toast(
                "⚠️ No data to save",
                { pos: "TR", slide: "rtl" },
                { background: "red" },
            );
            return false;
        }

        // Create progress panel
        createPanel("verticalProgressPanel2", "TR", "ctc", 60, 220, {
            title: "SAVE",
            verticalProgressBar: 100,
            noHeader: true,
            progressBar: 100,
            noFooter: true,
            bodyContent: `
            <div class="progress-container" style="display: flex; flex-direction: column; align-items: center;">
                <span class="progress-label">Saving...</span>
                <div class="progress-bar vertical">
                    <div class="progress-fill vertical" style="height: 0%"></div>
                </div>
            </div>`,
        });
        setTimeout(() => {
            toast(
                " Start saving ...",
                { pos: "TR", slide: "rtl" },
                { background: "red", width: 200 },
                1000,
            );
            moveXY("verticalProgressPanel2", window.innerWidth - 100, 80);
        }, 50);

        const panel = document.getElementById("verticalProgressPanel2");
        panel.style.left = window.innerWidth - 70 + "px";
        panel.style.top = "10px";

        try {
            const startTime = Date.now();

            // Prepare payload with all data
            const payload = {
                data: {
                    id,
                    name: id,
                    bucket: JSON.stringify(bucket || {}),
                    cup: JSON.stringify(cup || {}),
                    board: JSON.stringify(board || {}),
                    timestamp: new Date().toISOString(),
                },
            };

            // Get cached ETag if available
            const getUrl = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
            const cachedETag = sessionStorage.getItem(`etag:${getUrl}`);
            const headers = {
                "Content-Type": "application/json",
                ...(cachedETag && { "If-Match": cachedETag }),
            };

            // Show saving progress
            updateProgress(panel, 30, "Uploading data...");

            const response = await fetch("https://j.kunok.com/api622.php", {
                method: "POST",
                headers: headers,
                body: JSON.stringify(payload),
            });

            if (!response.ok) {
                const text = await response.text();
                if (response.status === 412) {
                    throw new Error(
                        "Data was modified by another user. Please reload and try again.",
                    );
                }
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            // Update progress
            updateProgress(panel, 70, "Verifying save...");

            // Update ETag if available
            const etag = response.headers.get("ETag");
            if (etag) {
                sessionStorage.setItem(`etag:${getUrl}`, etag);
            }

            // Verify the save by fetching the data back
            const verifyResponse = await fetch(getUrl);
            if (!verifyResponse.ok) {
                throw new Error("Failed to verify saved data");
            }

            const verifiedData = await verifyResponse.json();
            if (!verifiedData.data) {
                throw new Error("No data in verification response");
            }

            // Compare the saved data with what we sent
            const isDataValid = compareSavedData(
                payload.data,
                verifiedData.data,
            );
            if (!isDataValid) {
                throw new Error("Saved data verification failed");
            }

            // Update progress to complete
            updateProgress(panel, 100, "Save verified!");

            console.log(`✅ Save completed in ${Date.now() - startTime}ms`);
            toast(
                "✅ Saved successfully",
                { pos: "TR", slide: "ttb" },
                { background: "green" },
            );

            // Also save to local storage as backup
            saveToLocalStorage(id);

            return true;
        } catch (e) {
            console.error("❌ Save failed:", e.message);
            toast(
                `❌ Save failed: ${e.message}`,
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
            return false;
        } finally {
            // Close progress panel after a delay
            setTimeout(() => closePanel("verticalProgressPanel2"), 1500);
        }
    }

    // Helper function to update progress panel
    function updateProgress(panel, percent, message) {
        if (!panel) return;

        const fill = panel.querySelector(".progress-fill.vertical");
        const label = panel.querySelector(".progress-label");

        if (fill) fill.style.height = `${percent}%`;
        if (label) label.textContent = message;
    }

    // Helper function to compare saved data
    function compareSavedData(sentData, receivedData) {
        try {
            // Compare bucket
            const sentBucket = JSON.parse(sentData.bucket || "{}");
            const receivedBucket = JSON.parse(receivedData.bucket || "{}");
            if (JSON.stringify(sentBucket) !== JSON.stringify(receivedBucket)) {
                console.warn("Bucket data mismatch");
                return false;
            }

            // Compare cup
            const sentCup = JSON.parse(sentData.cup || "{}");
            const receivedCup = JSON.parse(receivedData.cup || "{}");
            if (JSON.stringify(sentCup) !== JSON.stringify(receivedCup)) {
                console.warn("Cup data mismatch");
                return false;
            }

            // Compare board
            const sentBoard = JSON.parse(sentData.board || "{}");
            const receivedBoard = JSON.parse(receivedData.board || "{}");
            if (JSON.stringify(sentBoard) !== JSON.stringify(receivedBoard)) {
                console.warn("Board data mismatch");
                return false;
            }

            return true;
        } catch (e) {
            console.error("Comparison error:", e);
            return false;
        }
    }

    // Unified panel creator
    function createPanelWrapper(panelId, formId) {
        // Track the current form globally

        // Add to stack if not already present
        if (!formStack.includes(panelId)) {
            formStack.push(panelId);
        }

        const content = `<div id="${formId}">Wait...</div>`;
        if (formId === "gform") {
            fsize = 700;
            rdir = "ttb";
        } else {
            fsize = 540;
            rdir = "btt";
        }
        const commonFooterButtons = [
            {
                label: "💾 Save💥",
                align: "center",

                onclick: (id) => saveToServerM(userid),
            },
            {
                label: "🌐 Load 💥",
                align: "center",

                onclick: (id) => genpaN(userid),
            },
            {
                label: "Close 💥",
                className: "task-btn",
                align: "center",
                onclick: (id, label) => {
                    closePanel(id);
                },
            },
        ];
        createPanel(panelId, "TC", rdir, fsize, window.innerHeight - 20, {
            noHeader: false,
            headerTitle: "form",
            bodyContent: content,
            bodyCloseButton: false,
            footerButtons: commonFooterButtons,
            footerTitle: "-",
            noDrag: false,
            resizeAble: true,
            overflow: true,
            radius: "1px",
            footerCloseBtn: true,
        });

        setTimeout(() => {
            moveXY(panelId, 140, 10);
        }, 10);
        addFooterButton(panelId, "Save", {
            className: "task-btn",
            align: "left",
            onclick: (id, label) => {
                saveToLocalStorage(userid);
            },
        });
        addFooterButton(panelId, "Load", {
            className: "task-btn",
            align: "left",
            onclick: (id, label) => {
                if (loadFromLocalStorage(userid)) {
                    // Refresh forms if they exist
                    if (document.getElementById("gform"))
                        genform("gform", bucket);
                    if (document.getElementById("pro")) genform("pro", cup);
                    //updateGrandSummary("summan", true, true);
                }
            },
        });
        //if (formId === "gform") genform(formId, bucket);        else if (formId === "pro") genform(formId, cup);
         // Add scroll position restoration after generating the form
    if (formId === "gform") {
        genform(formId, bucket);
        restoreScrollPosition(formId);
    } 
    else if (formId === "pro") {
        genform(formId, cup);
        restoreScrollPosition(formId);
    }
    }

    // Reusable functions
    function genpa(id) {
        loadPanelData(id, "gen", "gform", "bucket");
    }
    function genpaN(id) {
        loadPanelDataNoCOmpress(id, "gen", "gform", "bucket");
    }

    function profilepa(id) {
        loadPanelData(id, "profile", "pro", "cup");
    }
    function profilepaN(id) {
        loadPanelDataNoCOmpress(id, "profile", "pro", "cup");
    }
    function toggleGenPanel() {
        const panel = document.getElementById("gen");
        panel ? closePanel("gen") : createPanelWrapper("gen", "gform");
    }

    function toggleProfilePanel() {
        const panel = document.getElementById("profile");
        panel ? closePanel("profile") : createPanelWrapper("profile", "pro");
    }
    function togglerssum1Panel() {
        panel = document.getElementById("rssum1panel");
        if (panel) {
            closePanel("rssum1panel");
        } else {
            createrssum1panelPanel();
        }
    }
    function togglesummanPanel() {
        panel = document.getElementById("summ");
        if (panel) {
            closePanel("summ");
        } else {
            createsummPanel();
        }
    }
    function togglejumpPanel() {
        panel = document.getElementById("jump");
        if (panel) {
            closePanel("jump");
        } else {
            createjumpPanel();
        }
    }
    function createrssum1panelPanel() {
        createPanel("rssum1panel", "TC", "ttb", 840, window.innerHeight, {
            noHeader: true,
            headerTitle: "Stat",
            bodyContent: '<div id="rsSum1"></div>',
            bodyCloseButton: true,
            noFooter: true,
            noDrag: false,
            overflow: true,
            resizeAble: true,
            radius: "8px",
        });
    }

    function createsummPanel() {
        createPanel("summ", "TR", "ttb", 240, window.innerHeight, {
            noHeader: true,
            headerTitle: "Stat",
            bodyContent: '<div id="summan"></div>',
            bodyCloseButton: true,
            noFooter: true,
            noDrag: false,
            overflow: true,
            resizeAble: true,
            radius: "8px",
        });
    }
    function createjumpPanel() {
        createPanel("jump", "TC", "rtl", 240, window.innerHeight, {
            noHeader: true,
            headerTitle: "Stat",
            bodyContent: '<div id="jumperhelper"></div>',
            bodyCloseButton: true,
            noFooter: true,
            noDrag: false,
            overflow: true,
            resizeAble: true,
            radius: "8px",
        });
        setTimeout(() => {
            moveXY("jump", window.innerWidth - 490, 0);
        }, 10);
    }

    // Language switcher function

    function switchLang(lang) {
        window.lang = lang;
        document.querySelectorAll(".lang-btn").forEach((btn) => {
            btn.classList.toggle("active", btn.dataset.lang === lang);
        });
        // Scan window.ps and call appropriate function
        window.lang = lang;

        // Refresh all forms in the stack
        formStack.forEach((panelId) => {
            if (panelId === "gen") {
                genpaN(userid); // Refresh main form
            } else if (panelId === "profile") {
                profilepaN(userid); // Refresh profile form
            }
            // Add more form types as needed
        });

        // Optional: Refresh summary panels if they exist
        if (document.getElementById("summan")) {
            renderSchemaStructureToSumman(bucket, "gform", lang);
        }
        if (document.getElementById("jumperhelper")) {
            updateJumperHelperWithUnanswered(QSummary(bucket).summary, bucket);
        }
    }
    function toast(msgHTML, pos = {}, style = {}, timeclose = 2000) {
        const toastCount = panelStack.length + 1;
        const id = "toast_" + toastCount;
        const position = (pos.pos || "TR").toUpperCase();
        const slideDir = pos.slide || posToDir(position);
        const defaultWidth = 300;
        const defaultHeight = 80;

        // Use style.width if provided, otherwise use defaultWidth
        const panelWidth = style.width || defaultWidth;
        const panelHeight = style.height || defaultHeight;

        createPanel(id, position, slideDir, panelWidth, panelHeight, {
            toast: true,
            bodyContent: `<div style="margin-top: -10px;">
        <div style="display:flex; align-items:center; gap:10px;">
          <span style="font-size:20px;"> </span>
          <div>
            <div style="font-size:12px;"></div>
            <div style="margin-top:10px;font-size:12px;">${msgHTML}</div>
          </div>
        </div>
      </div>`,
            timeClose: timeclose,
            noDrag: true,
        });

        const panel = document.getElementById(id);
        if (panel && style.background) {
            panel.querySelector(".panel-body").style.background =
                style.background;
        }
        if (panel && style.color) {
            panel.querySelector(".panel-body").style.color = style.color;
        }
    }
    addStyle(`
                    .progress-bar {
                      width: 100px;
                      height: 8px;
                      background: rgba(0, 0, 0, 0.2);
                      border-radius: 4px;
                      overflow: hidden;
                      position: relative;
                    }
                    .progress-bar.vertical {
                      width: 8px;
                      height: 100px;
                      display: inline-block;
                    }
                    .progress-fill {
                      height: 100%;
                      background: #4caf50;
                      width: 0%;
                      transition: width 0.1s linear;
                    }
                    .progress-fill.vertical {
                      width: 100%;
                      height: 0%;
                      position: absolute;
                      bottom: 0;
                      transition: height 0.1s linear;
                    }
                    .progress-container {
                      display: flex;
                      align-items: center;
                      gap: 10px;
                    }
                    .progress-label {
                      font-size: 12px;
                      color: #333;
                    }
                    .header-progress-container {
                      flex-grow: 1;
                      margin-left: 10px;
                    }
                      .progress-bar {
                      width: 100px;
                      height: 8px;
                      background: rgba(0, 0, 0, 0.2);
                      border-radius: 4px;
                      overflow: hidden;
                    }
                    .progress-fill {
                      height: 100%;
                      background: #4caf50;
                      transition: width 0.3s ease;
                    }
                    .progress-container {
                      display: flex;
                      align-items: center;
                      gap: 10px;
                    }
                    .progress-label {
                      font-size: 12px;
                      color: #333;
                    }
                    .header-progress {
                      font-size: 12px;
                      color: #666;
                      margin-left: 10px;
                      font-family: monospace;
                    }
                    `);
 async function loadDataOnly(id) {
        // Show loading started toast
        toast(
            "⏳ Loading data...",
            { pos: "TR", slide: "rtl" },
            { background: "#2196F3" },
            1500,
        );

        if (!navigator.onLine) {
            const message = "⚠️ Offline — using cached data if available";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data`);
                toast(
                    "✅ Using cached data",
                    { pos: "TR", slide: "rtl" },
                    { background: "#4CAF50" },
                    1500,
                );
                return cached.data;
            }
            return null;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return null;
        }

        const url = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading data`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                "🔍 Fetching data...",
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ Not modified, using cached data`);
                if (cached && cached.data) {
                    const loadTime = Date.now() - startTime;
                    console.log(`✅ Load completed in ${loadTime}ms`);
                    toast(
                        `✅ Loaded from cache (${loadTime}ms)`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return cached.data;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                "📦 Processing data...",
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = "⚠️ No 'data' field in response";
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return null;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }

            const loadTime = Date.now() - startTime;
            console.log(`✅ Load completed in ${loadTime}ms`);
            toast(
                `✅ Load successful (${loadTime}ms)`,
                { pos: "TR", slide: "rtl" },
                { background: "#4CAF50" },
                1500,
            );
            return data;
        } catch (e) {
            console.error("❌ Load failed:", e.message);
            toast(
                `❌ Load failed: ${e.message}`,
                { pos: "TR", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
            return null;
        }
    }                    
    function restoreScrollPosition(panelId = "gen") {
  const panel = document.getElementById(panelId);
  if (!panel) return;
  const body = panel.querySelector(".panel-body");
  if (!body) return;
  const pos = JSON.parse(localStorage.getItem(`scroll_${panelId}`) || "{}");
  
  if (pos && typeof pos.top === "number") {
    // Smooth scroll implementation
    body.scrollTo({
      top: pos.top,
      left: pos.left || 0,
      behavior: 'smooth'
    });
    console.log(`✅ Restored scroll for ${panelId} with smooth animation`, pos.top, pos.left);
  }
}