// In-memory cache for ETags and responses
const responseCache = new Map();
function safeParseJSON(str) {
        try {
            return JSON.parse(str || "{}");
        } catch (e) {
            console.error("JSON parse error:", e);
            return {};
        }
    }
function normalizeGroupingData(data) {
        if (!data) return null;

        // Case 1: New structure (data_type: "grouping" at root)
        if (data.data_type === "grouping") {
            return {
                name: data.name || [],
                label: data.label || { en: [], th: [] },
                type: data.type || [],
            };
        }
        // Case 2: Old structure (nested under "grouping" key)
        else if (data.grouping) {
            return {
                name: data.grouping.name || [],
                label: data.grouping.label || { en: [], th: [] },
                type: data.grouping.type || [],
            };
        }
        // Case 3: No recognized grouping structure
        return null;
    }    
async function loadAndUpdateGS(id) {
   idx = "myPanel";
  const existing = document.getElementById(id);
// Check and remove existing panel if it exists
  const existingPanel = document.getElementById(idx);
  if (existingPanel) {
    try {
      // Try to use panel system's close method if available
      if (existingPanel.close) {
        existingPanel.close();
      } else {
        // Fallback removal
        existingPanel.remove();
      }
    } catch (e) {
      console.error("Error removing existing panel:", e);
    }
  }

  // Check and remove existing progress circle if it exists
  const existingLeftOne = document.getElementById("leftone");
  if (existingLeftOne) {
    try {
      existingLeftOne.remove();
    } catch (e) {
      console.error("Error removing existing leftone:", e);
    }
  }

  // Check and remove right content if it exists
  const existingRightOne = document.getElementById("rightone");
  if (existingRightOne) {
    try {
      existingRightOne.remove();
    } catch (e) {
      console.error("Error removing existing rightone:", e);
    }
  }
  aa = 0;
  bb = 0;
  lbb = 0;

  try {
    const data = await loadDataOnly(id);
    console.log("✔️ Raw data from loadDataOnly():", data);

    bucket = safeParseJSON(data.bucket) || {};
    cup = safeParseJSON(data.cup) || {};
    board = safeParseJSON(data.board) || {};

    console.log("✔️ Parsed bucket:", bucket);
    console.log("✔️ Parsed cup:", cup);
    console.log("✔️ Parsed board:", board);

    const containers = [
      { data: bucket, name: "Bucket" },
      { data: cup, name: "Cup" },
      { data: board, name: "Board" },
    ].filter(c => c.data && Object.keys(c.data).length);

    if (containers.length === 0) {
      console.warn("⚠️ No valid containers with data.");
      return;
    }

    const summaryData = [];  // ✅ define inside try block

    let totalAnsweredRequired = 0;
    let totalRequired = 0;

    console.log("=== Summary ===");

    containers.forEach(container => {
      const summaryResult = QSummary(container.data);
      if (!summaryResult?.summary?.totals) {
        console.warn(`⚠️ QSummary failed for ${container.name}`);
        return;
      }

      const s = summaryResult.summary.totals;

      const requiredPercent = s.requiredFields > 0
        ? Math.round((s.answeredRequiredFields / s.requiredFields) * 100)
        : 0;

      summaryData.push({
        title: `📦 ${container.name}`,
        required: `${s.answeredRequiredFields}/${s.requiredFields}`,
        totalFields: `${s.answeredFields}/${s.allFields}`,
        files: s.totalFiles || 0,
        progress: requiredPercent,
      });

      totalAnsweredRequired += s.answeredRequiredFields;
      totalRequired += s.requiredFields;

      console.log(`📦 ${container.name}`);
      console.log(`  - Required: ${s.answeredRequiredFields}/${s.requiredFields}`);
      console.log(`  - Total Fields: ${s.answeredFields}/${s.allFields}`);
      console.log(`  - Files: ${s.totalFiles || 0}`);
      console.log(`  - Progress: ${requiredPercent}%`);
    });

    // Render panel
    bb = `Total Fields: ${aa}/${bb}`;
    createPanel(idx, "CC", "ctc", 620, window.innerHeight-10, {
      title: "myPanel 🦘",
      noFooter: true,
      noDrag: false,
      forceReload:true,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
       <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 2px;">
    <p><div id="leftone">${bb}</div></p>
    
  </div>
  <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px;">
    <div id="rightone"></div>
    
  </div>
      </div>`
    });

    // ⭕ Initialize circular progress bar
    
    //const update = makeCircleProgress("leftone");
    //update(totalAnsweredRequired, totalRequired);

    // ✅ Now render the summary
    renderSummary(summaryData, "rightone");
    document.getElementById("leftone").insertAdjacentHTML("beforeend", `
<div class="itemBoxX" style="margin-top: 1px;">
      <div id="analogClock"></div>
    </div>
    <div class="itemBoxX" style="margin-top: 1px;">
      <div id="digitalClock"></div>
    </div>
    <div class="itemBoxX" style="margin-top: 1px;">
      <div id="countdownClock"></div>
    </div>
   
`);

//makeAnalogClock("analogClock");
//makeDigitalClock("digitalClock");
//makeCountdown("countdownClock");
  } catch (e) {
    console.error("❌ Error loading and summarizing:", e);
  }
}    
async function loadAndUpdateSummaries(id) {
    console.log("ID:"+id);
        try {
            // Show loading indicator
            toast(
                "⏳ Loading summaries...",
                { pos: "BR", slide: "ttb" },
                { background: "blue" },
            );

            const data = await loadDataOnly(id);
            if (!data) {
                toast(
                    "⚠️ No data received",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Parse and store into memory
            bucket = safeParseJSON(data.bucket) || {};
            cup = safeParseJSON(data.cup) || {};
            board = safeParseJSON(data.board) || {};
            // Normalize grouping data (works with both structures)
            const normalizedGrouping = normalizeGroupingData(bucket);
            if (normalizedGrouping) {
                // For backward compatibility, ensure bucket has grouping in expected format
                if (!bucket.grouping && !bucket.data_type) {
                    bucket.grouping = normalizedGrouping;
                }
            }
            // Verify data was loaded
            if (
                Object.keys(bucket).length === 0 &&
                Object.keys(cup).length === 0 &&
                Object.keys(board).length === 0
            ) {
                toast(
                    "⚠️ Empty data loaded",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Check for cup data and warn if missing
            if (!cup || Object.keys(cup).length === 0) {
                toast(
                    "⚠️ No Cup data found",
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                );
            }

            // Update summary UIs
            updateGrandSummary("summan", true, true);

            // Also update other summary panels if they exist
            if (document.getElementById("requirementProgress")) {
                const totals = QSummary(bucket).summary.totals;
                updateRequirementProgress(
                    totals.answeredRequiredFields,
                    totals.requiredFields,
                );
            }

            if (document.getElementById("requirementChecklist")) {
                updateRequirementChecklist([
                    { data: bucket, name: "Bucket" },
                    { data: cup, name: "Cup" },
                ]);
            }

            toast(
                "✅ Summaries updated",
                { pos: "BR", slide: "RTL" },
                { background: "green" },
            );
        } catch (e) {
            console.error("❌ Failed to load summaries:", e);
            toast(
                "❌ Failed to load summaries",
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
        }
    }
async function loadDataOnly(id) {
        // Show loading started toast
        toast(
            "⏳ Loading data...",
            { pos: "TR", slide: "rtl" },
            { background: "#2196F3" },
            1500,
        );

        if (!navigator.onLine) {
            const message = "⚠️ Offline — using cached data if available";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data`);
                toast(
                    "✅ Using cached data",
                    { pos: "TR", slide: "rtl" },
                    { background: "#4CAF50" },
                    1500,
                );
                return cached.data;
            }
            return null;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return null;
        }

        const url = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading data`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                "🔍 Fetching data...",
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ Not modified, using cached data`);
                if (cached && cached.data) {
                    const loadTime = Date.now() - startTime;
                    console.log(`✅ Load completed in ${loadTime}ms`);
                    toast(
                        `✅ Loaded from cache (${loadTime}ms)`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return cached.data;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                "📦 Processing data...",
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = "⚠️ No 'data' field in response";
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return null;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }

            const loadTime = Date.now() - startTime;
            console.log(`✅ Load completed in ${loadTime}ms`);
            toast(
                `✅ Load successful (${loadTime}ms)`,
                { pos: "TR", slide: "rtl" },
                { background: "#4CAF50" },
                1500,
            );
            return data;
        } catch (e) {
            console.error("❌ Load failed:", e.message);
            toast(
                `❌ Load failed: ${e.message}`,
                { pos: "TR", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
            return null;
        }
    }    
function updateGrandSummary(targetDivPrefix,hoverMode = false,showOnlyBucketCup = false) {
        // Initialize containers array
        let containers = [
            { data: bucket, name: "Bucket" },
            { data: cup, name: "Cup" },
            { data: board, name: "Board" },
        ].filter((container) => container.data); // Only include if data exists
        BucketName = "Assessment";
        CupName = "Profile";
        // Show warning if specifically requesting Bucket & Cup but cup is missing
        if (showOnlyBucketCup && (!cup || !Object.keys(cup).length)) {
            toast(
                "⚠️ Cup data not available",
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
            );
        }

        // Filter to only show Bucket and Cup if requested
        if (showOnlyBucketCup) {
            containers = containers.filter(
                (container) =>
                    container.name === "Bucket" || container.name === "Cup",
            );
        }

        const grandDivId = `${targetDivPrefix}-grand`;
        const panelExists = document.getElementById(grandDivId);

        // Calculate grand totals and container statuses
        let grandTotals = {
            allFields: 0,
            requiredFields: 0,
            answeredFields: 0,
            answeredRequiredFields: 0,
            totalFiles: 0, // Initialize file count          
        };

        let allReady = true;
        let allInactive = true;
        const containerStatuses = [];
            assessment_prog="";
            profile_prog="";
            all_prog="";
            status_prog="";
            assessment_dot="";
            profile_dor="";
            all_dot="";
            status_dot="";

        containers.forEach((container, index) => {
            const summary = QSummary(container.data).summary.totals;
            let requiredPercent =
                summary.requiredFields > 0
                    ? Math.round(
                          (summary.answeredRequiredFields /
                              summary.requiredFields) *
                              100,
                      )
                    : 0;

            // Aggregate all counts including files
            grandTotals.allFields += summary.allFields || 0;
            grandTotals.requiredFields += summary.requiredFields || 0;
            grandTotals.answeredFields += summary.answeredFields || 0;
            grandTotals.answeredRequiredFields +=
                summary.answeredRequiredFields || 0;
            grandTotals.totalFiles += summary.totalFiles || 0; // Add file count

            // Determine container status
            let status, statusClass;
            if (summary.requiredFields === 0) {
                status = "No Required Fields";
                statusClass = "status-neutral";
            } else if (
                summary.answeredRequiredFields >= summary.requiredFields
            ) {
                status = "READY ✓";
                statusClass = "status-ready";
                allInactive = false;
                status_dot="greenDot";
            } else if (summary.answeredRequiredFields > 0) {
                status = "IN PROGRESS 🟡";
                statusClass = "status-progress";
                allReady = false;
                allInactive = false;
                status_dot="yellowDot";
            } else {
                status = "INACTIVE ⛔";
                statusClass = "status-inactive";
                allReady = false;
                status_dot="redDot";
            }

            containerStatuses.push({
                name: container.name,
                status: status,
                statusClass: statusClass,
                requiredPercent: requiredPercent,
                stats: summary,
                totalFiles: summary.totalFiles || 0, // Add file count per container
            });
        });

        // Determine submit status status-ready
        let submitStatus, submitStatusClass;
        let isReadyToSubmit = false; // Add this flag

        if (containers.length === 0) {
            submitStatus = "NO DATA";
            submitStatusClass = "status-neutral";
        } else if (allReady) {
            submitStatus = " ✅ READY FOR SUBMIT";
            submitStatusClass = "status-ready-submit";
            isReadyToSubmit = true; // Set flag when ready
            status_dot="greenDot";
            progress_prog=submitStatus;
        } else if (allInactive) {
            submitStatus = "INACTIVE ⛔";
            submitStatusClass = "status-inactive";
            status_dot="redDot";
            progress_prog=submitStatus;
        } else {
            submitStatus = "IN PROGRESS 🟡";
            submitStatusClass = "status-progress";
            status_dot="yellowDot";
            progress_prog=submitStatus;
        }

        // Show alert if ready to submit
        if (isReadyToSubmit) {
            // Only alert if this is a new ready state (not already ready)
            if (!window.wasReadyToSubmit) {
              
             // cfb=document.querySelector(".confirm_btn");
              //cfb.style.display="block";
                alert("READY TO SUBMIT! All requirements are complete.");
                // Optional: Play a sound
               
            }
        }
        window.wasReadyToSubmit = isReadyToSubmit; // Remember state

        // Calculate grand percentages
        const grandRequiredPercent =
            grandTotals.requiredFields > 0
                ? Math.round(
                      (grandTotals.answeredRequiredFields /
                          grandTotals.requiredFields) *
                          100,
                  )
                : 0;

        // Build HTML content
        let html = `
    <style>
    .status-ready-submit     { color: #1c7d22ff; font-weight: bold; }
    .status-ready { color: #3b5a3dff; font-weight: bold; }
        .status-progress { color: #aa7f00ff; font-weight: bold; }
        .status-inactive { color: #F44336; font-weight: bold; }
        .status-neutral { color: #9E9E9E; }
        
        .container-card {
            margin: 1px 0;
            padding: 2px 10px;
            background:rgba(250,250,250,.4);
            backdrop-filter: blur(15px);
            box-shadow: 2px 2px 12px rgba(0, 0, 0, 0.1);
            border-radius: 6px;
            border-left: 4px solid #ddd;
            font-size:12px;
            width:85%;
        }
            .container-card strong{
            color:rgba(30, 24, 102, 0.8);
            font-size:13px;
            }
        .toggle-btn {
            padding: 5px 10px;
            background: #f0f0f0;
            border: 1px solid #ddd;
            border-radius: 4px;
            cursor: pointer;
            margin: 5px 0;
            font-size: 12px;
        }
        .toggle-btn:hover {
            background: #e0e0e0;
        }
        .file-count {
            margin-top: 1px;
            font-size: 0.9em;
            color: #666;
        }
        


#checklist {
  --item-bg: rgba(55,55,55,.8);
  --item-text-color: rgba(247, 247, 247, 0.8);
  --item-padding: 1px 16px;
  --item-gap: 2px;
  --item-radius: 12px;
  --item-border: 0px solid rgba(200,200,200,.01);
      border-radius: 16px; 
      background:rgba(200,200,200,.2);
      width:85%;
}

/* Individual item styling */
.itemsDisplay {
  display: flex;
  align-items: center;
  gap: var(--item-gap);
  background: var(--item-bg);
  color: var(--item-text-color);
  padding: var(--item-padding);
  border-radius: var(--item-radius);
  border: var(--item-border);
  margin-bottom: 6px;
  
}

/* Status dot styling */
.itemsStatusDot {
  width: 12px;
  height: 12px;
  border-radius: 50%;
  flex-shrink: 0;
}

/* Text area styling */
.itemsText {
  flex-grow: 1;
  white-space: nowrap;
  overflow: hidden;
  text-overflow: ellipsis;
  font-size:13px;
}

/* Color variants */
.greyDot { background: #95a5a6; }
.greenDot { background: #27ae60; }
.redDot { background: #e74c3c; }
.yellowDot { background: #f39c12; }
.blueDot { background: #3498db; }
.purpleDot { background: #9b59b6; }


.progress-container {
  font-family: Arial, sans-serif;
  font-size:12px;
  border: 0px solid #e0e0e0;
  border-radius: 8px;
  //background-color: #f9f9f9;
  //box-shadow: 1 2px 4px rgba(0,0,0,0.1);
}

.progress-container {
  font-family: sans-serif;
  width: 85%;
  margin-top:10px;
  padding: 2px 10px;
  border: 0px solid rgba(0,0,0,0.7);
  border-radius: 8px;
  background-color: rgba(255,255,255,.5);
  display: grid;
  grid-template-rows: auto auto;
  gap: 2px;
   box-shadow: 0 2px 4px rgba(0,0,0,0.1);
   
  backdrop-filter: blur(45px);
}

/* First row - status and stats */
.status-row {
  display: flex;
  justify-content: space-between;
  align-items: center;
}

.status-progress {
  font-weight: bold;
}

/* Second row - progress bar and completion */
.progress-row {
  display: flex;
  flex-direction: column;
  gap: 6px;
}

.progress-barI {
  height: 10px;
  background-color: #e0e0e0;
  border-radius: 10px;
  overflow: hidden;
  margin: 4px 0;
}

.progress-fill {
  height: 100%;
  background-color: #006eaaff;
  transition: width 0.3s ease;

}

.completion-stats {
  display: flex;
  justify-content: space-between;
  font-size: 0.9em;
  color: #666;
}
  #center{
   display: flex; flex-direction: column; align-items: center;
  }
   .confirm_btn {
        padding: 2px 6px !important;  /* Reduced padding */
        margin-left: 4px !important;  /* Reduced gap */
        font-size: 12px !important;
    }
    
   /* Timing section styling */
#timing_sec {
        gap: 6px !important;  /* Reduced from 10px */
        padding: 4px 8px !important;
         background-color: #006eaaff;
         backdrop-filter: blur(45px);
    }
    
    #timing_left {
        padding-right: 4px !important;
    }

#timing_right {
  margin-left: 1px;
}

.confirm_btn {
  padding: 1px 1px;
  border: none;
  border-radius: 6px;
  background-color: rgba(30, 136, 229, 0.9);
  
  font-weight: bold;
  cursor: pointer;
  transition: background-color 0.2s;
  box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.confirm_btn:hover {
  background-color: rgba(21, 101, 192, 0.9);
}
  .progress-checklist-wrapper {
    display: flex;
    flex-direction: column;
    align-items: center;
    gap: 10px;
    width: 100%;
}
     #cclock {
        display: flex;
        justify-content: space-between;
        font-family: sans-serif;
        font-size: 13px;
        padding: 5px 1px;
        background: rgba(200,200,200,0.1);
        border-radius: 6px;
        margin-bottom: -5px;
    }
    
    .clock-section {
        display: flex;
        align-items: center;
        gap: 6px;
    }
    
    .expired-date {
    font-size:13px;
        color: ${window.dateExpired && new Date() > new Date(window.dateExpired) ? '#d5271bff' : '#000e2dff'};
        font-weight: ${window.dateExpired && new Date() > new Date(window.dateExpired) ? 'bold' : 'normal'};
    }
    .right-align {
        justify-content: flex-end;
    }
    #timing_left {
        padding-right: 4px !important;
    }
    .countdown {
        color: #4CAF50;
    }
    </style>

    <div style="text-align: right;display:none">
        <button class="toggle-btn" onclick="updateGrandSummary('${targetDivPrefix}', ${hoverMode}, ${!showOnlyBucketCup})">
            ${showOnlyBucketCup ? "Show All" : "Show Only ${BucketName} & {CupName}"}
        </button>
    </div>
<div class="progress-checklist-wrapper">    
<div id="checklist" style="padding: 10px; ">
  <div class="itemsDisplay" id="item-start">
    <div class="itemsStatusDot greyDot"></div>
    <div class="itemsText">Start</div>
  </div>
  
  <div class="itemsDisplay" id="item-profile">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Profile</div>
  </div>
  
  <div class="itemsDisplay" id="item-assessment">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Assessment</div>
  </div>
  
  <div class="itemsDisplay" id="item-end">
    <div class="itemsStatusDot  greyDot"></div>
    <div class="itemsText">Progress: 0%</div>
  </div>
  
</div>
 <div class="progress-container">
 <div id="cclock"></div>
 </div> 
    <div class="progress-container">
         <div class="${submitStatusClass}">${submitStatus}</div>
        <div>Required: ${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields} (${grandRequiredPercent}%) ,
        Files: ${grandTotals.totalFiles}</div>
        <div class="progress-barI">
            <div class="progress-fill" style="width: ${grandRequiredPercent}%; background: ${grandRequiredPercent === 100 ? "#4CAF50" : grandRequiredPercent > 0 ? "#d35b06ff" : "#F44336"};"></div>
        </div>
        <div></div>
    </div>   

    
    `;
updateProgress("A1",grandRequiredPercent);
prog=`(${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields}) `+grandRequiredPercent+"%";
all_prog=prog;

updateStatus("A1",prog);
        // Add container status cards with file counts
        containerStatuses.forEach((container) => {
            if (container.name==="Bucket") {
                updateProgress("assessment",container.requiredPercent);
                prog=`(${container.stats.answeredRequiredFields}/${container.stats.requiredFields}) `+container.requiredPercent +"%";
                updateStatus("assessment",prog);
                assessment_prog=prog;
            }
             if (container.name==="Cup") {
                updateProgress("Profile",container.requiredPercent);
                prog=`(${container.stats.answeredRequiredFields}/${container.stats.requiredFields}) `+container.requiredPercent +"%";
                updateStatus("Profile",prog);
                profile_prog=prog;
            }
            // Map internal names to display names
            const displayName =
                container.name === "Bucket"
                    ? BucketName
                    : container.name === "Cup"
                      ? CupName
                      : container.name; // Keep "Board" as is or map it if needed
            html += `
        <div class="container-card" style="border-left-color: ${container.requiredPercent === 100 ? "#4CAF50" : container.requiredPercent > 0 ? "#0059cdff" : "#F44336"}">
            <div style="display: flex; justify-content: space-between;">
                <strong>${displayName}</strong>
                <span class="${container.statusClass}">${container.status}</span>
            </div>
            <div style="margin-top: 5px;">
                <div>Required: ${container.stats.answeredRequiredFields}/${container.stats.requiredFields} ,Progress: ${container.requiredPercent}%,Files: ${container.totalFiles}</div>
                <div class="progress-barI">
                    <div class="progress-fill" style="width: ${container.requiredPercent}%; background: ${container.requiredPercent === 100 ? "#38783aff" : container.requiredPercent > 0 ? "#3362b8ff" : "#F44336"};"></div>
                </div>
                <div></div>
                <div class="file-counts"></div>
            </div>
        </div>
       
        `;
        });
//bb = `Total Fields: ${aa}/${bb}`;
bb=grandRequiredPercent;
        html += `</div>`;
layoutqold=`<div style="display: flex; height: 100%; overflow: hidden;">
    <div style="flex: 1; overflow: auto; padding: 1px; ">
      <div id="left1">${submitStatus}</div>
      
    </div>
    <div style="flex: 1; box-sizing: border-box; overflow: hidden; padding: 1px; ">
     <div id="right1">`+html+`</div>
     
    </div>
  </div>
   </div>
  </div>`;
  board={
    user: userid,
    time: new Date().toISOString()   
}
butt = "";
if (isReadyToSubmit) { butt = checksubmitbtn(); }

layoutq = `
<div style="display: flex; flex-direction: column; height: 100%; overflow: hidden;">
  <div id="timing_sec" style="display: flex; justify-content: space-between; align-items: center; padding: 8px; background: rgba(200,200,200,0.3); border-radius: 8px; margin-bottom: 8px;">
    <div id="timing_left" style="font-weight: bold; font-size: 14px;" class="${submitStatusClass}">
      ${submitStatus}
    </div>
    <div id="timing_right">
      ${butt}
    </div>
  </div>
  ${html}
</div>`;

// Then continue with your createPanel code...
        // Create or update panel
        if (!panelExists) {
            createPanel(
                grandDivId,
                "CC",
                "ctc",
                420,                
                window.innerHeight - 80,
                {
                    title:
                        "GRAND SUMMARY" +
                        (showOnlyBucketCup
                            ? `(${BucketName} & ${CupName})`
                            : ""),
                    bodyContent: layoutq,
                    bodyCloseButton: false,
                    noFooter: true,
                    noDrag: false,
                    overflow: true,
                    radius: "8px",                    
                },
                
            );
           // updateStatus('item-profile', 'Profile 50%', 'blueDot');
           updateItemStatus('item-assessment', 'Assessment '+assessment_prog, 'blueDot');
           updateItemStatus('item-profile', 'Profile '+profile_prog, 'yellowDot');
 updateItemStatus('item-end', 'Progress '+all_prog, 'greenDot')
 now = new Date();
   startTimeText = now.toLocaleTimeString();
 updateItemStatus('item-start', 'last :'+ startTimeText, 'redDot')
//  /updateItemStatus('item-progress', 'staus '+progress_prog, status_dot)

//updateChecks(true, true, true, 100);
//updateChecks('assesment', assessment_prog);
//updateChecks('profile', profile_prog);

            //moveXY(grandDivId, 590, 0);
            // ⭕ Initialize circular progress bar
          //  setTimeout(() => {
   // const update = makeCircleProgress("leftone");
    //${grandTotals.answeredRequiredFields}/${grandTotals.requiredFields}
   // update(grandTotals.answeredRequiredFields, grandTotals.requiredFields);
    // }, 50);
            // Position the panel
            const panel = document.getElementById(grandDivId);
            if (panel) {
                panel.style.right = "10px";
                panel.style.top = "20px";
              //  dragDiv(grandDivId);
            }
        } else {
            // Just update the content if panel exists
            const contentDiv = document.querySelector(
                `#${grandDivId} .panel-body`,
            );
            if (contentDiv) {
               // contentDiv.innerHTML = html;
            }
        }
        // Update progress toast at BR position
       
        // Update other panels
        if (!document.getElementById("requirementProgress")) {
          //  createRequirementProgressPanel();
        }
        //updateRequirementProgress(            grandTotals.answeredRequiredFields || 0,            grandTotals.requiredFields || 0,        );

        //if (!document.getElementById("requirementChecklist")) {            createRequirementChecklist();        }
// updateRequirementChecklist(containerStatuses.map((container) => ({...container,data:containers.find((c) => c.name === container.name)?.data ||{},})),);
    }    
function QSummary(data) {
  // Create a default empty result structure
  const defaultResult = { 
    segments: [], 
    summary: { 
      segments: {}, 
      totals: {
        allFields: 0,
        requiredFields: 0,
        answeredFields: 0,
        answeredRequiredFields: 0,
        totalScore: 0,
        totalScoreWeighted: 0,
        maxPossibleScore: 0,
        maxPossibleScoreWeighted: 0,
        totalFiles: 0,
        unansweredRequiredFields: []
      }
    } 
  };
if (!data || typeof data !== 'object') {
    console.warn("Invalid data format: data is missing or not an object");
    return { segments: [], summary: { segments: {}, totals: {} } };
  }
// Handle profile-style grouping (where grouping is an object with arrays)
  if (data.grouping && typeof data.grouping === 'object' && !Array.isArray(data.grouping)) {
    // Normalize profile grouping structure to match gen structure
    const grouping = {
      name: Array.isArray(data.grouping.name) ? data.grouping.name : [data.grouping.name || "default"],
      type: Array.isArray(data.grouping.type) ? data.grouping.type : [data.grouping.type || "segment"],
      label: {
        en: Array.isArray(data.grouping.label?.en) ? data.grouping.label.en : [data.grouping.label?.en || "Default"],
        th: Array.isArray(data.grouping.label?.th) ? data.grouping.label.th : [data.grouping.label?.th || "ค่าเริ่มต้น"]
      }
    };
    data.grouping = grouping;
  }
  // If no grouping exists at all, create a default one
  else if (!data.grouping) {
    data.grouping = {
      name: ["default"],
      type: ["segment"],
      label: { 
        en: ["Default"], 
        th: ["ค่าเริ่มต้น"] 
      }
    };
  }
  // Initialize with default grouping if missing
  if (!data.grouping) {
    data.grouping = {
      name: ["default"],
      type: ["segment"],
      label: { en: ["Default"], th: ["ค่าเริ่มต้น"] }
    };
  }

  const result = { segments: [] };
  const summary = {
    segments: {},
    totals: {
      allFields: 0,
      requiredFields: 0,
      answeredFields: 0,
      answeredRequiredFields: 0,
      totalScore: 0,
      totalScoreWeighted: 0,
      maxPossibleScore: 0,
      maxPossibleScoreWeighted: 0,
      totalFiles: 0,
      unansweredRequiredFields: [],
    },
  };

  const segmentMap = {};

  Object.entries(data).forEach(([key, item]) => {
    if (key === "grouping" || item.type === "section") return;

    const segment = item.segment?.[0] || data.grouping?.name[0] || "default";
    const section = item.section;
    if (!segment || !section || !data[section]) {
      console.warn(
        `Invalid field ${key}: missing segment or section, or section not found in schema`,
      );
      return;
    }

    // Initialize segment/section if not exists
    if (!summary.segments[segment]) {
      const segmentIndex = data.grouping.name.indexOf(segment);
      summary.segments[segment] = {
        label: data.grouping.label?.en[segmentIndex] || segment,
        sections: {},
        totals: {
          allFields: 0,
          requiredFields: 0,
          answeredFields: 0,
          answeredRequiredFields: 0,
          totalScore: 0,
          totalScoreWeighted: 0,
          maxPossibleScore: 0,
          maxPossibleScoreWeighted: 0,
          totalFiles: 0,
          unansweredRequiredFields: [],
        },
      };
    }
    if (!summary.segments[segment].sections[section]) {
      summary.segments[segment].sections[section] = {
        label: data[section]?.label?.en || section,
        totals: {
          allFields: 0,
          requiredFields: 0,
          answeredFields: 0,
          answeredRequiredFields: 0,
          totalScore: 0,
          totalScoreWeighted: 0,
          maxPossibleScore: 0,
          maxPossibleScoreWeighted: 0,
          totalFiles: 0,
          unansweredRequiredFields: [],
        },
      };
    }

    const currentScore = calculateCurrentScore(item);
    const maxScore = calculateMaxScore(item);
    const isAnswered = isFieldAnswered(item);

    // Handle file counting for all field types
    let fileCount = 0;
    if (item.data_type === "attachment") {
      fileCount = countFiles(item);
    } else if (item.data_type === "radiotextatt") {
      // Create a temporary field object just for counting
      fileCount = countFiles({
        value: item.value?.att || "",
        data_type: "attachment",
      });
    } else if (item.data_type === "radiotextatt" && item.value?.att) {
      fileCount = countFiles({
        value: item.value.att,
        data_type: "attachment",
      });
    } else if (item.data_type === "radioatt" && item.value?.att) {
      // Added for radioatt
      fileCount = countFiles({
        value: item.value.att,
        data_type: "attachment",
      });
    }

    // Update totals at all levels
    const sectionTotals = summary.segments[segment].sections[section].totals;
    const segmentTotals = summary.segments[segment].totals;
    const globalTotals = summary.totals;

    // Section level
    sectionTotals.allFields++;
    if (item.required) sectionTotals.requiredFields++;
    if (isAnswered) sectionTotals.answeredFields++;
    if (item.required && isAnswered) sectionTotals.answeredRequiredFields++;
    sectionTotals.totalScore += isAnswered ? item.score || 1 : 0;
    sectionTotals.totalScoreWeighted += currentScore;
    sectionTotals.maxPossibleScore += item.score || 1;
    sectionTotals.maxPossibleScoreWeighted += maxScore;
    sectionTotals.totalFiles += fileCount;

    // Segment level (aggregate from sections)
    segmentTotals.allFields++;
    if (item.required) segmentTotals.requiredFields++;
    if (isAnswered) segmentTotals.answeredFields++;
    if (item.required && isAnswered) segmentTotals.answeredRequiredFields++;
    segmentTotals.totalScore += isAnswered ? item.score || 1 : 0;
    segmentTotals.totalScoreWeighted += currentScore;
    segmentTotals.maxPossibleScore += item.score || 1;
    segmentTotals.maxPossibleScoreWeighted += maxScore;
    segmentTotals.totalFiles += fileCount;

    // Global level (aggregate from segments)
    globalTotals.allFields++;
    if (item.required) globalTotals.requiredFields++;
    if (isAnswered) globalTotals.answeredFields++;
    if (item.required && isAnswered) globalTotals.answeredRequiredFields++;
    globalTotals.totalScore += isAnswered ? item.score || 1 : 0;
    globalTotals.totalScoreWeighted += currentScore;
    globalTotals.maxPossibleScore += item.score || 1;
    globalTotals.maxPossibleScoreWeighted += maxScore;
    globalTotals.totalFiles += fileCount;

    // Track unanswered required fields at all levels
    if (item.required && !isAnswered) {
      const fieldInfo = {
        key,
        label: getLabel(item, window.lang || "en") || key,
        segment,
        section,
      };

      sectionTotals.unansweredRequiredFields.push(fieldInfo);
      segmentTotals.unansweredRequiredFields.push(fieldInfo);
      globalTotals.unansweredRequiredFields.push(fieldInfo);
    }
  });

  // Build the result.segments structure (if needed for other purposes)
  Object.entries(summary.segments).forEach(([segmentKey, segment]) => {
    const segmentEntry = {
      name: segmentKey,
      label: segment.label,
      sections: [],
    };

    Object.entries(segment.sections).forEach(([sectionKey, section]) => {
      segmentEntry.sections.push({
        name: sectionKey,
        label: section.label,
        totals: section.totals,
      });
    });

    result.segments.push(segmentEntry);
  });

  return { result, summary };
}    
function renderSummary(data, targetId) {
  const container = document.getElementById(targetId);
  if (!container) return;

  container.innerHTML = ''; // Clear old content

  let totalRequired = 0;
  let totalAnswered = 0;
      BucketName = "Assessment";
        CupName = "Profile";
  // Calculate summary stats
  if (data.length === 0) {
            submitStatus = "NO DATA";
}
  data.forEach(item => {
    const [answeredReq, totalReq] = item.required.split('/').map(Number);
    totalAnswered += answeredReq;
    totalRequired += totalReq;
  });

  let  overallPercent = totalRequired > 0 ? Math.min(100, Math.round((totalAnswered / totalRequired) * 100)) : 0;

  // Summary Card
  const summaryBox = document.createElement("div");
  summaryBox.className = "itemBox";
  //summaryBox.style.background = "#e3f2fd";

  summaryBox.innerHTML = `
    <div class="title">📊 Progress ${overallPercent}%</div>        

    <div class="stats">
    <progress id="file" value="${overallPercent}" max="100"> ${overallPercent} %</progress>
      <div>Answered: ${totalAnswered},Total Required: ${totalRequired}</div>
      
  `;
  updateProgress("A1",overallPercent);
  container.appendChild(summaryBox);
  prog=`Progress (${totalAnswered}/${totalRequired}) `+overallPercent+"%";
updateStatus("A1",prog);

Title="";
other=false;
  // Each Item Card
  data.forEach(item => {
    const box = document.createElement("div");
    box.className = "itemBox";

    // Clean item.title to remove duplicate emoji if present
    const cleanTitle = item.title.replace(/^📦\s*/, ''); // Remove leading 📦 emoji
if (cleanTitle==="Bucket") Title="Assessment"; 
if (cleanTitle==="Cup") Title="Profile";

 if (cleanTitle==="Bucket") {
                updateProgress("assessment",item.progress);
                prog=`${Math.min(100, item.progress)}% (${item.required}) `;
                updateStatus("assessment",prog);
                box.innerHTML = `
    <div class="stats">  <div class="title">${Title}<label for="file"> ${item.progress}%</label></div>     
    <progress id="file" value="${Math.min(100, item.progress)}" max="100"> ${Math.min(100, item.progress)}% </progress>
    <div>Required: ${item.required}, Files: ${item.files}</div>
    </div>
    `;
    
    container.appendChild(box);
            }
if (cleanTitle==="Cup") {
                updateProgress("Profile",item.progress);
                  prog=`${Math.min(100, item.progress)}% (${item.required}) `;
                updateStatus("Profile",prog);
                box.innerHTML = `
    <div class="stats">  <div class="title">${Title}<label for="file"> ${item.progress}%</label></div>     
    <progress id="file" value="${Math.min(100, item.progress)}" max="100"> ${Math.min(100, item.progress)}% </progress>
    <div>Required: ${item.required}, Files: ${item.files}</div>
    </div>
    `;
    
    container.appendChild(box);
            }            

    
   
  });
    const boxsum = document.createElement("div");
    submit_status = "ON GOING";
  boxsum.className = "itemBox";
    allReady = true;
   
    //submitStatus = "NO DATA";
if (overallPercent>=100) submit_status = "READY ✓";
  boxsum.innerHTML = `
    <div class="title">STATUS : `+submit_status+`</div>        

    <div class="stats">
  
   </div>
      
  `;

  container.appendChild(boxsum);
    
}
async function loadPanelDataNoCOmpress(id, panelId, formId, objectKey) {
        // Show loading started toast
        toast(
            `⏳ Loading ${panelId}...`,
            { pos: "TR", slide: "rtl" },
            { background: "#2196F3" },
            1500,
        );

        const panel = document.getElementById(panelId);
    // First try to load from localStorage
    if (loadFromLocalStorage(id)) {
        console.log(`✅ Loaded ${panelId} data from localStorage`);
        processCachedDataFromLocalStorage(panelId, formId, objectKey);
        toast(
            `✅ ${panelId} loaded from cache`,
            { pos: "BR", slide: "rtl" },
            { background: "#4CAF50" },
            1500,
        );
        return; // Exit after successful localStorage load
    }
        if (!panel) {
            createPanelWrapper(panelId, formId);
            const targetEl = document.getElementById(formId);
            if (targetEl) {
                targetEl.innerHTML = `<div style="
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    margin: auto;
                    color: white;
                    min-height: 500px;" class="loader">.</div>`;
            }
        }

        if (!navigator.onLine) {
            const message = `⚠️ Offline — loading ${panelId} from cache if available`;
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );

            const cached = responseCache.get(id);
            if (cached && cached.data) {
                console.log(`🛠 Using cached data for ${panelId}`);
                processCachedData(cached.data, panelId, formId, objectKey);
                toast(
                    `✅ ${panelId} loaded from cache`,
                    { pos: "BR", slide: "rtl" },
                    { background: "#4CAF50" },
                    1500,
                );
                return;
            }
            toast(
                `❌ No cached data for ${panelId}`,
                { pos: "BR", slide: "rtl" },
                { background: "#F44336" },
                2000,
            );
            return;
        }

        if (!id) {
            const message = "⚠️ ID is required";
            console.warn(message);
            toast(
                message,
                { pos: "TR", slide: "rtl" },
                { background: "orange" },
                2000,
            );
            return;
        }

        const url = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
        console.log(`🚀 Start loading for ${panelId}`);

        try {
            const startTime = Date.now();
            const cached = responseCache.get(id);
            const headers = cached?.etag
                ? { "If-None-Match": cached.etag }
                : {};

            // Show fetching toast
            toast(
                `🔍 Fetching ${panelId} data...`,
                { pos: "TR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const response = await fetch(url, { headers });

            if (response.status === 304) {
                console.log(`✅ ${panelId} not modified, using cached data`);
                if (cached && cached.data) {
                    processCachedData(cached.data, panelId, formId, objectKey);
                    const loadTime = Date.now() - startTime;
                    console.log(
                        `✅ ${panelId} load completed in ${loadTime}ms`,
                    );
                    toast(
                        `✅ ${panelId} loaded (cached) in ${loadTime}ms`,
                        { pos: "TR", slide: "rtl" },
                        { background: "#4CAF50" },
                        1500,
                    );
                    return;
                }
                throw new Error("No cached data available for 304 response");
            }

            // Show parsing toast
            toast(
                `📦 Processing ${panelId} data...`,
                { pos: "CR", slide: "rtl" },
                { background: "#2196F3" },
                1000,
            );

            const text = await response.text();
            if (!response.ok) {
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            const json = JSON.parse(text);
            const data = json?.data;
            if (!data) {
                const message = `⚠️ No 'data' field in ${panelId} response`;
                console.warn(message);
                toast(
                    message,
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                    2000,
                );
                return;
            }

            // Store in cache
            const etag = response.headers.get("ETag");
            if (etag) {
                responseCache.set(id, { etag, data });
            }
// Save to localStorage
        saveToLocalStorage(id);
            processCachedData(data, panelId, formId, objectKey);
            const loadTime = Date.now() - startTime;
            console.log(`✅ ${panelId} load completed in ${loadTime}ms`);
            toast(
                `✅ ${panelId} loaded in ${loadTime}ms`,
                { pos: "CR", slide: "rtl" },
                { background: "#4CAF50" },
                1500,
            );
        } catch (e) {
            console.error(`❌ ${panelId} load failed:`, e.message);
            toast(
                `❌ ${panelId} load failed: ${e.message}`,
                { pos: "CR", slide: "rtl" },
                { background: "#F44336" },
                3000,
            );
        }
    }
function processCachedData(data, panelId, formId, objectKey) {
        const tryParse = (str) => {
            try {
                return JSON.parse(str);
            } catch {
                return {};
            }
        };

        bucket = tryParse(data.bucket || "{}");
        cup = tryParse(data.cup || "{}");
        board = tryParse(data.board || "{}");

        const objectMap = { bucket, cup };
        const targetObj = objectMap[objectKey];

        const panel = document.getElementById(panelId);
        if (!panel) {
            createPanelWrapper(panelId, formId);
        } else {
            genform(formId, targetObj);
        }
    }
        
// New helper function for localStorage data processing
function processCachedDataFromLocalStorage(panelId, formId, objectKey) {
    const objectMap = { bucket, cup };
    const targetObj = objectMap[objectKey];

    const panel = document.getElementById(panelId);
    if (!panel) {
        createPanelWrapper(panelId, formId);
    } else {
        genform(formId, targetObj);
    }
    
    // Trigger any necessary UI updates
    if (document.getElementById("summan")) {
        renderSchemaStructureToSumman(bucket, "gform", window.lang);
    }
    if (document.getElementById("jumperhelper")) {
        updateJumperHelperWithUnanswered(QSummary(bucket).summary, bucket);
    }
}    
// Helper function to process data (cached or fresh)
    function processCachedData(data, panelId, formId, objectKey) {
        const tryParse = (str) => {
            try {
                return JSON.parse(str);
            } catch {
                return {};
            }
        };

        bucket = tryParse(data.bucket || "{}");
        cup = tryParse(data.cup || "{}");
        board = tryParse(data.board || "{}");

        const objectMap = { bucket, cup };
        const targetObj = objectMap[objectKey];

        const panel = document.getElementById(panelId);
        if (!panel) {
            createPanelWrapper(panelId, formId);
        } else {
            genform(formId, targetObj);
        }
    }
    
    async function saveToServerM(id) {
        // Early exit checks
        if (!navigator.onLine) {
            console.warn("⚠️ Offline — cannot save to server");
            toast(
                "⚠️ Offline - cannot save",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        if (!id) {
            console.warn("⚠️ ID is required");
            toast(
                "⚠️ ID is required",
                { pos: "TR", slide: "ttb" },
                { background: "orange" },
            );
            return false;
        }

        // Check for actual data content
        const hasValidData = () => {
            const hasBucket = bucket && Object.keys(bucket).length > 0;
            const hasCup = cup && Object.keys(cup).length > 0;
            const hasBoard = board && Object.keys(board).length > 0;
            return hasBucket || hasCup || hasBoard;
        };

        if (!hasValidData()) {
            toast(
                "⚠️ No data to save",
                { pos: "TR", slide: "rtl" },
                { background: "red" },
            );
            return false;
        }

        // Create progress panel
        createPanel("verticalProgressPanel2", "TR", "ctc", 60, 220, {
            title: "SAVE",
            verticalProgressBar: 100,
            noHeader: true,
            progressBar: 100,
            noFooter: true,
            bodyContent: `
            <div class="progress-container" style="display: flex; flex-direction: column; align-items: center;">
                <span class="progress-label">Saving...</span>
                <div class="progress-bar vertical">
                    <div class="progress-fill vertical" style="height: 0%"></div>
                </div>
            </div>`,
        });
        setTimeout(() => {
            toast(
                " Start saving ...",
                { pos: "TR", slide: "rtl" },
                { background: "red", width: 200 },
                1000,
            );
            moveXY("verticalProgressPanel2", window.innerWidth - 100, 80);
        }, 50);

        const panel = document.getElementById("verticalProgressPanel2");
        panel.style.left = window.innerWidth - 70 + "px";
        panel.style.top = "10px";

        try {
            const startTime = Date.now();

            // Prepare payload with all data
            const payload = {
                data: {
                    id,
                    name: id,
                    bucket: JSON.stringify(bucket || {}),
                    cup: JSON.stringify(cup || {}),
                    board: JSON.stringify(board || {}),
                    timestamp: new Date().toISOString(),
                },
            };

            // Get cached ETag if available
            const getUrl = `https://j.kunok.com/api622.php?id=${encodeURIComponent(id)}`;
            const cachedETag = sessionStorage.getItem(`etag:${getUrl}`);
            const headers = {
                "Content-Type": "application/json",
                ...(cachedETag && { "If-Match": cachedETag }),
            };

            // Show saving progress
            updateProgress(panel, 30, "Uploading data...");

            const response = await fetch("https://j.kunok.com/api622.php", {
                method: "POST",
                headers: headers,
                body: JSON.stringify(payload),
            });

            if (!response.ok) {
                const text = await response.text();
                if (response.status === 412) {
                    throw new Error(
                        "Data was modified by another user. Please reload and try again.",
                    );
                }
                throw new Error(`HTTP ${response.status}: ${text}`);
            }

            // Update progress
            updateProgress(panel, 70, "Verifying save...");

            // Update ETag if available
            const etag = response.headers.get("ETag");
            if (etag) {
                sessionStorage.setItem(`etag:${getUrl}`, etag);
            }

            // Verify the save by fetching the data back
            const verifyResponse = await fetch(getUrl);
            if (!verifyResponse.ok) {
                throw new Error("Failed to verify saved data");
            }

            const verifiedData = await verifyResponse.json();
            if (!verifiedData.data) {
                throw new Error("No data in verification response");
            }

            // Compare the saved data with what we sent
            const isDataValid = compareSavedData(
                payload.data,
                verifiedData.data,
            );
            if (!isDataValid) {
                throw new Error("Saved data verification failed");
            }

            // Update progress to complete
            updateProgress(panel, 100, "Save verified!");

            console.log(`✅ Save completed in ${Date.now() - startTime}ms`);
            toast(
                "✅ Saved successfully",
                { pos: "TR", slide: "ttb" },
                { background: "green" },
            );

            // Also save to local storage as backup
            saveToLocalStorage(id);

            return true;
        } catch (e) {
            console.error("❌ Save failed:", e.message);
            toast(
                `❌ Save failed: ${e.message}`,
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
            return false;
        } finally {
            // Close progress panel after a delay
            setTimeout(() => closePanel("verticalProgressPanel2"), 1500);
        }
    }
function loadFromLocalStorage(userId) {
        console.log("loadFromLocalStorage");
        try {
            const savedData = localStorage.getItem(`userData_${userId}`);
            if (!savedData) {
                console.log("ℹ️ No local data found for user:", userId);
                return false;
            }

            const data = JSON.parse(savedData);

            // Update the global objects
            bucket = data.bucket || {};
            cup = data.cup || {};
            board = data.board || {};

            console.log("✅ Loaded from LocalStorage for user:", userId);
            return true;
        } catch (e) {
            console.error("❌ LocalStorage load failed:", e);
            return false;
        }
    }
    function saveToLocalStorage(userId) {
        console.log("saveToLocalStorage");
        try {
            const data = {
                bucket: bucket || {},
                cup: cup || {},
                board: board || {},
                lastSaved: new Date().toISOString(),
            };

            localStorage.setItem(`userData_${userId}`, JSON.stringify(data));
            console.log("✅ Saved to LocalStorage for user:", userId);
            toast(
                "✅ Saved to LocalStorage",
                { pos: "TR", slide: "ttb" },
                { background: "green", color: "white" },
                1000,
            );
        } catch (e) {
            console.error("❌ LocalStorage save failed:", e);
            toast(
                "❌ LocalStorage save failed",
                { pos: "TR", slide: "ttb" },
                { background: "red", color: "white" },
                1000,
            );
        }
    }        