/* checklist.js  – drop-in, no classes, no dependencies
   call: renderChecklist('#targetId', options)
   -----------------------------------------------------------------
   options = {
     direction : 'horizontal' | 'vertical'   (default = horizontal)
     labels    : ['Step 1','Step 2', ...]    (optional)
   }
*/
function renderChecklist(container, opts) {
  opts = opts || {};
  var dir = (opts.direction || 'horizontal');
  var vertical = (dir === 'vertical');
  var labels = opts.labels || [];

  /* ---------- helpers ---------- */
  function toggle(node) {
    node.classList.toggle('checked');
    updateCounter();
  }
  function updateCounter() {
    var checked = root.querySelectorAll('.node.checked').length;
    counter.textContent = checked + ' of ' + root.querySelectorAll('.node').length;
  }

  /* ---------- build DOM ---------- */
  var root = typeof container === 'string' ? document.querySelector(container) : container;
  root.innerHTML = '';                       // clean slate
  root.className = 'checklist-' + dir;

  var line = document.createElement('div');
  line.className = 'checklist-line';
  root.appendChild(line);

  var counter = document.createElement('div');
  counter.className = 'checklist-counter';
  counter.textContent = '0 of ' + labels.length;
  root.appendChild(counter);

  for (var i = 0; i < labels.length; i++) {
    var wrap = document.createElement('div');
    wrap.className = 'checklist-nodeWrap';

    var node = document.createElement('div');
    node.className = 'checklist-node';
    node.innerHTML = '<span class="checklist-tick">&#10003;</span>';
    node.onclick = function () { toggle(this); };

    var lbl = document.createElement('div');
    lbl.className = 'checklist-label';
    lbl.textContent = labels[i] || ('Item ' + (i + 1));

    wrap.appendChild(node);
    wrap.appendChild(lbl);
    root.appendChild(wrap);
  }
}