function addStyle(css) {
    const style = document.createElement('style');
    style.textContent = css;
    document.head.appendChild(style);
  }

  function createDiv() { 
    const wrapper = document.createElement('div');
    wrapper.innerHTML = `<div id="triggerIcon" title="Open Menu"></div>

  <div id="smartBar">
    <div class="menuButton" id="menuItem1">Inbox<div class="menuButton" id="sdf">Inbox</div></div>
    <div class="menuButton" id="menuItem2">Alerts<span class="badge" id="badge_menuItem2"></span></div>
    <div class="menuButton" id="menuItem3">Tasks<span class="badge" id="badge_menuItem3"></span></div>
  </div>`;
    document.body.appendChild(wrapper);
  }

  // Add some basic styling
  addStyle(`
     body {
      margin: 0;
      font-family: sans-serif;
    }

    #triggerIcon {
      width: 40px;
      height: 40px;
      background: #3498db;
      border-radius: 50%;
      margin: 10px;
      cursor: pointer;
      position: relative;
    }

    #smartBar {
      display: none;
      position: absolute;
      top: 60px;
      left: 10px;
      background: #eee;
      padding: 5px 10px;
      border-radius: 8px;
      box-shadow: 0 2px 6px rgba(0,0,0,0.2);
      z-index: 1000;
      white-space: nowrap;
    }

    .menuButton {
      position: relative;
      margin: 0 5px;
      padding: 5px 10px;
      background: #fff;
      border: 1px solid #ccc;
      border-radius: 6px;
      cursor: pointer;
      display: inline-block;
    }

    .badge {
      position: absolute;
      top: -6px;
      right: -6px;
      background: red;
      color: white;
      font-size: 12px;
      padding: 2px 6px;
      border-radius: 20px;
      display: none;
    }

    .menuButton:hover {
      background: #f9f9f9;
    }
  `);

  function updateBadge(target, count) {
 let element = typeof target === 'string' ? document.getElementById(target) : target;
  if (!element) return;

  let id = element.id || '';
  let badgeId = 'badge_' + id;
  let badge = document.getElementById(badgeId);

  // Create badge if not already present
  if (!badge) {
    badge = document.createElement('span');
    badge.className = 'badge';
    badge.id = badgeId;
    element.appendChild(badge);
  }
    if (count ) {
      badge.innerHTML = count;
      badge.style.display = 'inline-block';
    } else {
      badge.style.display = 'none';
    }
  }

  function randomizeBadge() {
    const randomCount = Math.floor(Math.random() * 100);
    updateBadge('menuItem0', randomCount);
    updateBadge('triggerIcon', randomCount*randomCount);
    updateBadge('sdf', randomCount*randomCount);
  }