(function () {
  // ⬛ TEXT version
  function updateProgressText(divId, percent, text) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    const clamped = Math.min(Math.max(percent, 0), 100);
    const blocks = 20;
    const filled = Math.round((clamped / 100) * blocks);
    const empty = blocks - filled;
    const bar = "[" + "#".repeat(filled) + "-".repeat(empty) + "]";
    div.textContent = `${bar} ${text || ""}`;
    div.title = `${percent}%`;
    div.style.fontFamily = "monospace";
  }

  // 🎨 VISUAL version
  function updateProgressBar(divId, percent, text) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    if (!div.style.position) div.style.position = "relative";
    div.innerHTML = `
      <div style="
        width: 100%;
        height: 100%;
        background: #ddd;
        border-radius: 4px;
        overflow: hidden;
      ">
        <div style="
          width: ${Math.min(Math.max(percent, 0), 100)}%;
          height: 100%;
          background: #4caf50;
          transition: width 0.3s;
        "></div>
        <div style="
          position: absolute;
          top: 0;
          left: 0;
          width: 100%;
          height: 100%;
          font-size: 12px;
          text-align: center;
          line-height: ${div.clientHeight}px;
          color: #000;
          font-family: sans-serif;
        ">${text || ""}</div>
      </div>
    `;
    div.title = `${percent}%`;
  }
(function () {
  function createProgressBar(div) {
    if (div._initialized) return;

    div.style.position = "relative";
    div.style.background = "#ddd";
    div.style.borderRadius = "4px";
    div.style.overflow = "hidden";

    const fill = document.createElement("div");
    fill.style.background = "#4caf50";
    fill.style.height = "100%";
    fill.style.width = "0%";
    fill.style.transition = "width 0.3s";
    div.appendChild(fill);

    const label = document.createElement("div");
    label.style.position = "absolute";
    label.style.top = "0";
    label.style.left = "0";
    label.style.width = "100%";
    label.style.height = "100%";
    label.style.display = "flex";
    label.style.alignItems = "center";
    label.style.justifyContent = "center";
    label.style.fontSize = "12px";
    label.style.fontFamily = "sans-serif";
    label.style.color = "#000";
    div.appendChild(label);

    div._fill = fill;
    div._label = label;
    div._initialized = true;
  }

  function updateProgressBar(divId, percent, text) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;
    createProgressBar(div);

    const clamped = Math.min(Math.max(percent, 0), 100);
    div._fill.style.width = clamped + "%";
    div._label.textContent = text || "";
    div.title = `${clamped}%`;
  }

  window.updateProgressBar = updateProgressBar;
})();
  // Expose globally
  window.updateProgressText = updateProgressText;
  window.updateProgressBar = updateProgressBar;
})();