   function createDiv() {
            const wrapper = document.createElement('div');
            wrapper.innerHTML = `
                  <div id="menuContainer" class="menu-container"></div>

            `;
            document.body.appendChild(wrapper);
        }
   const menuData = [
            {
                group: "User Actions",
                items: [
                    {
                        id: "profile",
                        icon: "👤",
                        text: "Profile",
                        badgeCount: 3
                    },
                    {
                        id: "settings",
                        icon: "⚙️",
                        text: "Settings",
                        badgeCount: 1
                    }
                ]
            },
            {
                group: "Notifications",
                items: [
                    {
                        id: "messages",
                        icon: "✉️",
                        text: "Messages",
                        badgeCount: 5
                    },
                    {
                        id: "alerts",
                        icon: "🔔",
                        text: "Alerts",
                        badgeCount: 2
                    }
                ]
            }
        ];

        // Render the menu with groups
        function renderMenu() {
            const container = document.getElementById('menuContainer');
            container.innerHTML = '';
            
            menuData.forEach(group => {
                // Create group container
                const groupDiv = document.createElement('div');
                groupDiv.className = 'menu-group';
                
                // Add group title
                const title = document.createElement('div');
                title.className = 'menu-group-title';
                title.textContent = group.group;
                groupDiv.appendChild(title);
                
                // Add menu items
                group.items.forEach(item => {
                    const itemDiv = document.createElement('div');
                    itemDiv.className = 'menu-item';
                    
                    itemDiv.innerHTML = `
                        <span class="menu-icon">${item.icon}</span>
                        <span class="menu-text">${item.text}</span>
                        <span class="badge" id="badge-${item.id}">${item.badgeCount}</span>
                    `;
                    
                    groupDiv.appendChild(itemDiv);
                });
                
                container.appendChild(groupDiv);
            });
            
            // Update badge visibility
            updateAllBadges();
        }

        // Update a specific badge
        function updateBadge(itemId, count) {
            const badge = document.getElementById(`badge-${itemId}`);
            if (badge) {
                badge.textContent = count;
                badge.style.display = count > 0 ? 'inline-block' : 'none';
                
                // Update in menuData
                menuData.forEach(group => {
                    const item = group.items.find(i => i.id === itemId);
                    if (item) item.badgeCount = count;
                });
            }
        }

        // Update all badges with random numbers
        function updateAllBadges() {
            menuData.forEach(group => {
                group.items.forEach(item => {
                    updateBadge(item.id, item.badgeCount);
                });
            });
        }

        // Randomize all badges
        function randomizeBadges() {
            menuData.forEach(group => {
                group.items.forEach(item => {
                    const randomCount = Math.floor(Math.random() * 10);
                    updateBadge(item.id, randomCount);
                });
            });
        }
        createDiv();
         renderMenu();