async function itemuserlistpanel() {
    const defaultAvatar = 'https://placehold.co/60x60/ccc/fff.png?text=?';
    let matchedUsers = [];

    function renderUsers() {
        if (!matchedUsers.length) {
            return `<div class="error">No matched users found</div>`;
        }

        return `
            <style>
                .item-user {
                    display: flex;
                    gap: 12px;
                    margin-bottom: 12px;
                    padding: 10px;
                    background: #fff;
                    border-radius: 6px;
                    border: 1px solid #ccc;
                    font-size: 14px;
                    cursor: pointer;
                    transition: background 0.2s;
                }
                .item-user:hover {
                    background: #f7f7f7;
                }
                .item-user img {
                    width: 60px;
                    height: 60px;
                    border-radius: 4px;
                    object-fit: cover;
                }
                .item-user pre {
                    background: #f7f7f7;
                    padding: 6px;
                    border-radius: 4px;
                    font-size: 12px;
                    margin-top: 4px;
                    max-height: 100px;
                    overflow-y: auto;
                }
                .item-user .meta {
                    font-size: 12px;
                    color: #666;
                }
                .error {
                    color: red;
                    text-align: center;
                    margin: 20px;
                }
            </style>
            <div id="itemUserList">
                ${matchedUsers.map(user => `
                    <div class="item-user" data-user-id="${user.id}">
                        <img src="${user.img ? atob(user.img) : defaultAvatar}" onerror="this.src='${defaultAvatar}'">
                        <div>
                            <div><strong>${user.name}</strong> (${user.username})</div>
                            <div class="meta">ID: ${user.id} | Level: ${user.level} | Flag: ${user.flag}</div>
                            <div class="meta">Timestamp: ${user.timestamp}</div>
                            <div><strong>Board:</strong><pre>${user.board}</pre></div>
                        </div>
                    </div>
                `).join("")}
            </div>
        `;
    }

    function attachClickEvents() {
        const cards = document.querySelectorAll(".item-user");
        cards.forEach(card => {
            card.addEventListener("click", () => {
                const userId = card.getAttribute("data-user-id");
                if (typeof updateUserPanel === "function") {
                    //closePanel("itemUserPanel");
                    updateUserPanel(userId);
                } else {
                    alert("updateUserPanel(userId) not found.");
                }
            });
        });
    }

    try {
        const itemsRes = await fetch('https://j.kunok.com/api62.php?action=list_all&fields=id,name,flag,timestamp,board');
        const itemsJson = await itemsRes.json();
        if (!itemsJson.data) throw new Error("No items found");

        const usersRes = await fetch('https://j.kunok.com/aui.php?action=list');
        const usersJson = await usersRes.json();
        if (!usersJson.data) throw new Error("No users found");

        const itemBoardMap = {};
        for (const item of itemsJson.data) {
            let boardText = "N/A";
            if (item.board?.trim()) {
                try {
                    boardText = JSON.stringify(JSON.parse(item.board), null, 2);
                } catch (e) {
                    boardText = "Invalid JSON";
                }
            }
            itemBoardMap[item.id] = boardText;
        }

        matchedUsers = usersJson.data.filter(u => itemBoardMap[u.id] !== undefined)
            .map(u => ({ ...u, board: itemBoardMap[u.id] }));

        const html = renderUsers();

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include micro2.js.");
            return;
        }

        createPanel("itemUserPanel", "CC", "ctc", 600, 600, {
            bodyContent: html,
            noFooter: true,
            title: "Matched Users with Board Info"
        });

        setTimeout(() => attachClickEvents(), 100);

    } catch (err) {
        console.error("Error loading item user panel:", err);
        createPanel("itemUserPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="error">${err.message}</div>`,
            noFooter: true,
            title: "Matched Users"
        });
    }
}
