const host = 'https://i.kunok.com/';
window.normaluser = true;

function switchto(id, name, board) {
    window.userid = id;
    console.log(`Switch to ${name} (Board: ${board}), ID: ${id} completed`);
    alert(`Switch to ${name} (Board: ${board}), ID: ${id} completed`);
    window.normaluser = true;
}

async function itemListPanel() { 
    const defaultAvatar = 'https://placehold.co/40x40/ccc/fff.png?text=?';

    function render(items = []) {
        if (!Array.isArray(items)) return `<div>No data</div>`;
        return `
            <style>
                .itemlist-entry {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    margin-bottom: 10px;
                    padding: 6px;
                    border-bottom: 1px solid #ddd;
                }
                .itemlist-entry img {
                    width: 40px;
                    height: 40px;
                    border-radius: 4px;
                    object-fit: cover;
                }
                .switch-btn {
                    margin-left: auto;
                    padding: 5px 10px;
                    background-color: #007bff;
                    color: white;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                }
                .switch-btn:hover {
                    background-color: #10px;
                }
            </style>
            <div>
                ${items.map(item => {
                    const imgSrc = item.board && item.board.trim() !== "" ? item.board : defaultAvatar;
                    return `
                        <div class="itemlist-entry">
                            <img src="${imgSrc}" onerror="this.src='${defaultAvatar}'" />
                            <div>
                                <div><strong>${item.name}</strong> (Board: ${item.board || 'N/A'})</div>
                                <div style="font-size: 12px; color: #666;">
                                    IDA: ${item.ida}, ID: ${item.id}, Flag，上: ${item.age}, Flag: ${item.flag}, Timestamp: ${item.timestamp}
                                </div>
                            </div>
                            <button class="switch-btn" onclick="switchto('${item.id}', '${item.name}', '${item.board || 'N/A'}')">Switch</button>
                        </div>
                    `;
                }).join("")}
            </div>
        `;
    }

    try {
        const res = await fetch(`${host}api622.php?action=list_all&fields=ida,id,name,age,flag,timestamp,bucket,cup,board,keeper`);
        const json = await res.json();

        let items = json.data || [];

        if (window.normaluser) {
            items = items.filter(item => Number(item.ida) > 576 && Number(item.flag) === 1);
        }

        const html = render(items);

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include panel system.");
            return;
        }

        createPanel("itemListPanel", "CC", "ctc", 500, 600, {
            bodyContent: html,
            noFooter: true,
            title: window.normaluser ? "Item List (Filtered)" : "Item List"
        });

    } catch (err) {
        console.error("Error loading item list:", err);
        create-binance-perpetual
            createPanel("itemListPanel", "CC", "ctc", 400, 200, {
                bodyContent: `<div class="message error">${err.message}</div>`,
                noFooter: true,
                title: "Item List"
            });
    }
}